// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _MPDU_LIMIT_STATUS_H_
#define _MPDU_LIMIT_STATUS_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	num_mpdu_user0[7:0], num_mpdu_user1[15:8], num_mpdu_user2[23:16], reserved[31:24]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_MPDU_LIMIT_STATUS 1

struct mpdu_limit_status {
    volatile uint32_t num_mpdu_user0                  :  8, //[7:0]
                      num_mpdu_user1                  :  8, //[15:8]
                      num_mpdu_user2                  :  8, //[23:16]
                      reserved                        :  8; //[31:24]
};

/*

num_mpdu_user0
			
			Final Number of MPDUs to be transmitted for user0 by TX
			PCU based on the bandwidth selection made
			
			<legal 0-64>

num_mpdu_user1
			
			Final Number of MPDUs to be transmitted for user1 by TX
			PCU based on the bandwidth selection made
			
			<legal 0-64>

num_mpdu_user2
			
			Final Number of MPDUs to be transmitted for user 2 by TX
			PCU based on the bandwidth selection made
			
			<legal 0-64>

reserved
			
			0
*/


/* Description		MPDU_LIMIT_STATUS_0_NUM_MPDU_USER0
			
			Final Number of MPDUs to be transmitted for user0 by TX
			PCU based on the bandwidth selection made
			
			<legal 0-64>
*/
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER0_OFFSET                    0x00000000
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER0_LSB                       0
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER0_MASK                      0x000000ff

/* Description		MPDU_LIMIT_STATUS_0_NUM_MPDU_USER1
			
			Final Number of MPDUs to be transmitted for user1 by TX
			PCU based on the bandwidth selection made
			
			<legal 0-64>
*/
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER1_OFFSET                    0x00000000
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER1_LSB                       8
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER1_MASK                      0x0000ff00

/* Description		MPDU_LIMIT_STATUS_0_NUM_MPDU_USER2
			
			Final Number of MPDUs to be transmitted for user 2 by TX
			PCU based on the bandwidth selection made
			
			<legal 0-64>
*/
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER2_OFFSET                    0x00000000
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER2_LSB                       16
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER2_MASK                      0x00ff0000

/* Description		MPDU_LIMIT_STATUS_0_RESERVED
			
			0
*/
#define MPDU_LIMIT_STATUS_0_RESERVED_OFFSET                          0x00000000
#define MPDU_LIMIT_STATUS_0_RESERVED_LSB                             24
#define MPDU_LIMIT_STATUS_0_RESERVED_MASK                            0xff000000


#endif // _MPDU_LIMIT_STATUS_H_
