// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _TX_PCU_INFO_H_
#define _TX_PCU_INFO_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	psdu_octet[19:0], reserved_0[24:20], num_of_mpdu[31:25]
//	1	num_vht_mac_pad[19:0], reserved_1[23:20], fixed_delimiters[31:24]
//	2	min_mpdu_spacing[9:0], reserved_2[31:10]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_TX_PCU_INFO 3

struct tx_pcu_info {
    volatile uint32_t psdu_octet                      : 20, //[19:0]
                      reserved_0                      :  5, //[24:20]
                      num_of_mpdu                     :  7; //[31:25]
    volatile uint32_t num_vht_mac_pad                 : 20, //[19:0]
                      reserved_1                      :  4, //[23:20]
                      fixed_delimiters                :  8; //[31:24]
    volatile uint32_t min_mpdu_spacing                : 10, //[9:0]
                      reserved_2                      : 22; //[31:10]
};

/*

psdu_octet
			
			PSDU length in octets which includes all useful data in
			a packet which does not include:
			
			Service (16 bits)
			
			Pad data after the last non-zero length MPDU (0 to 3
			bytes)
			
			Zero length EOF MPDU (4 bytes each)
			
			Tail (0 for LDPC and Nes * 6 for BCC) where Nes is the
			number of encoders
			
			PHY pad
			
			For 11n packets the HT-SIG HT length field will be the
			same as psdu_octets.  For 11ac packets the VHT-SIG-B length
			is ceiling (psdu_octet / 4).  Note that the VHT-SIG-B length
			field is in units of 4 octets.  Used by PCU.

reserved_0
			
			Reserved.  Not used by HW.
			
			<legal:0>

num_of_mpdu
			
			Number of MPDU.  According to the 802.11 standard values
			larger than 64 are not supported.

num_vht_mac_pad
			
			Number of MAC pad bytes after the end of the last MPDU. 
			The vht_ppdu_bit_length = service_bits + psdu_octet * 8 +
			num_vht_mac_pad * 8 + tail_bits + phy_pad_bits

reserved_1
			
			Reserved.  Not used by HW.
			
			<legal:0>

fixed_delimiters
			
			A fixed number of zero-length delimiters to add after
			this MPDU.  The actual number of zero-length delimiters will
			be maximum of this field and the amount based on the
			min_mpdu_spacing field.

min_mpdu_spacing
			
			Minimum number of dwords in an MPDU.  If the actual MPDU
			size is smaller than this, the PCU will insert zero-length
			delimiters after this MPDU to compensate for the difference.
			For example at a PHY rate of 1.3 Gbps if the receiver is
			capable of receiving only 1 MPDU every 16 usec, then this
			field should be set to 649.  This means that if the MPDU
			length is shorter than 2596 bytes then additional zero
			length delimiter and MAC byte padding should be added to get
			to a combined byte count of 2596 bytes.  This does not
			include the non-zero length delimiter.

reserved_2
			
			Reserved.  Not used by HW.
			
			<legal:0>
*/


/* Description		TX_PCU_INFO_0_PSDU_OCTET
			
			PSDU length in octets which includes all useful data in
			a packet which does not include:
			
			Service (16 bits)
			
			Pad data after the last non-zero length MPDU (0 to 3
			bytes)
			
			Zero length EOF MPDU (4 bytes each)
			
			Tail (0 for LDPC and Nes * 6 for BCC) where Nes is the
			number of encoders
			
			PHY pad
			
			For 11n packets the HT-SIG HT length field will be the
			same as psdu_octets.  For 11ac packets the VHT-SIG-B length
			is ceiling (psdu_octet / 4).  Note that the VHT-SIG-B length
			field is in units of 4 octets.  Used by PCU.
*/
#define TX_PCU_INFO_0_PSDU_OCTET_OFFSET                              0x00000000
#define TX_PCU_INFO_0_PSDU_OCTET_LSB                                 0
#define TX_PCU_INFO_0_PSDU_OCTET_MASK                                0x000fffff

/* Description		TX_PCU_INFO_0_RESERVED_0
			
			Reserved.  Not used by HW.
			
			<legal:0>
*/
#define TX_PCU_INFO_0_RESERVED_0_OFFSET                              0x00000000
#define TX_PCU_INFO_0_RESERVED_0_LSB                                 20
#define TX_PCU_INFO_0_RESERVED_0_MASK                                0x01f00000

/* Description		TX_PCU_INFO_0_NUM_OF_MPDU
			
			Number of MPDU.  According to the 802.11 standard values
			larger than 64 are not supported.
*/
#define TX_PCU_INFO_0_NUM_OF_MPDU_OFFSET                             0x00000000
#define TX_PCU_INFO_0_NUM_OF_MPDU_LSB                                25
#define TX_PCU_INFO_0_NUM_OF_MPDU_MASK                               0xfe000000

/* Description		TX_PCU_INFO_1_NUM_VHT_MAC_PAD
			
			Number of MAC pad bytes after the end of the last MPDU. 
			The vht_ppdu_bit_length = service_bits + psdu_octet * 8 +
			num_vht_mac_pad * 8 + tail_bits + phy_pad_bits
*/
#define TX_PCU_INFO_1_NUM_VHT_MAC_PAD_OFFSET                         0x00000004
#define TX_PCU_INFO_1_NUM_VHT_MAC_PAD_LSB                            0
#define TX_PCU_INFO_1_NUM_VHT_MAC_PAD_MASK                           0x000fffff

/* Description		TX_PCU_INFO_1_RESERVED_1
			
			Reserved.  Not used by HW.
			
			<legal:0>
*/
#define TX_PCU_INFO_1_RESERVED_1_OFFSET                              0x00000004
#define TX_PCU_INFO_1_RESERVED_1_LSB                                 20
#define TX_PCU_INFO_1_RESERVED_1_MASK                                0x00f00000

/* Description		TX_PCU_INFO_1_FIXED_DELIMITERS
			
			A fixed number of zero-length delimiters to add after
			this MPDU.  The actual number of zero-length delimiters will
			be maximum of this field and the amount based on the
			min_mpdu_spacing field.
*/
#define TX_PCU_INFO_1_FIXED_DELIMITERS_OFFSET                        0x00000004
#define TX_PCU_INFO_1_FIXED_DELIMITERS_LSB                           24
#define TX_PCU_INFO_1_FIXED_DELIMITERS_MASK                          0xff000000

/* Description		TX_PCU_INFO_2_MIN_MPDU_SPACING
			
			Minimum number of dwords in an MPDU.  If the actual MPDU
			size is smaller than this, the PCU will insert zero-length
			delimiters after this MPDU to compensate for the difference.
			For example at a PHY rate of 1.3 Gbps if the receiver is
			capable of receiving only 1 MPDU every 16 usec, then this
			field should be set to 649.  This means that if the MPDU
			length is shorter than 2596 bytes then additional zero
			length delimiter and MAC byte padding should be added to get
			to a combined byte count of 2596 bytes.  This does not
			include the non-zero length delimiter.
*/
#define TX_PCU_INFO_2_MIN_MPDU_SPACING_OFFSET                        0x00000008
#define TX_PCU_INFO_2_MIN_MPDU_SPACING_LSB                           0
#define TX_PCU_INFO_2_MIN_MPDU_SPACING_MASK                          0x000003ff

/* Description		TX_PCU_INFO_2_RESERVED_2
			
			Reserved.  Not used by HW.
			
			<legal:0>
*/
#define TX_PCU_INFO_2_RESERVED_2_OFFSET                              0x00000008
#define TX_PCU_INFO_2_RESERVED_2_LSB                                 10
#define TX_PCU_INFO_2_RESERVED_2_MASK                                0xfffffc00


#endif // _TX_PCU_INFO_H_
