// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _RX_PPDU_END_H_
#define _RX_PPDU_END_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	evm_p0[31:0]
//	1	evm_p1[31:0]
//	2	evm_p2[31:0]
//	3	evm_p3[31:0]
//	4	evm_p4[31:0]
//	5	evm_p5[31:0]
//	6	evm_p6[31:0]
//	7	evm_p7[31:0]
//	8	evm_p8[31:0]
//	9	evm_p9[31:0]
//	10	evm_p10[31:0]
//	11	evm_p11[31:0]
//	12	evm_p12[31:0]
//	13	evm_p13[31:0]
//	14	evm_p14[31:0]
//	15	evm_p15[31:0]
//	16	tsf_timestamp[31:0]
//	17	wb_timestamp[31:0]
//	18	struct rx_pkt_end rx_pkt_end;
//	19-22	struct rx_phy_ppdu_end rx_phy_ppdu_end;
//	23	struct rx_timing_offset rx_timing_offset;
//	24	struct rx_location_info rx_location_info;
//	25	rx_antenna[23:0], tx_ht_vht_ack[24], rx_pkt_end_valid[25], rx_phy_ppdu_end_valid[26], rx_timing_offset_valid[27], rx_location_info_valid[28], reserved_25[31:29]
//	26	bb_length[15:0], bb_data[16], reserved_24[30:17], ppdu_done[31]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_RX_PPDU_END 27

struct rx_ppdu_end {
    volatile uint32_t evm_p0                          : 32; //[31:0]
    volatile uint32_t evm_p1                          : 32; //[31:0]
    volatile uint32_t evm_p2                          : 32; //[31:0]
    volatile uint32_t evm_p3                          : 32; //[31:0]
    volatile uint32_t evm_p4                          : 32; //[31:0]
    volatile uint32_t evm_p5                          : 32; //[31:0]
    volatile uint32_t evm_p6                          : 32; //[31:0]
    volatile uint32_t evm_p7                          : 32; //[31:0]
    volatile uint32_t evm_p8                          : 32; //[31:0]
    volatile uint32_t evm_p9                          : 32; //[31:0]
    volatile uint32_t evm_p10                         : 32; //[31:0]
    volatile uint32_t evm_p11                         : 32; //[31:0]
    volatile uint32_t evm_p12                         : 32; //[31:0]
    volatile uint32_t evm_p13                         : 32; //[31:0]
    volatile uint32_t evm_p14                         : 32; //[31:0]
    volatile uint32_t evm_p15                         : 32; //[31:0]
    volatile uint32_t tsf_timestamp                   : 32; //[31:0]
    volatile uint32_t wb_timestamp                    : 32; //[31:0]
    struct            rx_pkt_end                       rx_pkt_end;
    struct            rx_phy_ppdu_end                       rx_phy_ppdu_end;
    struct            rx_timing_offset                       rx_timing_offset;
    struct            rx_location_info                       rx_location_info;
    volatile uint32_t rx_antenna                      : 24, //[23:0]
                      tx_ht_vht_ack                   :  1, //[24]
                      rx_pkt_end_valid                :  1, //[25]
                      rx_phy_ppdu_end_valid           :  1, //[26]
                      rx_timing_offset_valid          :  1, //[27]
                      rx_location_info_valid          :  1, //[28]
                      reserved_25                     :  3; //[31:29]
    volatile uint32_t bb_length                       : 16, //[15:0]
                      bb_data                         :  1, //[16]
                      reserved_24                     : 14, //[30:17]
                      ppdu_done                       :  1; //[31]
};

/*

evm_p0
			
			EVM for pilot 0.  Contain EVM for streams: 0, 1, 2 and
			3.

evm_p1
			
			EVM for pilot 1.  Contain EVM for streams: 0, 1, 2 and
			3.

evm_p2
			
			EVM for pilot 2.  Contain EVM for streams: 0, 1, 2 and
			3.

evm_p3
			
			EVM for pilot 3.  Contain EVM for streams: 0, 1, 2 and
			3.

evm_p4
			
			EVM for pilot 4.  Contain EVM for streams: 0, 1, 2 and
			3.

evm_p5
			
			EVM for pilot 5.  Contain EVM for streams: 0, 1, 2 and
			3.

evm_p6
			
			EVM for pilot 6.  Contain EVM for streams: 0, 1, 2 and
			3.

evm_p7
			
			EVM for pilot 7.  Contain EVM for streams: 0, 1, 2 and
			3.

evm_p8
			
			EVM for pilot 8.  Contain EVM for streams: 0, 1, 2 and
			3.

evm_p9
			
			EVM for pilot 9.  Contain EVM for streams: 0, 1, 2 and
			3.

evm_p10
			
			EVM for pilot 10.  Contain EVM for streams: 0, 1, 2 and
			3.

evm_p11
			
			EVM for pilot 11.  Contain EVM for streams: 0, 1, 2 and
			3.

evm_p12
			
			EVM for pilot 12.  Contain EVM for streams: 0, 1, 2 and
			3.

evm_p13
			
			EVM for pilot 13.  Contain EVM for streams: 0, 1, 2 and
			3.

evm_p14
			
			EVM for pilot 14.  Contain EVM for streams: 0, 1, 2 and
			3.

evm_p15
			
			EVM for pilot 15.  Contain EVM for streams: 0, 1, 2 and
			3.

tsf_timestamp
			
			Receive TSF timestamp sampled on the rising edge of
			rx_clear.  For PHY errors this may be the current TSF when
			phy_error is asserted if the rx_clear does not assert before
			the end of the PHY error.

wb_timestamp
			
			WLAN/BT timestamp is a 1 usec resolution timestamp which
			does not get updated based on receive beacon like TSF.  The
			same rules for capturing tsf_timestamp are used to capture
			the wb_timestamp.

struct rx_pkt_end rx_pkt_end
			
			Status associated with rx_pkt_end from the PHY.  See
			description in the beeliner_mac_phy_interface.docx

struct rx_phy_ppdu_end rx_phy_ppdu_end
			
			Status associated with rx_phy_pkt_end from the PHY.  See
			description in the beeliner_mac_phy_interface.docx

struct rx_timing_offset rx_timing_offset
			
			Status associated with rx_timing_offset from the PHY. 
			See description in the beeliner_mac_phy_interface.docx

struct rx_location_info rx_location_info
			
			Status associated with rx_location_info from the PHY. 
			See description in the beeliner_mac_phy_interface.docx

rx_antenna
			
			Receive antenna value

tx_ht_vht_ack
			
			Indicates that a HT or VHT Ack/BA frame was transmitted
			in response to this receive packet.

rx_pkt_end_valid
			
			Indicates that the rx_pkt_end structure above is valid

rx_phy_ppdu_end_valid
			
			Indicates that the rx_phy_ppdu_end structure above is
			valid

rx_timing_offset_valid
			
			Indicates that the rx_timing_offset structure above is
			valid

rx_location_info_valid
			
			Indicates that the rx_location_info structure above is
			valid

reserved_25
			
			Reserved: HW should fill with 0, FW should ignore.

bb_length
			
			Indicates the number of bytes of baseband information
			for PPDUs where the BB descriptor preamble type is 0x80 to
			0xFF which indicates that this is not a normal PPDU but
			rather contains baseband debug information.

bb_data
			
			Indicates that BB data associated with this PPDU will
			exist in the receive buffer.  The exact contents of this BB
			data can be found by decoding the BB TLV in the buffer
			associated with the BB data.  See vector_fragment in the
			beeliner_mac_phy_interface.docx

reserved_24
			
			Reserved: HW should fill with 0, FW should ignore.

ppdu_done
			
			PPDU end status is only valid when ppdu_done bit is set.
			Every time HW sets this bit in memory FW/SW must clear this
			bit in memory.  FW will initialize all the ppdu_done dword
			to 0.
*/


/* Description		RX_PPDU_END_0_EVM_P0
			
			EVM for pilot 0.  Contain EVM for streams: 0, 1, 2 and
			3.
*/
#define RX_PPDU_END_0_EVM_P0_OFFSET                                  0x00000000
#define RX_PPDU_END_0_EVM_P0_LSB                                     0
#define RX_PPDU_END_0_EVM_P0_MASK                                    0xffffffff

/* Description		RX_PPDU_END_1_EVM_P1
			
			EVM for pilot 1.  Contain EVM for streams: 0, 1, 2 and
			3.
*/
#define RX_PPDU_END_1_EVM_P1_OFFSET                                  0x00000004
#define RX_PPDU_END_1_EVM_P1_LSB                                     0
#define RX_PPDU_END_1_EVM_P1_MASK                                    0xffffffff

/* Description		RX_PPDU_END_2_EVM_P2
			
			EVM for pilot 2.  Contain EVM for streams: 0, 1, 2 and
			3.
*/
#define RX_PPDU_END_2_EVM_P2_OFFSET                                  0x00000008
#define RX_PPDU_END_2_EVM_P2_LSB                                     0
#define RX_PPDU_END_2_EVM_P2_MASK                                    0xffffffff

/* Description		RX_PPDU_END_3_EVM_P3
			
			EVM for pilot 3.  Contain EVM for streams: 0, 1, 2 and
			3.
*/
#define RX_PPDU_END_3_EVM_P3_OFFSET                                  0x0000000c
#define RX_PPDU_END_3_EVM_P3_LSB                                     0
#define RX_PPDU_END_3_EVM_P3_MASK                                    0xffffffff

/* Description		RX_PPDU_END_4_EVM_P4
			
			EVM for pilot 4.  Contain EVM for streams: 0, 1, 2 and
			3.
*/
#define RX_PPDU_END_4_EVM_P4_OFFSET                                  0x00000010
#define RX_PPDU_END_4_EVM_P4_LSB                                     0
#define RX_PPDU_END_4_EVM_P4_MASK                                    0xffffffff

/* Description		RX_PPDU_END_5_EVM_P5
			
			EVM for pilot 5.  Contain EVM for streams: 0, 1, 2 and
			3.
*/
#define RX_PPDU_END_5_EVM_P5_OFFSET                                  0x00000014
#define RX_PPDU_END_5_EVM_P5_LSB                                     0
#define RX_PPDU_END_5_EVM_P5_MASK                                    0xffffffff

/* Description		RX_PPDU_END_6_EVM_P6
			
			EVM for pilot 6.  Contain EVM for streams: 0, 1, 2 and
			3.
*/
#define RX_PPDU_END_6_EVM_P6_OFFSET                                  0x00000018
#define RX_PPDU_END_6_EVM_P6_LSB                                     0
#define RX_PPDU_END_6_EVM_P6_MASK                                    0xffffffff

/* Description		RX_PPDU_END_7_EVM_P7
			
			EVM for pilot 7.  Contain EVM for streams: 0, 1, 2 and
			3.
*/
#define RX_PPDU_END_7_EVM_P7_OFFSET                                  0x0000001c
#define RX_PPDU_END_7_EVM_P7_LSB                                     0
#define RX_PPDU_END_7_EVM_P7_MASK                                    0xffffffff

/* Description		RX_PPDU_END_8_EVM_P8
			
			EVM for pilot 8.  Contain EVM for streams: 0, 1, 2 and
			3.
*/
#define RX_PPDU_END_8_EVM_P8_OFFSET                                  0x00000020
#define RX_PPDU_END_8_EVM_P8_LSB                                     0
#define RX_PPDU_END_8_EVM_P8_MASK                                    0xffffffff

/* Description		RX_PPDU_END_9_EVM_P9
			
			EVM for pilot 9.  Contain EVM for streams: 0, 1, 2 and
			3.
*/
#define RX_PPDU_END_9_EVM_P9_OFFSET                                  0x00000024
#define RX_PPDU_END_9_EVM_P9_LSB                                     0
#define RX_PPDU_END_9_EVM_P9_MASK                                    0xffffffff

/* Description		RX_PPDU_END_10_EVM_P10
			
			EVM for pilot 10.  Contain EVM for streams: 0, 1, 2 and
			3.
*/
#define RX_PPDU_END_10_EVM_P10_OFFSET                                0x00000028
#define RX_PPDU_END_10_EVM_P10_LSB                                   0
#define RX_PPDU_END_10_EVM_P10_MASK                                  0xffffffff

/* Description		RX_PPDU_END_11_EVM_P11
			
			EVM for pilot 11.  Contain EVM for streams: 0, 1, 2 and
			3.
*/
#define RX_PPDU_END_11_EVM_P11_OFFSET                                0x0000002c
#define RX_PPDU_END_11_EVM_P11_LSB                                   0
#define RX_PPDU_END_11_EVM_P11_MASK                                  0xffffffff

/* Description		RX_PPDU_END_12_EVM_P12
			
			EVM for pilot 12.  Contain EVM for streams: 0, 1, 2 and
			3.
*/
#define RX_PPDU_END_12_EVM_P12_OFFSET                                0x00000030
#define RX_PPDU_END_12_EVM_P12_LSB                                   0
#define RX_PPDU_END_12_EVM_P12_MASK                                  0xffffffff

/* Description		RX_PPDU_END_13_EVM_P13
			
			EVM for pilot 13.  Contain EVM for streams: 0, 1, 2 and
			3.
*/
#define RX_PPDU_END_13_EVM_P13_OFFSET                                0x00000034
#define RX_PPDU_END_13_EVM_P13_LSB                                   0
#define RX_PPDU_END_13_EVM_P13_MASK                                  0xffffffff

/* Description		RX_PPDU_END_14_EVM_P14
			
			EVM for pilot 14.  Contain EVM for streams: 0, 1, 2 and
			3.
*/
#define RX_PPDU_END_14_EVM_P14_OFFSET                                0x00000038
#define RX_PPDU_END_14_EVM_P14_LSB                                   0
#define RX_PPDU_END_14_EVM_P14_MASK                                  0xffffffff

/* Description		RX_PPDU_END_15_EVM_P15
			
			EVM for pilot 15.  Contain EVM for streams: 0, 1, 2 and
			3.
*/
#define RX_PPDU_END_15_EVM_P15_OFFSET                                0x0000003c
#define RX_PPDU_END_15_EVM_P15_LSB                                   0
#define RX_PPDU_END_15_EVM_P15_MASK                                  0xffffffff

/* Description		RX_PPDU_END_16_TSF_TIMESTAMP
			
			Receive TSF timestamp sampled on the rising edge of
			rx_clear.  For PHY errors this may be the current TSF when
			phy_error is asserted if the rx_clear does not assert before
			the end of the PHY error.
*/
#define RX_PPDU_END_16_TSF_TIMESTAMP_OFFSET                          0x00000040
#define RX_PPDU_END_16_TSF_TIMESTAMP_LSB                             0
#define RX_PPDU_END_16_TSF_TIMESTAMP_MASK                            0xffffffff

/* Description		RX_PPDU_END_17_WB_TIMESTAMP
			
			WLAN/BT timestamp is a 1 usec resolution timestamp which
			does not get updated based on receive beacon like TSF.  The
			same rules for capturing tsf_timestamp are used to capture
			the wb_timestamp.
*/
#define RX_PPDU_END_17_WB_TIMESTAMP_OFFSET                           0x00000044
#define RX_PPDU_END_17_WB_TIMESTAMP_LSB                              0
#define RX_PPDU_END_17_WB_TIMESTAMP_MASK                             0xffffffff
#define RX_PPDU_END_18_RX_PKT_END_RX_PKT_END_OFFSET                  0x00000048
#define RX_PPDU_END_18_RX_PKT_END_RX_PKT_END_LSB                     0
#define RX_PPDU_END_18_RX_PKT_END_RX_PKT_END_MASK                    0xffffffff
#define RX_PPDU_END_19_RX_PHY_PPDU_END_RX_PHY_PPDU_END_OFFSET        0x0000004c
#define RX_PPDU_END_19_RX_PHY_PPDU_END_RX_PHY_PPDU_END_LSB           0
#define RX_PPDU_END_19_RX_PHY_PPDU_END_RX_PHY_PPDU_END_MASK          0xffffffff
#define RX_PPDU_END_20_RX_PHY_PPDU_END_RX_PHY_PPDU_END_OFFSET        0x00000050
#define RX_PPDU_END_20_RX_PHY_PPDU_END_RX_PHY_PPDU_END_LSB           0
#define RX_PPDU_END_20_RX_PHY_PPDU_END_RX_PHY_PPDU_END_MASK          0xffffffff
#define RX_PPDU_END_21_RX_PHY_PPDU_END_RX_PHY_PPDU_END_OFFSET        0x00000054
#define RX_PPDU_END_21_RX_PHY_PPDU_END_RX_PHY_PPDU_END_LSB           0
#define RX_PPDU_END_21_RX_PHY_PPDU_END_RX_PHY_PPDU_END_MASK          0xffffffff
#define RX_PPDU_END_22_RX_PHY_PPDU_END_RX_PHY_PPDU_END_OFFSET        0x00000058
#define RX_PPDU_END_22_RX_PHY_PPDU_END_RX_PHY_PPDU_END_LSB           0
#define RX_PPDU_END_22_RX_PHY_PPDU_END_RX_PHY_PPDU_END_MASK          0xffffffff
#define RX_PPDU_END_23_RX_TIMING_OFFSET_RX_TIMING_OFFSET_OFFSET      0x0000005c
#define RX_PPDU_END_23_RX_TIMING_OFFSET_RX_TIMING_OFFSET_LSB         0
#define RX_PPDU_END_23_RX_TIMING_OFFSET_RX_TIMING_OFFSET_MASK        0xffffffff
#define RX_PPDU_END_24_RX_LOCATION_INFO_RX_LOCATION_INFO_OFFSET      0x00000060
#define RX_PPDU_END_24_RX_LOCATION_INFO_RX_LOCATION_INFO_LSB         0
#define RX_PPDU_END_24_RX_LOCATION_INFO_RX_LOCATION_INFO_MASK        0xffffffff

/* Description		RX_PPDU_END_25_RX_ANTENNA
			
			Receive antenna value
*/
#define RX_PPDU_END_25_RX_ANTENNA_OFFSET                             0x00000064
#define RX_PPDU_END_25_RX_ANTENNA_LSB                                0
#define RX_PPDU_END_25_RX_ANTENNA_MASK                               0x00ffffff

/* Description		RX_PPDU_END_25_TX_HT_VHT_ACK
			
			Indicates that a HT or VHT Ack/BA frame was transmitted
			in response to this receive packet.
*/
#define RX_PPDU_END_25_TX_HT_VHT_ACK_OFFSET                          0x00000064
#define RX_PPDU_END_25_TX_HT_VHT_ACK_LSB                             24
#define RX_PPDU_END_25_TX_HT_VHT_ACK_MASK                            0x01000000

/* Description		RX_PPDU_END_25_RX_PKT_END_VALID
			
			Indicates that the rx_pkt_end structure above is valid
*/
#define RX_PPDU_END_25_RX_PKT_END_VALID_OFFSET                       0x00000064
#define RX_PPDU_END_25_RX_PKT_END_VALID_LSB                          25
#define RX_PPDU_END_25_RX_PKT_END_VALID_MASK                         0x02000000

/* Description		RX_PPDU_END_25_RX_PHY_PPDU_END_VALID
			
			Indicates that the rx_phy_ppdu_end structure above is
			valid
*/
#define RX_PPDU_END_25_RX_PHY_PPDU_END_VALID_OFFSET                  0x00000064
#define RX_PPDU_END_25_RX_PHY_PPDU_END_VALID_LSB                     26
#define RX_PPDU_END_25_RX_PHY_PPDU_END_VALID_MASK                    0x04000000

/* Description		RX_PPDU_END_25_RX_TIMING_OFFSET_VALID
			
			Indicates that the rx_timing_offset structure above is
			valid
*/
#define RX_PPDU_END_25_RX_TIMING_OFFSET_VALID_OFFSET                 0x00000064
#define RX_PPDU_END_25_RX_TIMING_OFFSET_VALID_LSB                    27
#define RX_PPDU_END_25_RX_TIMING_OFFSET_VALID_MASK                   0x08000000

/* Description		RX_PPDU_END_25_RX_LOCATION_INFO_VALID
			
			Indicates that the rx_location_info structure above is
			valid
*/
#define RX_PPDU_END_25_RX_LOCATION_INFO_VALID_OFFSET                 0x00000064
#define RX_PPDU_END_25_RX_LOCATION_INFO_VALID_LSB                    28
#define RX_PPDU_END_25_RX_LOCATION_INFO_VALID_MASK                   0x10000000

/* Description		RX_PPDU_END_25_RESERVED_25
			
			Reserved: HW should fill with 0, FW should ignore.
*/
#define RX_PPDU_END_25_RESERVED_25_OFFSET                            0x00000064
#define RX_PPDU_END_25_RESERVED_25_LSB                               29
#define RX_PPDU_END_25_RESERVED_25_MASK                              0xe0000000

/* Description		RX_PPDU_END_26_BB_LENGTH
			
			Indicates the number of bytes of baseband information
			for PPDUs where the BB descriptor preamble type is 0x80 to
			0xFF which indicates that this is not a normal PPDU but
			rather contains baseband debug information.
*/
#define RX_PPDU_END_26_BB_LENGTH_OFFSET                              0x00000068
#define RX_PPDU_END_26_BB_LENGTH_LSB                                 0
#define RX_PPDU_END_26_BB_LENGTH_MASK                                0x0000ffff

/* Description		RX_PPDU_END_26_BB_DATA
			
			Indicates that BB data associated with this PPDU will
			exist in the receive buffer.  The exact contents of this BB
			data can be found by decoding the BB TLV in the buffer
			associated with the BB data.  See vector_fragment in the
			beeliner_mac_phy_interface.docx
*/
#define RX_PPDU_END_26_BB_DATA_OFFSET                                0x00000068
#define RX_PPDU_END_26_BB_DATA_LSB                                   16
#define RX_PPDU_END_26_BB_DATA_MASK                                  0x00010000

/* Description		RX_PPDU_END_26_RESERVED_24
			
			Reserved: HW should fill with 0, FW should ignore.
*/
#define RX_PPDU_END_26_RESERVED_24_OFFSET                            0x00000068
#define RX_PPDU_END_26_RESERVED_24_LSB                               17
#define RX_PPDU_END_26_RESERVED_24_MASK                              0x7ffe0000

/* Description		RX_PPDU_END_26_PPDU_DONE
			
			PPDU end status is only valid when ppdu_done bit is set.
			Every time HW sets this bit in memory FW/SW must clear this
			bit in memory.  FW will initialize all the ppdu_done dword
			to 0.
*/
#define RX_PPDU_END_26_PPDU_DONE_OFFSET                              0x00000068
#define RX_PPDU_END_26_PPDU_DONE_LSB                                 31
#define RX_PPDU_END_26_PPDU_DONE_MASK                                0x80000000


#endif // _RX_PPDU_END_H_
