// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _PDG_BYPASS_H_
#define _PDG_BYPASS_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	overwrite_scrambler_seed[0], overwrite_lower_only[1], overwrite_lsig_parity[2], overwrite_crc[3], reserved_0[31:4]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_PDG_BYPASS 1

struct pdg_bypass {
    volatile uint32_t overwrite_scrambler_seed        :  1, //[0]
                      overwrite_lower_only            :  1, //[1]
                      overwrite_lsig_parity           :  1, //[2]
                      overwrite_crc                   :  1, //[3]
                      reserved_0                      : 28; //[31:4]
};

/*

overwrite_scrambler_seed
			
			Field only valid in SW_transmit_mode.
			
			
			
			When set, the PDG will insert/overwrite the scrambler
			seed value based on it's internal scrambler seed generation
			logic.
			
			
			
			<legal all>

overwrite_lower_only
			
			Field only valid in SW_transmit_mode.
			
			
			
			Field only valid when overwrite_scrambler_seed is set.
			
			
			
			When set, scrambler seed, low 4 bits will be
			overwritten. 
			
			When not set, PDG overwrites all 7 scrambler bits
			
			<legal all>

overwrite_lsig_parity
			
			Field only valid in SW_transmit_mode.
			
			
			
			When set, the PDG will insert/overwrite the lsig parity
			field with the proper value.
			
			
			
			<legal all>

overwrite_crc
			
			Field only valid in SW_transmit_mode.
			
			
			
			When set, the PDG will insert/overwrite the HT SIG, VHT
			SIG A, VHT SIG B CRC field with the proper value. 
			
			
			
			<legal all>

reserved_0
			
			<legal 0>
*/


/* Description		PDG_BYPASS_0_OVERWRITE_SCRAMBLER_SEED
			
			Field only valid in SW_transmit_mode.
			
			
			
			When set, the PDG will insert/overwrite the scrambler
			seed value based on it's internal scrambler seed generation
			logic.
			
			
			
			<legal all>
*/
#define PDG_BYPASS_0_OVERWRITE_SCRAMBLER_SEED_OFFSET                 0x00000000
#define PDG_BYPASS_0_OVERWRITE_SCRAMBLER_SEED_LSB                    0
#define PDG_BYPASS_0_OVERWRITE_SCRAMBLER_SEED_MASK                   0x00000001

/* Description		PDG_BYPASS_0_OVERWRITE_LOWER_ONLY
			
			Field only valid in SW_transmit_mode.
			
			
			
			Field only valid when overwrite_scrambler_seed is set.
			
			
			
			When set, scrambler seed, low 4 bits will be
			overwritten. 
			
			When not set, PDG overwrites all 7 scrambler bits
			
			<legal all>
*/
#define PDG_BYPASS_0_OVERWRITE_LOWER_ONLY_OFFSET                     0x00000000
#define PDG_BYPASS_0_OVERWRITE_LOWER_ONLY_LSB                        1
#define PDG_BYPASS_0_OVERWRITE_LOWER_ONLY_MASK                       0x00000002

/* Description		PDG_BYPASS_0_OVERWRITE_LSIG_PARITY
			
			Field only valid in SW_transmit_mode.
			
			
			
			When set, the PDG will insert/overwrite the lsig parity
			field with the proper value.
			
			
			
			<legal all>
*/
#define PDG_BYPASS_0_OVERWRITE_LSIG_PARITY_OFFSET                    0x00000000
#define PDG_BYPASS_0_OVERWRITE_LSIG_PARITY_LSB                       2
#define PDG_BYPASS_0_OVERWRITE_LSIG_PARITY_MASK                      0x00000004

/* Description		PDG_BYPASS_0_OVERWRITE_CRC
			
			Field only valid in SW_transmit_mode.
			
			
			
			When set, the PDG will insert/overwrite the HT SIG, VHT
			SIG A, VHT SIG B CRC field with the proper value. 
			
			
			
			<legal all>
*/
#define PDG_BYPASS_0_OVERWRITE_CRC_OFFSET                            0x00000000
#define PDG_BYPASS_0_OVERWRITE_CRC_LSB                               3
#define PDG_BYPASS_0_OVERWRITE_CRC_MASK                              0x00000008

/* Description		PDG_BYPASS_0_RESERVED_0
			
			<legal 0>
*/
#define PDG_BYPASS_0_RESERVED_0_OFFSET                               0x00000000
#define PDG_BYPASS_0_RESERVED_0_LSB                                  4
#define PDG_BYPASS_0_RESERVED_0_MASK                                 0xfffffff0


#endif // _PDG_BYPASS_H_
