// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _SCHEDULER_CMD_H_
#define _SCHEDULER_CMD_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	schedule_id[15:0], reserved_0a[20:16], fes_control_mode[22:21], ibss_beacon_frame[23], max_schedule_retries[27:24], pause_on_cbf_lower_bw[28], stall_schedule_enable[29], sta_pwr_state_chk_en[30], clear_cv_info[31]
//	1	scr_timer0_restart[0], scr_timer1_restart[1], scr_timer0_restart_after[2], scr_timer1_restart_after[3], sifs_burst_continuation[4], burst_continuation_ifs_time[5], sifs_burst_failure_ctrl[7:6], sifs_burst_flush_txop[8], sifs_burst_txop_restart_en[9], start_time_reference[12:10], end_time_reference[15:13], reserved_1a[31:16]
//	2	scheduler_tlv_ptr[31:0]
//	3	schedule_lifetime_exp[31:0]
//	4	schedule_start_time[31:0]
//	5	peer_entry_ptr0[31:0]
//	6	peer_entry_ptr1[31:0]
//	7	peer_entry_ptr2[31:0]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_SCHEDULER_CMD 8

struct scheduler_cmd {
    volatile uint32_t schedule_id                     : 16, //[15:0]
                      reserved_0a                     :  5, //[20:16]
                      fes_control_mode                :  2, //[22:21]
                      ibss_beacon_frame               :  1, //[23]
                      max_schedule_retries            :  4, //[27:24]
                      pause_on_cbf_lower_bw           :  1, //[28]
                      stall_schedule_enable           :  1, //[29]
                      sta_pwr_state_chk_en            :  1, //[30]
                      clear_cv_info                   :  1; //[31]
    volatile uint32_t scr_timer0_restart              :  1, //[0]
                      scr_timer1_restart              :  1, //[1]
                      scr_timer0_restart_after        :  1, //[2]
                      scr_timer1_restart_after        :  1, //[3]
                      sifs_burst_continuation         :  1, //[4]
                      burst_continuation_ifs_time     :  1, //[5]
                      sifs_burst_failure_ctrl         :  2, //[7:6]
                      sifs_burst_flush_txop           :  1, //[8]
                      sifs_burst_txop_restart_en      :  1, //[9]
                      start_time_reference            :  3, //[12:10]
                      end_time_reference              :  3, //[15:13]
                      reserved_1a                     : 16; //[31:16]
    volatile uint32_t scheduler_tlv_ptr               : 32; //[31:0]
    volatile uint32_t schedule_lifetime_exp           : 32; //[31:0]
    volatile uint32_t schedule_start_time             : 32; //[31:0]
    volatile uint32_t peer_entry_ptr0                 : 32; //[31:0]
    volatile uint32_t peer_entry_ptr1                 : 32; //[31:0]
    volatile uint32_t peer_entry_ptr2                 : 32; //[31:0]
};

/*

schedule_id
			
			Schedule command identifier
			
			
			
			A field that HW copies over into the scheduling status
			report, so that SW can determine to which scheduler command
			the status report belongs.
			
			This schedule ID is also reported in the PPDU status.   
			  
			
			<legal all>

reserved_0a
			
			<legal 0>

fes_control_mode
			
			<enum 0  SW_transmit_mode>  No HW generated TLVs
			
			
			
			<enum 1 PDG_transmit_mode> PDG  is activated to generate
			TLVs
			
			
			
			Note: Final Bandwidth selection is always performed by
			TX PCU.
			
			
			
			<legal 0-1>

ibss_beacon_frame
			
			When set, this scheduling command refers to an IBSS
			beacon frame.
			
			
			
			In IBSS, beacon transmission is initiated at TBTT. The
			beacon will go out after a regular Backoff period, or not at
			all if a beacon from another STA belonging to the same IBSS
			is received. During this period, all backoff engines for
			regular data transmissions are paused. They get re-enabled
			when either the other beacon is received, or this beacon
			frame got transmitted (and this configuration bit was set).
			
			 <legal all>

max_schedule_retries
			
			The maximum number of times this scheduler command can
			be tried if execution did not result in a successful FES
			transmission.
			
			
			
			For example: No ACK or BA frame was received at all
			after PPDU transmission. Or no CTS frame was received after
			transmitting an RTS.
			
			If for this transmission, no response frames are
			expected, this field will be ignored.<legal all>

pause_on_cbf_lower_bw
			
			Bit setting only valid when 'Send_ndp' is set.
			
			0: no action
			
			1: When received CBF has the CV report which is lower
			bandwidth than the bandwidth of the sounding sequence, pause
			the scheduler. This pausing will be notified to SW in the
			Scheduler Status report: Bit ???
			
			<legal all>

stall_schedule_enable
			
			0: No action
			
			1: Stall the scheduler processing of this scheduling
			command ring if the transmission is NOT successful
			(including the number of allowed retries). That is, no ACK,
			BA or sounding responses are received. Do not start on
			processing the next scheduling commands. <legal all>

sta_pwr_state_chk_en
			
			When set, scheduler performs the STA power state check.
			For this the scheduler reads the peer entry, and if the STA
			power state indicates power save mode, the scheduling
			command is retired. This reason will be indicated in the
			scheduling status.
			
			
			
			When NOT set, no power save state check will be
			performed by the scheduler

clear_cv_info
			
			0: No action
			
			1: Clear all the internal scheduler CV tracking info.
			The result is that for a next beamformed transmission
			(including MU-MIMO) the scheduler will discard the CV info
			that might already have been in the PHY, and will force a
			new CV parameters read from memory.

scr_timer0_restart
			
			Scheduler command ring (scr) timer 0 restart
			
			0: No action
			
			1: Restart the internal scheduler command ring timer0 at
			first time this scheduling command is evaluated by HW.
			<legal all>

scr_timer1_restart
			
			Scheduler command ring (scr) timer 1 restart
			
			0: No action
			
			1: Restart the internal scheduler command ring timer1 at
			first time this scheduling command is evaluated by HW.
			<legal all>

scr_timer0_restart_after
			
			Scheduler command ring timer (scr) 0 restart after
			
			0: No action
			
			1: Restart the internal scheduler command ring timer0
			after this scheduling command has finished successfully (=>
			Ack was received, or no response expected) <legal all>

scr_timer1_restart_after
			
			Scheduler command ring timer (scr) 1 restart after
			
			0: No action
			
			1: Restart the internal scheduler command ring timer1
			after this scheduling command has finished successfully (=>
			Ack was received, or no response expected) <legal all>

sifs_burst_continuation
			
			SIFS burst continuation
			
			0: No action
			
			1: The next scheduling command needs to start at SIFS
			time after finishing the frame transmissions in this
			command. This allows for SIFS based bursting
			
			
			
			<legal all>

burst_continuation_ifs_time
			
			
			
			
			<enum 0  SIFS> : Interframe space between 2 consecutive
			scheduling commands is SIFS.
			
			<enum 1  PIFS> : Interframe space between 2 consecutive
			scheduling commands is PIFS. This mode can be used in
			combination with Qboost, where it is not known up front if
			there will be any return data coming when a qboost trigger
			frame has been sent.
			
			<legal all>

sifs_burst_failure_ctrl
			
			
			<enum 0  allways_continue>  Continue with the next
			scheduling command in SIFS time irrespective of failure or
			success of this scheduling command
			
			<enum 1  pause_on_failure>  this scheduling command is a
			failure [schedule status does NOT indicate success], do NOT
			continue with the next scheduling command. Pause this
			scheduler command ring, till SW re-enables it.
			
			<enum 2  flush_on_failure>  Flush all remaining
			scheduling commands for this SIFS burst
			
			<enum 3  pifs_continue_on_failure>  If this scheduling
			command is a failure [schedule status does NOT indicate
			success], continue with the next schedule command in PIFS
			time.
			
			<legal 0-3>

sifs_burst_flush_txop
			
			Only valid when the previous scheduler command in this
			ring indicated: sifs_burst_continuation.
			
			
			
			0: No action
			
			1: If the remaining TXOP time is 0 or does not have
			enough time to transmit any frames, flush this scheduling
			command
			
			<legal all>

sifs_burst_txop_restart_en
			
			Only valid when the previous scheduler command in this
			ring indicated: sifs_burst_continuation.
			
			
			
			0: No action
			
			1: If from the previous SIFS commands, there is no TXOP
			time left to transmit any frame, then do NOT retire this
			command. Instead, keep this command and let it be the first
			command for the next transmission when the backoff engine
			expires.
			
			<legal all>

start_time_reference
			
			Indicates the reference clock to be used for checking
			the scheduling start time
			
			0: TSF1
			
			1: TSF2
			
			2: WB_Timer
			
			3: Internal scheduler command queue timer 0
			
			4: Internal scheduler command queue timer 1
			
			<legal 0-4>

end_time_reference
			
			Indicates the reference clock to be used for checking
			the lifetime expiration time of the command.
			
			0: TSF1
			
			1: TSF2
			
			2: WB_Timer
			
			3: Internal scheduler command queue timer 0
			
			4: Internal scheduler command queue timer 1
			
			<legal 0-4>

reserved_1a
			
			<legal 0>

scheduler_tlv_ptr
			
			The address location for the transmit TLVs.
			
			These TLVs get read/interpreted by the scheduler and
			when applicable pushed down the transmit chain to the other
			transmit modules. <legal all>

schedule_lifetime_exp
			
			Scheduling command lifetime expiration time.
			
			A value of zero: Command never expires
			
			A non-zero value: the Timestamp at which the scheduler
			command expires. Note that End_Time_reference indicates what
			the reference timer is.
			
			HW assumes the timer wraps around at 32 bits, and checks
			that the actual reference time is within the programmed time
			and this value minus 2^31. If not, the lifetime is assumed
			to be expired. <legal all>

schedule_start_time
			
			Scheduling command start time.
			
			A value of zero: Start time check is not enabled
			
			A non-zero value: the Timestamp before which the
			scheduler command may not be executed. The TX scheduler
			module will pause till this time is reached. Note that
			Start_Time_reference indicates what the reference timer is.
			
			HW assumes the timer wraps around at 32 bits, and checks
			that  the actual reference time is within the programmed
			time (schedule_start_time) and this value plus 2^31. If not,
			start time has not been reached yet. <legal all>

peer_entry_ptr0
			
			Pointer to the peer entry for user 0
			
			This pointer is used by the scheduler to initially check
			if the STA is in power save mode or not. (this check can be
			enabled with sta_pwr_state_chk_en field)
			
			
			
			<legal all>

peer_entry_ptr1
			
			This entry is NOT valid when equal to 0.
			
			
			
			Pointer to the peer entry for user 1
			
			This pointer is used by the scheduler to initially check
			if the STA is in power save mode or not. (this check can be
			enabled with sta_pwr_state_chk_en field)
			
			<legal all>

peer_entry_ptr2
			
			This entry is NOT valid when equal to 0.
			
			
			
			Pointer to the peer entry for user 2
			
			This pointer is used by the scheduler to initially check
			if the STA is in power save mode or not. (this check can be
			enabled with sta_pwr_state_chk_en field)
			
			
			
			
			
			<legal all>
*/


/* Description		SCHEDULER_CMD_0_SCHEDULE_ID
			
			Schedule command identifier
			
			
			
			A field that HW copies over into the scheduling status
			report, so that SW can determine to which scheduler command
			the status report belongs.
			
			This schedule ID is also reported in the PPDU status.   
			  
			
			<legal all>
*/
#define SCHEDULER_CMD_0_SCHEDULE_ID_OFFSET                           0x00000000
#define SCHEDULER_CMD_0_SCHEDULE_ID_LSB                              0
#define SCHEDULER_CMD_0_SCHEDULE_ID_MASK                             0x0000ffff

/* Description		SCHEDULER_CMD_0_RESERVED_0A
			
			<legal 0>
*/
#define SCHEDULER_CMD_0_RESERVED_0A_OFFSET                           0x00000000
#define SCHEDULER_CMD_0_RESERVED_0A_LSB                              16
#define SCHEDULER_CMD_0_RESERVED_0A_MASK                             0x001f0000

/* Description		SCHEDULER_CMD_0_FES_CONTROL_MODE
			
			<enum 0  SW_transmit_mode>  No HW generated TLVs
			
			
			
			<enum 1 PDG_transmit_mode> PDG  is activated to generate
			TLVs
			
			
			
			Note: Final Bandwidth selection is always performed by
			TX PCU.
			
			
			
			<legal 0-1>
*/
#define SCHEDULER_CMD_0_FES_CONTROL_MODE_OFFSET                      0x00000000
#define SCHEDULER_CMD_0_FES_CONTROL_MODE_LSB                         21
#define SCHEDULER_CMD_0_FES_CONTROL_MODE_MASK                        0x00600000

/* Description		SCHEDULER_CMD_0_IBSS_BEACON_FRAME
			
			When set, this scheduling command refers to an IBSS
			beacon frame.
			
			
			
			In IBSS, beacon transmission is initiated at TBTT. The
			beacon will go out after a regular Backoff period, or not at
			all if a beacon from another STA belonging to the same IBSS
			is received. During this period, all backoff engines for
			regular data transmissions are paused. They get re-enabled
			when either the other beacon is received, or this beacon
			frame got transmitted (and this configuration bit was set).
			
			 <legal all>
*/
#define SCHEDULER_CMD_0_IBSS_BEACON_FRAME_OFFSET                     0x00000000
#define SCHEDULER_CMD_0_IBSS_BEACON_FRAME_LSB                        23
#define SCHEDULER_CMD_0_IBSS_BEACON_FRAME_MASK                       0x00800000

/* Description		SCHEDULER_CMD_0_MAX_SCHEDULE_RETRIES
			
			The maximum number of times this scheduler command can
			be tried if execution did not result in a successful FES
			transmission.
			
			
			
			For example: No ACK or BA frame was received at all
			after PPDU transmission. Or no CTS frame was received after
			transmitting an RTS.
			
			If for this transmission, no response frames are
			expected, this field will be ignored.<legal all>
*/
#define SCHEDULER_CMD_0_MAX_SCHEDULE_RETRIES_OFFSET                  0x00000000
#define SCHEDULER_CMD_0_MAX_SCHEDULE_RETRIES_LSB                     24
#define SCHEDULER_CMD_0_MAX_SCHEDULE_RETRIES_MASK                    0x0f000000

/* Description		SCHEDULER_CMD_0_PAUSE_ON_CBF_LOWER_BW
			
			Bit setting only valid when 'Send_ndp' is set.
			
			0: no action
			
			1: When received CBF has the CV report which is lower
			bandwidth than the bandwidth of the sounding sequence, pause
			the scheduler. This pausing will be notified to SW in the
			Scheduler Status report: Bit ???
			
			<legal all>
*/
#define SCHEDULER_CMD_0_PAUSE_ON_CBF_LOWER_BW_OFFSET                 0x00000000
#define SCHEDULER_CMD_0_PAUSE_ON_CBF_LOWER_BW_LSB                    28
#define SCHEDULER_CMD_0_PAUSE_ON_CBF_LOWER_BW_MASK                   0x10000000

/* Description		SCHEDULER_CMD_0_STALL_SCHEDULE_ENABLE
			
			0: No action
			
			1: Stall the scheduler processing of this scheduling
			command ring if the transmission is NOT successful
			(including the number of allowed retries). That is, no ACK,
			BA or sounding responses are received. Do not start on
			processing the next scheduling commands. <legal all>
*/
#define SCHEDULER_CMD_0_STALL_SCHEDULE_ENABLE_OFFSET                 0x00000000
#define SCHEDULER_CMD_0_STALL_SCHEDULE_ENABLE_LSB                    29
#define SCHEDULER_CMD_0_STALL_SCHEDULE_ENABLE_MASK                   0x20000000

/* Description		SCHEDULER_CMD_0_STA_PWR_STATE_CHK_EN
			
			When set, scheduler performs the STA power state check.
			For this the scheduler reads the peer entry, and if the STA
			power state indicates power save mode, the scheduling
			command is retired. This reason will be indicated in the
			scheduling status.
			
			
			
			When NOT set, no power save state check will be
			performed by the scheduler
*/
#define SCHEDULER_CMD_0_STA_PWR_STATE_CHK_EN_OFFSET                  0x00000000
#define SCHEDULER_CMD_0_STA_PWR_STATE_CHK_EN_LSB                     30
#define SCHEDULER_CMD_0_STA_PWR_STATE_CHK_EN_MASK                    0x40000000

/* Description		SCHEDULER_CMD_0_CLEAR_CV_INFO
			
			0: No action
			
			1: Clear all the internal scheduler CV tracking info.
			The result is that for a next beamformed transmission
			(including MU-MIMO) the scheduler will discard the CV info
			that might already have been in the PHY, and will force a
			new CV parameters read from memory.
*/
#define SCHEDULER_CMD_0_CLEAR_CV_INFO_OFFSET                         0x00000000
#define SCHEDULER_CMD_0_CLEAR_CV_INFO_LSB                            31
#define SCHEDULER_CMD_0_CLEAR_CV_INFO_MASK                           0x80000000

/* Description		SCHEDULER_CMD_1_SCR_TIMER0_RESTART
			
			Scheduler command ring (scr) timer 0 restart
			
			0: No action
			
			1: Restart the internal scheduler command ring timer0 at
			first time this scheduling command is evaluated by HW.
			<legal all>
*/
#define SCHEDULER_CMD_1_SCR_TIMER0_RESTART_OFFSET                    0x00000004
#define SCHEDULER_CMD_1_SCR_TIMER0_RESTART_LSB                       0
#define SCHEDULER_CMD_1_SCR_TIMER0_RESTART_MASK                      0x00000001

/* Description		SCHEDULER_CMD_1_SCR_TIMER1_RESTART
			
			Scheduler command ring (scr) timer 1 restart
			
			0: No action
			
			1: Restart the internal scheduler command ring timer1 at
			first time this scheduling command is evaluated by HW.
			<legal all>
*/
#define SCHEDULER_CMD_1_SCR_TIMER1_RESTART_OFFSET                    0x00000004
#define SCHEDULER_CMD_1_SCR_TIMER1_RESTART_LSB                       1
#define SCHEDULER_CMD_1_SCR_TIMER1_RESTART_MASK                      0x00000002

/* Description		SCHEDULER_CMD_1_SCR_TIMER0_RESTART_AFTER
			
			Scheduler command ring timer (scr) 0 restart after
			
			0: No action
			
			1: Restart the internal scheduler command ring timer0
			after this scheduling command has finished successfully (=>
			Ack was received, or no response expected) <legal all>
*/
#define SCHEDULER_CMD_1_SCR_TIMER0_RESTART_AFTER_OFFSET              0x00000004
#define SCHEDULER_CMD_1_SCR_TIMER0_RESTART_AFTER_LSB                 2
#define SCHEDULER_CMD_1_SCR_TIMER0_RESTART_AFTER_MASK                0x00000004

/* Description		SCHEDULER_CMD_1_SCR_TIMER1_RESTART_AFTER
			
			Scheduler command ring timer (scr) 1 restart after
			
			0: No action
			
			1: Restart the internal scheduler command ring timer1
			after this scheduling command has finished successfully (=>
			Ack was received, or no response expected) <legal all>
*/
#define SCHEDULER_CMD_1_SCR_TIMER1_RESTART_AFTER_OFFSET              0x00000004
#define SCHEDULER_CMD_1_SCR_TIMER1_RESTART_AFTER_LSB                 3
#define SCHEDULER_CMD_1_SCR_TIMER1_RESTART_AFTER_MASK                0x00000008

/* Description		SCHEDULER_CMD_1_SIFS_BURST_CONTINUATION
			
			SIFS burst continuation
			
			0: No action
			
			1: The next scheduling command needs to start at SIFS
			time after finishing the frame transmissions in this
			command. This allows for SIFS based bursting
			
			
			
			<legal all>
*/
#define SCHEDULER_CMD_1_SIFS_BURST_CONTINUATION_OFFSET               0x00000004
#define SCHEDULER_CMD_1_SIFS_BURST_CONTINUATION_LSB                  4
#define SCHEDULER_CMD_1_SIFS_BURST_CONTINUATION_MASK                 0x00000010

/* Description		SCHEDULER_CMD_1_BURST_CONTINUATION_IFS_TIME
			
			
			
			
			<enum 0  SIFS> : Interframe space between 2 consecutive
			scheduling commands is SIFS.
			
			<enum 1  PIFS> : Interframe space between 2 consecutive
			scheduling commands is PIFS. This mode can be used in
			combination with Qboost, where it is not known up front if
			there will be any return data coming when a qboost trigger
			frame has been sent.
			
			<legal all>
*/
#define SCHEDULER_CMD_1_BURST_CONTINUATION_IFS_TIME_OFFSET           0x00000004
#define SCHEDULER_CMD_1_BURST_CONTINUATION_IFS_TIME_LSB              5
#define SCHEDULER_CMD_1_BURST_CONTINUATION_IFS_TIME_MASK             0x00000020

/* Description		SCHEDULER_CMD_1_SIFS_BURST_FAILURE_CTRL
			
			
			<enum 0  allways_continue>  Continue with the next
			scheduling command in SIFS time irrespective of failure or
			success of this scheduling command
			
			<enum 1  pause_on_failure>  this scheduling command is a
			failure [schedule status does NOT indicate success], do NOT
			continue with the next scheduling command. Pause this
			scheduler command ring, till SW re-enables it.
			
			<enum 2  flush_on_failure>  Flush all remaining
			scheduling commands for this SIFS burst
			
			<enum 3  pifs_continue_on_failure>  If this scheduling
			command is a failure [schedule status does NOT indicate
			success], continue with the next schedule command in PIFS
			time.
			
			<legal 0-3>
*/
#define SCHEDULER_CMD_1_SIFS_BURST_FAILURE_CTRL_OFFSET               0x00000004
#define SCHEDULER_CMD_1_SIFS_BURST_FAILURE_CTRL_LSB                  6
#define SCHEDULER_CMD_1_SIFS_BURST_FAILURE_CTRL_MASK                 0x000000c0

/* Description		SCHEDULER_CMD_1_SIFS_BURST_FLUSH_TXOP
			
			Only valid when the previous scheduler command in this
			ring indicated: sifs_burst_continuation.
			
			
			
			0: No action
			
			1: If the remaining TXOP time is 0 or does not have
			enough time to transmit any frames, flush this scheduling
			command
			
			<legal all>
*/
#define SCHEDULER_CMD_1_SIFS_BURST_FLUSH_TXOP_OFFSET                 0x00000004
#define SCHEDULER_CMD_1_SIFS_BURST_FLUSH_TXOP_LSB                    8
#define SCHEDULER_CMD_1_SIFS_BURST_FLUSH_TXOP_MASK                   0x00000100

/* Description		SCHEDULER_CMD_1_SIFS_BURST_TXOP_RESTART_EN
			
			Only valid when the previous scheduler command in this
			ring indicated: sifs_burst_continuation.
			
			
			
			0: No action
			
			1: If from the previous SIFS commands, there is no TXOP
			time left to transmit any frame, then do NOT retire this
			command. Instead, keep this command and let it be the first
			command for the next transmission when the backoff engine
			expires.
			
			<legal all>
*/
#define SCHEDULER_CMD_1_SIFS_BURST_TXOP_RESTART_EN_OFFSET            0x00000004
#define SCHEDULER_CMD_1_SIFS_BURST_TXOP_RESTART_EN_LSB               9
#define SCHEDULER_CMD_1_SIFS_BURST_TXOP_RESTART_EN_MASK              0x00000200

/* Description		SCHEDULER_CMD_1_START_TIME_REFERENCE
			
			Indicates the reference clock to be used for checking
			the scheduling start time
			
			0: TSF1
			
			1: TSF2
			
			2: WB_Timer
			
			3: Internal scheduler command queue timer 0
			
			4: Internal scheduler command queue timer 1
			
			<legal 0-4>
*/
#define SCHEDULER_CMD_1_START_TIME_REFERENCE_OFFSET                  0x00000004
#define SCHEDULER_CMD_1_START_TIME_REFERENCE_LSB                     10
#define SCHEDULER_CMD_1_START_TIME_REFERENCE_MASK                    0x00001c00

/* Description		SCHEDULER_CMD_1_END_TIME_REFERENCE
			
			Indicates the reference clock to be used for checking
			the lifetime expiration time of the command.
			
			0: TSF1
			
			1: TSF2
			
			2: WB_Timer
			
			3: Internal scheduler command queue timer 0
			
			4: Internal scheduler command queue timer 1
			
			<legal 0-4>
*/
#define SCHEDULER_CMD_1_END_TIME_REFERENCE_OFFSET                    0x00000004
#define SCHEDULER_CMD_1_END_TIME_REFERENCE_LSB                       13
#define SCHEDULER_CMD_1_END_TIME_REFERENCE_MASK                      0x0000e000

/* Description		SCHEDULER_CMD_1_RESERVED_1A
			
			<legal 0>
*/
#define SCHEDULER_CMD_1_RESERVED_1A_OFFSET                           0x00000004
#define SCHEDULER_CMD_1_RESERVED_1A_LSB                              16
#define SCHEDULER_CMD_1_RESERVED_1A_MASK                             0xffff0000

/* Description		SCHEDULER_CMD_2_SCHEDULER_TLV_PTR
			
			The address location for the transmit TLVs.
			
			These TLVs get read/interpreted by the scheduler and
			when applicable pushed down the transmit chain to the other
			transmit modules. <legal all>
*/
#define SCHEDULER_CMD_2_SCHEDULER_TLV_PTR_OFFSET                     0x00000008
#define SCHEDULER_CMD_2_SCHEDULER_TLV_PTR_LSB                        0
#define SCHEDULER_CMD_2_SCHEDULER_TLV_PTR_MASK                       0xffffffff

/* Description		SCHEDULER_CMD_3_SCHEDULE_LIFETIME_EXP
			
			Scheduling command lifetime expiration time.
			
			A value of zero: Command never expires
			
			A non-zero value: the Timestamp at which the scheduler
			command expires. Note that End_Time_reference indicates what
			the reference timer is.
			
			HW assumes the timer wraps around at 32 bits, and checks
			that the actual reference time is within the programmed time
			and this value minus 2^31. If not, the lifetime is assumed
			to be expired. <legal all>
*/
#define SCHEDULER_CMD_3_SCHEDULE_LIFETIME_EXP_OFFSET                 0x0000000c
#define SCHEDULER_CMD_3_SCHEDULE_LIFETIME_EXP_LSB                    0
#define SCHEDULER_CMD_3_SCHEDULE_LIFETIME_EXP_MASK                   0xffffffff

/* Description		SCHEDULER_CMD_4_SCHEDULE_START_TIME
			
			Scheduling command start time.
			
			A value of zero: Start time check is not enabled
			
			A non-zero value: the Timestamp before which the
			scheduler command may not be executed. The TX scheduler
			module will pause till this time is reached. Note that
			Start_Time_reference indicates what the reference timer is.
			
			HW assumes the timer wraps around at 32 bits, and checks
			that  the actual reference time is within the programmed
			time (schedule_start_time) and this value plus 2^31. If not,
			start time has not been reached yet. <legal all>
*/
#define SCHEDULER_CMD_4_SCHEDULE_START_TIME_OFFSET                   0x00000010
#define SCHEDULER_CMD_4_SCHEDULE_START_TIME_LSB                      0
#define SCHEDULER_CMD_4_SCHEDULE_START_TIME_MASK                     0xffffffff

/* Description		SCHEDULER_CMD_5_PEER_ENTRY_PTR0
			
			Pointer to the peer entry for user 0
			
			This pointer is used by the scheduler to initially check
			if the STA is in power save mode or not. (this check can be
			enabled with sta_pwr_state_chk_en field)
			
			
			
			<legal all>
*/
#define SCHEDULER_CMD_5_PEER_ENTRY_PTR0_OFFSET                       0x00000014
#define SCHEDULER_CMD_5_PEER_ENTRY_PTR0_LSB                          0
#define SCHEDULER_CMD_5_PEER_ENTRY_PTR0_MASK                         0xffffffff

/* Description		SCHEDULER_CMD_6_PEER_ENTRY_PTR1
			
			This entry is NOT valid when equal to 0.
			
			
			
			Pointer to the peer entry for user 1
			
			This pointer is used by the scheduler to initially check
			if the STA is in power save mode or not. (this check can be
			enabled with sta_pwr_state_chk_en field)
			
			<legal all>
*/
#define SCHEDULER_CMD_6_PEER_ENTRY_PTR1_OFFSET                       0x00000018
#define SCHEDULER_CMD_6_PEER_ENTRY_PTR1_LSB                          0
#define SCHEDULER_CMD_6_PEER_ENTRY_PTR1_MASK                         0xffffffff

/* Description		SCHEDULER_CMD_7_PEER_ENTRY_PTR2
			
			This entry is NOT valid when equal to 0.
			
			
			
			Pointer to the peer entry for user 2
			
			This pointer is used by the scheduler to initially check
			if the STA is in power save mode or not. (this check can be
			enabled with sta_pwr_state_chk_en field)
			
			
			
			
			
			<legal all>
*/
#define SCHEDULER_CMD_7_PEER_ENTRY_PTR2_OFFSET                       0x0000001c
#define SCHEDULER_CMD_7_PEER_ENTRY_PTR2_LSB                          0
#define SCHEDULER_CMD_7_PEER_ENTRY_PTR2_MASK                         0xffffffff


#endif // _SCHEDULER_CMD_H_
