#!/bin/bash

USAGE_STRING="Usage: . setenv.sh [ZCN-1523H | ZCN-1523H-2-8] [NB]"
DEF_PRODUCE_NAME=ZCN-1523H
DEF_OEM_NAME=NB


######## CHECK INPUT ########
if [ "$1" = ""  ]; then
	INPUT_NAME="${DEF_PRODUCE_NAME}"
	INPUT_OEM="${DEF_OEM_NAME}"
	#echo "Default Product: ${DEF_PRODUCE_NAME} ${DEF_OEM_NAME}"
	#echo "Fail to set environment with no args!"
	#echo ${USAGE_STRING}
	#return
else
if [ "$2" = ""  ]; then
	echo "Default Oem: $1 ${DEF_OEM_NAME}"
	INPUT_OEM="${DEF_OEM_NAME}"
else
	INPUT_OEM="$2"
fi
	INPUT_NAME="$1"
fi

######## CHECK PRODUCT ########
case ${INPUT_NAME} in
ZCN-1523H)
	BOARD_TYPE="pb90"
#	IMG_ID=0x6615235a
	IMG_ID=0xAAAAAAAA
	PRODUCT_NAME="ZCN1523"
	;;
ZCN-1523H-2-8)
#	BOARD_TYPE="ap91fus"
	BOARD_TYPE="pb90"
	IMG_ID=0x66661523
	PRODUCT_NAME="ZCN1523"
	;;
*)
	echo "Invalid Produce Name!"
	echo ${USAGE_STRING}
	return
	;;
esac

######## CHECK OEM ########
case ${INPUT_OEM} in
NB)
	OEM_NAME=${INPUT_OEM}
	;;
MN)
	OEM_NAME=${INPUT_OEM}
	;;
*)
	echo "Invalid Oem Name!"
	echo ${USAGE_STRING}
	return
	;;
esac


######## EXPORT ENV ########
export BUILD_TOOLS=${TOPDIR}/build/gcc-3.4.4-2.16.1/build_mips_nofpu
export PATH=$BUILD_TOOLS/bin:$PATH
export TOPDIR=`pwd`
export APPS_DIR=${TOPDIR}/apps
export BUILD_TYPE=jffs2
export BOARD_TYPE
export TARGET_ROOT_DIR=${TOPDIR}/rootfs-${BOARD_TYPE}.build
export PRODUCT_NAME
export OEM_NAME
export IMG_ID
echo "======================================"
echo " Product Name: [${DEF_PRODUCE_NAME}]"
echo "     OEM Name: [${DEF_OEM_NAME}]"
echo "     Image ID: [$IMG_ID]"
echo "======================================"
cd build

######## CHECK ENV ########
if [ ! -d "${BUILD_TOOLS}" ]; then
	echo "Can NOT found '${BUILD_TOOLS}', please build toolchain first:"
	echo "'make toolchain_build'"
fi
