#ifdef ZCOM_TDM_COORDINATION

#include <linux/version.h>
#ifndef AUTOCONF_INCLUDED
#include <linux/config.h>
#endif

#include <linux/module.h>
#include <linux/skbuff.h>
#include <linux/netdevice.h>
#include <linux/if_vlan.h>

#include <linux/interrupt.h>
#include <linux/time.h>

#include <asm/unistd.h>
#include <asm-mips/mach-ar7240/ar7240.h>

#include "if_media.h"
#include "ieee80211_var.h"
#include "ah.h"
//#include "ath_internal.h"
//#include <net80211/ieee80211_var.h>

#include "stdm_config.h"
#include "ieee80211_dev_config.h"
#include <linux/string.h>

extern u_int16_t my_id;
extern u_int16_t sta_time_slice;
extern struct ieee80211vap * STDMvap;
extern uint32_t ar7240_ahb_freq;

static u_int16_t		TimeSlot;

static u_int8_t BeaconID;
static int stdm_tx_stop = 0;
static char *ar7240_timer3_name = "Timer3";

int bTimerIRQRegistered = 0;

#ifdef _ZCOM_TDM_WDS_
//
// type:                    1 byte, 0x38                [01 byte(s)]
// length:                  1 byte                      [02 byte(s)]
// identifier string:       8 bytes                     [10 byte(s)]
// version:                 1 byte                      [11 byte(s)]
// sequence number:         1 byte                      [12 byte(s)]
// total slices time:       2 bytes                     [14 byte(s)]
// time slices count:       1 byte                      [15 byte(s)]
// slave clients count:     1 byte                      [16 byte(s)]
// master mac:              6 bytes                     [22 byte(s)]
// + slave clients list:    8 bytes per slave client    [22 + 8*n byte(s)]
//   + slave client 1
//     - slave client 1 number:             1 byte, 1
//     - slave client 1 time slices count:  1 byte
//     - slave client 1 mac:                6 bytes
//   + slave client 2
//     - slave client 2 number:             1 byte, 2
//     - slave client 2 time slices count:  1 byte
//     - slave client 2 mac:                6 bytes
//   ...
//   + slave client n
//     - slave client n number:             1 byte, n
//     - slave client n time slices count:  1 byte
//     - slave client n mac:                6 bytes
//
u_int8_t *ieee80211_add_wds_stdm(u_int8_t *frame)
{
    struct ieee80211_wds_stdm_ie *ie = (struct ieee80211_wds_stdm_ie *)frame;

    // Init the members of the `ie`
    //
    ie->type = WDS_STDM_TYPE;
    ie->length = sizeof(*ie) - sizeof(ie->type) - sizeof(ie->length);
    memcpy(ie->identifier_string, WDS_STDM_UNIQUE_STRING, sizeof(ie->identifier_string));
    ie->version = WDS_STDM_VERSION;
    ie->sequence_number = BeaconID++;
    ie->total_slices_time = 0;
    ie->time_slices_count = 0;
    ie->slave_clients_count = 0;
    memset(ie->master_mac, 0, IEEE80211_ADDR_LEN);

    return frame + sizeof(*ie);
}

int ieee80211_parser_wds_stdm(struct ieee80211_node *ni, struct ieee80211_beacon_offsets *bo, struct sk_buff *skb)
{
    int i = 0;
    u_int8_t wds_stdm_length = 0;
    u_int32_t different_length = 0;
    struct ieee80211com *ic = ni->ni_ic;
    struct ieee80211_node** ni_list = ic->wds_handle->iv_wds_get_assocnodelist();
    int wdsNum = ic->wds_handle->iv_wds_get_assocnodenum();
    struct ieee80211vap *vap = ni->ni_vap;
    struct ieee80211_wds_stdm_ie *ie = (struct ieee80211_wds_stdm_ie *)bo->bo_wds_stdm;
    struct wds_stdm_slave_client *slave_clients = (struct wds_stdm_slave_client *)(bo->bo_wds_stdm + sizeof(*ie));
    
    if(ic->wds_handle == NULL) return 0;

    // Init the members of the `ie`
    //
    ie->type = WDS_STDM_TYPE;
    ie->length = sizeof(*ie) - sizeof(ie->type) - sizeof(ie->length);
    memcpy(ie->identifier_string, WDS_STDM_UNIQUE_STRING, sizeof(ie->identifier_string));
    ie->version = WDS_STDM_VERSION;
    ie->sequence_number = BeaconID++;
    ie->total_slices_time = ic->ic_lintval;
    ie->time_slices_count = 0;
    ie->slave_clients_count = 0;
    memcpy(ie->master_mac, ni->ni_vap->iv_myaddr, IEEE80211_ADDR_LEN);

    // update the slave clients list
    // 
    for (i = 0;i < wdsNum; i++)
    {
        struct ieee80211_node *node_head = NULL;
        struct wds_stdm_slave_client *p_slave_client = &slave_clients[ie->slave_clients_count];

        if (ni_list[i] == NULL || !ZCOMWDS_NODE_IS_WDS(ni_list[i]))
                continue;

#ifdef NODE_FREE_DEBUG
        node_head = ieee80211_ref_node(ni_list[i], __func__);
#else
        node_head = ieee80211_ref_node(ni_list[i]);
#endif

	// update the members of slave client
        //
        p_slave_client->number = ie->slave_clients_count;
        p_slave_client->time_slices_count = 1;
        memcpy(p_slave_client->mac, node_head->ni_macaddr, IEEE80211_ADDR_LEN);

        // update the members if `ie`
        //
        ie->time_slices_count += 1;
        ie->slave_clients_count++;
    }

    if (vap->iv_wds_stdm_mode == WDS_STDM_AP_REPEATER_MASTER)
    {
        if (vap->iv_unit < MAX_VAP_NUM)
        {
            struct ieee80211_node *node_head, *node_next;
            struct ieee80211_node_table *nt= ni->ni_table;
            TAILQ_FOREACH_SAFE(node_head, &nt->nt_node, ni_list, node_next)
            {
                if (node_head->ni_associd != 0)
                {
                    struct wds_stdm_slave_client *p_slave_client = &slave_clients[ie->slave_clients_count];

                    // update the members of slave client
                    //
                    p_slave_client->number = ie->slave_clients_count;
                    p_slave_client->time_slices_count = 1;
                    memcpy(p_slave_client->mac, node_head->ni_macaddr, IEEE80211_ADDR_LEN);

                    // update the members if `ie`
                    //
                    ie->time_slices_count += 1;
                    ie->slave_clients_count++;
                }
            }
        }
    }

    if (ie->time_slices_count == 0 || ie->slave_clients_count == 0) return 0;

    // update the `length` member of `ie`
    //
    ie->length += sizeof(slave_clients[0]) * ie->slave_clients_count;

    // adjust the memory of `skb`
    //
    wds_stdm_length = ie->length + sizeof(ie->type) + sizeof(ie->length);
    different_length = wds_stdm_length - bo->bo_wds_stdm_len;
    if (different_length == 0)
    {
        return 0; // length is not changed
    }
    else
    {
        if (different_length > 0)
        {
            skb_put(skb, different_length);
        }
        else if (different_length < 0)
        {
            skb_trim(skb, skb->len + different_length);
        }

        bo->bo_wds_stdm_len = wds_stdm_length;

        return 1; // length is changed
    }
}
#endif

u_int8_t *ieee80211_add_vqos(u_int8_t *frame){
	u_int8_t *frame_start = frame;		
	*frame++ = VQOS_TYPE_ID;										//type									
	ADDSHORT(frame, 0);												//length
	memcpy(frame, VQOS_UNIQUE_STRING, strlen(VQOS_UNIQUE_STRING)); //flag
	frame += strlen(VQOS_UNIQUE_STRING);
	*frame++ = VQOS_SUB_TYPE_ID;									//subtype
	*frame++ = BeaconID++;											//beacon id
	ADDSHORT(frame, 0);												//total slice time(ms)
	*frame++ = VQOS_RETAIN;										//retain
	memset(frame , 0, sizeof(struct elem_list));							//elem list
	*frame++ = 0x10;												//elem flag
	*frame++ = 0;													//sta num
	*frame++ = 0;													//time slice num
	*frame++ = VQOS_ELEMENT_ID;									//elem flag
	*(frame_start + 1) = (frame - frame_start - 3)&0xff;					//calculate length
	*(frame_start + 2) = (frame - frame_start - 3)>>8;
	return frame;
}

void ieee80211_parser_vqos(struct ieee80211_node *ni, struct ieee80211_beacon_offsets *bo, struct sk_buff *skb){
	struct ieee80211vap *vap = ni->ni_vap;
	struct ieee80211com *ic = ni->ni_ic;
	struct ieee80211_node_table *nt= ni->ni_table;
	struct ieee80211_node *node_head, *node_next;
	u_int16_t queue_len = 0;
	u_int16_t sta_id = 0;
	
	if(vap ->iv_unit>=MAX_VAP_NUM)
		return;
		//printk("[Taurus debug]:ath_index is invaild\n");			
	if (bo->bo_vqos == NULL)
		return;
	if (vap->iv_sta_assoc)
	{ 
		u_int8_t *frame = bo->bo_vqos;
		*frame++ = VQOS_TYPE_ID;										//type
		ADDSHORT(frame, 0);												//length
		memcpy((u_int8_t *)frame, VQOS_UNIQUE_STRING, strlen(VQOS_UNIQUE_STRING));  //flag
		frame += strlen(VQOS_UNIQUE_STRING);
		*frame++ = VQOS_SUB_TYPE_ID;									//subtype
		*frame++ = BeaconID++;											//beacon id
		ADDSHORT(frame, ic->ic_lintval);									//total slice time(ms)
		*frame++ = VQOS_RETAIN;											//retain
		//struct elem_list *cxtdm_list = (struct elem_list*)frm;
		*frame++ = VQOS_ELEMENT_ID;										//elem flag
		*frame++ = vap->iv_sta_assoc;										//The number of the sta that  connect to current VAP		
		ADDSHORT(frame, ic->ic_sta_assoc);									//total sta that connect to all VAP
		TAILQ_FOREACH_SAFE(node_head, &nt->nt_node, ni_list, node_next)
		{
			if (node_head->ni_associd != 0) 
			{
				sta_id++;
				if(vap!=node_head->ni_vap)           							//isn't current vap
					continue;
				memcpy(frame, node_head->ni_macaddr, IEEE80211_ADDR_LEN);
				frame += IEEE80211_ADDR_LEN;
				*frame++ = node_head->ni_rssi;
				*frame++ = 1;
				ADDSHORT(frame, sta_id - 1); 
			}
		}
		*frame++ = 0x77;													//end flag
		*((bo->bo_vqos)+1) = (frame-bo->bo_vqos - 3)&0xff;					//calculate length
		*((bo->bo_vqos)+2) = (frame-bo->bo_vqos - 3)>>8;
		queue_len = (IEEE80211_ADDR_LEN + VQOS_ELEMENT_RSSI_LENGTH + VQOS_ELEMENT_TS_LENGTH \
					+ VQOS_ELEMENT_TS_ID_LENGTH) * vap->iv_sta_assoc + 1;
	}

	if (queue_len != bo->bo_vqos_len){
		int diff_len;
		diff_len = queue_len - bo->bo_vqos_len;
		if (diff_len){
			skb_put(skb, diff_len);
		}
		bo->bo_vqos_len = queue_len;
	}
}

static inline void
ar7240_set_timer(u_long usec /* micro seconds */)
{
	usec = usec * (ar7240_ahb_freq / USEC_PER_SEC);
	ar7240_reg_wr(AR7240_GENERAL_TMR3, usec);
}

static inline void
ar7240_set_reload_timer(u_long usec /* micro seconds */)
{
	usec = usec * (ar7240_ahb_freq / USEC_PER_SEC);
	ar7240_reg_wr(AR7240_GENERAL_TMR3_RELOAD, usec);
}

static inline void
ar7240_init_timer(u_long usec /* micro seconds */)
{
	if(usec >TIME_SLICE_MAX)
		usec = TIME_SLICE_MAX;
	else if(usec <TIME_SLICE_MIN)
		usec = TIME_SLICE_MIN;
	
	local_irq_disable();
	ar7240_set_timer(usec);
	ar7240_set_reload_timer(usec);
	TimeSlot = 0;
	local_irq_enable();
}


void stdm_txq_sch(){
	if (STDMvap && STDMvap->iv_opmode == IEEE80211_M_STA){
		if (TimeSlot >= sta_time_slice){
			TimeSlot = 0;
		}
		if ((TimeSlot++ % sta_time_slice) == my_id){
			stdm_tx_stop = 0;
			if((STDMvap!=NULL)&&(STDMvap->iv_ah!=NULL))
				ath_hal_pauseTx(STDMvap->iv_ah, 0, 0);
		}
		else{
			if (!stdm_tx_stop){
				stdm_tx_stop = 1;
				if((STDMvap!=NULL)&&(STDMvap->iv_ah!=NULL))
					ath_hal_pauseTx(STDMvap->iv_ah, 0xf, 1);
			}
		}
	}
}

static irqreturn_t ar7240_timer3_interrupt(int cpl, void *dev_id, struct pt_regs *regs)
{
	stdm_txq_sch();
	return IRQ_HANDLED;
}

void StartPlatformTimer(u_long start_time)  // unit:us
{
	ar7240_init_timer(start_time);
	
	//printk("[Taurus debug]%s: time_slice = %ldms\n", __func__,start_time);
	if (!bTimerIRQRegistered)
	{
		int retval = -1;
		
		retval = request_irq(AR7240_MISC_IRQ_TIMER3,ar7240_timer3_interrupt,
					SA_INTERRUPT,ar7240_timer3_name,(void *)ar7240_timer3_name);
		
		if (retval)
		{
			printk("Oops! Register TIMER3 Failed!\n");
		}
		else
		{
			bTimerIRQRegistered = 1;
		}
	}

}

void StopPlatformTimer() {
	if ( bTimerIRQRegistered) {
		free_irq(AR7240_MISC_IRQ_TIMER3, (void *)ar7240_timer3_name);
		bTimerIRQRegistered = 0;
	}

	stdm_tx_stop = 0;
	if((STDMvap!=NULL)&&(STDMvap->iv_ah!=NULL))
		ath_hal_pauseTx(STDMvap->iv_ah, 0, 0);
}

void ResetPlatformTimer(u_long resetTimer) // unit:us
{
	ar7240_init_timer(resetTimer);
#ifdef _ZCOM_TDM_WDS_
	stdm_txq_sch();
#endif
	return;
}

EXPORT_SYMBOL(StartPlatformTimer);
EXPORT_SYMBOL(StopPlatformTimer);
EXPORT_SYMBOL(ResetPlatformTimer);
EXPORT_SYMBOL(bTimerIRQRegistered);
#endif
