/**************************************************************************/
/*                                                                        */
/*                                                                        */
/*           Copyright 1998 - 2001,                                       */
/*             Intoto, Inc, SANTACLARA, CA, USA                           */
/*                      ALL RIGHTS RESERVED                               */
/*                                                                        */
/*   Permission is hereby granted to licensees of Intoto,                 */
/*   Inc. products to use or abstract this computer program for the       */
/*   sole purpose of implementing a product based on                      */
/*   Intoto, Inc. products.No other rights to reproduce,                  */
/*   use,or disseminate this computer program, whether in part or in      */
/*   whole, are granted.                                                  */
/*                                                                        */
/*   Intoto, Inc. makes no representation or warranties                   */
/*   with respect to the performance of this computer program, and        */
/*   specifically disclaims any responsibility for any damages,           */
/*   special or consequential, connected with the use of this program.    */
/*                                                                        */
/************************************************************************ */
/************************************************************************/
/*  File         : sha1.h                                               */
/*                                                                      */
/*  Description  :                                                      */
/*                                                                      */
/*  Version      Date      Author      Change Description               */
/*  -------    --------    ------    ----------------------             */
/*                                                                      */
/************************************************************************/

#ifndef _IGWSHA1_H_
#define _IGWSHA1_H_

#ifndef _SHA_enum_
#define _SHA_enum_
enum
{
	shaSuccess = 0,
	shaNull,
	shaInputTooLong,
	shaStateError
};
#endif
#define IGW_SHA1HASH_SIZE				20
#define A_SHA_DIGEST_LEN				20
#define IGW8021X_PASS_PHRASE_MAX_LEN	63
#define IGW8021X_PASS_PHRASE_MIN_LEN	8
#define IGW8021X_MAX_SSID_LEN			32+1
#define T_FAILURE						0
#define T_SUCCESS						1

#define LOCAL
#define T_VOID		void
#define T_INT32		int
#define T_UINT8		unsigned char
#define T_UCHAR8	unsigned char
#define T_UINT32	unsigned int
#define T_CHAR8		char

typedef struct SHA1Context
{
	T_UINT32 Intermediate_Hash[IGW_SHA1HASH_SIZE/4];/* Message Digest  */

	T_UINT32 Length_Low;							/* Message length in bits      */
	T_UINT32 Length_High;							/* Message length in bits      */

													/* Index into message block array */
	T_INT32 Message_Block_Index;
	T_UINT8 Message_Block[64];						/* 512-bit message blocks      */

	int Computed;									/* Is the digest computed?     */
	int Corrupted;									/* Is the message digest corrupted? */
} SHA1Context;

T_VOID IGWHMACSHA1( T_UCHAR8 *text, T_INT32 text_len,
					T_UCHAR8 *key, T_INT32 key_len,
					T_UCHAR8 *digest);
#endif /* _SHA1_H_ */
