/*
 * if_zcom_wds.h
 */
#ifdef _ZCOM_FOR_WDS_
#ifndef __ZCOM_WLAN_WDS_H__
#define __ZCOM_WLAN_WDS_H__

////////////////////////////////////////////////////////////////////
// Basic data type defines
////////////////////////////////////////////////////////////////////
#include <stdbool.h>

#ifndef IN
#define IN
#endif

#ifndef OUT
#define OUT
#endif

////////////////////////////////////////////////////////////////////
// WDS module data defines
////////////////////////////////////////////////////////////////////
typedef struct WDS_CONTEXT* WDS_HANDLE;

typedef enum _WDS_NODE_TYPE
{
	WDS_NODE_UNKNOWN = 0,		// Invalid node type
	WDS_NODE_DESTINATION,
	WDS_NODE_ASSOCIATION
} WDS_NODE_TYPE, *PWDS_NODE_TYPE;

typedef enum _WDS_PACKET_STATUS
{
	WDS_PACKET_DISCARD,
	WDS_PACKET_UNICASTING,
	WDS_PACKET_BROADCASTING,
	WDS_PACKET_INDICATE,
	WDS_PACKET_BROADCASTING_INDICATE
} WDS_PACKET_STATUS, *PWDS_PACKET_STATUS;

#define WDS_MAC_ADDR_SIZE		6
typedef unsigned char	WDS_MAC_ADDR[WDS_MAC_ADDR_SIZE];

#define WDS_NULLDATA_INTVAL				(2 * HZ)
#define MAX_WDS_LAST_TIME				(30 * HZ)
#define MAX_WDS_NULLDATA_FAIL_COUNT		5
#define MAX_REMOTEMAP_COUNT				32

typedef	struct RouteMapEntry{
	struct RouteMapEntry*	pNextMap;
	WDS_MAC_ADDR			remoteApPC;
	u_int8_t				pad[2];
#define	MAX_WDS_MAP_LIFE_TICKS	30000			// in millisecond
	u_int32_t				ulLastActiveTicks;	// ticks in millisecond, record last time receive frame from it.
} RouteMapEntry;

typedef struct _WDS_NODE
{
	WDS_MAC_ADDR		MacAddr;
	WDS_NODE_TYPE		NodeType;
	RouteMapEntry		*RouteMapNode;
	u_int32_t			iRouteMapNodeCount;
	struct ieee80211_node *ni_wds_node;
} WDS_NODE, *PWDS_NODE;

#define WDS_MAX_ASSOC_NODE_NUM	255
typedef struct _WDS_ASSOC_NODE_LIST
{
	unsigned int		ulCount;
	struct ieee80211_node *assoc_node_ni[WDS_MAX_ASSOC_NODE_NUM];
} WDS_ASSOC_NODE_LIST, *PWDS_ASSOC_NODE_LIST;

typedef void*	PWDS_802_3_FRAME_HEADER;
typedef void*	PWDS_802_11_FRAME_HEADER;

////////////////////////////////////////////////////////////////////
// WDS module interface defines
////////////////////////////////////////////////////////////////////

/*
 *	Basic Operations
 */
typedef int (*ieee80211_hardstart_send_cb_t)(struct ieee80211vap *vap, struct ieee80211_node *ni, struct sk_buff *skb);

WDS_HANDLE WDS_Initialize(void);
void WDS_Release(void);
bool WDS_Reset(void);

/*
 *	Node operations
 */
PWDS_NODE
WDS_AddAssociationNode(
	IN const WDS_MAC_ADDR MacAddr,
	IN struct ieee80211_node* ni
);

PWDS_NODE
WDS_AddDestinationNode(
	IN WDS_HANDLE WdsHandle,
	IN const WDS_MAC_ADDR MacAddr,
	IN const WDS_MAC_ADDR MacAddrOfItsAssocNode
);

PWDS_NODE
WDS_FindNode(
	IN WDS_HANDLE WdsHandle,
	IN const WDS_MAC_ADDR MacAddr
);

struct ieee80211_node**
WDS_GetAssocNodeList(void);

/*
 *	Packet operations
 */
WDS_PACKET_STATUS
WDS_SendPacket(
	struct ieee80211vap *vap,
	IN const WDS_MAC_ADDR DestMacAddr,
	IN const WDS_MAC_ADDR SourceMacAddr,
	OUT struct ieee80211_node **ni
);

WDS_PACKET_STATUS
WDS_ReceivePacket(
	struct ieee80211vap *vap,
	IN const WDS_MAC_ADDR DestMacAddr,
	IN const WDS_MAC_ADDR SourceMacAddr,
	IN const WDS_MAC_ADDR TransmitterMacAddr,
	OUT struct ieee80211_node **ni
);
typedef WDS_PACKET_STATUS (*ieee80211_wds_send_packet_cb_t)(
					struct ieee80211vap *vap,
					u_int8_t *destAddr, u_int8_t *srcAddr,
					struct ieee80211_node **ni);
typedef WDS_PACKET_STATUS (*ieee80211_wds_recv_packet_cb_t)(
					struct ieee80211vap *vap,
					u_int8_t *destAddr, u_int8_t *srcAddr, u_int8_t *transAddr, 
					struct ieee80211_node **ni);
typedef struct ieee80211_node** (*ieee80211_wds_get_assocnodelist_cb_t)(void);
typedef u_int8_t (*ieee80211_wds_get_assocnodenum_cb_t)(void);
typedef int (*ieee80211_broad_to_wds_cb_t)(struct sk_buff *skb, 
					WDS_MAC_ADDR ExpectWDSMac, struct ieee80211vap *vap);
typedef PWDS_NODE (*iv_wds_add_assoc_node_cb_t)(const WDS_MAC_ADDR MacAddr,
					struct ieee80211_node* ni);
typedef struct ieee80211_node* (*iv_wds_del_assoc_node_cb_t)(const WDS_MAC_ADDR MacAddr);
typedef bool (*iv_wds_reset_cb_t)(void);
typedef void (*iv_wds_forward_packet_cb_t)(struct sk_buff *skb,
					struct ieee80211vap *vap,
					struct ieee80211_node *ni);
typedef struct ieee80211_node* (*iv_wds_find_rx_node_cb_t)(const u_int8_t *srcmac);
typedef void (*wds_set_wds_psk_cb_t)(struct ieee80211vap *vap, u_int8_t key_type, u_int8_t key_len, u_int8_t *passPhrase);
typedef bool (*wds_addRouteMapEntry_cb_t)(IN const WDS_MAC_ADDR RemoteAPAddr, IN const WDS_MAC_ADDR RemoteApPcAddr);
typedef bool (*wds_localPCEntryCheck_cb_t)(IN const WDS_MAC_ADDR SrcMacAddr);
typedef void (*wds_localPcMacAddEntry_cb_t)(IN const WDS_MAC_ADDR LocalApPcAddr);
typedef struct ieee80211_node* (*wds_remotePCCheck_cb_t)(IN const WDS_MAC_ADDR LocalApPcAddr);

struct ieee80211_wds_handle
{
	WDS_PACKET_STATUS (*iv_wds_send_packet)(IN	struct ieee80211vap *vap,
					u_int8_t *destAddr, u_int8_t *srcAddr,
					struct ieee80211_node **ni);
	WDS_PACKET_STATUS (*iv_wds_recv_packet)(IN	struct ieee80211vap *vap,
					u_int8_t *destAddr, u_int8_t *srcAddr, u_int8_t *transAddr, 
					struct ieee80211_node **ni);
	struct ieee80211_node** (*iv_wds_get_assocnodelist)(void);
	u_int8_t (*iv_wds_get_assocnodenum)(void);
	int (*iv_wds_broad_to_wds)(struct sk_buff *skb, 
					WDS_MAC_ADDR ExpectWDSMac, struct ieee80211vap *vap);
	void (*iv_wds_forward_packet)(struct sk_buff *skb,
					struct ieee80211vap *vap,
					struct ieee80211_node *ni);
	PWDS_NODE (*iv_wds_add_assoc_node)(const WDS_MAC_ADDR MacAddr,
					struct ieee80211_node* ni);
	struct ieee80211_node* (*iv_wds_del_assoc_node)(const WDS_MAC_ADDR MacAddr);
	struct ieee80211_node* (*iv_wds_find_rx_node)(const u_int8_t *srcmac);
	bool (*iv_wds_reset)(void);
	void (*wds_set_wds_psk)(struct ieee80211vap *vap, u_int8_t key_type, u_int8_t key_len, u_int8_t *passPhrase);
	bool (*wds_addRouteMapEntry)(IN const WDS_MAC_ADDR RemoteAPAddr, IN const WDS_MAC_ADDR RemoteApPcAddr);
	bool (*wds_localPCEntryCheck)(IN const WDS_MAC_ADDR SrcMacAddr);
	void (*wds_localPcMacAddEntry)(IN const WDS_MAC_ADDR LocalApPcAddr);
	struct ieee80211_node* (*wds_remotePCCheck)(IN const WDS_MAC_ADDR LocalApPcAddr);
};

void attach_wds_interface(struct ieee80211_wds_handle * *ppWdsHandle, ieee80211_hardstart_send_cb_t fc);
void deattach_wds_interface(struct ieee80211_wds_handle * *ppWdsHandle);


/*----------------------------------------------------------------------------
 *
 *---------------------------------------------------------------------------*/
#define IEEE80211_WDS_NULLDATA_LEN		16
#define IEEE80211_WDS_NULLDATA_MAGIC	"ALIVE"
#define IEEE80211_WDS_NULLDATA_MAGIC_LEN 5
#define IEEE80211_WDS_NULLDATA_VERSION	0x03
#define IEEE80211_WDS_NULLDATA_UNCMPT	0x10
#define IEEE80211_WDS_NULLDATA_REQ		0x01
#define IEEE80211_WDS_NULLDATA_RESP		0x02
#define IEEE80211_WDS_NULLDATA_OK		0x11
#define IEEE80211_WDS_NULLDATA_ERR		0x12

struct ieee80211_node *alloc_wds_node(struct ieee80211vap *vap, u_int8_t *macaddr, u_int8_t is_11n);
void add_wds_timer(struct ieee80211vap *vap);
void del_wds_timer(struct ieee80211vap *vap);
int ieee80211_wds_is_old_nulldata(struct ieee80211_node *ni, u_int8_t *frm, unsigned int len);
void ieee80211_wds_recv_nulldata(struct ieee80211_node *ni, u_int8_t *frm, unsigned int len, u_int8_t owl_cmpt);
int ieee80211_wds_send_nulldata(struct ieee80211_node *ni, u_int8_t type);

#endif//__ZCOM_WLAN_WDS_H__
#endif
