#ifndef _IF_ZCOM_INFO_H_
#define _IF_ZCOM_INFO_H_
#ifdef _ZCOM_INFO_
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/sched.h>
#include <linux/version.h>
#include <linux/module.h>
#include <linux/netdevice.h>
#include <linux/utsname.h>
#include <linux/if_arp.h>		/* XXX for ARPHRD_ETHER */
#include <net/iw_handler.h>
#include <asm/uaccess.h>
#include <asm/processor.h>
#include <net80211/ieee80211_var.h>

#define ZCOM_INFO_MACADDR 				"\x01\x00\x0c\xcc\xcc\xcc"
#define ZCOM_INFO_PROTOCOL				0x2000
#define ZCOM_INFO_VERSION				0x01
#define ZCOM_INFO_TTL					180
#define ZCOM_INFO_ID_MAC				0x0001
#define ZCOM_INFO_ID_IP					0x0002
#define ZCOM_INFO_ID_NAME				0x0003
#define ZCOM_INFO_ID_VERSION			0x0005
#define ZCOM_INFO_ID_PLATFORM			0x0006
#define ZCOM_INFO_INTVAL				(30 * HZ)

#define IS_ZCOM_INFO_PKT(eh)			(eh->ether_type == htons(ZCOM_INFO_PROTOCOL)	\
										&& memcmp(eh->ether_dhost, ZCOM_INFO_MACADDR, ETH_ALEN) == 0)

void del_zcominfo_timer(struct ieee80211vap *vap);
void add_zcominfo_timer(struct ieee80211vap *vap);
void ieee80211_recv_zcominfo(struct ieee80211_node *ni, u_int8_t *frm, u_int16_t frmlen);
int ieee80211_send_zcominfo(struct ieee80211_node *ni);

#endif
#endif	//_IF_ZCOM_INFO_H_
