#ifdef _ZCOM_INFO_
#include <linux/version.h>
#include <linux/module.h>
#include "if_ethersubr.h"
#include "if_zcom_info.h"
#include "ieee80211.h"

#define	IS_RUNNING(_dev) \
	((_dev->flags & (IFF_RUNNING|IFF_UP)) == (IFF_RUNNING|IFF_UP))

static int get_assoc_num(struct ieee80211vap* vap)
{
    struct ieee80211com *ic = vap->iv_ic;
	struct ieee80211_node_table *nt = &ic->ic_sta;
	struct ieee80211_node *ni;
	u_int gen, ulCount = 0;

	IEEE80211_SCAN_LOCK(nt);
	gen = nt->nt_scangen++;
restart:
	IEEE80211_NODE_LOCK(nt);
	TAILQ_FOREACH(ni, &nt->nt_node, ni_list) {
		if (ni->ni_scangen != gen)
		{
			ni->ni_scangen = gen;
			IEEE80211_NODE_UNLOCK(nt);
			if (vap != vap && vap != vap->iv_xrvap)		/* only entries for this vap (or) xrvap */
				continue;
			if (vap->iv_opmode == IEEE80211_M_HOSTAP && ni->ni_associd == 0)    /* only associated stations */
				continue;
			if (ni->ni_chan == IEEE80211_CHAN_ANYC) /* XXX bogus entry */
				continue;
			ulCount++;
			goto restart;
		}
	}
	IEEE80211_NODE_UNLOCK(nt);
	IEEE80211_SCAN_UNLOCK(nt);
	return ulCount;
}

static void ieee80211_zcominfo_timer(unsigned long arg)
{
	struct ieee80211vap* vap = (struct ieee80211vap *)arg;
	struct ieee80211com *ic = vap->iv_ic;

	if(!IS_RUNNING(vap->iv_dev)
	  || vap->iv_state != IEEE80211_S_RUN
	  || ic->ic_bsschan == IEEE80211_CHAN_ANYC
	  || ((ic->ic_flags & IEEE80211_F_SCAN) && !(vap->iv_flags_ext & IEEE80211_FEXT_VAP_IND))
	  || vap->iv_opmode == IEEE80211_M_MONITOR)
	{
		goto _end;
	}
#ifdef _ZCOM_FOR_WDS_
	if (ic->wds_handle
	 && (  ZCOMWDS_MODE_IS_WDS(ic)
#ifdef _ZCOM_LAN2LAN_
		|| vap->iv_opmode == IEEE80211_M_HOSTAP
#endif
		))
	{
		int i;
		struct ieee80211_node **ni_list = ic->wds_handle->iv_wds_get_assocnodelist();
		int wdsNum = ic->wds_handle->iv_wds_get_assocnodenum();

		for (i = 0;i < wdsNum; i++)
		{
			if (ni_list[i] != NULL && ni_list[i]->ni_vap == vap)
			{
				ieee80211_send_zcominfo(ieee80211_ref_node(ni_list[i]
					#ifdef NODE_FREE_DEBUG
									,__func__
					#endif
								));
			}
		}
	}
#endif
	if (vap->iv_opmode == IEEE80211_M_HOSTAP || vap->iv_opmode == IEEE80211_M_STA)
	{
		if (get_assoc_num(vap) > 0)
		{
			ieee80211_send_zcominfo(ieee80211_ref_node(vap->iv_bss
							#ifdef NODE_FREE_DEBUG
								,__func__
							#endif
							));
		}
	}

_end:
	mod_timer(&vap->zcominfo_timer, jiffies + ZCOM_INFO_INTVAL);
}
void del_zcominfo_timer(struct ieee80211vap *vap)
{
	del_timer(&vap->zcominfo_timer);
}
void add_zcominfo_timer(struct ieee80211vap *vap)
{
	del_zcominfo_timer(vap);
	init_timer(&vap->zcominfo_timer);
	vap->zcominfo_timer.function = ieee80211_zcominfo_timer;
	vap->zcominfo_timer.data = (unsigned long)vap;
	mod_timer(&vap->zcominfo_timer, jiffies + ZCOM_INFO_INTVAL / 2);
}


void ieee80211_recv_zcominfo(struct ieee80211_node *ni, u_int8_t *frm, u_int16_t frmlen)
{
	u_int8_t *p = frm, zcomversion, zcomttl;
	u_int16_t id, len, tmplen, zcomsum;

/*{
int i;
for (i=0; i<frmlen; i++)
	printk("%c%02x", i%16==0?'\n':' ', p[i]);
printk("\n");
}*/
	IEEE80211_DPRINTF(ni->ni_vap, IEEE80211_MSG_DEBUG | IEEE80211_MSG_DUMPPKTS,
	    "%s recv zcominfo frame\n", ether_sprintf(ni->ni_macaddr));
	zcomversion = *(p++);
	zcomttl = *(p++);
	zcomsum = ntohs(*(u_int16_t *)p);
	p += 2;
	if (zcomversion > ZCOM_INFO_VERSION)
		return;
	while (p < frm + frmlen)
	{
		id = ntohs(*(u_int16_t*)p);
		p += 2;
		len = ntohs(*(u_int16_t*)p);
		p += 2;
		switch(id)
		{
		case ZCOM_INFO_ID_IP:
			if (len >= sizeof(u_int32_t))
			{
				ni->ni_ipaddr = ntohl(*(u_int32_t*)p);
				p += sizeof(u_int32_t);
			}
			break;
		case ZCOM_INFO_ID_NAME:
			tmplen = MIN(sizeof(ni->ni_devname)-1, len);
			memcpy(ni->ni_devname, p, tmplen);
			ni->ni_devname[tmplen] = '\0';
			break;
		}
	}
}

int ieee80211_send_zcominfo(struct ieee80211_node *ni)
{
	struct ieee80211vap *vap = ni->ni_vap;
	struct ieee80211com *ic = vap->iv_ic;
	struct net_device *parent = ic->ic_dev;
	struct sk_buff *skb;
	struct ieee80211_cb *cb;
	struct ether_header *eth;
	u_int8_t *frm, *psum, *p;
	u_int16_t len, sum;

	len = ETH_HLEN
			 + sizeof(u_int8_t)			// version
			 + sizeof(u_int8_t)			// ttl
			 + sizeof(u_int16_t)		// fcs
			 + sizeof(u_int16_t) + sizeof(u_int16_t) + sizeof(ic->zcominfo_ip)			// ip
			 + sizeof(u_int16_t) + sizeof(u_int16_t) + strlen(ic->zcominfo_name)		// device name
			 + sizeof(u_int16_t) + sizeof(u_int16_t) + strlen(ic->zcominfo_version);	// version
	skb = dev_alloc_skb(len);
	if (skb == NULL) {
		/* XXX debug msg */
		vap->iv_stats.is_tx_nobuf++;
        ieee80211_free_node(ni);
		return -ENOMEM;
	}
	skb_put(skb, len);
	cb = (struct ieee80211_cb *)skb->cb;
	cb->ni = ni;
	skb->priority = WME_AC_BE;
	skb->dev = parent;
	// ether header
	eth = (struct ether_header *)skb->data;
	memcpy(eth->ether_dhost, ZCOM_INFO_MACADDR, ETH_ALEN);
	memcpy(eth->ether_shost, vap->iv_myaddr, ETH_ALEN);
	eth->ether_type = htons(ZCOM_INFO_PROTOCOL);
	// zcom info header
	frm = skb->data + ETH_HLEN;
	*(frm++) = ZCOM_INFO_VERSION;
	*(frm++) = ZCOM_INFO_TTL;
	psum = frm;	//checksum, fill it later
	frm += 2;
	// zcominfo TLV
	//ip
	*(u_int16_t *) frm = htons(ZCOM_INFO_ID_IP);
	frm += 2;
	*(u_int16_t *) frm = htons(sizeof(u_int32_t));
	frm += 2;
	*(u_int32_t *) frm = htonl(ic->zcominfo_ip);
	frm += 4;
	//devname
	*(u_int16_t *) frm = htons(ZCOM_INFO_ID_NAME);
	frm += 2;
	*(u_int16_t *) frm = htons(strlen(ic->zcominfo_name));
	frm += 2;
	strcpy(frm, ic->zcominfo_name);
	frm += strlen(ic->zcominfo_name);
	//version
	*(u_int16_t *) frm = htons(ZCOM_INFO_ID_VERSION);
	frm += 2;
	*(u_int16_t *) frm = htons(strlen(ic->zcominfo_version));
	frm += 2;
	strcpy(frm, ic->zcominfo_version);
	frm += strlen(ic->zcominfo_version);
	for (p=psum+2, sum=0; p<frm; p++)
		sum += *psum;
	*(u_int16_t *) psum = htons(sum);
/*{
u_int8_t *p = (u_int8_t *)skb->data;
int i;
for (i=0; i<skb->len; i++)
	printk("%c%02x", i%16==0?'\n':' ', p[i]);
printk("\n");
}*/
	IEEE80211_DPRINTF(vap, IEEE80211_MSG_DEBUG | IEEE80211_MSG_DUMPPKTS,
	    "%s send zcominfo frame to on channel %u\n",
	    ether_sprintf(ni->ni_macaddr), ieee80211_chan2ieee(ic, ic->ic_curchan));

	IEEE80211_NODE_STAT(ni, tx_data);
    ic->ic_lastdata = jiffies;
    vap->iv_lastdata = jiffies;
#ifdef _ZCOM_FOR_WDS_
	ni->ni_tx_last = jiffies;
#endif
	ieee80211_pwrsave_wakeup(vap, TRANSMIT);
	(void) dev_queue_xmit(skb);
	return 0;
}

#endif
