//
// Copyright (c) 2002 Z-Com	Nanjing, Inc. China
//
// Module Name:
//
// Globals Accessed:
//
// Callers:
//
// Called routines:
//
// Functional Description:
//
// Comments:
//
// Diagnostics:
//

//////////////////////////////////////////////////////////////////////////////
//																			//
//	 This program is free software;	you	can	redistribute it	and/or modify	//
//	 it	under the terms	of the GNU General Public License as published by	//
//	 the Free Software Foundation; either version 2	of the License,	or		//
//	 (at your option) any later	version.									//
//																			//
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
//		|---|---|---|---|---|---|---|---|									//
//		32	28	24	20	16	12	8	4	0									//
//		|---|---|---|---|---|---|---|---|									//
//		  1	  2	  3	  4	  5	  6	  7	  8										//
//																			//
//		bit	0 -	7	End	Node												//
//		bit	8 -	15	4th	Subtree												//
//		bit	16-	19	3rd	Subtree												//
//		bit	20-	23	2nd	Subtree												//
//		bit	24-	27	1st	Subtree												//
//		bit	28-	31	Reserved												//
//////////////////////////////////////////////////////////////////////////////
#ifndef	_DOT11_MIB_H_
#define	_DOT11_MIB_H_

# define IFNAMSIZ 16
# define SIOCDEVPRIVATE 0x89F0

typedef unsigned short UINT16;
typedef unsigned char UCHAR;
typedef unsigned char WLAN_MACADDR[6];
typedef signed char INT8;
typedef short INT16;
typedef int INT32;
typedef long long INT64;

typedef unsigned char UINT8;
typedef unsigned int UINT32;
typedef unsigned long long UINT64;

#ifndef __GNUC__
#define __attribute__(x)
#endif

#define __ATTRIB_PACK	__attribute__ ((packed))

/*
 *		MIB	NAME								MIB ID		// ASN ID		Size(byte) implement range default access	memo
 */
/*
 * Child IO_CONTROL	Command	define
 */

// 1.0.0.0.0: dot11smt
// 1.1.0.0.0: dot11StationConfigTable
// 1.1.1.0.0: dot11StationConfigEntry
#define	DOT11_STATION_ID						0x01110100	// 1.1.1.1.0  6	  *					  R		=according the card's HW mac address	  
#define	DOT11_MEDIUM_OCCUPANCY_LIMIT			0x01110200	// 1.1.1.2.0  2
#define	DOT11_CF_POLLABLE						0x01110300	// 1.1.1.3.0  1
#define	DOT11_CFP_PERIOD						0x01110400	// 1.1.1.4.0  1
#define	DOT11_CFP_MAX_DURATION					0x01110500	// 1.1.1.5.0  2
#define	DOT11_AUTHERNTICATION_RESPONSE_TIMEOUT	0x01110600	// 1.1.1.6.0  4
#define	DOT11_PRIVACY_OPTION_IMPLEMENTED		0x01110700	// 1.1.1.7.0  1	  *	(0..1)		1	  R		=1 TRUE
#define	DOT11_POWER_MANAGEMENT_MODE				0x01110800	// 1.1.1.8.0  1
#define	DOT11_DESIRED_SSID						0x01110900	// 1.1.1.9.0  32  *	Zero-terminal string
#define	DOT11_DESIRED_BSS_TYPE					0x01110a00	// 1.1.1.10.0 1	  *	(1..3)		1	  R		=1 INFRASTRUCTURE_BSS
#define	DOT11_OPERATIONAL_RATE_SET						0x01110b00	// 1.1.1.11.0 9	  *	see	the	following comment
//
//Mbps		  6		9	  12	18	  24	36	  48	54
//default	  0x8C,	0x12, 0x98,	0x24, 0xB0,	0x48, 0x60,	0x6C
//IsBasicRate Yes	No	  Yes	No	  Yes	No	  No	No
//each octet= (rate(in Mbps)*2)	| ((IsBasicRate)?0x80:0x00)
//
#define	DOT11_BEACON_PERIOD						0x01110c00	// 1.1.1.12.0 2	  *	(1..65535)	100	  RW	(20..1000)
#define	DOT11_DTIM_PERIOD						0x01110d00	// 1.1.1.13.0 1	  *	(1..255)	1	  RW
#define	DOT11_ASSOCIATION_RESPONSE_TIMEOUT		0x01110e00	// 1.1.1.14.0 4

// 1.2.0.0.0: dot11AuthenticationAlgorithmsTable
// 1.2.1.0.0: dot11AuthenticationAlgorithmsEntry
#define	DOT11_AUTHENTICATION_ALGORITHMS_INDEX	0x01210100	// 1.2.1.1.0  1
#define	DOT11_AUTHENTICATION_ALGORITHMS			0x01210200	// 1.2.1.2.0  1
#define	DOT11_AUTHENTICATION_ALGORITHMS_ENABLE	0x01210300	// 1.2.1.3.0  1

// 1.3.0.0.0: dot11WEPDefaultKeysTable
// 1.3.1.0.0: dot11WEPDefaultKeysEntry
#define	DOT11_WEP_DEFAULT_KEY_INDEX				0x01310100	// 1.3.1.1.0  1
#define	DOT11_WEP_DEFAULT_KEY_VALUE				0x01310200	// 1.3.1.2.0  5

// 1.4.0.0.0: dot11WEPKeyMappingsTable
#define	DOT11_WEP_KEY_MAPPINGS_ENTRY			0x01410000	// 1.4.1.0.0  28  *	see	the	sample,	different with 802.11b
//#define DOT11_WEP_KEY_MAPPING_INDEX			0x01410100	// 1.4.1.1.0  1
#define	DOT11_WEP_KEY_MAPPING_ADDRESS			0x01410200	// 1.4.1.2.0  6
#define	DOT11_WEP_KEY_MAPPING_WEP_ON			0x01410300	// 1.4.1.3.0  1
#define	DOT11_WEP_KEY_MAPPING_VALUE				0x01410400	// 1.4.1.4.0  5
#define	DOT11_WEP_KEY_MAPPING_STATUS			0x01410500	// 1.4.1.5.0  1

// 1.5.0.0.0: dot11PrivacyTable
// 1.5.1.0.0: dot11PrivacyEntry
#define	DOT11_PRIVACY_INVOKED					0x01510100	// 1.5.1.1.0  1	  *	(0..1)		0	  RW  0=false
#define	DOT11_WEP_DEFAULT_KEY_ID				0x01510200	// 1.5.1.2.0  1	  *	(1..4)		0	  RW
#define	DOT11_WEP_KEY_MAPPING_LENGTH			0x01510300	// 1.5.1.3.0  1
#define	DOT11_EXCLUDE_UNENCRYPTED				0x01510400	// 1.5.1.4.0  1
#define	DOT11_WEP_ICV_ERROR_COUNT				0x01510500	// 1.5.1.5.0  4
#define	DOT11_WEP_EXCLUDED_COUNT				0x01510600	// 1.5.1.6.0  4

// 1.6.0.0.0: dot11SMTnotification
// 1.6.1.0.0: dot11Disassociate
// 1.6.2.0.0: dot11Deauthenticate
// 1.6.3.0.0: dot11AuthenticateFail

// 2.0.0.0.0: dot11mac
// 2.1.0.0.0: dot11OperationTable
// 2.1.1.0.0: dot11OperationEntry
//#define DOT11_MAC_ADDRESS						0x02110100	// 2.1.1.1.0
#define	DOT11_RTS_THRESHOLD						0x02110200	// 2.1.1.2.0  2  *	(0..2347)	2347  RW
#define	DOT11_SHORT_RETRY_LIMIT					0x02110300	// 2.1.1.3.0  1
#define	DOT11_LONG_RETRY_LIMIT					0x02110400	// 2.1.1.4.0  1
#define	DOT11_FRAGMENTATION_THRESHOLD			0x02110500	// 2.1.1.5.0  2  *	(256..2346 even	only) 2346	RW
#define	DOT11_MAX_TRANSMIT_MSDU_LIFE_TIME		0x02110600	// 2.1.1.6.0  4
#define	DOT11_MAX_RECEIVE_LIFE_TIME				0x02110700	// 2.1.1.7.0  4
#define	DOT11_MANUFACTURER_ID					0x02110800	// 2.1.1.8.0  129
#define	DOT11_PRODUCT_ID						0x02110900	// 2.1.1.9.0  129


// 2.2.0.0.0: dot11CountersTable
// 2.2.1.0.0: dot11CountersEntry
#define	DOT11_TRANSMITTED_FRAGMENT_COUNT		0x02210100	// 2.2.1.1.0  4
#define	DOT11_MULTICAST_TRANSMITTED_FRAME_COUNT	0x02210200	// 2.2.1.2.0  4
#define	DOT11_FAILED_COUNT						0x02210300	// 2.2.1.3.0  4
#define	DOT11_RETRY_COUNT						0x02210400	// 2.2.1.4.0  4
#define	DOT11_MULTIPLE_RETRY_COUNT				0x02210500	// 2.2.1.5.0  4
#define	DOT11_FRAME_DUPLICATE_COUNT				0x02210600	// 2.2.1.6.0  4
#define	DOT11_RTS_SUCCESS_COUNT					0x02210700	// 2.2.1.7.0  4

#define	DOT11_RTS_FAILURE_COUNT					0x02210800	// 2.2.1.8.0  4
#define	DOT11_ACK_FAILURE_COUNT					0x02210900	// 2.2.1.9.0  4
#define	DOT11_RECEIVED_FRAGMENT_COUNT			0x02210a00	// 2.2.1.10.0 4
#define	DOT11_MULTICAST_RECEIVED_FRAME_COUNT	0x02210b00	// 2.2.1.11.0 4
#define	DOT11_FCS_ERROR_COUNT					0x02210c00	// 2.2.1.12.0 4
#define	DOT11_TRANSMITTED_FRAME_COUNT			0x02210d00	// 2.2.1.13.0 4
#define	DOT11_WEP_UNDECRYPTABLE_COUNT			0x02210e00	// 2.2.1.14.0 4

// 2.3.0.0.0: dot11GroupAddressesTable
// 2.3.1.0.0: dot11GroupAddressesEntry
#define	DOT11_GROUP_ADDRESSES_INDEX				0x02310100	// 2.3.1.1.0  1
#define	DOT11_ADDRESS							0x02310200	// 2.3.1.2.0  6
#define	DOT11_GROUP_ADDRESSES_STATUS			0x02310300	// 2.3.1.3.0  1

// 3.0.0.0.0: dot11res
// 3.1.0.0.0: dot11resAttribute
// 3.1.1.0.0: dot11ResourceTypeIDName
// 3.1.2.0.0: dot11ResourceInfoTable
// 3.1.2.1.0: dot11ResourceInfoEntry
#define	DOT11_MANUFACTURER_OUI					0x03120101	// 3.1.2.1.1  3
#define	DOT11_MANUFACTURER_NAME					0x03120102	// 3.1.2.1.2  129
#define	DOT11_MANUFACTURER_PRODUCT_NAME			0x03120103	// 3.1.2.1.3  129 *	string	  R
#define	DOT11_MANUFACTURER_PRODUCT_VERSION		0x03120104	// 3.1.2.1.4  129

// 4.0.0.0.0: dot11phy
// 4.1.0.0.0: dot11PhyOperationTable
// 4.1.1.0.0: dot11phyOperationEntry
#define	DOT11_PHY_TYPE							0x04110100	// 4.1.1.1.0  1
#define	DOT11_CURRENT_REG_DOMAIN				0x04110200	// 4.1.1.2.0  1
#define	DOT11_TEMP_TYPE							0x04110300	// 4.1.1.3.0  1

// 4.2.0.0.0: dot11PhyAntennaTable
// 4.2.1.0.0: dot11PhyAntennaEntry

// 4.3.0.0.0: dot11PhyTxPowerTable
// 4.3.1.0.0: dot11PhyTxPowerEntry

// 4.4.0.0.0: dot11PhyFHSSTable
// 4.4.1.0.0: dot11PhyFHSSEntry

// 4.5.0.0.0: dot11PhyDSSSSTable
// 4.5.1.0.0: dot11PhyDSSSEntry
#define	DOT11_CURRENT_CHANNEL					0x04510100	// 4.5.1.1.0  1	  *	(34|38|42|46 for MKK) 1	RW	=34
#define	DOT11_CCA_MODE_SUPPORTED				0x04510200	// 4.5.1.2.0  1
#define	DOT11_CURRENT_CCA_MODE					0x04510300	// 4.5.1.3.0  1
#define	DOT11_ED_THRESHOLD						0x04510400	// 4.5.1.4.0  4

// 4.6.0.0.0: dot11PhyIRTable
// 4.6.1.0.0: dot11PhyIREntry

// 4.7.0.0.0: dot11RegDomainsSupportedTable
// 4.7.1.0.0: dot11RegDomainsSupportEntry
#define	DOT11_REG_DOMAINS_SUPPORT_INDEX			0x04710100	// 4.7.1.1.0  1
#define	DOT11_REG_DOMAINS_SUPPORT_VALUE			0x04710200	// 4.7.1.2.0  1

// 4.8.0.0.0: dot11AntennasListTable
// 4.8.1.0.0: dot11AntennasListEntry

// 4.9.0.0.0: dot11SupportedDataRatesTxTable
// 4.9.1.0.0: dot11SupportedDataRatesTxEntry
#define	DOT11_SUPPORTED_DATA_RATES_TX_INDEX		0x04910100	// 4.9.1.1.0  1
#define	DOT11_SUPPORTED_DATA_RATES_TX_VALUE		0x04910200	// 4.9.1.2.0  1

// 4.10.0.0.0:	dot11SupportedDataRatesRxTable
// 4.10.1.0.0:	dot11SupportedDataRatesRxEntry
#define	DOT11_SUPPORTED_DATA_RATES_RX_INDEX		0x04a10100	// 4.10.1.1.0 1
#define	DOT11_SUPPORTED_DATA_RATES_RX_VALUE		0x04a10200	// 4.10.1.2.0 1

//
// the following are the Z-Com defined IDs
//
#define DOT11_ZCOM_11GMODE						0x00100000
#define DOT11_ZCOM_ABOLT						0x00100001
#define DOT11_ZCOM_ACCESS_CONTROL_ENTRY			0x00100002	//AccessControlEntry_t RW
#define DOT11_ZCOM_ACCESS_CONTROL_MODE			0x00100003	//1	* (0..2)  1		RW	=enabled
															//0= ACL disabled
															//1= ACL enabled
															//2= ACL strict
#define DOT11_ZCOM_AES_DEFAULT_KEY_ID			0x00100004	//1	* (1..4)  0		RW	1-4
#define DOT11_ZCOM_ANTENNA						0x00100005	//4
#define DOT11_ZCOM_AP_MODE						0x00100006	//1 *(0..5)	0		RW
															// 0= AP
															// 1= AP Client
															// 2= Bridge
															// 3= Bridge Enhanced
															// 4= Repeat
															// 5= Repeat Enhanced
															// 6= Promiscuous
#define DOT11_ZCOM_SCAN_RESULT					0x00100007
#define DOT11_ZCOM_ASSOC_STA_ENTRY				0x00100008	//AssocStaEntry_t	**	R
#define DOT11_ZCOM_AUTH_TYPE					0x00100009	//1	* (0..1)  0		RW
															//0= Open-System
															//1= Shared-Key
#define DOT11_ZCOM_AUTO_CHANNEL					0x0010000a
#define DOT11_ZCOM_BRIDGE						0x0010000b
		
#define DOT11_ZCOM_CIPHER_MODE					0x0010000c	//1	* (0..2)  0		RW	=WEP
															//0= WEP 
															//1= AES 
															//2= AUTO
#define DOT11_ZCOM_COUNTRY_CODE					0x0010000d	//2	* enum	  ?		RW	default	defined	by card
															// detail see programer's guide
#define DOT11_ZCOM_DYNAMIC_KEY					0x0010000e
#define DOT11_ZCOM_ECM							0x0010000f
#define DOT11_ZCOM_FORBID_W2W					0x00100010	//1	**(0..1)  0		RW	false
#define DOT11_ZCOM_HARDWARE_CAPABILITY			0x00100011
#define DOT11_ZCOM_HARDWARE_RETRY				0x00100012	//1	* (0..1)  1		RW	true
#define DOT11_ZCOM_HIDE_AP						0x00100013	//1	* (0..1)  0		RW	false
#define DOT11_ZCOM_KEY_SOURCE					0x00100014
#define DOT11_ZCOM_KICK_OUT_STA					0x00100015	//6	** macaddress	W
#define DOT11_ZCOM_MAX_STA_NUM					0x00100016
#define DOT11_ZCOM_OVERLAPPING_BSS				0x00100017
#define DOT11_ZCOM_PREAMBLE						0x00100018
#ifdef	_ZCOM_RADIO_TEST_
#define DOT11_ZCOM_RADIO_TEST					0x00100019
#endif//_ZCOM_RADIO_TEST_
#define DOT11_ZCOM_RATE_CONTROL					0x0010001a	//1	* (0..1)  1	RW	true
#define DOT11_ZCOM_SCAN_ACTION					0x0010001b
#define DOT11_ZCOM_SHORT_SLOT_TIME				0x0010001c
#define DOT11_ZCOM_SOFTWARE_RETRY				0x0010001d	//1	* (0..1)  1	RW	true
#define DOT11_ZCOM_STATISTIC					0x0010001e
#define DOT11_ZCOM_SUPER_G_OPTION				0x0010001f
#define DOT11_ZCOM_SWRETRY_MODE					0x00100020
#define DOT11_ZCOM_TX_POWER						0x00100021	//1	* (0..4)  0	RW	0=max
															//0= full power
															//1= -3	dB(50%)
															//2= -6	dB(25%)
															//3= -9	dB(12.5%)
															//4= min power
#define DOT11_ZCOM_TX_RATE						0x00100022	//1	* see DOT11_RATE_TABLE
#define DOT11_ZCOM_VALID_CHANNEL_LIST			0x00100023	//24	* bytes	array	R
#define DOT11_ZCOM_WDS_ENTRY					0x00100024
#define DOT11_ZCOM_WIRELESS_MODE				0x00100025
#define DOT11_ZCOM_PRIVATE_IE					0x00100026	// MgtPrivateIEs_t
#define DOT11_ZCOM_TX_POWER_DEFAULT				0x00100027
#define DOT11_ZCOM_TX_POWER_OVERRIDE			0x00100028	// 4	overRideTxPower

//Windy: define the following for AP-Client mode.
#define DOT11_ZCOM_NETWORK_STATUS				0x00100029
#define DOT11_ZCOM_CLIENT_BSSID					0x0010002a
#define DOT11_ZCOM_CLIENT_WMODE_RANGE			0x0010002b

//Define for power backoff
#define DOT11_ZCOM_XPD_INFO						0x0010002c	// 4bytes (uint32_t) Readonly
#define DOT11_ZCOM_RX_RSSI						0x0010002d	// 1bytes (uchar_t)  Readonly
#define NOISE_FLOOR_INVALID						0xffff
#define DOT11_ZCOM_NOISE_FLOOR					0x0010002e	// 4bytes (uint32_t)  Readonly 
															//Mask: 0x000001ff

#define DOT11_ZCOM_ISOLATION_WDS				0x0010002f
#define DOT11_ZCOM_DFS							0x00100100
#define DOT11_ZCOM_NOISE_THRESHOLD				0x00100110
#define DOT11_ZCOM_WME							0x00100120
#define DOT11_ZCOM_WMM_SET						0x00100121

// new added
#define DOT11_ZCOM_CHAN_POWER_INFO				0x00100200	//
#define DOT11_ZCOM_RATETOSIGNAL					0x00100122   //add by jxq

#define DOT11_ZCOM_PROBE						0x00100300

#define DOT11_ZCOM_PRIVACY_WDS_ENHANCE			0x00200004
#define DOT11_ZCOM_CTSMODE						0x00200005	// 4bytes (uint32_t) RWrite
#define DOT11_ZCOMCAP							0x00200006
#define DOT11_ZCOM_LONG_DETECT					0x00200007	// 4byte (uint32_t) read only
#define DOT11_ZCOM_RADIO						0x00200008	// Radio on/off, 4byte bool, R/W

/*
 * the following are the Z-Com defined DEBUG IDs
 */
#define DOT11_ZCOM_DRIFT_FREQUENCY				0x00300100
#define DOT11_APCLIENT_GATEWAY					0x00300101
#define DOT11_APCLIENT_GATEWAYMASK				0x00300102

#define DOT11_ZCOM_EXCLUDE						0x00300103

#define DOT11_ZCOM_REBOOT						0x00300104
#define DOT11_ZCOM_FACTORY_RESTORE				0x00300105

#define DOT11_ZCOM_VAP_INDEX					0x00300106
#define DOT11_ZCOM_VAP_ACTIVE					0x00300107
#define DOT11_ZCOM_VAP_MACADDRESS				0x00300108

// define for 11n
#define DOT11_ZCOM_CWM_MODE						0x00300201
#define DOT11_ZCOM_CWM_EXTOFFSET				0x00300202
#define DOT11_ZCOM_CWM_EXTPROTMODE				0x00300203
#define DOT11_ZCOM_CWM_EXTPROTSPACING			0x00300204
#define DOT11_ZCOM_CWM_ENABLE					0x00300205
#define DOT11_ZCOM_CWM_EXTBUSYTHRESHOLD			0x00300206
#define DOT11_ZCOM_CWM_CHWIDTH					0x00300207


/*
 * The MIB interface structure used between the application and the driver
 * to get/set 802.11 MIBs
 */
#define	WLAN_IO_MIB_GET	0x0001
#define	WLAN_IO_MIB_SET	0x0002

typedef enum MIB_STATUS
{
	MIB_ACCESS_ERROR=0,
} MIB_STATUS;

/* 802.11b 2312 ~ 2500 MHz, -19 ~ -7, 1 ~ 14  */
/* 802.11b 2312 ~ 2500 MHz, -19 ~ -7, 1 ~ 13  */
/* 802.11a 5120 ~ 5825 MHz, 24 ~ 165   */
#define CHANNEL_INDEX_MAX	230

#define BASIC11G_DOT11		0	/* 1,2 */
#define BASIC11G_DOT11B		1	/* 1,2,5.5,11 */
#define BASIC11G_DOT11G		2	/* 1,2,5.5,11,6,12,24 */
#define BASIC11G_OFDM		3	/* 6,12,24 */
#define BASIC11G_MIN		0
#define BASIC11G_MAX		BASIC11G_OFDM

typedef	struct
{
	INT32			lDot11WEPKeyIndex;	// 1-4 is DefaultKey else for Key Mapping
	UINT16			usKeyBitSize;
	unsigned char	puchKey[128/8];
} WEPKeyEntry_t;

typedef	struct
{
	INT32			lIndex;
	WLAN_MACADDR	Station;
	UINT32			ulIpAddr;
	UINT32			ulLastUpdateTime;
#define	DUT_STATUS_UNKNOWN	0
#define	DUT_STATUS_INACTIVE	1
#define	DUT_STATUS_ACTIVE	2
	UINT32			ulDutStatus;
	INT32			lRssi;
	UINT32			ulAssocTime;
#define STA_MODE_A		0		/* STA operates in 11a mode */
#define STA_MODE_G		1		/* STA operates in 11g mode */
#define STA_MODE_B		2		/* STA operates in 11b mode */
#define STA_MODE_108G	3		/* STA operates in 11g turbo mode */
	INT32			lWirelessMode;
} AssocStaEntry_t;

#define XPD_GAIN0	0x00000001
#define XPD_GAIN6	0x00000002
#define XPD_GAIN12	0x00000004
#define XPD_GAIN18	0x00000008

typedef	struct
{
	INT32			lAclIndex;	//index of ACL (1..4096)
	WLAN_MACADDR	Station;	//macaddress of the access controled station
#define MACACL_NONE				0x0000
#define MACACL_PRIVACYINVOKED	0x0001
#define MACACL_DENY				0x0002
#define MACACL_DEFAULT			0x0004
#define MACACL_KEY				0x0008
#define MACACL_DEL				0x0010
#define MACACL_SELFUP			0x0020
	UINT32			ulACLType;
	INT32			lKeyIndex;	//index of key(1..2048)
} AccessControlEntry_t;

typedef struct
{
	u_int32_t			lIndex;
	WLAN_MACADDR		BridgeMac;
	// Action
#define	BRIDGE_ACTION_APPEND		0x40000000L
#define	BRIDGE_ACTION_REMOVE_ONE	0x80000000L
#define	BRIDGE_ACTION_REMOVE_ALL	0xF0000000L
	// Status
#define	BRIDGE_STATUS_UNKNOWN	0
#define	BRIDGE_STATUS_INACTIVE	1
#define	BRIDGE_STATUS_ACTIVE	2
	u_int32_t		ulStatusOrAction;
} BridgeEntry_t;

typedef struct
{
	INT32			lIndex;
	WLAN_MACADDR	RemoteAP;
	WLAN_MACADDR	RemoteHost;
} WDSEntry_t;

typedef	struct
{
	INT32			lindex;
	UINT32			rssi;
	UINT32			channel;
	UINT32			wirelessmode;
	UINT8			ssid[36];	//Max string length is 32 
	UINT32			isWEP;
	WLAN_MACADDR	bssid;
	UINT32			isWPA;
	UINT32			isWPA_PSK;
	UINT32			isWPA2;
	UINT32			isWPA2_PSK;
} ApScan_t;

typedef	struct
{
#define SCAN_CANCEL		0x0
#define SCAN_START		0x1

#define SCAN_11B		0x01
#define SCAN_11G		0x02
#define SCAN_11A		0x04
#define SCAN_11ATURBO	0x08
#define SCAN_11APRIME	0x10
#define SCAN_11GTURBO	0x20
#define SCAN_ALL		0x3f
	UINT32		ScanAction;
#define ACTIVE			0x00
#define PASSIVE			0x01
	UINT32		ScanType;
	UINT8		wirelessmode;
	UINT32		channel;
} ApScanAction_t;

typedef	struct
{
	UINT8		uchpriv;
#define	VLAN_AES	0
#define	VLAN_WEP	1
#define	VLAN_NONE	2
#define	VLAN_NATIVE	3
#define	VLAN_STACK	4
	UINT16		usVlanTag;
} VlanEntry_t;

typedef	enum
{
	KEY_SOURCE_LOCAL = 0,
	KEY_SOURCE_SERVER,
	KEY_SOURCE_MIXED
} KeySource_e;

typedef struct
{
	WLAN_MACADDR	Station;
	UINT16			usKeyBitSize;
	UINT8			puchKey[256/8];
} DynamicKey_t;

typedef struct
{
	UINT16	cmd;
	UINT16	item;
	UINT16	data;
} Zcomcap_t;

typedef	struct
{
	UINT32	ulRequestType;
	UINT32	ulParam;
	UINT32	ulReturn;
} HardwareCapability_t;

typedef struct
{
#define	PRIVATE_IE_REMOVE_ALL		0x00000000
#define	PRIVATE_IE_FOR_BEACON		0x00000001
#define	PRIVATE_IE_FOR_PROBE_RESP	0x00000002
#define	PRIVATE_IE_FOR_BOTH			(PRIVATE_IE_FOR_BEACON|PRIVATE_IE_FOR_PROBE_RESP)
	UINT32		ulValidFrameBitmap;	// Valid for Beacon or/and Probe Response.
									// 0 remove all Private IEs
	UINT32		ulLength;			// 0 remove, otherwise update or append.
} MgtPrivateIEsHdr_t;

typedef	struct
{
	MgtPrivateIEsHdr_t	Hdr;
	UINT8				IEs[3];		// byte-align,actual buffer length depends on ulLength.
} MgtPrivateIEs_t;

typedef struct
{
	// OFDM rates power
	UINT8	uchPwr6;
	UINT8	uchPwr9;
	UINT8	uchPwr12;
	UINT8	uchPwr18;
	UINT8	uchPwr24;
	UINT8	uchPwr36;
	UINT8	uchPwr48;
	UINT8	uchPwr54;
	// CCK rates power
	UINT8	uchPwr1L;
	UINT8	uchPwr2L;
	UINT8	uchPwr2S;
	UINT8	uchPwr5_5L;
	UINT8	uchPwr5_5S;
	UINT8	uchPwr11L;
	UINT8	uchPwr11S;
	// XR's power power
	UINT8	uchPwrXR;
} TargetPower_t;

typedef struct
{
#ifdef BIG_ENDIAN
	UINT8	rsrv		: 1,
			aci			: 2,
			acm			: 1,
			aifs		: 4;
	UINT8	logCwMax	: 4,
			logCwMin	: 4;
#else
	UINT8	aifs		: 4,
			acm			: 1,
			aci			: 2,
			rsrv		: 1;
	UINT8	logCwMin	: 4,
			logCwMax	: 4;
#endif
	UINT16	txOpLimit;
} __ATTRIB_PACK WME_PARAM;

typedef struct {
	UINT32		ulMode;
	UINT32		ulQueue;
	UINT32		ulParamType;
	WME_PARAM	ulParamData;
} WMM_Param_t;

typedef	struct wlanStats_t
{
	struct wlanNetStats_t
	{
		UINT64	ullBytes;

		UINT64	ullPacketsTotal;
		UINT64	ullPacketsUnicast;
		UINT64	ullPacketsMulticast;
		UINT64	ullPacketsBroadcast;

		UINT64	ulPacketsError;
		UINT64	ulPacketsDropped;
	} Rx, Tx;
} wlanStats_t;

struct chanpower_info_t{
	u_int32_t freq;	// channel freq
	u_int32_t flags;// channel flags
	u_int8_t min;	// min power of this channel
	u_int8_t nonht;	// power of non-HT
	u_int8_t ht20;	// power of HT20 mode
	u_int8_t ht40;	// power of HT40 mode, if == 0,means not exist ht40 mode
	u_int8_t quarter;//
	u_int8_t half;	//
};
struct ieee80211req_chanpowers_t{
	u_int	ic_nchanpowers;
    struct chanpower_info_t ic_chanpowers[255];
	//struct chanpower_info_t ic_chanpowers[IEEE80211_CHAN_MAX];
};

#define	MAX_DATA_LEN	64
typedef	union IOReqData
{
	UINT8					uchar;
	UINT16					uint16;
	UINT32					uint32;
	WLAN_MACADDR			Station;
	VlanEntry_t				VlanEntry;
	BridgeEntry_t			BridgeEntry;
	WEPKeyEntry_t			WEPKeyEntry;
	DynamicKey_t			DynamicKey;
	Zcomcap_t				Zcomcap;
	AssocStaEntry_t			AssocStaEntry;
	AccessControlEntry_t	AccessControlEntry;
	WDSEntry_t				WDSEntry;
	ApScan_t				ApScanEntry;
	ApScanAction_t			ApScanAtion;
	WMM_Param_t				WMP;
	wlanStats_t				wlanStats;
	HardwareCapability_t	HwCapability;
	MgtPrivateIEs_t			MgtPrivateIEs;
	TargetPower_t			TargetPower;
	UINT8					puchData[MAX_DATA_LEN];
	UINT16					pusData[MAX_DATA_LEN/sizeof(UINT16)];
	struct ieee80211req_chanpowers_t	chanPowerInfo;
} IOReqData;

#define SIOCSIWREQ		(SIOCDEVPRIVATE + 12)
#define SIOCGIWREQ		(SIOCDEVPRIVATE + 13)
#define SIOCGIW_NAME	(SIOCDEVPRIVATE + 14)
#define	CORRECT_NAME	"ZCom.Madwifi"
#define IW_SCAN_ZCOM_START	0x1000

typedef struct zcomioreq
{
	union
	{
		char ifname[IFNAMSIZ];
	} sDevice;
	union
	{
		char	name[IFNAMSIZ];
		struct
		{
			UINT32	MIBCommand;
			UINT32	dataLength;
			INT32	IOReturn;
			void*	data;	//= &IOReqData
		} info;
	} u;
} zcomioreq_t;

#endif//_DOT11_MIB_H_
