//**************************************************************************
//	dot11MIB.c	-	 description
//	-------------------
//	Copyright	(c)	Nanjing	Z-Com, Inc.
//	http://www.zcom.com.cn
//**************************************************************************

//========================================================================//
// System	Includes
#include <linux/config.h>
#include <linux/version.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/skbuff.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/random.h>
#include <linux/delay.h>
#include <linux/cache.h>
#include <linux/sysctl.h>
#include <linux/proc_fs.h>
#include <linux/if_arp.h>
#include <asm/uaccess.h>

// Project Includesc
#include "if_media.h"
#include "net80211/ieee80211_var.h"
#include "net80211/ieee80211_scan.h"

#include "if_athproto.h"
#include "dot11MIB.h"

//========================================================================//
// Local Constants

//========================================================================//
// Local Macros
#define ENTRY_INDEX_BASE		1

#define keyValid(pKey)	((pKey)->keyLength != 0)

#define	MIB_PARAM_CHECK(TYPE)						\
	if ((NULL==pIOReq)||(ulDataLen<sizeof(TYPE)))	\
	{												\
		return -sizeof(TYPE);						\
	}

#define	MIB_LEN_CHECK(len)							\
	if ((NULL==pIOReq)||(ulDataLen<len))			\
	{												\
		return -len;								\
	}

#define MIB_COPY_VALUE(Type, Value)					\
	do { MIB_PARAM_CHECK(Type);						\
	memcpy(pIOReq, &(Value), sizeof(Type));			\
	nRet = sizeof(Type); } while(0)

#define MIB_ASSIGN_VALUE(Type, Value)				\
	do { MIB_PARAM_CHECK(Type);						\
	*(Type*)pIOReq = (Value);						\
	nRet = sizeof(Type); } while(0)

#define MODE_SELECT_11A		0x01
#define MODE_SELECT_11B		0x04
#define MODE_SELECT_11G		0x08


static int GetAssocEntry(struct ieee80211vap *vap, AssocStaEntry_t *entry)
{
	struct ieee80211com *ic = vap->iv_ic;
	struct ieee80211_node *ni;
	int id_node_assoc = 0;

	TAILQ_FOREACH(ni, &ic->ic_sta.nt_node, ni_list) {
		if (ni->ni_associd != 0) {
			if (id_node_assoc == entry->lIndex - 1)
				break;
			else {
				id_node_assoc++;
				continue;
			}
		}
	}

	if (ni != NULL)
	{
		entry->ulIpAddr = ni->ni_ipaddr;
		entry->lRssi = ic->ic_node_getrssi(ni,-1,IEEE80211_RSSI_RX) - 100;//ni->ni_rssi - 100;
		// the init value of jiffies is -(300 * HZ)
		entry->ulAssocTime = ni->ni_assoctime + (300 * HZ);
		entry->ulDutStatus = vap->iv_state;
		memcpy(entry->Station, ni->ni_macaddr, IEEE80211_ADDR_LEN);
		return 1;
	}
	return 0;
}

static int GetChanPowerInfo(struct ieee80211vap *vap, struct ieee80211req_chanpowers_t *info)
{
	struct ieee80211com *ic = vap->iv_ic;
	struct ieee80211_channel *c;
	struct chanpower_info_t *pThis, *pFirst;
	int i, j, rateNum;
	u_int16_t rateArray[64], min, max;

	info->ic_nchanpowers = 1;
	pFirst = &info->ic_chanpowers[0];	// auto channel
	pFirst->freq = 0;
	for (i=0; i<ic->ic_nchans; i++)
	{
		c = &ic->ic_channels[i];
		if (c->ic_flags & IEEE80211_CHAN_RADAR)
			continue;
		// skip chan14
		if (c->ic_ieee == 14)
			continue;

		// init
		min = max = 0;
		pThis = NULL;
		memset(rateArray, 0, sizeof(rateArray));
		// get power of rates
		rateNum = ic->ic_get_powerinfo(ic, c, rateArray, sizeof(rateArray));
		udelay(100);	// avoid get invalid power info
		if (rateNum <= 0)
			continue;
		//min = (c->ic_freq <= 2484) ? (8*2)		// 11g: ?dBm
		//	: (c->ic_freq <= 5650) ? (12*2)		// 5180~5650: 12dBm
		//	:  (9*2);							// > 5650: 9dBm
		min = (12*2);							// according to Meeting Minutes 2011/3/15
		for (j=0; j<rateNum; j++)
		{
			if (rateArray[j] > max)
				max = rateArray[j];
		}
		// collect
		for (j=0; j<info->ic_nchanpowers; j++)
		{
			if (info->ic_chanpowers[j].freq == c->ic_freq)
			{
				pThis = &info->ic_chanpowers[j];
				break;
			}
		}
		if (pThis == NULL)
		{
			pThis = &info->ic_chanpowers[info->ic_nchanpowers];
			info->ic_nchanpowers++;
		}
		pThis->freq = c->ic_freq;
		if (IEEE80211_IS_CHAN_11N_HT20(c) && !IEEE80211_IS_CHAN_HALF(c) && !IEEE80211_IS_CHAN_QUARTER(c))
		{
			pThis->ht20 = max;
			pThis->flags |= c->ic_flags & IEEE80211_CHAN_HT20;
			if (pFirst->ht20 < max)
				pFirst->ht20 = max;
		}
		else if (IEEE80211_IS_CHAN_11N_HT40(c) && !IEEE80211_IS_CHAN_HALF(c) && !IEEE80211_IS_CHAN_QUARTER(c) )
		{
			pThis->ht40 = max;
			pThis->flags |= c->ic_flags & (IEEE80211_CHAN_HT40MINUS | IEEE80211_CHAN_HT40PLUS);
			if (pFirst->ht40 < max)
				pFirst->ht40 = max;
		}
		else if (!IEEE80211_IS_CHAN_11N(c)&& !IEEE80211_IS_CHAN_HALF(c) && !IEEE80211_IS_CHAN_QUARTER(c))
		{
			pThis->nonht = max;
			if (pFirst->nonht < max)
				pFirst->nonht = max;
		}
		else if (IEEE80211_IS_CHAN_HALF(c))
		{
			pThis->half = max;			
			pThis->flags |= /*c->ic_flags & */(IEEE80211_CHAN_HALF);
			if (pFirst->half < max)
				pFirst->half = max;
		}
		else if (IEEE80211_IS_CHAN_QUARTER(c))
		{
			pThis->quarter = max;
			pThis->flags |= /*c->ic_flags & */IEEE80211_CHAN_QUARTER;
			if (pFirst->quarter < max)
				pFirst->quarter = max;
		}
		if (max != 0 && max < min)
			min = max;
		pThis->min = min;
		if (pFirst->min < min)
			pFirst->min = min;
	}
#if 0
	for (i=0, pThis=&info->ic_chanpowers[0]; i<info->ic_nchanpowers; i++, pThis++)
	{
		printf("[freq=%d, min=%d nonht=%d ht20=%d ht40=%d quar=%d, half=%d]\n",
			pThis->freq, pThis->min, pThis->nonht, pThis->ht20, pThis->ht40,
			pThis->quarter, pThis->half);
	}
#endif
	return info->ic_nchanpowers;
}

//------------------------------------------------------------------------//
//	WlanMIBGet
//
//	used to	Get	dot11MIB
//
//	Arguments:
//		pdevInfo : WLAN_DEV_INFO handle
//		ulMibCode: dot11MIB	command
//		pData: pointer for store the parameter
//		ulDataLen: buffer length of	pData
//
//	Returns:
//		<=0:	ERROR
//		>0:		length of	the	parameters to	get
//------------------------------------------------------------------------//
INT32
WlanMIBGet(
	struct ieee80211vap		*vap,
	UINT32					ulMibCode,
	IOReqData				*pIOReq,
	UINT32					ulDataLen
	)
{
	INT32	nRet = MIB_ACCESS_ERROR;
	struct net_device *pdev;
    	struct noderatemapsignal *nrms = NULL;
   	struct ieee80211_node *ni = NULL; 

	pdev = vap->iv_dev;
	switch	(ulMibCode)
	{
	case DOT11_ZCOM_ASSOC_STA_ENTRY:
		MIB_PARAM_CHECK(AssocStaEntry_t);
		if (GetAssocEntry(vap, &pIOReq->AssocStaEntry) == 1)
		{
			nRet = sizeof(AssocStaEntry_t);
		}
		break;
	case DOT11_ZCOM_STATISTIC:
		MIB_PARAM_CHECK(wlanStats_t);
		//RX statistics
		pIOReq->wlanStats.Rx.ullBytes 				= vap->iv_devstats.rx_bytes;
		pIOReq->wlanStats.Rx.ullPacketsTotal		= vap->iv_devstats.rx_packets 
													+ vap->iv_devstats.multicast
													+ vap->iv_devstats.collisions;
		pIOReq->wlanStats.Rx.ullPacketsUnicast		= vap->iv_devstats.rx_packets;
		pIOReq->wlanStats.Rx.ullPacketsMulticast	= vap->iv_devstats.multicast;
		pIOReq->wlanStats.Rx.ullPacketsBroadcast	= vap->iv_devstats.collisions;
		pIOReq->wlanStats.Rx.ulPacketsError			= vap->iv_devstats.rx_errors;
		pIOReq->wlanStats.Rx.ulPacketsDropped 		= vap->iv_devstats.rx_dropped;

		//TX statistics
		pIOReq->wlanStats.Tx.ullBytes				= vap->iv_devstats.tx_bytes;
		pIOReq->wlanStats.Tx.ullPacketsTotal		= vap->iv_devstats.tx_packets
													+ vap->iv_tx_multicast
													+ vap->iv_tx_broadcast;
		pIOReq->wlanStats.Tx.ullPacketsUnicast 		= vap->iv_devstats.tx_packets;
		pIOReq->wlanStats.Tx.ullPacketsMulticast	= vap->iv_tx_multicast;
		pIOReq->wlanStats.Tx.ullPacketsBroadcast	= vap->iv_tx_broadcast;
		pIOReq->wlanStats.Tx.ulPacketsError			= vap->iv_devstats.tx_errors;
		pIOReq->wlanStats.Tx.ulPacketsDropped 		= vap->iv_devstats.tx_dropped;
		nRet = sizeof(wlanStats_t);
		break;
	case DOT11_ZCOM_RATETOSIGNAL:
		nrms = (struct noderatemapsignal *) pIOReq;
		ni = ieee80211_find_txnode(vap, nrms->mac);
		
		if (ni != NULL) {
			memcpy(&nrms->rms, &ni->ni_rms, sizeof(struct ratemapsignal));
		}

		nRet =  sizeof(struct ratemapsignal);
		break;
	case DOT11_ZCOM_CHAN_POWER_INFO:
		MIB_PARAM_CHECK(struct ieee80211req_chanpowers_t);
		if (GetChanPowerInfo(vap, &pIOReq->chanPowerInfo))
		{
			nRet = sizeof(struct ieee80211req_chanpowers_t);
		}
		break;
	default:
		nRet = MIB_ACCESS_ERROR;
		break;
	}
	return nRet;
}

//------------------------------------------------------------------------//
//	WlanMIBSet
//
//	used to	set	dot11MIB parameters
//
//	Arguments:
//		pdevInfo : WLAN_DEV_INFO handle
//		ulMibCode: dot11MIB	command
//		pData: pointer for store the parameter
//		ulDataLen: buffer length of	pData
//
//	Returns:
//		<=0:	ERROR
//		>0:		length of	the	parameters has bee set
//------------------------------------------------------------------------//
INT32
WlanMIBSet(
	struct ieee80211vap		*vap,
	UINT32					ulMibCode,
	IOReqData				*pIOReq,
	UINT32					ulDataLen
	)
{
	INT32	nRet = MIB_ACCESS_ERROR;

	if (NULL == vap)
	{
		return nRet;
	}
	switch (ulMibCode)
	{
	default:
		nRet = MIB_ACCESS_ERROR;
		break;
	}
	return nRet;
}
