#ifndef _PKTLOG_INTERNAL_H
#define _PKTLOG_INTERNAL_H

#ifndef REMOVE_PKT_LOG

#include "pktlog.h"
#include "pktlog_rc.h"
#include "pktlog_hal.h"
#include "if_athvar.h"
#include "if_llc.h"

#define PKTLOG_DEFAULT_BUFSIZE (1024 * 1024)

extern struct ath_pktlog_funcs *g_pktlog_funcs;
extern struct ath_pktlog_halfuncs *g_pktlog_halfuncs;
extern struct ath_pktlog_rcfuncs *g_pktlog_rcfuncs;

/*
 * internal pktlog API's (common to all OS'es)
 */
void pktlog_init(struct ath_pktlog_info *pl_info);
void pktlog_cleanup(struct ath_pktlog_info *pl_info);
int pktlog_enable(struct ath_softc *sc, int32_t log_state);
int pktlog_setsize(struct ath_softc *sc, int32_t size);
void pktlog_txctl(struct ath_softc *sc, struct log_tx *log_data, u_int16_t flags);
void pktlog_txstatus(struct ath_softc *sc, struct log_tx *log_data, u_int16_t flags);
void pktlog_rx(struct ath_softc *sc, struct log_rx *log_data, u_int16_t flags);
void pktlog_ani(HAL_SOFTC hal_sc, struct log_ani *log_data, u_int16_t flags);
void pktlog_rcfind(struct ath_softc *sc, struct log_rcfind *log_data, u_int16_t flags);
void pktlog_rcupdate(struct ath_softc *sc, struct log_rcupdate *log_data, u_int16_t flags);
int pktlog_text(struct ath_softc *sc, char *tbuf, u_int16_t flags);
int pktlog_tcpip(struct ath_softc *sc, struct llc *llc, u_int32_t *proto_log, int *proto_len);
int pktlog_start(struct ath_softc *, int log_state);
int pktlog_read_hdr(struct ath_softc *, void *buf, u_int32_t buf_len,
                    u_int32_t *required_len,
                    u_int32_t *actual_len);
int pktlog_read_buf(struct ath_softc *, void *buf, u_int32_t buf_len,
                    u_int32_t *required_len,
                    u_int32_t *actual_len);


#define get_pktlog_state(_sc)  ((_sc)?(_sc)->pl_info->log_state: \
                                   g_pktlog_info->log_state)

#define get_pktlog_bufsize(_sc)  ((_sc)?(_sc)->pl_info->buf_size: \
                                     g_pktlog_info->buf_size)

/*
 * helper functions (OS dependent)
 */
void pktlog_disable_adapter_logging(void);
int pktlog_alloc_buf(struct ath_softc *sc, struct ath_pktlog_info *pl_info);
void pktlog_release_buf(struct ath_pktlog_info *pl_info);

#endif /* ifndef REMOVE_PKT_LOG */
#endif
