/*
 * Copyright (c) 2008, Atheros Communications Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _ATHRS_IOCTL_H
#define _ATHRS_IOCTL_H 1
typedef unsigned int uint32;
typedef unsigned char uint8;

#define DEFAULT_MACLIMIT	32

typedef struct eth_maclimit{
    uint32 portnum; /* Port # 1 - 4 */
    uint32 limit;  /* Limit of maximum MAC address per port, default : 32 */
}ETHCFG_MACLIMIT;

typedef struct eth_macaging{
    uint8         mac_addr[8]; /* MAC address */
    unsigned long maxagingtime; /* aging time in seconds */
    unsigned long curagingtime; /* aging time in seconds */
}ETHCFG_MACAGING;

typedef struct eth_mactbl{
    uint8 num_entries;  /* number of entries in the MAC table */
    uint8 mac_addr; /* MAC address table data */
}ETHCFG_MACTBL;

typedef enum eth_stormtype{
    ETH_STORMTYPE_BROADCAST,
    ETH_STORMTYPE_MULTICAST,
    ETH_STORMTYPE_UNICAST,
}ETH_STORMTYPE;

typedef struct eth_stomctl{
    uint32 portnum; /* Port # 1 - 4 */
    uint32 enabled; /* 0 -disabled, 1 - enabeld */
    ETH_STORMTYPE storm_type;
    uint32 storm_rate; /* in K pkt/sec */
}ETHCFG_STOMCTL;


typedef struct eth_stominfo{
    uint32 enabled; /* 0 -disabled, 1 - enabeld */
    uint32 storm_rate; /* in K pkt/sec */
}ETHCFG_STOMINFO;

typedef struct eth_portstomctl{
	uint32 portnum; /* Port # 1 - 4 */
	ETHCFG_STOMINFO broadcast;
	ETHCFG_STOMINFO multicast;
	ETHCFG_STOMINFO unicast;
}ETHCFG_PORTSTOMCTL;

#define DEFAULT_STORMRATE	100000 /* 100K */

typedef struct eth_storminfo{
    uint32 enabled; /* 0 -disabled, 1 - enabeld */
    uint32 storm_rate; /* in K pkt/sec */
}ETH_STORMINFO;

typedef union eth_cfg_cmd_parms{
	ETHCFG_STOMCTL stomctl;
	ETHCFG_PORTSTOMCTL portstomctl;
}ETH_CFGCMD_PARAMS;

typedef struct eth_cfg_params {
    uint32 cmd;
    ETH_CFGCMD_PARAMS cmdparams;
}ETHCFGPARAMS;

#define S26_RD_PHY       (SIOCDEVPRIVATE | 0x1)
#define S26_WR_PHY       (SIOCDEVPRIVATE | 0x2)
#define S26_FORCE_PHY    (SIOCDEVPRIVATE | 0x3)
#define ETH_STORMCTL_CFG  (SIOCDEVPRIVATE | 0x4)
#define ETH_STORMCTL_SHOW (SIOCDEVPRIVATE | 0x5)

#define ETH_LANCTLEXT_STROM_TYPE_MAX        3
#define ETH_LANCTLEXT_STROM_ENABLE_MAX      2

#define ETH_MAX_LANPORTS	4
#define ETH_LANCTLEXT_NOERROR	0
#define ETH_LANCTLEXT_ERROR_1	1
#define ETH_LANCTLEXT_ERROR_2	2
#define ETH_LANCTLEXT_ERROR_3	3
#define ETH_LANCTLEXT_ERROR_4	4
#define ETH_LANCTLEXT_ERROR_5	5
#define ETH_LANCTLEXT_ERROR_6	6


#define BRCTL_GET_ATHR_PHY_PORT_MAC_AGEING_INTERVAL 19
#define BRCTL_SET_ATHR_PHY_PORT_MAC_AGEING_INTERVAL 20
#define BRCTL_GET_ATHR_PHY_PORT_MAC_ADDR_LIMIT  21
#define BRCTL_SET_ATHR_PHY_PORT_MAC_ADDR_LIMIT  22
#define BRCTL_GET_ATHR_PHY_PORT_MAC_TABLE       23





#define ETH_LANCTLEXT_MAX_CMDS  7

typedef int (*ETHLANCMDPROC)(int argc,char *argv[]);


int athrs_ioctl_extension(struct eth_cfg_params *ethcfg, int cmd);

#endif //_ATHRS_IOCTL_H
