/*
 * This file contains the configuration parameters for the dbau1x00 board.
 */

#ifndef __CONFIG_H
#define __CONFIG_H

#include <configs/ar7240.h>

//#define DEBUG
//#define RUN_IN_RAM
//#define CONFIG_HW_WATCHDOG
//#define CONFIG_WATCHDOG
#define MFG_SUPPORT
/*-----------------------------------------------------------------------
 * FLASH and environment organization
 */
#define CFG_MAX_FLASH_BANKS     1	    /* max number of memory banks */
#define CFG_MAX_FLASH_SECT      128	//exten to 8M flash // 64    /* max number of sectors on one chip */
#define CFG_FLASH_SECTOR_SIZE   (64*1024)
#define CFG_FLASH_SIZE           0x00800000//extern to 8M flash //0x00400000 /* Total flash size */

#if (CFG_MAX_FLASH_SECT * CFG_FLASH_SECTOR_SIZE) != CFG_FLASH_SIZE
#	error "Invalid flash configuration"
#endif

#define CFG_FLASH_WORD_SIZE     unsigned short 

/* 
 * We boot from this flash
 */
#define CFG_FLASH_BASE		    0x9f000000

/* 
 * The following #defines are needed to get flash environment right 
 */
#define	CFG_MONITOR_BASE	TEXT_BASE
#define	CFG_MONITOR_LEN		(192 << 10)

#if CFG_FLASH_SIZE == 0x00800000	// 8M flash
#undef CONFIG_BOOTARGS
/* XXX - putting rootfs in last partition results in jffs errors */
#define	CONFIG_BOOTARGS     "console=ttyS0,115200 root=31:02 rootfstype=jffs2 init=/sbin/init mtdparts=ar7240-nor0:256k(u-boot),64k(u-boot-env),6208k(rootfs),1472k(uImage),64k(configure),64k(mfg),64k(eeprom)"

/* default mtd partition table */
#undef MTDPARTS_DEFAULT
#define MTDPARTS_DEFAULT    "mtdparts=ar7240-nor0:256k(u-boot),64k(u-boot-env),6208k(rootfs),1472k(uImage),64k(configure),64k(mfg),64k(eeprom)"
#else								// 4M flash
#undef CONFIG_BOOTARGS
/* XXX - putting rootfs in last partition results in jffs errors */
#define	CONFIG_BOOTARGS     "console=ttyS0,115200 root=31:02 rootfstype=jffs2 init=/sbin/init mtdparts=ar7240-nor0:256k(u-boot),64k(u-boot-env),2688k(rootfs),896k(uImage),64k(configure),64k(mfg),64k(reserved)"

/* default mtd partition table */
#undef MTDPARTS_DEFAULT
#define MTDPARTS_DEFAULT    "mtdparts=ar7240-nor0:256k(u-boot),64k(u-boot-env),2688k(rootfs),896k(uImage),64k(configure),64k(mfg),64k(reserved)"
#endif
#undef CFG_PLL_FREQ
#if 1
#define CFG_PLL_FREQ	CFG_PLL_350_350_175
#else
#define CFG_PLL_FREQ	CFG_PLL_400_400_200
#endif

#undef CFG_HZ
/*
 * MIPS32 24K Processor Core Family Software User's Manual
 *
 * 6.2.9 Count Register (CP0 Register 9, Select 0)
 * The Count register acts as a timer, incrementing at a constant
 * rate, whether or not an instruction is executed, retired, or
 * any forward progress is made through the pipeline.  The counter
 * increments every other clock, if the DC bit in the Cause register
 * is 0.
 */
/* Since the count is incremented every other tick, divide by 2 */
/* XXX derive this from CFG_PLL_FREQ */
#if (CFG_PLL_FREQ == CFG_PLL_200_200_100)
#	define CFG_HZ          (200000000/2)
#elif (CFG_PLL_FREQ == CFG_PLL_300_300_150)
#	define CFG_HZ          (300000000/2)
#elif (CFG_PLL_FREQ == CFG_PLL_350_350_175)
#	define CFG_HZ          (350000000/2)
#elif (CFG_PLL_FREQ == CFG_PLL_333_333_166)
#	define CFG_HZ          (333000000/2)
#elif (CFG_PLL_FREQ == CFG_PLL_266_266_133)
#	define CFG_HZ          (266000000/2)
#elif (CFG_PLL_FREQ == CFG_PLL_266_266_66)
#	define CFG_HZ          (266000000/2)
#elif (CFG_PLL_FREQ == CFG_PLL_400_400_200) || (CFG_PLL_FREQ == CFG_PLL_400_400_100)
#	define CFG_HZ          (400000000/2)
#elif (CFG_PLL_FREQ == CFG_PLL_320_320_80) || (CFG_PLL_FREQ == CFG_PLL_320_320_160)
#	define CFG_HZ          (400000000/2)
#endif


/* 
 * timeout values are in ticks 
 */
#define CFG_FLASH_ERASE_TOUT	(2 * CFG_HZ) /* Timeout for Flash Erase */
#define CFG_FLASH_WRITE_TOUT	(2 * CFG_HZ) /* Timeout for Flash Write */

/*
 * Cache lock for stack
 */
#define CFG_INIT_SP_OFFSET	0x1000

#define	CFG_ENV_IS_IN_FLASH    1
#undef CFG_ENV_IS_NOWHERE  

/* Address and size of Primary Environment Sector	*/
#define CFG_ENV_ADDR		0x9f040000
#define CFG_ENV_SIZE		0x10000

//#define CONFIG_BOOTCOMMAND "bootm 0x9f300000"
#define CONFIG_BOOTCOMMAND "bootm " MK_STR(CONFIG_UIMAGE_ADDR)
//#define CONFIG_FLASH_16BIT

/* DDR init values */

#define CONFIG_NR_DRAM_BANKS	2
#define CFG_DDR_REFRESH_VAL     0x4f10
#if 1
#define CFG_DDR_CONFIG_VAL      0xc7bc8cd0
#else	// to Test... result ???
#define CFG_DDR_CONFIG_VAL      0x77bc8cd0
#endif
#define CFG_DDR_MODE_VAL_INIT   0x133
#define CFG_DDR_EXT_MODE_VAL    0x0
#define CFG_DDR_MODE_VAL        0x33

#define CFG_DDR_TRTW_VAL        0x1f
#define CFG_DDR_TWTR_VAL        0x1e

#if 1
#define CFG_DDR_CONFIG2_VAL	 0x9dd0e6a8
#else	// to Test... result ???
#define CFG_DDR_CONFIG2_VAL	 0x9fd1f6a2
#endif
#define CFG_DDR_RD_DATA_THIS_CYCLE_VAL  0x00ff

/* DDR2 Init values */
#define CFG_DDR2_EXT_MODE_VAL    0x402

#define CONFIG_NET_MULTI

#define CONFIG_MEMSIZE_IN_BYTES
#define CONFIG_PCI

/*-----------------------------------------------------------------------
 * Cache Configuration
 */
#define CONFIG_COMMANDS	(( CONFIG_CMD_DFL | CFG_CMD_DHCP | CFG_CMD_ELF | CFG_CMD_PCI |	\
	CFG_CMD_MII | CFG_CMD_PING | CFG_CMD_NET | CFG_CMD_JFFS2 | CFG_CMD_ENV |	\
	CFG_CMD_FLASH | CFG_CMD_LOADS | CFG_CMD_RUN | CFG_CMD_LOADB | CFG_CMD_ELF | CFG_CMD_ETHREG ))

#ifdef DEBUG
#define CONFIG_IPADDR   192.168.12.207
#define CONFIG_SERVERIP 192.168.12.206
#else
#define CONFIG_IPADDR   192.168.0.35
#define CONFIG_SERVERIP 192.168.0.36
#endif
#define CONFIG_NETMASK	255.255.255.0
#define CONFIG_ETHADDR 0x00:0xaa:0xbb:0xcc:0xdd:0xee
#define CFG_FAULT_ECHO_LINK_DOWN    1


#define CFG_PHY_ADDR 0 
#define CFG_AG7240_NMACS 1
#define CFG_GMII     0
#define CFG_MII0_RMII             1
#define CFG_AG7100_GE0_RMII             1

#define CFG_BOOTM_LEN	(16 << 20) /* 16 MB */
#define CFG_HUSH_PARSER
#define CFG_PROMPT_HUSH_PS2 "hush>"

#define CONFIG_MFG_PARTION
#define TMP_MEM_ADDR			0x82100000
#define CONFIG_RAM_ART_ADDR		0x8005fffc
#if CFG_FLASH_SIZE == 0x00800000	// 8M flash
#define	CONFIG_UBOOT_ADDR		0x9f000000	// = CFG_FLASH_BASE
#define	CONFIG_UBOOT_ADDR_END	0x9f03ffff
#define	CONFIG_ENV_ADDR			0x9f040000	// = CFG_ENV_ADDR
#define	CONFIG_ENV_ADDR_END		0x9f04ffff
#define CONFIG_ROOTFS_ADDR		0x9f050000
#define CONFIG_ROOTFS_ADDR_END	0x9f65ffff
#define CONFIG_UIMAGE_ADDR		0x9f660000
#define CONFIG_UIMAGE_ADDR_END	0x9f75ffff	//0x9f7cffff	// reserved for oem data
#define CONFIG_CFG_ADDR			0x9f7d0000
#define CONFIG_CFG_ADDR_END		0x9f7dffff
#define CONFIG_MFG_ADDR			0x9f7e0000
#define CONFIG_MFG_ADDR_END		0x9f7effff
#define CONFIG_EEPROM			0x9f7f0000
#define CONFIG_EEPROM_END		0x9f7fffff
#else	// 4M flash
#define	CONFIG_UBOOT_ADDR		0x9f000000	// = CFG_FLASH_BASE
#define	CONFIG_UBOOT_ADDR_END	0x9f03ffff
#define	CONFIG_ENV_ADDR			0x9f040000	// = CFG_ENV_ADDR
#define	CONFIG_ENV_ADDR_END		0x9f04ffff
#define CONFIG_ROOTFS_ADDR		0x9f050000	// 2688 K
#define CONFIG_ROOTFS_ADDR_END	0x9f2effff
#define CONFIG_UIMAGE_ADDR		0x9f2f0000	// 896 K
#define CONFIG_UIMAGE_ADDR_END	0x9f3cffff
#define CONFIG_CFG_ADDR			0x9f3d0000	// 64 K
#define CONFIG_CFG_ADDR_END		0x9f3dffff
#define CONFIG_MFG_ADDR			0x9f3e0000	// 64 K
#define CONFIG_MFG_ADDR_END		0x9f3effff
#define CONFIG_EEPROM			0x9f3f0000	// 64 k
#define CONFIG_EEPROM_END		0x9f3fffff
#endif
#define	CONFIG_MFG_ID			0xaaaa
#define	CONFIG_DOMAIN_ID		0x8348
#define DEFAULT_UBOOT_NAME 		"uboot.bin"
#define DEFAULT_MODEL_NAME 		"ZCN1523-2-8"
#define DEFAULT_CONFIG_NAME 	"config.bin"
#define DEFAULT_FIRMWARE_NAME 	"ap.img"
#define DEFAULT_RIMAGE_NAME		"ap91fus-jffs2"
#define DEFAULT_ART_NAME		"ap91fus-art.bin"
#define	DEFAULT_KIMAGE_NAME		"vmlinux.lzma.uImage"

#define GPIO_PIN_WATCHDOG		1
#define GPIO_BTN_MFG			12
#define GPIO_BTN_RESET			0
#define GPIO_LED_INIT			11
#define GPIO_LED_LAN			17

/*
** Parameters defining the location of the calibration/initialization
** information for the two Merlin devices.
** NOTE: **This will change with different flash configurations**
*/

#define WLANCAL                        0xbfff1000
#define BOARDCAL                       0xbfff0000
#define ATHEROS_PRODUCT_ID             138
#define CAL_SECTOR                     (CFG_MAX_FLASH_SECT - 1)

/* For Kite, only PCI-e interface is valid */
#define AR7240_ART_PCICFG_OFFSET        3



#include <cmd_confdefs.h>

#endif	/* __CONFIG_H */
