#include <common.h>
#include <command.h>
#include <asm/mipsregs.h>
#include <asm/addrspace.h>
#include <config.h>
#include <version.h>
#include "ar7240_soc.h"

extern void ar7240_ddr_initial_config(uint32_t refresh);
extern int ar7240_ddr_find_size(void);

void
ar7240_usb_initial_config(void)
{
    ar7240_reg_wr_nf(AR7240_USB_PLL_CONFIG, 0x0a04081e);
    ar7240_reg_wr_nf(AR7240_USB_PLL_CONFIG, 0x0804081e);
}

void ar7240_gpio_config()
{
    /* Disable clock obs */
    ar7240_reg_wr (AR7240_GPIO_FUNC, (ar7240_reg_rd(AR7240_GPIO_FUNC) & 0xffe7e0ff));
    /* Enable eth Switch LEDs */
    ar7240_reg_wr (AR7240_GPIO_FUNC, (ar7240_reg_rd(AR7240_GPIO_FUNC) | 0xf8));
}

int
ar7240_mem_config(void)
{
#ifndef RUN_IN_RAM
    unsigned int tap_val1, tap_val2;
    ar7240_ddr_initial_config(CFG_DDR_REFRESH_VAL);

/* Default tap values for starting the tap_init*/
    ar7240_reg_wr (AR7240_DDR_TAP_CONTROL0, 0x8);
    ar7240_reg_wr (AR7240_DDR_TAP_CONTROL1, 0x9);

    ar7240_gpio_config();
    ar7240_ddr_tap_init();

    tap_val1 = ar7240_reg_rd(0xb800001c);
    tap_val2 = ar7240_reg_rd(0xb8000020);
    printf("#### TAP VALUE 1 = %x, 2 = %x\n",tap_val1, tap_val2);

    ar7240_usb_initial_config();

#endif
    return (ar7240_ddr_find_size());
}

long int initdram(int board_type)
{
    return (ar7240_mem_config());
}

int checkboard (void)
{
    printf("AP91 (ar7240) U-boot\n");
    return 0;
}

void zcom_init_pin(void)
{
	// gpio led: diable ethernet led pin 13~16
	ar7240_reg_rmw_clear(AR7240_GPIO_FUNC, 0x78);
	// lan led: enable ethernet led pin 17
	//ar7240_reg_rmw_set(AR7240_GPIO_FUNC, (1<<GPIO_LED_LAN));
	// lan & wlan led: enable output pin 11,13,14,15,17
	ar7240_reg_rmw_set(AR7240_GPIO_OE, 0x2e800);
	// default btn,WPS btn: enable input pin 16,12
	ar7240_reg_rmw_clear(AR7240_GPIO_OE, (1<<GPIO_BTN_RESET));
	ar7240_reg_rmw_clear(AR7240_GPIO_OE, (1<<GPIO_BTN_MFG));
	// turn on init led
	//ar7240_reg_rmw_set(AR7240_GPIO_OE, (1<<GPIO_LED_INIT));
	ar7240_reg_rmw_clear(AR7240_GPIO_OUT, (1<<GPIO_LED_INIT));
#if defined(CONFIG_WATCHDOG) || defined(CONFIG_HW_WATCHDOG) 
	watchdog_reset();
#endif
	// turn off other leds
	ar7240_reg_rmw_set(AR7240_GPIO_OUT, 0xe000);	
}