<html>
<head>
<META HTTP-EQUIV="expires" CONTENT="0">
<META HTTP-EQUIV="pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache, must-revalidate">
<%languagechar_show();%>
<title>LAN Interface Setup</title>
<link rel="stylesheet" href="./stylesheets/nb.css" type="text/css">
<% language=javascript %>
<script type="text/javascript" src="./javascripts/common.js"> </script>
<SCRIPT>
<!--

function changeIpType(bGray) 
{
	document.tcpip.bridge_ip.disabled = bGray;
	document.tcpip.bridge_mask.disabled = bGray;
	document.tcpip.bridge_gateway.disabled = bGray;
	document.tcpip.anyip[0].disabled = bGray;
	document.tcpip.anyip[1].disabled = bGray;
}

function updateDhcpRelayState(form)
{
	if(form.dhcp.selectedIndex == 0)
	{
		enableField(form.dhcpRelayEnable,true);
		enableField(form.dhcpServerIp,form.dhcpRelayEnable.checked);
	}
	else
	{
		enableField(form.dhcpRelayEnable,false);
		enableField(form.dhcpServerIp,false);
	}
}

function dhcpChange(value)
{
	bEnable = (value == 1);

	enableField(document.tcpip.dhcpRangeStart, bEnable);
	enableField(document.tcpip.dhcpRangeEnd, bEnable);
	enableField(document.tcpip.lan_wins1, bEnable);
	enableField(document.tcpip.lan_wins2, bEnable);
	enableField(document.tcpip.dhcpdns1, bEnable);
	enableField(document.tcpip.dhcpdns2, bEnable);
	enableField(document.tcpip.dhcp_gateway, bEnable);
	enableField(document.tcpip.dhcp_mask, bEnable);
	enableField(document.tcpip.dhcpLeaseTime, bEnable);
	
	updateDhcpRelayState(document.tcpip);
}

function checkClientRange(start,end)
{
	start_d = getDigit(start,4);
	start_d += getDigit(start,3)*256;
	start_d += getDigit(start,2)*256;
	start_d += getDigit(start,1)*256;

	end_d = getDigit(end,4);
	end_d += getDigit(end,3)*256;
	end_d += getDigit(end,2)*256;
	end_d += getDigit(end,1)*256;

	if ( start_d <= end_d )
		return true;

	return false;
}

function wanShowDiv(pptp_bool, dns_bool, pppoe_bool, static_bool, L2tp_bool)
{
 	show_div(pptp_bool,"pptp_div");
  	show_div(dns_bool,"dns_div");
  	show_div(pppoe_bool,"pppoe_div");
  	show_div(static_bool,"static_div"); 
  	show_div(L2tp_bool,"L2tp_div");
  	if (pptp_bool==0 && pppoe_bool==0 && static_bool==0 && L2tp_bool==0)
  	  	show_div(1,"dhcp_div");
  	else
  		show_div(0,"dhcp_div");  
}

function changeWanType(field)
{
	if(field.selectedIndex == 0){	//static ip
		wanShowDiv(0 , 1, 0, 1, 0); //pptp, dns, pppoe, static (div)
	}
	else if(field.selectedIndex == 1){ //Dhcp
		wanShowDiv(0 , 0, 0, 0, 0);   	
	}else if(field.selectedIndex == 2){ //pppoe
		wanShowDiv(0 , 0, 1, 0, 0); 
	}else if(field.selectedIndex == 3){ //pptp
		wanShowDiv(1 , 0, 0, 0, 0); 
	}else if(field.selectedIndex == 4){ //L2TP
	    wanShowDiv(0 , 0, 0 ,0 , 1);
	}
}

function pppTypeSelection()
{
  if ( document.tcpip.pppConnectType.value == 2) {
  	if (document.tcpip.ppp_status.value=="0.0.0.0") {
  		enableButton(document.tcpip.pppConnect);
		disableButton(document.tcpip.pppDisconnect);
	}
	else {
 		disableButton(document.tcpip.pppConnect);
		enableButton(document.tcpip.pppDisconnect);
	}
	disableTextField(document.tcpip.pppIdleTime);
  }
  else {
	disableButton(document.tcpip.pppConnect);
	disableButton(document.tcpip.pppDisconnect);
	if (document.tcpip.pppConnectType.value == 1)
		enableTextField(document.tcpip.pppIdleTime);
	else
		disableTextField(document.tcpip.pppIdleTime);
  }
}

function pppConnectClick(connect)
{
  if (document.tcpip.pppConnectType.value == 2 && connect==0) {
      if (document.tcpip.pppUserName.value=="") {
          alert("<%getlanguage("PPP user name cannot be empty!");%>");
	  document.tcpip.pppUserName.focus();
	  return false;
      }
      if (document.tcpip.pppPassword.value=="") {
          alert("<%getlanguage("PPP password cannot be empty!");%>");
	  document.tcpip.pppPassword.focus();
	  return false;
      }
  }
  return true;
}

function saveChanges_wan(form)
{
  var wanType = form.wanType.selectedIndex ;
  var warn_show1=new Array();
  var ip_flag;
    if ( wanType == 0 ){ //static IP
    		if(checkIPSubnet(form.lan_ip.value,form.lan_mask.value,form.wan_ip.value,form.wan_mask.value)==false)	
		{	
			return 25;	
		}
		if (checkIpAddr(form.wan_ip) != "")
  			return 1;  
  		if (checkIPMask(form.wan_mask) != "")
  			return 2;

	  	if (form.wan_gateway.value!="" && form.wan_gateway.value!="0.0.0.0") {
		    	if ( checkIpAddr(form.wan_gateway) != "" )
		      		return 3;
		    	if ( !checkSubnet(form.wan_ip.value,form.wan_mask.value,form.wan_gateway.value)) {
		      		return 4;
		    	}
	  	}
	  	else
	    		form.wan_gateway.value = '0.0.0.0'; 
	  
	  	if (form.fixedIpMtuSize != null){
		    	d2 = getDigit(form.fixedIpMtuSize.value, 1);
		    	if ( validateKey(form.fixedIpMtuSize.value) == 0 ||
					(d2 > 1500 || d2 < 1400) ) {
					return 6;
		     	}
	  	}

		Wan_IPAddress = form.wan_ip.value;
		Wan_Netmask = form.wan_mask.value;
		Wan_Gateway = form.wan_gateway.value;
	  	
//	  	alert(IPAddress + Netmask + Gateway);
		wan_ipsegment = Wan_IPAddress.split(".");
		Wan_IPAddress = (wan_ipsegment[0]<<24)|(wan_ipsegment[1]<<16)|(wan_ipsegment[2]<<8)|wan_ipsegment[3];
		wan_ipsegment = Wan_Netmask.split(".");
		Wan_Netmask = (wan_ipsegment[0]<<24)|(wan_ipsegment[1]<<16)|(wan_ipsegment[2]<<8)|wan_ipsegment[3];
		wan_ipsegment = Wan_Gateway.split(".");
		Wan_Gateway = (wan_ipsegment[0]<<24)|(wan_ipsegment[1]<<16)|(wan_ipsegment[2]<<8)|wan_ipsegment[3];

		if(((Wan_IPAddress&Wan_Netmask)|(~Wan_Netmask))==Wan_Gateway){
			return 7;
		}
  	}
  	else if ( wanType == 1){ //dhcp wanType 
  		var j=0;  
  		var str1=document.tcpip.hostName.value;
  		for (var i=0; i<str1.length; i++) { 
    		if ( str1.charAt(i) == ' ' ||str1.charAt(i) == '"' ||str1.charAt(i) == '\x27' || str1.charAt(i) == '\x5c' ||str1.charAt(i) == '$')						
			return 11;
    		if(str1.charAt(i)>='0'&& str1.charAt(i)<='9'){
  				j++;
        		if(j==str1.length)
        			return 13; 	
      		}
 	
  		}		
  		  
  	  	if (form.dhcpMtuSize != null){
	    	d2 = getDigit(form.dhcpMtuSize.value, 1);
	     	if ( validateKey(form.dhcpMtuSize.value) == 0 ||
				(d2 > 1500 || d2 < 1400) ) {
				return 1;
	     	}
	  	} 
  	}
  	else if ( wanType == 2){ //pppoe wanType
 		if(form.pppStaticIP.value!="" && form.pppStaticIP.value!="0.0.0.0")
 		{
	  	   if(checkIpAddr(form.pppStaticIP)!=""){
				return 5;
	  	   }
 		}
	   	if (form.pppUserName.value=="") {
			return 1;
	   	}
	   	if (form.pppPassword.value=="") {
		  	return 2;
	   	}
	   	if ( form.pppIdleTime != null){
			d1 = getDigit(form.pppIdleTime.value, 1);
			if ( validateKey(form.pppIdleTime.value) == 0 ||
				(d1 > 1000 || d1 < 1) ) {
				return 3;
			}
	  	} 
           
        if ( form.pppMtuSize != null){
	     	d2 = getDigit(form.pppMtuSize.value, 1);
	     	if ( validateKey(form.pppMtuSize.value) == 0 ||
				(d2 > 1492 || d2 < 1392) ) {
				return 4;
	     	}
	   	}
  	}
  	else if ( wanType == 3){ //pptp wanType
  		if(checkIPSubnet(form.lanip.value,form.lanmask.value,form.pptpIpAddr.value,form.pptpSubnetMask.value)==false)	
		{	
			return 25;	
		}
	  	if ( checkIpAddr(form.pptpIpAddr) != "" )
	    	return 1;
	  	if (checkIPMask(form.pptpSubnetMask) != "")
  			return 2 ;
	 	if (form.pptpgateway.value!="" && form.pptpgateway.value!="0.0.0.0") {
	    	if ( checkIpAddr(form.pptpgateway) != "" )
	      		return 22;
	    	if ( !checkSubnet(form.pptpIpAddr.value,form.pptpSubnetMask.value,form.pptpgateway.value)) {
	     		 return 24;
	    	}
	  	}
	  	else
	    	form.pptpgateway.value = '0.0.0.0';
	  	if ( checkIpAddr(form.pptpServerIpAddr) != "" )
	      	return 3;

	  	if (form.pptpUserName.value=="") {
		  	return 5;
	  	}
	  	if (form.pptpPassword.value=="") {
		  	return 6;
	  	}
	  	if ( form.pptpMtuSize != null){
	  		d2 = getDigit(form.pptpMtuSize.value, 1);
	   		if ( validateKey(form.pptpMtuSize.value) == 0 ||
				(d2 > 1460 || d2 < 1360) ) {
				return 7;
	   		}
	  	}
   	}
  	else if ( wanType == 4){
  		if(checkIPSubnet(form.lanip.value,form.lanmask.value,form.L2tpIpAddr.value,form.L2tpSubnetMask.value)==false)	
		{	
			return 25;	
		}
	  	if ( checkIpAddr(form.L2tpIpAddr) != "" )
	    	return 1;
	  	if (checkIPMask(form.L2tpSubnetMask) != "")
  			return 2 ;
  			
	  	if (form.L2tpgateway.value!="" && form.L2tpgateway.value!="0.0.0.0") {
	    	if ( checkIpAddr(form.L2tpgateway) != "" )
	      		return 22;
	    	if ( !checkSubnet(form.L2tpIpAddr.value,form.L2tpSubnetMask.value,form.L2tpgateway.value)) {
	      		return 24;
	    	}
	  	}
	  	else
	      	form.L2tpgateway.value = '0.0.0.0';
	      
	  	if ( checkIpAddr(form.L2tpServerIpAddr) != "")
	      	return 3;

	  	if (form.L2tpUserName.value=="") {
		  	return 5;
	  	}
	  	if (form.L2tpPassword.value=="") {
		  	return 6;
	  	}
	  	if ( form.L2tpMtuSize != null){
	  		d2 = getDigit(form.L2tpMtuSize.value, 1);
	   		if ( validateKey(form.L2tpMtuSize.value) == 0 ||
				(d2 > 1460 || d2 < 1360) ) {
				return 7;
	   		}
	  	}	
  	}
   	if( wanType != 0 ) { // not static IP
		if (form.dns1.value=="")
			form.dns1.value="0.0.0.0";
	    if (form.dns1.value!="0.0.0.0") {
			if ( checkIpAddr(form.dns1) != "" )
		    	return 10;
	    }		
	    if (form.dns2.value=="")
			form.dns2.value="0.0.0.0";
	    if (form.dns2.value!="0.0.0.0") {
			if ( checkIpAddr(form.dns2) != "" )
		    	return 20;
	    }			
   	}
   	else{
		if (form.dns1.value=="")
	    	form.dns1.value="0.0.0.0";
	  	if (form.dns1.value!="0.0.0.0") {
	     	if ( checkIpAddr(form.dns1) != "" )
	       	return 10;
	  	}	  	    
	  	if (form.dns2 != null){  
	  		if (form.dns2.value=="")
	    		form.dns2.value="0.0.0.0";
	  		if (form.dns2.value!="0.0.0.0") {
	    		if ( checkIpAddr(form.dns2) != "" )
	      			return 20;
	  		}	    		
	  	}
   	}
	if (form.wan_macAddr != null){
   		if (form.wan_macAddr.value == "")
			form.wan_macAddr.value = c_EmptyMac;
		var str = form.wan_macAddr.value;
   		if ( str.length < 17) {
			return 8;
  		}  	
   		for (var i=0; i<str.length; i++) {
   			if((i+1)%3!=0){
     			if ( (str.charAt(i) >= '0' && str.charAt(i) <= '9') ||
				(str.charAt(i) >= 'a' && str.charAt(i) <= 'f') ||
				(str.charAt(i) >= 'A' && str.charAt(i) <= 'F') )
				continue;		
				return 9; 						
   			}
   			else
   			{
    			if ( str.charAt(i) ==':'  || str.charAt(i) =='-' )
					continue;
					return 14; 			 
  			}
		}	
	} 
	return 0;
}
function saveChanges_wan1(form)
{
	var temp_mac = new Array(1);
	var flag,warn_show,ip_flag;
	var wanType = form.wanType.selectedIndex;
		
	flag = saveChanges_wan(form);
	if(wanType == 1)
	{
		var str = document.tcpip.hostName.value;
		for (var i=0; i<str.length; i++) {
	    	if ( 	(str.charAt(i) == '-')||
			(str.charAt(i) >= '0' && str.charAt(i) <= '9') ||
			(str.charAt(i) >= 'a' && str.charAt(i) <= 'z') ||
			(str.charAt(i) >= 'A' && str.charAt(i) <= 'Z') )
			continue;
	   		<%write("warn_show ='");getlanguage("Invalid Host Name. It can only contain numbers 0-9, letters A-Z and a-z, or hyphens");write("';\n");%>
	   		alert(warn_show);
	   	return false;
		}	
	}
	if(flag==25) 
	{
		<%write("warn_show ='");getlanguage("LAN and WAN can not in same subnet");write("';\n");%>
	  	alert(warn_show);
		return false;
	}
	if(flag==8)
	{
		<%write("warn_show ='");getlanguage("Input MAC address is not complete. It should be 12 digits in hex.");write("';\n");%>
	  	alert(warn_show);
	}
	else if(flag==9)
	{
		<%write("warn_show ='");getlanguage("Invalid MAC address. It should be in hex number (0-9 or a-f).");write("';\n");%>
	  	alert(warn_show);
	}			
        else if(flag==14)
        {
        	<%write("warn_show ='");getlanguage("Invalid MAC address.Error format.");write("';\n");%>
	        alert(warn_show);
        }
		
	if(flag==10) 
	{
		warn_show = checkIpAddr(form.dns1);
		if (warn_show != "")
		{
			alert(warn_show);
		    return false;
		}
	}
	else if(flag==20) 
	{
		warn_show = checkIpAddr(form.dns2);
		if (warn_show != "")
		{
			alert(warn_show);
		    return false;
		}
	}	
	if( wanType == 0 )
	{

		if(flag==1) //ip
		{
			warn_show = checkIpAddr(form.wan_ip);
			if (warn_show != "")
			{
				alert(warn_show);
			    return false;
			}
		}
		else if(flag==2) //subnet
		{
			warn_show = checkIPMask(form.wan_mask);
			if (warn_show != "")
			{
				alert(warn_show);
				return false;
			}
		}
		else if(flag==3) //gateway
		{
			warn_show = checkIpAddr(form.wan_gateway);
			if (warn_show != "")
			{
				alert(warn_show);
			    return false;
			}
		}
		else if(flag==4) 
		{
			<%write("warn_show ='");getlanguage("Invalid gateway address!It should be located in the same subnet of current IP address.");write("';\n");%>
		  	alert(warn_show);
		  	
		  	form.wan_gateway.value = form.wan_gateway.defaultValue;
	      form.wan_gateway.focus();

		}
		
		else if(flag==6) 
		{
			<%write("warn_show ='");getlanguage("Invalid MTU size! You should set a value between 1400-1500.");write("';\n");%>
		  	alert(warn_show);
		  	form.fixedIpMtuSize.value = form.fixedIpMtuSize.defaultValue;
			form.fixedIpMtuSize.focus();
		}
		else if(flag==7)
		{
			<%write("warn_show ='");getlanguage("Gateway address can not be broadcast address.");write("';\n");%>
			alert(warn_show); 
			form.wan_gateway.value = form.wan_gateway.defaultValue;
	     		 form.wan_gateway.focus();
		}
	}
	else if( wanType == 1 )
	{
	  var str=document.tcpip.hostName.value;
		if(str.length==0){
			<%write("warn_show ='");getlanguage("Host Name cannot be empty.");write("';\n");%>
			alert(warn_show);
			return false;	  
	  	}
		if(flag==11){
			<%write("warn_show ='");getlanguage("Invalid Host Name! Please enter characters in A(a)~Z(z) or 0-9 without spacing.");write("';\n");%>
			alert(warn_show);
			form.hostName.value = form.hostName.defaultValue;
		}	
		if(flag==12){
			<%write("warn_show ='");getlanguage("Invalid host name length");write("';\n");%>
			alert(warn_show);
			form.hostName.value = form.hostName.defaultValue;
		}
		if(flag==13){
			<%write("warn_show ='");getlanguage("Invalid host name.");write("';\n");%>
			alert(warn_show);
			form.hostName.value = form.hostName.defaultValue;
		}
		if(flag == 1){
			<%write("warn_show ='");getlanguage("Invalid MTU size! You should set a value between 1400-1500.");write("';\n");%>
	  		alert(warn_show);
	  		form.dhcpMtuSize.value = form.dhcpMtuSize.defaultValue;
			form.dhcpMtuSize.focus();
		}
	}
	else if( wanType == 2 )
	{
	   if(flag==5)
	   	{
			warn_show = checkIpAddr(form.pppStaticIP);
			if (warn_show != "")
			{
				alert(warn_show);
			    return false;
			}
	   	}
		else if(flag==1) 
		{
			<%write("warn_show ='");getlanguage("PPP user name cannot be empty!");write("';\n");%>
		  	alert(warn_show);
		  	form.pppUserName.value = form.pppUserName.defaultValue;
		  	form.pppUserName.focus();
		}
		else if(flag==2) 
		{
			<%write("warn_show ='");getlanguage("PPP password cannot be empty!");write("';\n");%>
		  	alert(warn_show);
		  	form.pppPassword.value = form.pppPassword.defaultValue;
		  	form.pppPassword.focus();
		}
		else if(flag==3) 
		{
			<%write("warn_show ='");getlanguage("Invalid idle time value! You should set a value between 1-1000.");write("';\n");%>
		  	alert(warn_show);
		  	form.pppIdleTime.focus();
		}
		else if(flag==4) 
		{
			<%write("warn_show ='");getlanguage("Invalid MTU size! You should set a value between 1392-1492.");write("';\n");%>
		  	alert(warn_show);
		  	form.pppMtuSize.value = form.pppMtuSize.defaultValue;
			form.pppMtuSize.focus();
		}
	}
	else if( wanType == 3 )
	{
		if(flag==1)
		{
			warn_show = checkIpAddr(form.pptpIpAddr);
			if (warn_show != "")
			{
				alert(warn_show);
			    return false;
			}
		}
		else if(flag==2)
		{
			warn_show = checkIPMask(form.pptpSubnetMask);
			if (warn_show != "")
			{
				alert(warn_show);
				return false;
			}
		}
		else if(flag==3)
		{
			warn_show = checkIpAddr(form.pptpServerIpAddr);
			if (warn_show != "")
			{
				alert(warn_show);
			    return false;
			}
		}
		else if(flag==24)
		{
			<%write("warn_show ='");getlanguage("Invalid server IP address!It should be located in the same subnet of local IP address.");write("';\n");%>
		  	alert(warn_show);
		  	form.pptpServerIpAddr.value = form.pptpServerIpAddr.defaultValue;
	      	form.pptpServerIpAddr.focus();
		}
		else if(flag==5)
		{
			<%write("warn_show ='");getlanguage("User name cannot be empty!");write("';\n");%>
		  	alert(warn_show);
		  	form.pptpUserName.value = form.pptpUserName.defaultValue;
		  	form.pptpUserName.focus();
		}
		else if(flag==6)
		{
			<%write("warn_show ='");getlanguage("Password cannot be empty!");write("';\n");%>
		  	alert(warn_show);
		  	form.pptpPassword.value = form.pptpPassword.defaultValue;
		  	form.pptpPassword.focus();
		}
		else if(flag==7)
		{
			<%write("warn_show ='");getlanguage("Invalid MTU size! You should set a value between 1360-1460.");write("';\n");%>
		  	alert(warn_show);
		  	form.pptpMtuSize.value = form.pptpMtuSize.defaultValue;
			form.pptpMtuSize.focus();
		}
	}	
	warn_show = checkIpAddr(form.lan_ip);
	if (warn_show != "")
	{
		alert(warn_show);
	    return false;
	}
	
	warn_show = checkIPMask(form.lan_mask);
	if (warn_show != "")
	{
		alert(warn_show);
		return false;
	}  		
	
	if ( form.dhcp.selectedIndex == 1) 
	{
		warn_show = checkIpAddr(form.dhcpRangeStart);
		if (warn_show != "")
		{
			alert(warn_show);
		    return false;
		}
		
		if ( !checkSubnet(form.lan_ip.value,form.lan_mask.value,form.dhcpRangeStart.value)) {
		<%write("warn_show ='");getlanguage("Invalid DHCP client start address.It should be located in the same subnet of current IP address.");write("';\n");%>
		alert(warn_show);
		form.dhcpRangeStart.value = form.dhcpRangeStart.defaultValue;
		form.dhcpRangeStart.focus();
		return false;
		}
		warn_show = checkIpAddr(form.dhcpRangeEnd);
		if (warn_show != "")
		{
			alert(warn_show);
		    return false;
		}
		
		if ( !checkSubnet(form.lan_ip.value,form.lan_mask.value,form.dhcpRangeEnd.value)) {
		<%write("warn_show ='");getlanguage("Invalid DHCP client end address.It should be located in the same subnet of current IP address.");write("';\n");%>
		alert(warn_show);
		form.dhcpRangeEnd.value = form.dhcpRangeEnd.defaultValue;
		form.dhcpRangeEnd.focus();
		return false;
		}

		if ( !checkClientRange(form.dhcpRangeStart.value,form.dhcpRangeEnd.value) ) {
		  <%write("warn_show ='");getlanguage("Invalid DHCP client address range.Ending address should be greater than starting address.");write("';\n");%>
			alert(warn_show);
			form.dhcpRangeStart.focus();
			return false;
		}
		/*
		warn_show = checkIPMask(form.dhcp_mask);
		if (warn_show != "")
		{
			alert(warn_show);
			return false;
		}
		*/
		if (!ValidateNum(form.dhcpLeaseTime, 15, 44640))
		{
			return false;
		}
		if (form.lan_wins1.value=="")
			form.lan_wins1.value="0.0.0.0";
		if (form.lan_wins1.value!="0.0.0.0") 
		{
			warn_show = checkIpAddr(form.lan_wins1);
			if (warn_show != "")
			{
				alert(warn_show);
			    return false;
			}
		}	

		 if (form.lan_wins2.value=="")
		 	form.lan_wins2.value="0.0.0.0";
		 if (form.lan_wins2.value!="0.0.0.0") 
		 {
			warn_show = checkIpAddr(form.lan_wins2);
			if (warn_show != "")
			{
				alert(warn_show);
			    return false;
			}
		}		  

	}
	else
	{
		if(form.dhcpRelayEnable.checked==true)
		{
			warn_show = checkIpAddr(form.dhcpServerIp);
			if (warn_show != "")
			{
				alert(warn_show);
				return false;
			}
		}
	}
	
	if(flag==0)
		return true;	


	return false;
}


function saveChanges(form)
{
	var warn_show,ip_flag;

	if (<%writeValue("networkMode");%>!=0)	// router
		return saveChanges_wan1(form);

	warn_show = checkIpAddr(form.bridge_ip);
	if (warn_show != "")
	{
		alert(warn_show);
	    return false;
	}
	
	warn_show = checkIPMask(form.bridge_mask);
	if (warn_show != "")
	{
		alert(warn_show);
		return false;
	}
	  
	if (form.bridge_gateway.value != "" && form.bridge_gateway.value != "0.0.0.0")
	{
		var IPAddress;
		var Netmask;
		var Gateway;
		var ipsegment;
		
		IPAddress = form.bridge_ip.value;
		Netmask = form.bridge_mask.value;
		Gateway = form.bridge_gateway.value;
	  	
//	  	alert(IPAddress + Netmask + Gateway);
		ipsegment = IPAddress.split(".");
		IPAddress = (ipsegment[0]<<24)|(ipsegment[1]<<16)|(ipsegment[2]<<8)|ipsegment[3];
		ipsegment = Netmask.split(".");
		Netmask = (ipsegment[0]<<24)|(ipsegment[1]<<16)|(ipsegment[2]<<8)|ipsegment[3];
		ipsegment = Gateway.split(".");
		Gateway = (ipsegment[0]<<24)|(ipsegment[1]<<16)|(ipsegment[2]<<8)|ipsegment[3];

		if ((IPAddress&Netmask) != (Gateway&Netmask)){
			<%write("warn_show ='");getlanguage("IP address and Gateway address must be in the same subnet");write("';\n");%>
			alert(warn_show); 
			return false;
		}

		if(((IPAddress&Netmask)|(~Netmask))==Gateway){
			<%write("warn_show ='");getlanguage("Gateway address can not be broadcast address.");write("';\n");%>
			alert(warn_show); 
			return false;
		}
	}	 
  
	if (form.anyip[0].checked && form.szBridgeIPType[1].checked)
	{
		if (checkIpAddr(form.bridge_gateway) != "")
		{
  		<%write("warn_show ='");getlanguage("Enable AnyIP ,we must set valid Gateway address.");write("';\n");%>
			alert(warn_show); 
			return false;
		}
		else if (checkIpAddr(form.bridge_dns1) != "" && checkIpAddr(form.bridge_dns2) != "")
		{
			<%write("warn_show ='");getlanguage("Enable AnyIP ,we must set valid DNS address .");write("';\n");%>
			alert(warn_show); 
			return false;
		}
	}
	  
  return true;
}

function initpage(){
	var form = document.tcpip;
	bBridge = (<%writeValue("networkMode");%>==0) ? 1 : 0;
	bDhcpc = (<%writeValue("TCPIPDhcp");%> == 1);
	pppType = <%writeValue("pppConnectType");%>;
	dhcps = <%writeValue("dhcp");%>;
	wanType = <%writeValue("wanDhcp");%>;
	anyip = <%writeValue("anyipenable");%>;
	pptpSecurity = <%writeValue("pptpSecurity");%>;

	GenResourceSupprotedOptions(ipTypeArray, form.wanType, (1<<0)|(1<<1)|(1<<3));
	form.wanType.value = wanType;
	form.szBridgeIPType[0].checked = bDhcpc;
	form.szBridgeIPType[1].checked = !bDhcpc;
	form.pppConnectType.selectedIndex = pppType;
	form.dhcp.selectedIndex = dhcps;
	form.anyip[0].checked = anyip;
	form.anyip[1].checked = !anyip;
	form.pptpSecurity.checked = pptpSecurity;

	show_div(bBridge, "bridge_div");
	show_div(!bBridge, "wan_div");
	show_div(!bBridge, "lan_div");
	show_id(false,"dhcp_subnetmask");
	show_id(false,"dhcp_gateway");

	changeIpType(bDhcpc);
	dhcpChange(dhcps);

	changeWanType(form.wanType);
	pppTypeSelection();
}
-->
</SCRIPT>
</head>
<BODY onLoad="initpage();" class="bodyContainer">
<div class="boxHeader">
  <h2>
    <%getlanguage("TCP/IP Settings");%>
  </h2>
  <span class="note">
  <%getlanguage("Use this page to configure the parameters for local area network which connects to the LAN port of your Access Point. Here you may change the setting for IP address, subnet mask, DHCP, etc..");%>
  </span> </div>
<form action=/goform/formTcpipSetup method=POST name="tcpip" onSubmit="return saveChanges(this)">
  <div class="box" id="bridge_div">
    <h3>
      <%getlanguage("IP Address Assignment");%>
    </h3>
    <table class="text">
      <tr>
        <TD colspan="2" nowrap><input name="szBridgeIPType" type="radio" value="yes" onClick="changeIpType(true);">
          <%getlanguage("Obtain IP Address Automatically"); %></TD>
      </tr>
      <tr>
        <TD colspan="2" nowrap><input name="szBridgeIPType" type="radio" value="no" onClick="changeIpType(false)">
          <%getlanguage("Use Fixed IP Address"); %></TD>
      </tr>
      <tr>
        <td width="33%"><%getlanguage("IP Address");%>
          :</td>
        <td><input type="text" name="bridge_ip" size="15" maxlength="15" value=<% writeValue("ip-rom"); %>></td>
      </tr>
      <tr>
        <td width="33%"><%getlanguage("Subnet Mask");%>
          :</td>
        <td><input type="text" name="bridge_mask" size="15" maxlength="15" value="<% writeValue("mask-rom"); %>"></td>
      </tr>
      <tr>
        <td width="33%"><%getlanguage("Gateway Ip Address");%>
          :</td>
        <td><input type="text" name="bridge_gateway" size="15" maxlength="15" value="<% writeValue("gateway-rom"); %>"></td>
      </tr>
      <tr>
        <td width="33%"><%getlanguage("DNS 1");%>
          :</td>
        <td><input type="text" name="bridge_dns1" size="15" maxlength="15" value=<% writeValue("lan-dns1"); %>></td>
      </tr>
      <tr>
        <td width="33%"><%getlanguage("DNS 2");%>
          :</td>
        <td><input type="text" name="bridge_dns2" size="15" maxlength="15" value=<% writeValue("lan-dns2"); %>></td>
      </tr>
      <tr style="display:none">
        <td><%getlanguage("AnyIP"); %></td>
        <td><input type="radio" name="anyip" value="yes">
          <%getlanguage("Enabled"); %>
          &nbsp;&nbsp;
          <input type="radio" name="anyip" value="no">
          <%getlanguage("Disabled"); %>
        </td>
      </tr>
    </table>
  </div>
  <div class="box" id="wan_div">
    <h3>
      <%getlanguage("WAN Settings");%>
      :</h3>
    <input type="hidden" value="<% writeValue("ip-rom"); %>" name="lanip">
    <input type="hidden" value="<% writeValue("mask-rom"); %>" name="lanmask">
    <table class="text">
      <tr>
        <td width="33%"><%getlanguage("WAN Access Type");%>
          :</td>
        <td width="66%"><select size="1" name="wanType" onChange="changeWanType(this)">
          </select></td>
      </tr>
      <tbody id = "static_div">
        <tr>
          <td><%getlanguage("IP Address");%>
            :</td>
          <td><input type="text" name="wan_ip" size="18" maxlength="15" value="<% writeValue("wan-ip-rom"); %>"></td>
        </tr>
        <tr>
          <td><%getlanguage("Subnet Mask");%>
            :</td>
          <td><input type="text" name="wan_mask" size="18" maxlength="15" value="<% writeValue("wan-mask-rom"); %>"></td>
        </tr>
        <tr>
          <td><%getlanguage("Default Gateway");%>
            :</td>
          <td><input type="text" name="wan_gateway" size="18" maxlength="15" value="<% writeValue("wan-gateway-rom"); %>"></td>
        </tr>
        <tr id="fixedMtu" style="display:none">
          <td><%getlanguage("MTU Size");%>
            :</td>
          <td><input type="text" name="fixedIpMtuSize" size="10" maxlength="10" value="<% writeValue("fixedIpMtuSize"); %>">
            &nbsp;
            <%getlanguage("(1400-1500 bytes)");%></td>
        </tr>
      </tbody>
      <tbody id = "dhcp_div">
        <tr>
          <td><%getlanguage("Host Name");%>
            :</td>
          <td><input type="text" name="hostName" size="18" maxlength="15" value="<% writeValue("host_name"); %>"></td>
        </tr>
        <tr id="dhcpcMtu" style="display:none">
          <td><%getlanguage("MTU Size");%>
            :</td>
          <td><input type="text" name="dhcpMtuSize" size="10" maxlength="10" value="<% writeValue("dhcpMtuSize"); %>">
            &nbsp;
            <%getlanguage("(1400-1500 bytes)");%></td>
        </tr>
      </tbody>
      <tbody id = "pppoe_div">
        <tr>
          <td><%getlanguage("Static IP");%>
            :</td>
          <td><input type="text" name="pppStaticIP" size="18" maxlength="31" value="<% writeValue("pppStaticIP"); %>"></td>
        </tr>
        <tr>
          <td><%getlanguage("User Name");%>
            :</td>
          <td><input type="text" name="pppUserName" size="18" maxlength="31" value="<% writeValue("pppUserName"); %>"></td>
        </tr>
        <tr>
          <td><%getlanguage("Password");%>
            :</td>
          <td><input type="password" name="pppPassword" size="18" maxlength="31" value="<% writeValue("pppPassword"); %>"></td>
        </tr>
        <tr>
          <td><%getlanguage("Service Name");%>
            :</td>
          <td><input type="text" name="pppServiceName" size="18" maxlength="31" value="<% writeValue("pppServiceName"); %>"></td>
        </tr>
        <tr>
          <td><%getlanguage("Reconnect Mode");%>
            :</td>
          <td><select size="1" name="pppConnectType" onChange="pppTypeSelection()">
              <option value="0">
              <%getlanguage("Continuous"); %>
              </option>
              <option value="1">
              <%getlanguage("Connect on Demand"); %>
              </option>
              <option value="2">
              <%getlanguage("Manual"); %>
              </option>
            </select>
            <input type="submit" value="<%getlanguage("Connect"); %>" name="pppConnect" onClick="return pppConnectClick(0)">
            &nbsp;&nbsp;
            <input type="submit" value="<%getlanguage("Disconnect"); %>" name="pppDisconnect" onClick="return pppConnectClick(1)">
            <% if ( getValue("pppConnectStatus")==1 ) write("\n<script> setPPPConnected(); </script>\n"); %>
          </td>
          <input type="hidden" value="<% writeValue("wan-ppp-status"); %>" name="ppp_status">
        </tr>
        <tr id="pppoe_idletime_id">
          <td><%getlanguage("Idle Time");%>
            :</td>
          <td><input type="text" name="pppIdleTime" size="10" maxlength="10" value="<% writeValue("wan-ppp-idle"); %>">
            &nbsp;
            <%getlanguage("(1-1000 minutes)");%></td>
        </tr>
        <tr id="pppoeMtu" style="display:none">
          <td><%getlanguage("MTU Size");%>
            :</td>
          <td><input type="text" name="pppMtuSize" size="10" maxlength="10" value="<% writeValue("pppMtuSize"); %>">
            &nbsp;
            <%getlanguage("(1392-1492 bytes)");%></td>
        </tr>
      </tbody>
      <tbody id = "pptp_div">
      <td><%getlanguage("IP Address");%>
          :</td>
        <td><input type="text" name="pptpIpAddr" size="18" maxlength="15" value="<% writeValue("pptpIp"); %>"></td>
      </tr>
      <tr>
        <td><%getlanguage("Subnet Mask");%>
          :</td>
        <td><input type="text" name="pptpSubnetMask" size="18" maxlength="15" value="<% writeValue("pptpSubnet"); %>"></td>
      </tr>
      <tr>
        <td><%getlanguage("Default Gateway");%>
          :</td>
        <td><input type="text" name="pptpgateway" size="18" maxlength="15" value="<% writeValue("wan-gateway-rom"); %>"></td>
      </tr>
      <tr>
        <td><%getlanguage("Server IP Address");%>
          :</td>
        <td><input type="text" name="pptpServerIpAddr" size="18" maxlength="15" value="<% writeValue("pptpServerIp"); %>"></td>
      </tr>
      <tr>
        <td><%getlanguage("User Name");%>
          :</td>
        <td><input type="text" name="pptpUserName" size="18" maxlength="31" value="<% writeValue("pptpUserName"); %>"></td>
      </tr>
      <tr>
        <td><%getlanguage("Password");%>
          :</td>
        <td><input type="password" name="pptpPassword" size="18" maxlength="31" value="<% writeValue("pptpPassword"); %>"></td>
      </tr>
      <tr style="display:none">
        <td><%getlanguage("MTU Size");%>
          :</td>
        <td><input type="text" name="pptpMtuSize" size="10" maxlength="10" value="<% writeValue("pptpMtuSize"); %>">
          &nbsp;
          <%getlanguage("(1360-1460 bytes)");%></td>
      </tr>
      <tr>
        <td width="100%" colspan="2"><input type="checkbox" name="pptpSecurity" value="ON">
          &nbsp;&nbsp;
          <%getlanguage("Request MPPE Encryption");%>
        </td>
      </tr>
      </tbody>
      
      <!--L2TP-->
      <tbody id = "L2tp_div">
      </tbody>
      <!--END L2TP-->
      <tbody id = "dns_div">
      <td><%getlanguage("DNS 1");%>
          :</td>
        <td><input type="text" name="dns1" size="18" maxlength="15" value=<% writeValue("wan-dns1"); %>></td>
      </tr>
      <tr>
        <td><%getlanguage("DNS 2");%>
          :</td>
        <td><input type="text" name="dns2" size="18" maxlength="15" value=<% writeValue("wan-dns2"); %>></td>
      </tr>
      </tbody>
      
    </table>
    <!--
	<table class="text">
	  <tr>
	    <td width="33%">
	      <%getlanguage("MAC Address");%>:</td>
	    <td width="66%"><input type="text" name="wan_macAddr" size="18" maxlength="17" value=<% writeValue("wlClonedMac"); %>>
	      <input type="submit" value="<%getlanguage("MAC Clone"); %>" name="macclone">
	      &nbsp;&nbsp; </td>
	  </tr>
	  <tr>
	    <td width="100%" colspan="2">
	      <input type="checkbox" name="igmpEnabled" value="ON" >
	      &nbsp;&nbsp;
	      <%getlanguage("Enable IGMP"); %>
	      </td>
	  </tr>
	  <tr>
	    <td width="100%" colspan="2">
	      <input type="checkbox" name="PingWanAccess" value="ON" <% if (getValue("PingWanAccess")) write("checked");
	       %>>
	      &nbsp;&nbsp;
	      <%getlanguage("Enable Ping Access on WAN");%>
	      </td>
	  </tr>
	  <tr>
	    <td width="100%" colspan="2">
	      <input type="checkbox" name="webWanAccess" value="ON" <% if (getValue("webWanAccess")) write("checked");
	       %>>
	      &nbsp;&nbsp;
	      <%getlanguage("Enable Web Server Access on WAN");%>
	      </td>
	  </tr>
	  <tr>
	    <td width="100%" colspan="2">
	      <input type="checkbox" name="WANPassThru1" <% if (getValue("VPNPassThruIPsec")) write("checked"); %> value="ON">
	      &nbsp;&nbsp;
	      <%getlanguage("Enable IPsec pass through on VPN connection");%>
	      </td>
	  </tr>
	  <tr>
	    <td width="100%" colspan="2">
	      <input type="checkbox" name="WANPassThru2" <% if (getValue("VPNPassThruPPTP")) write("checked"); %> value="ON">
	      &nbsp;&nbsp;
	      <%getlanguage("Enable PPTP pass through on VPN connection");%>
	      </td>
	  </tr>
	  <td width="100%" colspan="2">
	      <input type="checkbox" name="WANPassThru3" <% if (getValue("VPNPassThruL2TP")) write("checked"); %> value="ON">
	      &nbsp;&nbsp;
	      <%getlanguage("Enable L2TP pass through on VPN connection");%>
	      </td>
	  </tr>
	</table>
	-->
  </div>
  <div class="box" id="lan_div">
    <h3>
      <%getlanguage("LAN Settings");%>
      :</h3>
    <table class="text">
      <tr>
        <td width="33%"><%getlanguage("IP Address");%>
          :</td>
        <td><input type="text" name="lan_ip" size="15" maxlength="15" value=<% writeValue("ip-rom"); %>></td>
      </tr>
      <tr>
        <td width="33%"><%getlanguage("Subnet Mask");%>
          :</td>
        <td><input type="text" name="lan_mask" size="15" maxlength="15" value="<% writeValue("mask-rom"); %>"></td>
      </tr>
      <tr>
        <td width="33%"><%getlanguage("DHCP Server"); %>
          :</td>
        <td><select size="1" name="dhcp" onChange="dhcpChange(this.value)">
            <option value="0">
            <%getlanguage("Disabled"); %>
            </option>
            <option value="1">
            <%getlanguage("Enabled"); %>
            </option>
          </select>
        </td>
      </tr>
      <tr>
        <td width="33%"><%getlanguage("DHCP IP Address Range"); %>
          :</td>
        <td><input type="text" name="dhcpRangeStart" size="15" maxlength="15" value="<% writeValue("dhcpRangeStart"); %>">
          -
          <input type="text" name="dhcpRangeEnd" size="15" maxlength="15" value="<% writeValue("dhcpRangeEnd"); %>">
          &nbsp; </td>
      </tr>
      <tr id="dhcp_subnetmask">
        <td width="33%"><%getlanguage("DHCP Subnet Mask");%>
          :</td>
        <td><input type="text" name="dhcp_mask" size="15" maxlength="15" value="<% writeValue("mask-dhcp"); %>"></td>
      </tr>
      <tr id="dhcp_gateway">
        <td width="33%"><%getlanguage("DHCP Gateway");%>
          :</td>
        <td><input type="text" name="dhcp_gateway" size="15" maxlength="15" value="<% writeValue("gateway-dhcp"); %>"></td>
      </tr>
      <tbody style="display:none">
        <tr>
          <td width="33%"><%getlanguage("WINS1"); %>
            :</td>
          <td><input type="text" name="lan_wins1" size="15" maxlength="15" value=<% writeValue("lan-wins1"); %>></td>
        </tr>
        <tr>
          <td width="33%"><%getlanguage("WINS2"); %>
            :</td>
          <td><input type="text" name="lan_wins2" size="15" maxlength="15" value=<% writeValue("lan-wins2"); %>></td>
        </tr>
        <tr>
          <td width="33%"><%getlanguage("Primary DNS Server");%>
            :</td>
          <td><input type="text" name="dhcpdns1" size="15" maxlength="15" value=<% writeValue("dhcp-dns1"); %>></td>
        </tr>
        <tr>
          <td width="33%"><%getlanguage("Secondary DNS Server");%>
            :</td>
          <td><input type="text" name="dhcpdns2" size="15" maxlength="15" value=<% writeValue("dhcp-dns2"); %>></td>
        </tr>
      </tbody>
      <tr>
        <td width="33%"><%getlanguage("Lease Time");%>
          :</td>
        <td><input type="text" name="dhcpLeaseTime" size="5" maxlength="5" value="<% writeValue("dhcpLeaseTime"); %>">
          &nbsp;
          <%getlanguage("(15-44640 Minutes)"); %></td>
      </tr>
      <tr>
        <td colspan="2"><input type="checkbox" name="dhcpRelayEnable" value="ON" 
				<% if (getValue("dhcpRelayEnable")) write("checked"); %> ONCLICK="updateDhcpRelayState(document.tcpip)">
          &nbsp;&nbsp;
          <%getlanguage("Enable DHCP Relay"); %>
        </td>
      </tr>
      <tr>
        <td width="33%"><%getlanguage("DHCP Sever IP"); %>
          :</td>
        <td><input type="text" name="dhcpServerIp" size="15" maxlength="15" value="<% writeValue("dhcpServerIp"); %>">
        </td>
      </tr>
    </table>
  </div>
  <p align="center">
    <input type="submit" value="<%getlanguage("Apply");%>" name="save">
    &nbsp;&nbsp;
    <input type="reset" value="<%getlanguage("Cancel");%>" name="reset" onClick="Refreshweb()">
    <input type="hidden" value="/sysip.asp" name="submit-url">
  </p>
</form>
</body>
</html>
