/*===========================================================================*/
/* browser compatibility */
function isIE(){ //ie?
  return (window.navigator.userAgent.toLowerCase().indexOf("msie") >= 1);
}

if(!isIE()){ //firefox innerText define
  HTMLElement.prototype.__defineGetter__( "innerText",
  function(){
  var anyString = "";
  var childS = this.childNodes;
  for(var i=0; i <childS.length; i++) {
  if(childS[i].nodeType==1)
  anyString += childS[i].tagName=="BR" ? '\n' : childS[i].innerText;
  else if(childS[i].nodeType==3)
  anyString += childS[i].nodeValue;
  }
  return anyString;
  }
  );
  HTMLElement.prototype.__defineSetter__( "innerText",
  function(sText){
  this.textContent=sText;
  }
  );
}

function verifyBrowser() {
	var ms = navigator.appVersion.indexOf("MSIE");
	ie4 = (ms>0) && (parseInt(navigator.appVersion.substring(ms+5, ms+6)) >= 4);
	var ns = navigator.appName.indexOf("Netscape");
	ns= (ns>=0) && (parseInt(navigator.appVersion.substring(0,1))>=4);
	if (ie4)
		return "ie4";
	else
		if(ns)
			return "ns";
		else
			return false;
}

function createRadio(name,value,isChecked)
{
    var oRadio = null;
    if(isIE())
    {
        oRadio = document.createElement("<input name='" + name + (isChecked ? "' checked='"+ isChecked +"'/>" : "' />"));
        oRadio.id = name;
        oRadio.type = "radio";
        oRadio.value = value;
    }
    else
    {
        oRadio = document.createElement("input");
        oRadio.setAttribute("type","radio");
        oRadio.setAttribute("id",name);
        oRadio.setAttribute("name",name);
        oRadio.setAttribute("value",value);
        if(isChecked)
        {
            oRadio.setAttribute("checked",isChecked);
        }        
    }
    return oRadio;
}
/*===========================================================================*/
/* const var defines */
var c_EmptyMac = "00:00:00:00:00:00";
var c_EmptyIp = "0.0.0.0";

/*===========================================================================*/
/* spec defines */
var g_etherNum = <%writeValue("specEthernetNum");%>;

/*===========================================================================*/
/* string resource */
var onOffArray = [
		{value:0,	name: "<%getlanguage("Off");%>"	},
		{value:1,	name: "<%getlanguage("On");%>"	}
];
var upDownArray = [
		{value:0,	name: "<%getlanguage("Down");%>"	},
		{value:1,	name: "<%getlanguage("Up");%>"		}
];
var ipTypeArray = [
		{value:0,	name: "<%getlanguage("Static IP");%>"	},
		{value:1,	name: "<%getlanguage("DHCP Client");%>"	},
		{value:2,	name: "<%getlanguage("DHCP Server");%>"	},
		{value:3,	name: "<%getlanguage("PPPoE");%>"		},
		{value:4,	name: "<%getlanguage("PPTP");%>"		},
		{value:5,	name: "<%getlanguage("L2TP");%>"		}
];
var opModeArray = [
		{value:0,	name: "<%getlanguage("AP");%>"				},
		{value:1,	name: "<%getlanguage("Wireless Client");%>"	},
		{value:2,	name: "<%getlanguage("Bridge");%>"			},
		{value:3,	name: "<%getlanguage("AP Repeater");%>"		}
];
var wirModeArray = [
		{value:0,	name: "<%getlanguage("802.11B/G");%>"		},
		{value:1,	name: "<%getlanguage("802.11A Only");%>"	},
		{value:2,	name: "<%getlanguage("802.11B Only");%>"	},
		{value:3,	name: "<%getlanguage("802.11G Only");%>"	},
		{value:7,	name: "<%getlanguage("802.11A/N");%>"		},
		{value:8,	name: "<%getlanguage("802.11B/G/N");%>"		}
];
var authModeArray = [
		// auth_value;	auth_show_string								supported operation mode format "ap.cpe.wds.repeater"
		{value:0,	name: "<%getlanguage("Open System");%>",			support:"1.1.1.1"	},
		{value:1,	name: "<%getlanguage("Shared Key");%>",				support:"1.1.0.0"	},
		{value:2,	name: "<%getlanguage("Legacy 802.1x");%>",			support:"1.1.0.0"	},
		{value:4,	name: "<%getlanguage("WPA with Radius");%>",		support:"1.1.0.0"	},
		{value:8,	name: "<%getlanguage("WPA2 with Radius");%>",		support:"1.1.0.0"	},
		{value:12,	name: "<%getlanguage("WPA & WPA2 with Radius");%>",	support:"1.0.0.0"	},
		{value:16,	name: "<%getlanguage("WPA-PSK");%>",				support:"1.1.1.1"	},
		{value:32,	name: "<%getlanguage("WPA2-PSK");%>",				support:"1.1.1.1"	},
		{value:48,	name: "<%getlanguage("WPA-PSK&WPA2-PSK");%>",		support:"1.0.0.0"	}
];
var etherRateArray = [
		{value:0,	name: "<%getlanguage("Auto");%>"				},
		{value:1,	name: "<%getlanguage("10M/full-duplex");%>"		},
		{value:2,	name: "<%getlanguage("100M/full-duplex");%>"	},
		{value:4,	name: "<%getlanguage("10M/half-duplex");%>"		},
		{value:5,	name: "<%getlanguage("100M/half-duplex");%>"	}
];


function GetResourceString(resource, value)
{
	for (i=0; i<resource.length; i++)
	{
		if (resource[i].value == value)
			return resource[i].name;
	}
	return "<%getlanguage("N/A");%>";
}

function EmptyOptions(list)
{
	for (i=list.length; i>=0; i--)
	{
		list.remove(i);
	}
}

function GenResourceOptions(resource, list)
{
	EmptyOptions(list);
	for (i=0; i<resource.length; i++)
	{
		var oOption=new Option(resource[i].name, resource[i].value);
		list.options[list.length]=oOption;
	}
}
function GenResourceSupprotedOptions(resource, list, bitmap)
{
	EmptyOptions(list);
	for (i=0; i<resource.length; i++)
	{
		if (bitmap & (1<<resource[i].value))
		{
			var oOption=new Option(resource[i].name, resource[i].value);
			list.options[list.length]=oOption;
		}
	}
}
/*===========================================================================*/
/* common APIs */
function skip () { this.blur(); }
function disableTextField (field) {
  if (document.all || document.getElementById)
    field.disabled = true;
  else {
    field.oldOnFocus = field.onfocus;
    field.onfocus = skip;
  }
}

function enableTextField (field) {
  if (document.all || document.getElementById)
    field.disabled = false;
  else {
    field.onfocus = field.oldOnFocus;
  }
}

function enableField (field, enable) {
  if (document.all || document.getElementById)
    field.disabled = !enable;
  else {
    field.onfocus = field.oldOnFocus;
  }
}

function disableAll()
{
	var items = document.getElementsByTagName("select");
	for (i=0; i<items.length; i++)
	{
		items[i].disabled = true;
	}
	var items = document.getElementsByTagName("input");
	for (i=0; i<items.length; i++)
	{
		items[i].disabled = true;
	}
}

function Refreshweb()
{
	window.location.reload(true);
}

function disableButton (button) {
  //if (verifyBrowser() == "ns")
  //	return;
  if (document.all || document.getElementById)
    button.disabled = true;
  else if (button) {
    button.oldOnClick = button.onclick;
    button.onclick = null;
    button.oldValue = button.value;
    button.value = 'DISABLED';
  }
}

function enableButton (button) {
  //if (verifyBrowser() == "ns")
  //	return;
  if (document.all || document.getElementById)
    button.disabled = false;
  else if (button) {
    button.onclick = button.oldOnClick;
    button.value = button.oldValue;
  }
}

function style_display_on()
{
	if (window.ActiveXObject)
	{ // IE
		return "block";
	}
	else if (window.XMLHttpRequest)
	{ // Mozilla, Safari,...
		return "table-row";
	}
}

function show_div(show,id) {
	if(show)
		document.getElementById(id).style.display  = "" ;
	else	    
  	document.getElementById(id).style.display  = "none" ;
}

function show_id(show,id) {
	if(show)
	{
		document.getElementById(id).style.visibility = "visible";
		document.getElementById(id).style.display = style_display_on();
	}
    else
	{
		document.getElementById(id).style.visibility = "hidden";
		document.getElementById(id).style.display = "none";
	}
}

function Str2Html(field) 
{
	for (var cnt=0; cnt<field.length; cnt++)
	{
		if (field.charAt(cnt) == '<')
			document.write("&#60;");
		else if(field.charAt(cnt) == '>')
			document.write("&#62;");
		else if(field.charAt(cnt) == '&')
			document.write("&#38;");
		else if(field.charAt(cnt) == '"')
			document.write("&#34;");
		else if(field.charAt(cnt) == ' ')
			document.write("&#160;");
		else
			document.write(field.charAt(cnt) );
	}
}

function ValidName(obj) 
{
	var myName = obj.value;
	if (! isNaN(myName))
	{
		alert("Invalid Device Name. It can not be empty or pure digists.");
		obj.select();
		return false;
	}
	for (var cnt=0; cnt<myName.length; cnt++)
	{
		if (myName.charAt(cnt) != '-'
		&& (myName.charAt(cnt) < 'a' || myName.charAt(cnt) > 'z')
		&& (myName.charAt(cnt) < 'A' || myName.charAt(cnt) > 'Z')
		&& (myName.charAt(cnt) < '0' || myName.charAt(cnt) > '9')
		)
		{
			alert("Invalid Device Name. It can only contain numbers 0-9, letters A-Z and a-z, or hyphens.");
			obj.select();
			return false;
		}
	}	
	
	return true;
}

function ValidateNum(numObj, start, end)
{
	if (!numObj || numObj.value.length < 1)
	{
		alert("<%getlanguage("Empty value. It should be in decimal number (0-9).");%>");
		numObj.focus();
		return false;
	}
	var num_letters = "1234567890";
	for (var p=0; p<numObj.value.length; p++)
	{
		var num_char = numObj.value.charAt(p);
		if (num_letters.indexOf(num_char) == -1)
		{
			alert("<%getlanguage("Invalid value. It should be in decimal number (0-9).");%>");
			numObj.focus();
			return false;
		}
	}

	var val = Number(numObj.value);
	if (val < start || val > end)
	{
		alert("<%getlanguage("Invalid value. It should be a decimal number between ");%>" + start + " ~ " + end + ".");
		numObj.focus();
		return false;
	}
	return true;
}

function ValidateIP(ipObj, bAllowEmpty)
{
	var re =/^([1-9]|[1-9]\d|1\d{2}|2[0-1]\d|22[0-3])(\.(\d|[1-9]\d|1\d{2}|2[0-4]\d|25[0-4])){3}$/;

	if (bAllowEmpty && (ipObj.value=="" || ipObj.value==c_EmptyIp))
	{
		return true;
	}
	if (ipObj.value=="")
	{
		alert("<%getlanguage("Empty IP address.");%>");
		macObj.focus();
		return false;
	}
	if(!re.test(ipObj.value)){
		alert("<%getlanguage("Invalid IP address. It should be like '192.168.1.1'.");%>");
		ipObj.focus();
		return false;
	}
	return true;
}

function ValidateMAC(macObj){
	var re =/[a-fA-F\d]{2}:[a-fA-F\d]{2}:[a-fA-F\d]{2}:[a-fA-F\d]{2}:[a-fA-F\d]{2}:[a-fA-F\d]{2}/;
	if (macObj.value=="")
	{
		alert("<%getlanguage("Empty MAC address.");%>");
		macObj.focus();
		return false;
	}
	if(!re.test(macObj.value) || macObj.value==c_EmptyMac){
		alert("<%getlanguage("Invalid MAC address. It should be like '00:60:b3:12:34:56'.");%>");
		macObj.focus();
		return false;
	}
	if (parseInt(macObj.value.slice(0,2), 16) % 2 != 0)
	{
		alert("<%getlanguage("The first byte of MAC address must be even!");%>");
		macObj.focus();
		return false;	
	}

	return true;
}

function mhz2ieee(freq)
{
	if (freq == 0)
		return 0;
	if (freq == 2484)
		return 14;
	if (freq < 2484)
		return (freq - 2407) / 5;
	if (freq < 3000)
		return 15 + ((freq - 2512) / 20);
	if (freq < 5000)
	{
		if(freq > 4000)
			return (freq - 4000) / 5;
		else
			return 15 + ((freq - 2512) / 20);
	}
	return (freq - 5000) / 5;
}

function validateKey(str)
{
   var j=0;
   for (var i=0; i<str.length; i++) {
    if ( (str.charAt(i) >= '0' && str.charAt(i) <= '9') ||(str.charAt(i) == '.' ) )
			{
				if(str.charAt(i) == '.')
			 	 	j++;
				continue;
    		}
	return 0;
  }
  if(j==3)
    return 1;
  return -1; 
}

function getDigit(str, num)
{
  i=1;
  if ( num != 1 ) {
  	while (i!=num && str.length!=0) {
		if ( str.charAt(0) == '.' ) {
			i++;
		}
		str = str.substring(1);
  	}
  	if ( i!=num )
  		return -1;
  }
  for (i=0; i<str.length; i++) {
  	if ( str.charAt(i) == '.' ) {
		str = str.substring(0, i);
		break;
	}
  }
  if ( str.length == 0)
  	return -1;
  d = parseInt(str, 10);
  return d;
}

function checkDigitRange(str, num, min, max)
{
  d = getDigit(str,num);
  if ( d > max || d < min )
      	return false;
  return true;
}

function updateGKey(form)
{
	if(form.GKey.checked)
	{
		 enableTextField(form.GKey_type[0]);
		 enableTextField(form.GKey_type[1]);
		 enableTextField(form.GKye_Seconds);
		 enableTextField(form.GKye_pkt);
	//	 enableTextField(form.GKey_update);		
	}
	else
	{
		disableTextField(form.GKey_type[0]);
		disableTextField(form.GKey_type[1]);
		disableTextField(form.GKye_Seconds);
		disableTextField(form.GKye_pkt);
	//	disableTextField(form.GKey_update);	
	}
}
function check_wpa_psk(form)
{
	var str = form.pskValue.value;

	if (str.length < 8) {
		alert('Pre-Shared Key value should be set at least 8 characters.');
		form.pskValue.focus();
		return false;
	}
	if (str.length > 64) {
		alert('Pre-Shared Key value should be less than 63 characters or 64 hex');
		form.pskValue.focus();
		return false;
	}
  return true;
}

function saveChanges_wpa(form)
{
	var ip_flag1,if_flag2;
  method = form.method;
  wpaAuth= form.wpaAuth;
  if (method.selectedIndex>=2 && (wpaAuth.value == "psk" || wpaAuth[1].checked))
	return check_wpa_psk(form);	
 

	if (form.elements["radiusPort1"].value=="") {
		return 1;
  	}
	if (validateKey(form.elements["radiusPort1"].value)==0) {
		return 2;
	}
	/*if (form.elements["radiusPort2"].value=="") {
		return 1;
  	}
	if (validateKey(form.elements["radiusPort2"].value)==0) {
		return 2;
	}*/
        port1 = parseInt(form.elements["radiusPort1"].value, 10);
     //   port2 = parseInt(form.elements["radiusPort2"].value, 10);
 	if (port1 > 65535 || port1 < 1)// || port2 > 65535 || port2 < 1)
 	{
		return 3;
  	}

   return 0;
}


/*==============================================================================*/
/*   sysip.asp  */
function checkMask(str, num)
{
  d = getDigit(str,num);
  if(num == 1){
  	if( !(d==128 || d==192 || d==224 || d==240 || d==248 || d==252 || d==254 || d==255 ))
  		return false;
  }	
	if(num == 2){
  	if( !(d==0 || d==128 || d==192 || d==224 || d==240 || d==248 || d==252 || d==254 || d==255 ))
  		return false;
  }	
  if(num == 3){
  if( !(d==0 || d==128 || d==192 || d==224 || d==240 || d==248 || d==252 || d==254 || d==255 ))
  	return false;
  }	
  if(num == 4){
  	if( !(d==0 || d==128 || d==192 || d==224 || d==240 || d==248 || d==252 || d==254 ))
  		return false;
  }	

  return true;
}


function checkSubnet(ip, mask, client)
{
  ip_d = getDigit(ip, 1);
  mask_d = getDigit(mask, 1);
  client_d = getDigit(client, 1);
  if ( (ip_d & mask_d) != (client_d & mask_d ) )
	return false;

  ip_d = getDigit(ip, 2);
  mask_d = getDigit(mask, 2);
  client_d = getDigit(client, 2);
  if ( (ip_d & mask_d) != (client_d & mask_d ) )
	return false;

  ip_d = getDigit(ip, 3);
  mask_d = getDigit(mask, 3);
  client_d = getDigit(client, 3);
  if ( (ip_d & mask_d) != (client_d & mask_d ) )
	return false;

  ip_d = getDigit(ip, 4);
  mask_d = getDigit(mask, 4);
  client_d = getDigit(client, 4);
  if ( (ip_d & mask_d) != (client_d & mask_d ) )
	return false;

  return true;
}
function checkIPMask(field)
{
  if (field.value=="") {
    return "<%getlanguage("Subnet mask cannot be empty! It should be filled with 4 digit numbers as xxx.xxx.xxx.xxx.");%>";
  }
  if ( validateKey( field.value ) == 0 ) {
    return "<%getlanguage("Invalid subnet mask value. It should be the decimal number (0-9).");%>";
  }
  if ( !checkMask(field.value,1) ) {

    return "<%getlanguage("Invalid subnet mask range in 1st digit.It should be the number of 0, 128, 192, 224, 240, 248, 252 or 254");%>";
  }
  if ( !checkMask(field.value,2) ) {

    return "<%getlanguage("Invalid subnet mask range in 2nd digit.It should be the number of 0, 128, 192, 224, 240, 248, 252 or 254");%>";
  }
  if ( !checkMask(field.value,3) ) {

    return "<%getlanguage("Invalid subnet mask range in 3rd digit.It should be the number of 0, 128, 192, 224, 240, 248, 252 or 254");%>";
  }
  if ( !checkMask(field.value,4) ) {
    return "<%getlanguage("Invalid subnet mask range in 4th digit.It should be the number of 0, 128, 192, 224, 240, 248, 252 or 254");%>";
  }
  return "";
} 

function checkIpAddr(field)
{
  if (field.value=="") {
	return "<%getlanguage("IP address cannot be empty! It should be filled with 4 digit numbers as xxx.xxx.xxx.xxx.");%>";
  }
   if ( validateKey(field.value) == 0) {
      return "<%getlanguage("Invalid IP address value. It should be the decimal number (0-9).");%>";
   }
   if ( !checkDigitRange(field.value,1,1,223)||getDigit(field.value,1)==127 ) {
      return "<%getlanguage("Invalid IP address range in 1st digit. It should be 1-126 or 128-223.");%>";
   }
   if ( !checkDigitRange(field.value,2,0,255) ) {
      return "<%getlanguage("Invalid IP address range in 2nd digit. It should be 0-255.");%>";
   }
   if ( !checkDigitRange(field.value,3,0,255) ) {
      return "<%getlanguage("Invalid IP address range in 3rd digit. It should be 0-255.");%>";
   }
   if ( !checkDigitRange(field.value,4,1,254) ) {
      return "<%getlanguage("Invalid IP address range in 4th digit. It should be 1-254.");%>";
   }
   if ( validateKey(field.value) == -1) {
      return "<%getlanguage("Invalid IP address format. It should be filled with 4 digit numbers as xxx.xxx.xxx.xxx.");%>";
   }
   return "";
}

/////////////////////////////////////////////////////////////////////////////
/*wlsecurity.asp*/
function validateKey_wep(form, idx, str, len)
{
	 if (idx >= 0) {
  if(len==0)
  {
  	str=="";
  	str.length = 0;
  	return 0;
  }
  		
  if (form.elements["defaultTxKeyId"].selectedIndex==idx && str.length==0) {
	return 1;
  }
  if (str.length ==0)
  	return 0;

  if ( str.length != len) {
  	idx++;
  	return idx*100+len;
  }
  }
  else {
	if ( str.length != len) {
		return len;
  	}
  }
  if ( str == "*****" ||
       str == "**********" ||
       str == "*************" ||
       str == "**************************" )
       return 0;

  if (form.keytype.value==1)
  {
       return 0;
  }
  else
  {
	  for (var i=0; i<str.length; i++) {
	    if ( (str.charAt(i) >= '0' && str.charAt(i) <= '9') ||
				(str.charAt(i) >= 'a' && str.charAt(i) <= 'f') ||
				(str.charAt(i) >= 'A' && str.charAt(i) <= 'F') )
				continue;
	
	return 2;
	  }
  }
  return 0;
}

function saveChanges_wep(form,auth)
{
  var keyLen,encryp;
  var key_flag;
  if (auth.value == 0 || auth.value == 2)
  	encryp = form.open;
  else if(auth.value == 1)
  	encryp = form.share;
  else
  	return 0;

  if(encryp.value==40){		
  	if ( form.keytype.value == 1)
		keyLen = 5;
	else
		keyLen = 10;
  }
  else if(encryp.value==104){
  	if ( form.keytype.value == 1)
		keyLen = 13;
	else
		keyLen = 26;
  }
  else if(encryp.value==128){
  	if ( form.keytype.value == 1)
		keyLen = 16;
	else
		keyLen = 32;
  }
  else
	keyLen = 0;

key_flag = validateKey_wep(form, 0,form.elements["key1"].value, keyLen);
  if (key_flag!=0) {
	form.elements["key1"].focus();  	
	return key_flag;
  }
 key_flag = validateKey_wep(form, 1,form.elements["key2"].value, keyLen);
  if (key_flag!=0) {
	form.elements["key2"].focus();  	
	return key_flag;
  }
   key_flag = validateKey_wep(form, 2,form.elements["key3"].value, keyLen);
  if (key_flag!=0) {
	form.elements["key3"].focus();  	
	return key_flag;
  }
   key_flag = validateKey_wep(form, 3,form.elements["key4"].value, keyLen);
  if (key_flag!=0) {
	form.elements["key4"].focus();  	
	return key_flag;
  }

  return 0;
}

function checkIPSubnet(srcip, srcmask, desip,desmask)
{
  srcip_d = getDigit(srcip, 1);
  srcmask_d = getDigit(srcmask, 1);
  desip_d = getDigit(desip, 1);
  desmask_d = getDigit(desmask, 1);
  if(srcmask_d!=0&&desmask_d!=0)
  {
  	if ( (srcip_d & srcmask_d) != (desip_d & desmask_d ) )
		return true;
  }
  else
  {
  	return false;
  }

  srcip_d = getDigit(srcip, 2);
  srcmask_d = getDigit(srcmask, 2);
  desip_d = getDigit(desip, 2);
  desmask_d = getDigit(desmask, 2);
  if(srcmask_d!=0&&desmask_d!=0)
  {
  	if ( (srcip_d & srcmask_d) != (desip_d & desmask_d ) )
		return true;
  }
  else
  {
  	return false;
  }

  srcip_d = getDigit(srcip, 3);
  srcmask_d = getDigit(srcmask, 3);
  desip_d = getDigit(desip, 3);
  desmask_d = getDigit(desmask, 3);
  if(srcmask_d!=0&&desmask_d!=0)
  {
  	if ( (srcip_d & srcmask_d) != (desip_d & desmask_d ) )
		return true;
  }
  else
  {
  	return false;
  }
	
  srcip_d = getDigit(srcip, 4);
  srcmask_d = getDigit(srcmask, 4);
  desip_d = getDigit(desip, 4);
  desmask_d = getDigit(desmask, 4);
  if(srcmask_d!=0&&desmask_d!=0)
  {
  	if ( (srcip_d & srcmask_d) != (desip_d & desmask_d ) )
		return true;
  }
  else
  {
  	return false;
  }

  return false;
}

function WriteList(array, value)
{
	var len = array.length;
	for(i=0; i<len; i++)
	{
		document.write("<option value=\"" + array[i].value + "\"");
		if(value == array[i].value)
			document.write(" selected");
		document.write(">");
		document.write(array[i].name);
		document.write("</option>");
	}
}

/*
 *bob, for caching html data
 */
function readData(name)
{
	var start=new Date().getTime(); 
	while(parent == undefined || parent.data == undefined || parent.data.readCacheData == undefined)
	{	// effective ?
		if(new Date().getTime()-start > 100)
		{
			return undefined;
		}
	}
	return parent.data.readCacheData(name);
}

function writeData(name, value)
{
	var start=new Date().getTime(); 
	while(parent == undefined || parent.data == undefined || parent.data.writeCacheData == undefined)
	{	// effective ?
		if(new Date().getTime()-start > 100)
		{
			return undefined;
		}
	}
	return parent.data.writeCacheData(name, value);
}

// for ajax
function createAjax()
{	
	var http_request;

	if(window.XMLHttpRequest){
		http_request=new XMLHttpRequest();
		if(http_request.overrideMimeType){
			http_request.overrideMimeType("text/html");
		}
	}
	else if(window.ActiveXObject){
		try{
			http_request=new ActiveXObject("Xsxml2.XMLHTTP");
		}
		catch(e){
			try{
				http_request=new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch(e){
			}
		}
	} 
	return http_request;
}
