#ifndef __COMMON_H__
#define __COMMON_H__

#ifndef BYTE 
#define BYTE unsigned char
#endif

#ifndef WORD
#define WORD unsigned short
#endif

#ifndef LWORD
#define LWORD unsigned long
#endif

#ifndef DWORD
#define DWORD unsigned long
#endif

#ifndef VLWORD
#define VLWORD volatile unsigned long
#endif

#ifndef BOOLEAN
#define BOOLEAN BYTE
#endif

#ifndef BOOL
#define BOOL BYTE
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef NULL
#define NULL	((void *)0)
#endif

#define S8            signed char
#define S08            signed char
#define S16           signed short
#define S32           signed long
#define U8            unsigned char
#define U08            unsigned char
#define U16           unsigned short
#define U32           unsigned long
#define REG8          volatile unsigned char
#define REG16         volatile unsigned short
#define REG32         volatile unsigned long 

#define READ_SIZE 512
#define PAD_DATA 0xff;
#define PAD_LEN 4

#define YES 0x1
#define NO 0x0

#define SESSION_MAGIC_LEN 8

struct file_session{
	U8 session_magic[8];
	U32 session_start_addr;
	U32 session_len;
}__attribute__ ((packed));

struct combine_arg_tab {
    char    *file_name;
    char    *magic;
    unsigned int  start_addr;
}__attribute__ ((packed));

#if 1
#define debug_printf printf
#define diag_printf printf
#else
#define debug_printf(...)
#define diag_printf(...)
#endif

#endif
