/*****************************************************
 * tx99_config.h
 * Copyright(c) Nanjing Z-Com, Inc.
 * http://www.zcom.com.cn
 *
 * begin	:Thu May 2010
 * copyright	:(c) 2010 by Z-com
 * email	:jxq19881013@hotmail.com
 *//////////////////////////////////////////////////////////////////////////////////////

//===================================
//System Includes

#ifndef __TX99_CONFIG__
#define __TX99_CONFIG__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <errno.h>
#include <ctype.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/ioctl.h>
#include <linux/sysctl.h>
#define MAX_COMMAND_LINE_SIZE	200
#define MODULE_ATH_HAL_NAME 	ath_hal
#define MODULE_ATH_DEV_NAME	ath_dev
#define MODULE_ATH_PCI		ath_pci
#define MODULE_WLAN 		wlan
#define MODULE_TX99_PATH	/lib/modules/2.6.15/net/ath_tx99.ko
#define PROC_TX99_TYPE_PATH	/proc/sys/dev/wifi0/tx99type
#define PROC_TX99_TXPOWER_PATH	/proc/sys/dev/wifi0/tx99power
#define PROC_TX99_TXRATE_PATH	/proc/sys/dev/wifi0/tx99rate
#define PROC_TX99_TXFREQ_PATH	/proc/sys/dev/wifi0/tx99freq
#define PROC_TX99_TXMODE_PATH	/proc/sys/dev/wifi0/tx99txmode
#define PROC_TX99_TXHTEXT_PATH	/proc/sys/dev/wifi0/tx99htext
#define PROC_TX99_TXHTMODE_PATH	/proc/sys/dev/wifi0/tx99htmode
#define PROC_TX99_RECV_PATH	/proc/sys/dev/wifi0/tx99recv

typedef	struct ExchangeEnumInfo_t
{
	unsigned int ulValue;
	char		*szName;
} ExchangeEnumInfo_t;

typedef struct Tx99_para
{
	unsigned int type;		/*single carrier or frame type*/
	unsigned int txpower; 		/*tx power*/
	unsigned int txrate; 		/*tx rate*/
	unsigned int txfreq;		/*tx channel frequency*/
	unsigned int txmode;		/*tx channel mode*/
	unsigned int htmode;		/*channel width mode, e.g. HT20,HT40*/
	unsigned int htext;		/*extension channel for HT40*/
	unsigned int recv;		/*continuous receive modeextension channel for HT40*/
} Tx99_para_t;


enum Tx99_type
{
	FRAME_DATA = 0,
	SINGLE_CARRIER = 1
};

enum Tx99_txmode
{
	MODE_11A = 1,		/*5GHz,OFDM*/
	MODE_11NA_HT20 = 7,		/**/
	MODE_11NA_HT40PLUS = 9,		/**/
	MODE_11NA_HT40MINUS = 10		/**/
};


enum Tx99_htmode
{
	HT20 = 0,	
	HT40 = 2
};


enum Tx99_htext
{
	HTEXTNONE = 0,
	HTEXTPLUS = 1,
	HTEXTMINUS = 2
};

enum Tx99_11a_freq
{
	FREQ_11A_1 = 2412,
	FREQ_11A_2 = 2417,
	FREQ_11A_3 = 2422,
	FREQ_11A_4 = 2427,
	FREQ_11A_5 = 2432,
	FREQ_11A_6 = 2437,
	FREQ_11A_7 = 2442,
	FREQ_11A_8 = 2447,
	FREQ_11A_9 = 2452,
	FREQ_11A_10 = 2457,
	FREQ_11A_11 = 2462
	
};

enum Tx99_11na_HT20_freq
{
	HT20_11NA_FREQ1 = 5180,
	HT20_11NA_FREQ2 = 5200,
	HT20_11NA_FREQ3 = 5220,
	HT20_11NA_FREQ4 = 5240,
	HT20_11NA_FREQ5 = 5745,
	HT20_11NA_FREQ6 = 5765,
	HT20_11NA_FREQ7 = 5785,
	HT20_11NA_FREQ8 = 5805,
	HT20_11NA_FREQ9 = 5825
};

static const ExchangeEnumInfo_t s_11a_Rates[] =
{
	{11,	"6M"					},
	{15,	"9M" 				},
	{10,	"12M" 				},
	{14,	"18M" 				},
	{ 9,	"24M" 				},
	{13,	"36M" 				},
	{ 8,	"48M" 				},
	{12,	"54M" 				},
};

static const ExchangeEnumInfo_t s_11n_Rates_noGI[] =
{
	{11,		"6M"				},
	{15,		"9M" 			},
	{10,		"12M" 			},
	{14,		"18M" 			},
	{ 9,		"24M" 			},
	{13,		"36M" 			},
	{ 8,		"48M" 			},
	{12,		"54M" 			},
	{128,	"MCS0-6.5[13.5]"	},
	{129,  	"MCS1-13[27]"		},
	{130,  	"MCS2-19.5[40.5]"	},
	{131,  	"MCS3-26[54]"		},
	{132,  	"MCS4-39[81]"		},
	{133,  	"MCS5-52[108]"		},
	{134,  	"MCS6-58.5[121.5]"	},
	{135,  	"MCS7-65[135]"		},
	{136,	"MCS8-13[27]"		},
	{137,	"MCS9-26[54]"		},
	{138,	"MCS10-39[81]"		},
	{139,	"MCS11-52[108]" 	},
	{140,	"MCS12-78[162]" 	},
	{141,	"MCS13-104[216]"	},
	{142,	"MCS14-117[243]"	},
	{143,	"MCS15-130[270]"	},
};

enum Tx99_11na_HT40PLUS_freq
{
	HT40PLUS_11NA_FREQ1 = 5180,
	HT40PLUS_11NA_FREQ2 = 5220,
	HT40PLUS_11NA_FREQ3 = 5745,
	HT40PLUS_11NA_FREQ4 = 5785
};

enum Tx99_11na_HT40MINUS_freq
{
	HT40MINUS_11NA_FREQ1 = 5200,
	HT40MINUS_11NA_FREQ2 = 5240,
	HT40MINUS_11NA_FREQ3 = 5765,
	HT40MINUS_11NA_FREQ4 = 5805
};

/*
 *check the current enviroment for to settup enviroment and start tx99 mode
 * */
int check_current_env(void);
int check_module_status(char *);
int check_exist_wifi(void);
int check_wlan_interface_num(void);
int check_wlan_interface_status(void);
int stop_wlan_interface(int);
int user_input(void);
int input_tx99_type(void);
int input_tx99_txmode(void);
int input_tx99_txpower(void);
int input_tx99_txfreq(void);
int input_tx99_txrate(void);
int tx99_setup(void);
int tx99_start(void);
int tx99_stop(void);

void banner_printer(void);

void txmode_11a_freq_printer(void);
void txmode_11na_ht20_freq_printer(void);
void txmode_11na_ht40plus_freq_printer(void);
void txmode_11na_ht40minus_freq_printer(void);

void txmode_11a_txrate_printer(void);
void txmode_11na_ht20_txrate_printer(void);
void txmode_11na_ht40plus_txrate_printer(void);
void txmode_11na_ht40minus_txrate_printer(void);

void tx99_para_printer(void);
void rate_table_printer(void);
void freq_table_printer(void);
int file_is_null(char *filename);
int file_lines_num(char *filename);

#endif
