// ieee802dot11.c
//

//#define	_DEBUG

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <signal.h>
#include <unistd.h>
#include <math.h>

#include "zcom_snmp.h"

int		g_dot11DisassociateReason1, g_dot11DeauthenticateReason1,
		g_dot11AuthenticateFailStatus1, g_dot11DisassociateReason2,
		g_dot11DeauthenticateReason2, g_dot11AuthenticateFailStatus2;
char	g_dot11DisassociateStation1[18], g_dot11DeauthenticateStation1[18],
		g_dot11AuthenticateFailStation1[18], g_dot11DisassociateStation2[18],
		g_dot11DeauthenticateStation2[18], g_dot11AuthenticateFailStation2[18];

const char *szManufacturerID = "00:13:49";
const char *szProductID = "ZCN1523";
const uint8_t ManufacturerOUI[3] = {0x00, 0x13, 0x49};
const char *szManufacturerName = "Zcom";
const char *szManufacturerProductName = "ZCN1523";

///////////////////////////////////////////////////////////////////////////////
// ZCom Oid Access Routines
///////////////////////////////////////////////////////////////////////////////
static	ZComOidAccess_t ZComOidAccessMultiDomainCap;
static	ZComOidAccess_t ZComOidAccessResInfo;
static	ZComOidAccess_t ZComOidAccessAntennaInfo;
static	ZComOidAccess_t ZComOidAccessTxPowerInfo;
static	ZComOidAccess_t ZComOidAccessOFDMInfo;

static	ZComOidAccess_t ZComOidAccessManufacturerID;
static	ZComOidAccess_t ZComOidAccessRetryLimit;
static	ZComOidAccess_t ZComOidAccessMSDULifeTime;
static	ZComOidAccess_t ZComOidAccessCounters;
static	ZComOidAccess_t ZComOidAccessDataRatesValue;

static  FindVarMethod	DOT11FindMethod;

#define	WLAN_TABLE1 1
#define	WLAN_TABLE2	2
#define	MIB_NULL	MIB_WLAN_SSID

static ZComOidInfo_t s_DOT11OidInfos[] =
{
	// .1 dot11smt
	// .1.7 dot11MultiDomainCapabilityTable
	// .1.7.1 dot11MultiDomainCapabilityEntry
	ZCOM_OID_FIX_INFO(0, MIB_NULL, ASN_INTEGER,   RONLY,	WLAN_TABLE2, ZComOidAccessMultiDomainCap, 1, 7, 1, 2),
	ZCOM_OID_FIX_INFO(0, MIB_NULL, ASN_INTEGER,   RONLY,	WLAN_TABLE2, ZComOidAccessMultiDomainCap, 1, 7, 1, 3),

	// .2 dot11mac
	// .2.1 dot11OperationTable
	// .2.1.1 dot11OperationEntry
	//OM_OID_FIX_INFO(0, MIB_WLAN_LOCAL_MAC,			ASN_OCTET_STR,	RONLY,	WLAN_TABLE1, ZComOidAccessMultiMacAddress, 2, 1, 1, 1),
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_RTS_THRESHOLD,		ASN_INTEGER,	RWRITE,	WLAN_TABLE1, ZComOidAccessMultiGeneric, 2, 1, 1, 2),
	ZCOM_OID_FIX_INFO(0, MIB_NULL,						ASN_INTEGER,	RWRITE,	WLAN_TABLE1, ZComOidAccessRetryLimit, 2, 1, 1, 3),
	ZCOM_OID_FIX_INFO(0, MIB_NULL,						ASN_INTEGER,	RWRITE,	WLAN_TABLE1, ZComOidAccessRetryLimit, 2, 1, 1, 4),
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_FRAGMENT_THRESHOLD,	ASN_INTEGER,	RWRITE,	WLAN_TABLE1, ZComOidAccessMultiGeneric, 2, 1, 1, 5),
	ZCOM_OID_FIX_INFO(0, MIB_NULL,						ASN_OCTET_STR,	RONLY,	WLAN_TABLE1, ZComOidAccessManufacturerID, 2, 1, 1, 8),
	ZCOM_OID_FIX_INFO(0, MIB_NULL,						ASN_OCTET_STR,	RONLY,	WLAN_TABLE1, ZComOidAccessManufacturerID, 2, 1, 1, 9),

	// .2.2 dot11CountersTable
	// .2.2.1 dot11CountersEntry
/*COM_OID_FIX_INFO(0, MIB_WLAN_STATS, ASN_OCTET_STR,   RONLY,	WLAN_TABLE1, ZComOidAccessCounters, 2, 2, 1, 1),
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_STATS, ASN_OCTET_STR,   RONLY,	WLAN_TABLE1, ZComOidAccessCounters, 2, 2, 1, 2),
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_STATS, ASN_OCTET_STR,   RONLY,	WLAN_TABLE1, ZComOidAccessCounters, 2, 2, 1, 3),
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_STATS, ASN_OCTET_STR,   RONLY,	WLAN_TABLE1, ZComOidAccessCounters, 2, 2, 1, 4),
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_STATS, ASN_OCTET_STR,   RONLY,	WLAN_TABLE1, ZComOidAccessCounters, 2, 2, 1, 5),
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_STATS, ASN_OCTET_STR,   RONLY,	WLAN_TABLE1, ZComOidAccessCounters, 2, 2, 1, 6),
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_STATS, ASN_OCTET_STR,   RONLY,	WLAN_TABLE1, ZComOidAccessCounters, 2, 2, 1, 7),
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_STATS, ASN_OCTET_STR,   RONLY,	WLAN_TABLE1, ZComOidAccessCounters, 2, 2, 1, 8),
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_STATS, ASN_OCTET_STR,   RONLY,	WLAN_TABLE1, ZComOidAccessCounters, 2, 2, 1, 9),
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_STATS, ASN_OCTET_STR,   RONLY,	WLAN_TABLE1, ZComOidAccessCounters, 2, 2, 1, 10),
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_STATS, ASN_OCTET_STR,   RONLY,	WLAN_TABLE1, ZComOidAccessCounters, 2, 2, 1, 11),
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_STATS, ASN_OCTET_STR,   RONLY,	WLAN_TABLE1, ZComOidAccessCounters, 2, 2, 1, 12),
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_STATS, ASN_OCTET_STR,   RONLY,	WLAN_TABLE1, ZComOidAccessCounters, 2, 2, 1, 13),
*/
	// .3 dot11res
	// .3.1 dot11resAttribute
	// .3.1.2 dot11ResourceInfoTable
	// .3.1.2.1 dot11ResourceInfoEntry
	ZCOM_OID_FIX_INFO(0, MIB_NULL, ASN_OCTET_STR,   RONLY,	WLAN_TABLE1, ZComOidAccessResInfo, 3, 1, 2, 1, 1),
	ZCOM_OID_FIX_INFO(0, MIB_NULL, ASN_OCTET_STR,   RONLY,	WLAN_TABLE1, ZComOidAccessResInfo, 3, 1, 2, 1, 2),
	ZCOM_OID_FIX_INFO(0, MIB_NULL, ASN_OCTET_STR,   RONLY,	WLAN_TABLE1, ZComOidAccessResInfo, 3, 1, 2, 1, 3),
	ZCOM_OID_FIX_INFO(0, MIB_NULL, ASN_OCTET_STR,   RONLY,	WLAN_TABLE1, ZComOidAccessResInfo, 3, 1, 2, 1, 4),

	// .4 dot11phy
	// .4.2 dot11PhyAntennaTable
	// .4.2.1 dot11PhyAntennaEntry
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_ANTENNA, ASN_INTEGER,   RONLY,	WLAN_TABLE1, ZComOidAccessMultiGeneric, 4, 2, 1, 1),
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_ANTENNA, ASN_INTEGER,   RONLY,	WLAN_TABLE1, ZComOidAccessAntennaInfo, 4, 2, 1, 2),
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_ANTENNA, ASN_INTEGER,   RONLY,	WLAN_TABLE1, ZComOidAccessMultiGeneric, 4, 2, 1, 3),

	// .4.3 dot11PhyTxPowerTable
	// .4.3.1 dot11PhyTxPowerEntry
	ZCOM_OID_FIX_INFO(0, MIB_NULL, 					ASN_INTEGER,   RONLY,	WLAN_TABLE1, ZComOidAccessTxPowerInfo, 4, 3, 1, 1),
	//OM_OID_FIX_INFO(0, MIB_WLAN_TX_POWER_IN_DBM, 	ASN_INTEGER,   RONLY,	WLAN_TABLE1, ZComOidAccessTxPowerInfo, 4, 3, 1, 2),
	//OM_OID_FIX_INFO(0, MIB_WLAN_TX_POWER_IN_DBM, 	ASN_INTEGER,   RONLY,	WLAN_TABLE1, ZComOidAccessTxPowerInfo, 4, 3, 1, 3),
	//OM_OID_FIX_INFO(0, MIB_WLAN_TX_POWER_IN_DBM,	ASN_INTEGER,   RONLY,	WLAN_TABLE1, ZComOidAccessTxPowerInfo, 4, 3, 1, 4),
	//OM_OID_FIX_INFO(0, MIB_WLAN_TX_POWER_IN_DBM, 	ASN_INTEGER,   RONLY,	WLAN_TABLE1, ZComOidAccessTxPowerInfo, 4, 3, 1, 5),
	//OM_OID_FIX_INFO(0, MIB_WLAN_TX_POWER_IN_DBM, 	ASN_INTEGER,   RONLY,	WLAN_TABLE1, ZComOidAccessTxPowerInfo, 4, 3, 1, 6),
	//OM_OID_FIX_INFO(0, MIB_WLAN_TRANSMIT_POWER,	ASN_INTEGER,   RWRITE,	WLAN_TABLE1, ZComOidAccessTxPowerInfo, 4, 3, 1, 10),

	// .4.9 dot11SupportedDataRatesTxTable
	// .4.9.1 dot11SupportedDataRatesTxEntry
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_WIRELESS_MODE, ASN_INTEGER,   RONLY,	WLAN_TABLE2, ZComOidAccessDataRatesValue, 4, 9, 1, 2),

	// .4.10 dot11SupportedDataRatesRxTable
	// .4.10.1 dot11SupportedDataRatesRxEntry
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_WIRELESS_MODE, ASN_INTEGER,   RONLY,	WLAN_TABLE2, ZComOidAccessDataRatesValue, 4, 10, 1, 2),

	// .4.11 dot11PhyOFDMTable
	// .4.11.1 dot11PhyOFDMEntry
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_CHANNEL, ASN_INTEGER,   RWRITE,	WLAN_TABLE1, ZComOidAccessOFDMInfo, 4, 11, 1, 1),
};

///////////////////////////////////////////////////////////////////////////////
// Oid Dispatch routines
///////////////////////////////////////////////////////////////////////////////
static const char	s_cszModuleName[]	= "ieee802dot11";
static oid	s_cDOT11OidPrefix[]= {1, 2, 840, 10036};

void init_ieee802dot11(void)
{
	//void snmpTrapGetSysLogPos(void);
	ZComOidInfoInit(s_DOT11OidInfos, TABLE_COUNT(s_DOT11OidInfos), DOT11FindMethod);
	
#ifdef	_DEBUG
	printf("Total Oids: %d\r\n", TABLE_COUNT(s_DOT11OidInfos));
#endif//_DEBUG

	REGISTER_MIB(s_cszModuleName, s_DOT11OidInfos, ZComOidInfo_t, s_cDOT11OidPrefix);
}

static void	SubOidIncrease(oid *pSubOid, size_t iSubOidLen)
{
	if (iSubOidLen>0)
	{
		pSubOid[0]++;
		if (pSubOid[0]>2 && iSubOidLen>1)
		{
			pSubOid[0] = 1;
			pSubOid[1]++;
		}
	}
}

static bool_t	ZComOidCheck(
	ZComOidInfo_t	*pOidInfo,
	oid				*name,
	size_t			*pLength,
	bool_t			fIsGet
	)
{
    oid current[MAX_OID_LEN] = {0};
	int	namelen = TABLE_COUNT(s_cDOT11OidPrefix);
	int	iSubOidLen = (0==pOidInfo->uchSubOidLen)?1:pOidInfo->uchSubOidLen;
    int result = 0;

	memcpy(current, s_cDOT11OidPrefix, sizeof(s_cDOT11OidPrefix));
	memcpy(current+namelen, pOidInfo->name, sizeof(oid)*pOidInfo->namelen);
	namelen += pOidInfo->namelen;

	result = snmp_oid_compare(name,
		(*pLength>namelen)?namelen:*pLength, current, namelen);

	if (result>0)
	{
		return FALSE;
	}
	// Get
	if (fIsGet)
	{
		return 0==result
			&& (namelen+iSubOidLen)==(*pLength)
			&& (0!=pOidInfo->uchSubOidLen || 0==name[namelen]);
	}

	// Get Next
	if (result<0 || (*pLength)<(namelen+iSubOidLen))
	{
		*pLength = namelen+iSubOidLen;
		memcpy(name, current, sizeof(oid)*namelen);
		name += namelen;
		while (iSubOidLen-->=0)
		{
			*name++ = (0!=pOidInfo->uchSubOidLen)?1:0;
		}
		return TRUE;
	}

	// result==0, prefix is same
	if ((0==pOidInfo->uchSubOidLen) || (*pLength)>(namelen+iSubOidLen))
	{
		return FALSE;
	}
	// Increase Sub Oids
	SubOidIncrease(name+namelen, pOidInfo->uchSubOidLen);
	return TRUE;
}

static ZComOidInfo_t	*s_pLastOidInfo = NULL;

static WriteMethod	DOT11WriteMethod;

static uint8_t*	DOT11FindMethod(
	struct variable	*vp,
	oid				*name,
	size_t			*length,
	int				fIsGet,		// 1: Get 0: Get Next
	size_t			*var_len,
	WriteMethod		**write_method
	)
{
	ZComOidInfo_t	*pOidInfo = &s_DOT11OidInfos[vp->magic-1];
	void			*pOidVar = NULL;
	oid				*pSubOid = name+vp->namelen;

	if (vp->magic>TABLE_COUNT(s_DOT11OidInfos))
	{
		return NULL;
	}

#ifdef	_DEBUG
	OidTrace(fIsGet?"get ":"get next ", name, *length);
	OidTrace("of ", vp->name, vp->namelen);
#endif//_DEBUG

	if (!ZComOidCheck(pOidInfo, name, length, fIsGet))
	{
	
#ifdef	_DEBUG
		printf("Oid Check Failed\r\n");
#endif//_DEBUG
		return NULL;
	}

	*write_method = NULL;
	*var_len = 0;

	if (SNMP_ERR_NOERROR!=pOidInfo->ZComOidAccess(
		pOidInfo, &pOidVar, var_len, pSubOid, pOidInfo->uchSubOidLen))
	{
		pOidVar = NULL;
		*var_len = 0;
		if (!fIsGet && 2==pOidInfo->uchSubOidLen)
		{
		
#ifdef	_DEBUG
			OidTrace("fail on ", name, *length);
#endif//_DEBUG

			SubOidIncrease(pSubOid, pOidInfo->uchSubOidLen);
			if (SNMP_ERR_NOERROR!=pOidInfo->ZComOidAccess(
				pOidInfo, &pOidVar, var_len, pSubOid, pOidInfo->uchSubOidLen))
			{
				pOidVar = NULL;
				*var_len = 0;
			}
		}
	}

	if (NULL!=pOidVar && RWRITE==(RWRITE&pOidInfo->acl))
	{
		s_pLastOidInfo = pOidInfo;	// save the OidInfo for write routine.
		*write_method = DOT11WriteMethod;
	}

#ifdef	_DEBUG
	OidTrace((NULL!=pOidVar)?"current ":"fail on ", name, *length);
	printf("\r\n");
#endif//_DEBUG

	return pOidVar;
}

static ZComOidInfo_t*	ZComOidInfoFind(
	ZComOidInfo_t	*pOidInfo,	// Preferred OidInfo
	oid				*name,
	size_t			namelen
	)
{
	if (NULL==name
		|| namelen<=TABLE_COUNT(s_cDOT11OidPrefix)
		|| 0!=memcmp(name, s_cDOT11OidPrefix, sizeof(s_cDOT11OidPrefix))
		)
	{
		return NULL;
	}

	namelen -= TABLE_COUNT(s_cDOT11OidPrefix);
	name += TABLE_COUNT(s_cDOT11OidPrefix);

	if (NULL!=pOidInfo
		&& namelen==pOidInfo->namelen+((0==pOidInfo->uchSubOidLen)?1:pOidInfo->uchSubOidLen)
		&& 0==memcmp(name, pOidInfo->name, sizeof(oid)*pOidInfo->namelen)
		)
	{
		return pOidInfo;
	}

	pOidInfo = s_DOT11OidInfos;
	while (pOidInfo<(s_DOT11OidInfos+TABLE_COUNT(s_DOT11OidInfos)))
	{
		if (NULL!=pOidInfo
			&& namelen==pOidInfo->namelen+((0==pOidInfo->uchSubOidLen)?1:pOidInfo->uchSubOidLen)
			&& 0==memcmp(name, pOidInfo->name, sizeof(oid)*pOidInfo->namelen)
			)
		{
			return pOidInfo;
		}
		pOidInfo++;
	}
	return NULL;
}

static int	DOT11WriteMethod(
	int		action,
	u_char	*var_val,
	u_char	var_val_type,
	size_t	var_val_len,
	u_char	*statP,			// returned from DOT11FindMethod
	oid		*name,
	size_t	name_len
	)
{
	ZComOidInfo_t	*pOidInfo = ZComOidInfoFind(s_pLastOidInfo, name, name_len);
	oid				*pSubOid = name + TABLE_COUNT(s_cDOT11OidPrefix);
	char			szDummy[4] = "";

#ifdef	_DEBUG
	OidTrace("Write ", name, name_len);
	printf("%s type:%d var", s_cszWriteAction[action], var_val_type);
	HexTrace(NULL, var_val, var_val_len);
	//printf("\tstatP");
	//HexTrace(NULL, statP, var_val_len);
	printf("\r\n");
#endif//_DEBUG

	if (NULL==pOidInfo)
	{
		printf("missed oid!\r\n");
		return SNMP_ERR_NOTWRITABLE;
	}

	pSubOid += pOidInfo->namelen;

	if (RWRITE!=(RWRITE&pOidInfo->acl))
	{
		printf("not writable oid!\r\n");
		return SNMP_ERR_NOTWRITABLE;
	}
	if (var_val_type!=pOidInfo->type)
	{
		printf("missed oid type: %d vs. %d!\r\n", var_val_type, pOidInfo->type);
		return SNMP_ERR_WRONGTYPE;
	}

	if (COMMIT!=action)
	{
		return SNMP_ERR_NOERROR;
	}
	
	if (NULL==var_val)
	{
		var_val = szDummy;
	}
	return pOidInfo->ZComOidAccess(pOidInfo,
		(void**)&var_val, &var_val_len,	pSubOid, pOidInfo->uchSubOidLen);
}

///////////////////////////////////////////////////////////////////////////////
// Oid Access routines
///////////////////////////////////////////////////////////////////////////////
static ZCOM_OID_ACCESS_DEFINE(ZComOidAccessMultiDomainCap)
{
	uint32_t	ulNumOfChannels = 0;
	uint8_t		puchChannels[24] = {0};
	
	if (NULL==*ppVar
		&& SNMP_ERR_NOERROR==ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM)
		&& NULL!=*ppVar
		)
	{
		uint32_t ulCountryCode = 0;
		ConfigReadInteger(pOidInfo->uchIndex, MIB_SYS_COUNTRY, &ulCountryCode);
		uint32_t ulWirelessMode = 0;
		ConfigReadInteger(pOidInfo->uchIndex, MIB_WLAN_WIRELESS_MODE, &ulWirelessMode);
		
		switch (pOidInfo->name[pOidInfo->namelen - 1])
		{
			case 2:
				//nfigReadString(pOidInfo->uchIndex, MIB_WLAN_VALID_CHANNELS, puchChannels, 24);
				*((uint32_t *)*ppVar) = puchChannels[0];
				*pVarLen = sizeof(uint32_t);
				break;
			case 3:
				//nfigReadInteger(pOidInfo->uchIndex, MIB_WLAN_VALID_CHANNELS_NUM, &ulNumOfChannels);

				if (124 == ulCountryCode || 840 == ulCountryCode || 484 == ulCountryCode || 630 == ulCountryCode)
					ulNumOfChannels = 11;
				else if (2 == ulWirelessMode && 392 == ulCountryCode)
					ulNumOfChannels = 14;
				else
					ulNumOfChannels = 13;
				
				*((uint32_t *)*ppVar) = ulNumOfChannels;
				*pVarLen = sizeof(uint32_t);
				break;
		}
		if (pOid[1] > 1) // only 1 result for now!
		{
			return SNMP_ERR_GENERR;
		}

		return SNMP_ERR_NOERROR;
	}
	
	return SNMP_ERR_GENERR;
}

static ZCOM_OID_ACCESS_DEFINE(ZComOidAccessResInfo)
{
	if (NULL==*ppVar
		&& SNMP_ERR_NOERROR==ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM)
		&& NULL!=*ppVar
		)
	{
		switch (pOidInfo->name[pOidInfo->namelen - 1])
		{
			case 1:
				memcpy(*ppVar, ManufacturerOUI, sizeof(ManufacturerOUI));
				*pVarLen = sizeof(ManufacturerOUI);
				break;
			case 2:
				strcpy(*ppVar, szManufacturerName);
				*pVarLen = strlen(szManufacturerName);
				break;
			case 3:
				strcpy(*ppVar, szManufacturerProductName);
				*pVarLen = strlen(szManufacturerProductName);
				break;
			case 4:
				//rcpy(*ppVar, szManufacturerProductVersion);
				//VarLen = strlen(szManufacturerProductVersion);
				break;
		}
		return SNMP_ERR_NOERROR;
	}
	
	return SNMP_ERR_GENERR;
}

static ZCOM_OID_ACCESS_DEFINE(ZComOidAccessAntennaInfo)
{
	if (NULL==*ppVar
		&& SNMP_ERR_NOERROR==ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM)
		&& NULL!=*ppVar
		)
	{
		switch (pOidInfo->name[pOidInfo->namelen - 1])
		{
			case 2:
				*((uint32_t *)*ppVar) = 2; // fast diversity is disabled
				*pVarLen = sizeof(uint32_t);
				break;
		}
		return SNMP_ERR_NOERROR;
	}
	
	return SNMP_ERR_GENERR;
}

/*
 * Convert a value in dBm to a value in milliWatt.
 */
int DBm2mWatt(int in)
{
	return((int) (floor(pow(10.0, (((double) in) / 10.0)))));
}

static ZCOM_OID_ACCESS_DEFINE(ZComOidAccessTxPowerInfo)
{
	int32_t		iPowerdBm = 0;
	uint32_t	ulPowerLevel = 0;
	
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM) && NULL!=*ppVar)
		{
			switch (pOidInfo->name[pOidInfo->namelen - 1])
			{
				case 1:
					*((uint32_t *)*ppVar) = 5;
					*pVarLen = sizeof(uint32_t);
					break;
				case 2:
				case 3:
				case 4:
				case 5:
				case 6:
					iPowerdBm = *((int32_t *)*ppVar);
					ConfigReadInteger(pOidInfo->uchIndex, MIB_WLAN_TRANSMIT_POWER, &ulPowerLevel);
					ulPowerLevel += 1;
					
					*((int32_t *)*ppVar) = DBm2mWatt(iPowerdBm - (pOidInfo->name[pOidInfo->namelen - 1] - ulPowerLevel) * 3);
					*pVarLen = sizeof(int32_t);
					break;
				case 10:
					*((uint32_t *)*ppVar) += 1;
					*pVarLen = sizeof(uint32_t);
					break;
			}
			return SNMP_ERR_NOERROR;
		}
		else return SNMP_ERR_GENERR;
	}
	else
	{
		if (pOidInfo->name[pOidInfo->namelen - 1] != 10)
			return SNMP_ERR_NOTWRITABLE;
		
		if( *((uint32_t*)*ppVar) < 1 || *((uint32_t*)*ppVar) > 5 )
			return SNMP_ERR_BADVALUE;

		*((uint32_t*)*ppVar) -= 1;
		*pVarLen = sizeof(uint32_t);
		
		return ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM);				
	}

	return SNMP_ERR_GENERR;
}

static ZCOM_OID_ACCESS_DEFINE(ZComOidAccessOFDMInfo)
{
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM) && NULL!=*ppVar)
		{
			return SNMP_ERR_NOERROR;
		}
		else return SNMP_ERR_GENERR;
	}
	else
	{
		if (pOidInfo->name[pOidInfo->namelen - 1] != 1)
		{
			return SNMP_ERR_NOTWRITABLE;
		}
		
		return ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM);	
	}
	
	return SNMP_ERR_GENERR;
}

static ZCOM_OID_ACCESS_DEFINE(ZComOidAccessManufacturerID)
{
	if (NULL==*ppVar
		&& SNMP_ERR_NOERROR==ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM)
		&& NULL!=*ppVar
		)
	{
		switch (pOidInfo->name[pOidInfo->namelen - 1])
		{
			case 8:
				strcpy(*ppVar, szManufacturerID);
				*pVarLen = strlen(szManufacturerID);
				break;
			case 9:
				strcpy(*ppVar, szProductID);
				*pVarLen = strlen(szProductID);
				break;
		}
		return SNMP_ERR_NOERROR;
	}
	
	return SNMP_ERR_GENERR;
}

// TODO: Write
static ZCOM_OID_ACCESS_DEFINE(ZComOidAccessRetryLimit)
{
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM) && NULL!=*ppVar)
		{
			switch (pOidInfo->name[pOidInfo->namelen - 1])
			{
				case 3:
					*((uint32_t *)*ppVar) = 7;
					*pVarLen = sizeof(uint32_t);
					break;
				case 4:
					*((uint32_t *)*ppVar) = 4;
					*pVarLen = sizeof(uint32_t);
					break;
			}
			return SNMP_ERR_NOERROR;
		}
		else return SNMP_ERR_GENERR;
	}
	else
	{
		return SNMP_ERR_NOERROR;
	}
	
	return SNMP_ERR_GENERR;
}

static ZCOM_OID_ACCESS_DEFINE(ZComOidAccessCounters)
{
	if (NULL == *ppVar
		&& SNMP_ERR_NOERROR==ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM)
		&& NULL != *ppVar
		&& sizeof(NetDeviceStats_t)==*pVarLen
		)
	{
		int64_t			llCounter64 = 0;
		NetDeviceStats_t	*pStats = *ppVar;

		switch (pOidInfo->name[pOidInfo->namelen - 1])
		{
		case 1:
		case 13:
			llCounter64 = pStats->Tx.ullPacketsTotal - pStats->Tx.ulPacketsError;
			break;
		case 2:
			llCounter64 = pStats->Tx.ullPacketsBroadcast + pStats->Tx.ullPacketsMulticast;
			break;
		case 3:
			llCounter64 = pStats->Tx.ulPacketsError;
			break;
		case 10:
			llCounter64 = pStats->Rx.ullPacketsTotal - pStats->Rx.ulPacketsError;			
			break;
		case 11:
			llCounter64 = pStats->Rx.ullPacketsBroadcast + pStats->Rx.ullPacketsMulticast;
		default:
			return SNMP_ERR_GENERR;
		}
		if (llCounter64 < 0)
		{
			llCounter64 = 0;
		}
		sprintf(*ppVar,"%lld",llCounter64);
		*pVarLen = strlen(*ppVar);
		return SNMP_ERR_NOERROR;
	}
	
	return SNMP_ERR_GENERR;
}

uint32_t g_uiDataRatesTableLen = 0;
static ZCOM_OID_ACCESS_DEFINE(ZComOidAccessDataRatesValue)
{
	if (NULL==*ppVar
		&& SNMP_ERR_NOERROR==ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM)
		&& NULL!=*ppVar
		)
	{
		switch ( *((uint32_t*)*ppVar) )
		{
			case WIRELESS_MODE_11A:
			case WIRELESS_MODE_11G_ONLY:
				{
					switch (pOid[1])
					{
						case 1:
							*((uint32_t *)*ppVar) = 6000;
							break;
						case 2:
							*((uint32_t *)*ppVar) = 9000;
							break;
						case 3:
							*((uint32_t *)*ppVar) = 12000;
							break;
						case 4:
							*((uint32_t *)*ppVar) = 18000;
								break;
						case 5:
							*((uint32_t *)*ppVar) = 24000;
								break;
						case 6:
							*((uint32_t *)*ppVar) = 36000;
								break;
						case 7:
							*((uint32_t *)*ppVar) = 48000;
								break;
						case 8:
							*((uint32_t *)*ppVar) = 54000;
								break;
						default:
							break;
					}
					*((uint32_t *)*ppVar) = *((uint32_t *)*ppVar)/500;
					*pVarLen = sizeof(uint32_t);
					if (pOid[1] > 8)
					{
						return SNMP_ERR_GENERR;
					}
					return SNMP_ERR_NOERROR;
				}
				break;

			case WIRELESS_MODE_11B_ONLY:
				{
					switch (pOid[1])
					{
						case 1:
							*((uint32_t *)*ppVar) = 1000;
							break;
						case 2:
							*((uint32_t *)*ppVar) = 2000;
							break;
						case 3:
							*((uint32_t *)*ppVar) = 5500;
							break;
						case 4:
							*((uint32_t *)*ppVar) = 11000;
								break;
						default:
							break;
					}
					*((uint32_t *)*ppVar) = *((uint32_t *)*ppVar)/500;
					*pVarLen = sizeof(uint32_t);
					if (pOid[1] > 4)
					{
						return SNMP_ERR_GENERR;
					}
					return SNMP_ERR_NOERROR;
				}
				break;

			case WIRELESS_MODE_AUTO:
				{
					switch (pOid[1])
					{
						case 1:
							*((uint32_t *)*ppVar) = 1000;
							break;
						case 2:
							*((uint32_t *)*ppVar) = 2000;
							break;
						case 3:
							*((uint32_t *)*ppVar) = 5500;
							break;
						case 4:
							*((uint32_t *)*ppVar) = 6000;
								break;
						case 5:
							*((uint32_t *)*ppVar) = 9000;
								break;
						case 6:
							*((uint32_t *)*ppVar) = 11000;
								break;
						case 7:
							*((uint32_t *)*ppVar) = 12000;
								break;
						case 8:
							*((uint32_t *)*ppVar) = 18000;
								break;
						case 9:
							*((uint32_t *)*ppVar) = 24000;
								break;
						case 10:
							*((uint32_t *)*ppVar) = 36000;
								break;
						case 11:
							*((uint32_t *)*ppVar) = 48000;
								break;
						case 12:
							*((uint32_t *)*ppVar) = 54000;
								break;
						default:
							break;
					}
					*((uint32_t *)*ppVar) = *((uint32_t *)*ppVar)/500;
					*pVarLen = sizeof(uint32_t);
					if (pOid[1] > 12)
					{
						return SNMP_ERR_GENERR;
					}
					return SNMP_ERR_NOERROR;
				}
				break;

			default:
				break;
		}
	}
	
	return SNMP_ERR_GENERR;
}

