/*
 * zcn1523.c
 */

//#define _DEBUG
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <fcntl.h>
#include <unistd.h>

#include "zcom_snmp.h"
#include "zcom_firewall.h"
enum SNMPD_UserInfo_t
{
	SNMPD_START = 0,
	SNMPD_NAME = 1,
	SNMPD_ACCESS,
	SNMPD_AUTH,
	SNMPD_PASSWORD,
	SNMPD_PRIV,
	SNMPD_END
};

enum NetworkStatistics_t
{
	NET_STAT_FIRST			= 0,
	NET_STAT_TX_TOTALPKT,
	NET_STAT_RX_TOTALPKT,
	NET_STAT_TX_TOTALBYTES,
	NET_STAT_RX_TOTALBYTES,
	NET_STAT_TX_UNICAST,
	NET_STAT_RX_UNICAST,
	NET_STAT_TX_BROADCAST,
	NET_STAT_RX_BROADCAST,
	NET_STAT_TX_MULTICAST,
	NET_STAT_RX_MULTICAST,
	NET_STAT_LAST,

	NET_STAT_TYPE_MASK 		= 0x0f,
	NET_STAT_WIRELESS		= 0x10,
	NET_STAT_ETHERNET1		= 0x20,
	NET_STAT_ETHERNET2		= 0x40,
	NET_STAT_INTERFACE_MASK	= 0xf0,
};
	
///////////////////////////////////////////////////////////////////////////////
// ZCom Oid Access Routines
///////////////////////////////////////////////////////////////////////////////

static	ZComOidAccess_t	ZComOidAccessNetIPAddress;
static	ZComOidAccess_t	ZComOidAccessDhcpdIPAddress;
static	ZComOidAccess_t	ZComOidRebootAP;
static	ZComOidAccess_t	ZComOidUsage;
//atic	ZComOidAccess_t	ZComOidAccessStaList;
static	ZComOidAccess_t	ZComOidAccessWlanControl;
static	ZComOidAccess_t	ZComOidSNMPUserInfo;

static	FindVarMethod	ZCN1523FindMethod;
//ntp
ZComOidAccess_t ZComOidAccessTimezone;
ZComOidAccess_t ZComOidAccessNtpServerIP1;
//acl
ZComOidAccess_t ZComOidAccessAclAdd;
ZComOidAccess_t ZComOidAccessAcldel;
ZComOidAccess_t ZComOidAccessAclMac;
//firewall
ZComOidAccess_t ZComOidAccessFirewallAdd;
ZComOidAccess_t ZComOidAccessIpFilterIp;
ZComOidAccess_t ZComOidAccessIpFilterComment;

ZComOidAccess_t ZComOidAccessPortFilterSport;
ZComOidAccess_t ZComOidAccessPortFilterEport;
ZComOidAccess_t ZComOidAccessPortFilterProtocol;
ZComOidAccess_t ZComOidAccessPortFilterComment;

ZComOidAccess_t ZComOidAccessPortForwardIp;
ZComOidAccess_t ZComOidAccessPortForwardSport;
ZComOidAccess_t ZComOidAccessPortForwardEport;
ZComOidAccess_t ZComOidAccessPortForwardProtocol;
ZComOidAccess_t ZComOidAccessPortForwardComment;
ZComOidAccess_t ZComOidAccessMultiVapIndex;
static	ZComOidAccess_t ZComOidAccessUpgradeFwState;

static	ZComOidAccess_t	ZComOidStatistics;

static ZComOidInfo_t ZCN1523OidInfos[] =
{
	//system
	ZCOM_OID_FIX_INFO(0,		MIB_FIRMWARE_VERSION,		ASN_OCTET_STR,	RONLY,	,	ZComOidAccessGeneric, 1, 1),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_SYS_MAC_ADDRESS,		ASN_OCTET_STR,	RONLY,	,	ZComOidAccessMacAddress ),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_HOST_NAME,				ASN_OCTET_STR,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_SYS_COUNTRY,			ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_SYSTEM_PORT_STATUS,	ASN_INTEGER,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(1,	MIB_SYSTEM_PORT_STATUS,	ASN_INTEGER,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WAN_CLONED_ENABLE,		ASN_INTEGER,	RWRITE,	,	ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WAN_CLONED_MAC,		ASN_OCTET_STR,	RWRITE,	,	ZComOidAccessMacAddress),// yangpeng change ASN_INTEGER to ASN_OCTET_STR
	ZCOM_OID_CONTINUE_INFO(0,	MIB_SYSTEM_POE_POWER,	ASN_INTEGER,	RWRITE,	,	ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(DEV_PORT_BRIDGE,	MIB_BRIDGE_SPANNING_TREE,	ASN_INTEGER,	RWRITE,	,	ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(DEV_PORT_BRIDGE,	MIB_STP_FORWARD_DELAY,	ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO (0, MIB_GPS_LATITUDE,		ASN_OCTET_STR, RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_SUB_END_INFO (0, MIB_GPS_LONGITUDE,		ASN_OCTET_STR, RWRITE, ,  ZComOidAccessGeneric,1),

	ZCOM_OID_FIX_INFO(0, 		0,						ASN_INTEGER,   RWRITE , , ZComOidAccessUpgradeFwState, 1, 99),//MIB OID 99

	//ipSetting
	ZCOM_OID_FIX_INFO(0,		MIB_ROUTE_MODE,		ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric, 2, 1),
	//bridge ip setting
	ZCOM_OID_FIX_INFO(DEV_PORT_BRIDGE,		MIB_NET_TYPE,				ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric, 2, 2,1),
	ZCOM_OID_CONTINUE_INFO(DEV_PORT_BRIDGE,	MIB_NET_IP,					ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessNetIPAddress),
	ZCOM_OID_CONTINUE_INFO(DEV_PORT_BRIDGE,	MIB_NET_MASK,				ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessNetIPAddress),
	ZCOM_OID_CONTINUE_INFO(DEV_PORT_BRIDGE,	MIB_NET_GATEWAY,			ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessIPAddress),
	ZCOM_OID_CONTINUE_INFO(DEV_PORT_BRIDGE,	MIB_NET_DNS_PRIMARY,		ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessIPAddress),
	ZCOM_OID_SUB_END_INFO(DEV_PORT_BRIDGE,	MIB_NET_DNS_SECONDARY,		ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessIPAddress,1),
	
	//router ip setting
	ZCOM_OID_FIX_INFO(DEV_PORT_WAN,		MIB_NET_TYPE,		ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric, 2,3,1,1),
	ZCOM_OID_CONTINUE_INFO(DEV_PORT_WAN,	MIB_NET_IP,					ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessNetIPAddress),
	ZCOM_OID_CONTINUE_INFO(DEV_PORT_WAN,	MIB_NET_MASK,				ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessNetIPAddress),
	ZCOM_OID_CONTINUE_INFO(DEV_PORT_WAN,	MIB_NET_GATEWAY,			ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessIPAddress),
	ZCOM_OID_CONTINUE_INFO(DEV_PORT_WAN,	MIB_NET_DNS_PRIMARY,		ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessIPAddress),
	ZCOM_OID_CONTINUE_INFO(DEV_PORT_WAN,	MIB_NET_DNS_SECONDARY,		ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessIPAddress),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_HOST_NAME,		ASN_OCTET_STR,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WAN_CONN_STATUS,		ASN_OCTET_STR,	RONLY,	,	ZComOidAccessGeneric), //#8676	
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WAN_PPP_LOCALIP,		ASN_IPADDRESS,	RONLY,	,	ZComOidAccessIPAddress),	   //#8676	  MIB_NET_IP_STATUS
	ZCOM_OID_CONTINUE_INFO(0,	MIB_PPPOE_STATICIP,			ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessIPAddress),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_PPPOE_USERNAME,		ASN_OCTET_STR,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_PPPOE_PASSWD,			ASN_OCTET_STR,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_PPPOE_SERVICE,			ASN_OCTET_STR,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_PPPOE_CONNECT_TYPE,	ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_SUB_END_INFO(0,	MIB_PPPOE_IDLE_TIME,			ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric,1),

	ZCOM_OID_FIX_INFO(0,		MIB_NET_IP,					ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessNetIPAddress, 2,3,2,1),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_NET_MASK,				ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessNetIPAddress),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_DHCPS_DAEMON,			ASN_INTEGER,	RWRITE,	,	ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_DHCPS_IP_RANGE_START,	ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessDhcpdIPAddress),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_DHCPS_IP_RANGE_END,	ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessDhcpdIPAddress),
	//ZCOM_OID_CONTINUE_INFO(0,	MIB_DHCPS_NETMASK,			ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessIPAddress),
	//ZCOM_OID_CONTINUE_INFO(0,	MIB_DHCPS_GATEWAY,			ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessIPAddress),
#ifdef _ZCOM_DHCP_RELAY_
	ZCOM_OID_CONTINUE_INFO(0,	MIB_DHCPS_LEASE,			ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_DHCP_RELAY_DAEMON,		ASN_INTEGER,	RWRITE,	,	ZComOidAccessBoolean),
	ZCOM_OID_SUB_END_INFO(0,		MIB_DHCP_SERVER_IP,			ASN_IPADDRESS,	RWRITE,	,	ZComOidAccessIPAddress,1),
#else
	ZCOM_OID_SUB_END_INFO(0,		MIB_DHCPS_LEASE,			ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric,1),
#endif
	
	//Wlan Setting
	ZCOM_OID_FIX_INFO(0,		MIB_WLAN_OPERATION_MODE,	ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric, 3, 1),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_WIRELESS_MODE,		ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_RADIO_ENABLE,		ASN_INTEGER,	RWRITE,	,	ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_SSID,				ASN_OCTET_STR,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_SSID_SUPPRESS,		ASN_INTEGER,	RWRITE,	,	ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_CHANNEL,			ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_TRANSMIT_RATE,		ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_BEACON_INTERVAL,	ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_RTS_THRESHOLD,		ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_FRAGMENT_THRESHOLD,ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_DTIM_INTERVAL,		ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_ANTENNA,			ASN_INTEGER,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_ANTENNA_GAIN,		ASN_INTEGER,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_PREAMBLE,			ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_TRANSMIT_POWER,	ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_HTPROT,			ASN_INTEGER,	RWRITE,	,	ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_CHANNEL_MODE,			ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_CHANNEL_OFFSET,			ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_CHANNEL_PROTECT,		ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_SHORTGI,			ASN_INTEGER,	RWRITE,	,	ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_AMPDU,				ASN_INTEGER,	RWRITE,	,	ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_AMSDU,				ASN_INTEGER,	RWRITE,	,	ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_IGMP_SNOOPING,		ASN_INTEGER,	RWRITE,	,	ZComOidAccessBoolean),
#ifdef ZCOM_TDM_COORDINATION	//add for STDM
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_STDM,				ASN_INTEGER,   	RWRITE,  , 	ZComOidAccessBoolean),
#endif
#ifdef _ZCOM_TDM_WDS_
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WDS_STDM_MODE,			ASN_INTEGER,   	RWRITE,  , 	ZComOidAccessGeneric),
#endif
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_CPE_TYPE,			ASN_INTEGER,   	RWRITE,  , 	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_WMM,				ASN_INTEGER,	RWRITE,	,	ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_WIRELESS_ISOLATION,ASN_INTEGER,	RWRITE,	,	ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_RIFS,				ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_LINK_INTEGRATION,	ASN_INTEGER,	RWRITE,	,	ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_MAX_STATION_NUM,	ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, 	MIB_WLAN_STA_NUM_LMT, 		ASN_INTEGER, 	RWRITE, , 	ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_SPACE_IN_METER,	ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_BW_ENABLED,				ASN_INTEGER,	RWRITE,	,	ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_BW_DOWN_STREAM,			ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_BW_DOWN_BURST,			ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_BW_UP_STREAM,			ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric),
	ZCOM_OID_SUB_END_INFO(0,	MIB_BW_UP_BURST,			ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric,1),

//VAP Profile
	ZCOM_OID_FIX_INFO(0,  0, ASN_INTEGER,	RWRITE, ,ZComOidAccessMultiVapIndex,4,1),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WLAN_VAP_ENABLE, ASN_INTEGER, RWRITE, , ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WLAN_PRONAME, ASN_OCTET_STR, RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WLAN_SSID, ASN_OCTET_STR,	RWRITE,	, ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WLAN_SSID_SUPPRESS, ASN_INTEGER,	RWRITE,	, ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WLAN_VAP_VLAN_PARAM, ASN_INTEGER,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WLAN_WIRELESS_ISOLATION, ASN_INTEGER, RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WLAN_WMM, ASN_INTEGER, RWRITE, , ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WLAN_MAX_STATION_NUM, ASN_INTEGER, RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WLAN_STA_NUM_LMT, ASN_INTEGER, RWRITE, , ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WLAN_AUTHENTICATION, ASN_INTEGER,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WLAN_ENCRYPTION, ASN_INTEGER, RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WPA_PSK, ASN_OCTET_STR, RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_VLAN_ENABLE, ASN_INTEGER, RWRITE, , ZComOidAccessBoolean),		
	ZCOM_OID_SUB_END_INFO(0,  MIB_VLAN_MANAGE_ID, ASN_INTEGER, RWRITE, , ZComOidAccessGeneric, 1),


	//security setting
	ZCOM_OID_FIX_INFO(0, MIB_WLAN_AUTHENTICATION,			ASN_INTEGER,	RWRITE, , ZComOidAccessGeneric, 5,1),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WLAN_ENCRYPTION,			ASN_INTEGER,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WEP_KEY_TYPE,				ASN_INTEGER,	RWRITE, , ZComOidAccessKeyType),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WEP_KEY_DEFAULT,			ASN_INTEGER,	RWRITE, , ZComOidAccessGeneric),
//	ZCOM_OID_CONTINUE_INFO(0, MIB_WEP_KEY_PASS_PHRASE,		ASN_OCTET_STR,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WEP_KEY1,					ASN_OCTET_STR,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WEP_KEY2,					ASN_OCTET_STR,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WEP_KEY3,					ASN_OCTET_STR,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WEP_KEY4,					ASN_OCTET_STR,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WPA_PSK,								ASN_OCTET_STR,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WPA_EAP_TYPE,						ASN_INTEGER,		RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WPA_EAP_INNER_TYPE,			ASN_INTEGER,		RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WPA_USERNAME,						ASN_OCTET_STR,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WPA_LOGINNAME,					ASN_OCTET_STR,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WPA_PASSWORD,						ASN_OCTET_STR,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0, MIB_WPA_USERCERT,						ASN_OCTET_STR,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_SUB_END_INFO(0, 	MIB_WPA_PRIVATEKEY_PASSWORD,	ASN_OCTET_STR,	RWRITE, , ZComOidAccessGeneric, 1),

	//wlanAccessControl
	ZCOM_OID_FIX_INFO (0, MIB_WLAN_ACL_MODE,				ASN_INTEGER,	RWRITE,	,	ZComOidAccessGeneric , 6, 1),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_ACL_ALLOW_LIST,	ASN_OCTET_STR,	RWRITE, , 	ZComOidAccessAclAdd),
	ZCOM_OID_SUB_END_INFO(0,		MIB_WLAN_ACL_NUM,	ASN_INTEGER,	RWRITE, ,	ZComOidAccessAcldel,1),
	ZCOM_OID_FIX_INFO(0,			MIB_WLAN_ACL_ALLOW_LIST,	ASN_OCTET_STR, 	RWRITE,2,	ZComOidAccessAclMac, 6, 4,1,1),
	//WDS setting
	ZCOM_OID_FIX_INFO(0,		MIB_SYS_MAC_ADDRESS,		ASN_OCTET_STR,	RONLY,	,	ZComOidAccessMacAddress , 7, 1),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_WLAN_REMOTE_AP,			ASN_OCTET_STR,	RWRITE,	,	ZComOidAccessMacAddress ),
	ZCOM_OID_CONTINUE_INFO(1,	MIB_WLAN_REMOTE_AP,			ASN_OCTET_STR,	RWRITE,	,	ZComOidAccessMacAddress ),
	ZCOM_OID_CONTINUE_INFO(2,	MIB_WLAN_REMOTE_AP,			ASN_OCTET_STR,	RWRITE,	,	ZComOidAccessMacAddress ),
	ZCOM_OID_CONTINUE_INFO(3,	MIB_WLAN_REMOTE_AP,			ASN_OCTET_STR,	RWRITE,	,	ZComOidAccessMacAddress ),//ZComOidAccessWDS
	ZCOM_OID_SUB_END_INFO(0,	MIB_WLAN_WDS_ISOLATION,		ASN_INTEGER,   	RWRITE,  , 	ZComOidAccessBoolean, 1),

	
	
	//info802dot1x . authinfo
	ZCOM_OID_FIX_INFO(RADIUS_AUTH_PRIMARY,		MIB_RADIUS_IP,					ASN_IPADDRESS,	RWRITE, , ZComOidAccessIPAddress, 8, 1),
	ZCOM_OID_CONTINUE_INFO(RADIUS_AUTH_PRIMARY,	MIB_RADIUS_PORT,				ASN_INTEGER,	RWRITE, , ZComOidAccessGeneric),
	//ZCOM_OID_CONTINUE_INFO(RADIUS_AUTH_PRIMARY,	MIB_WPA_RE_AUTH_SECONDS,		ASN_INTEGER,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(RADIUS_AUTH_PRIMARY,	MIB_WPA_GKEY_UPDATE_CONDITION,	ASN_INTEGER,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(RADIUS_AUTH_PRIMARY,	MIB_WPA_GKEY_UPDATE_SECONDS,	ASN_INTEGER,	RWRITE, , ZComOidAccessGeneric),
	//ZCOM_OID_CONTINUE_INFO(RADIUS_AUTH_PRIMARY,	MIB_WPA_GKEY_UPDATE_PACKETS,	ASN_INTEGER,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_SUB_END_INFO(RADIUS_AUTH_PRIMARY,	MIB_RADIUS_SECRET,				ASN_OCTET_STR,	RWRITE, , ZComOidAccessGeneric,1),

	//firewall
	//src ip filter
	ZCOM_OID_FIX_INFO(0,			MIB_IPFILTER_ENABLED,		ASN_INTEGER, 	RWRITE,	,	ZComOidAccessBoolean, 9,1),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_IPFILTER_CLI_SNMP_ADD,	ASN_OCTET_STR,	RWRITE, ,ZComOidAccessFirewallAdd),
	ZCOM_OID_SUB_END_INFO(0,	MIB_IPFILTER_CLI_SNMP_DEL,	ASN_INTEGER,	RWRITE, ,ZComOidAccessGeneric,1),
	ZCOM_OID_FIX_INFO(0,			MIB_IPFILTER_NUM,			ASN_IPADDRESS, 	RWRITE,2,	ZComOidAccessIpFilterIp, 9, 4,1,1),
	ZCOM_OID_FIX_INFO(0,			MIB_IPFILTER,				ASN_OCTET_STR, 	RWRITE,2,	ZComOidAccessIpFilterComment, 9, 4,1,2),
	//dst ip filter
	ZCOM_OID_FIX_INFO(0,			MIB_DSTIPFILTER_ENABLED,		ASN_INTEGER, 	RWRITE,	,	ZComOidAccessBoolean, 9,5),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_DSTIPFILTER_CLI_SNMP_ADD,	ASN_OCTET_STR,	RWRITE, , 	ZComOidAccessFirewallAdd),
	ZCOM_OID_SUB_END_INFO(0,		MIB_DSTIPFILTER_CLI_SNMP_DEL,	ASN_INTEGER,	RWRITE, ,	ZComOidAccessGeneric,1),
	ZCOM_OID_FIX_INFO(0,			MIB_DSTIPFILTER_NUM,			ASN_IPADDRESS, 	RWRITE,2,	ZComOidAccessIpFilterIp, 9, 8,1,1),
	ZCOM_OID_FIX_INFO(0,			MIB_DSTIPFILTER,					ASN_OCTET_STR, 	RWRITE,2,	ZComOidAccessIpFilterComment, 9, 8,1,2),
	//src port filter
	ZCOM_OID_FIX_INFO(0,			MIB_SRC_PORTFILTER_ENABLED,			ASN_INTEGER, 	RWRITE,	,	ZComOidAccessBoolean, 9,9),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_SRC_PORTFILTER_CLI_SNMP_ADD,	ASN_OCTET_STR,	RWRITE, , 	ZComOidAccessFirewallAdd),
	ZCOM_OID_SUB_END_INFO(0,		MIB_SRC_PORTFILTER_CLI_SNMP_DEL,	ASN_INTEGER,	RWRITE, ,	ZComOidAccessGeneric,1),
	ZCOM_OID_FIX_INFO(0,			MIB_SRC_PORTFILTER_NUM,				ASN_INTEGER, 	RWRITE,2,	ZComOidAccessPortFilterSport, 9, 12,1,1),
	ZCOM_OID_FIX_INFO(0,			MIB_SRC_PORTFILTER_NUM,				ASN_INTEGER, 	RWRITE,2,	ZComOidAccessPortFilterEport, 9, 12,1,2),
	ZCOM_OID_FIX_INFO(0,			MIB_SRC_PORTFILTER_NUM,				ASN_INTEGER, 	RWRITE,2,	ZComOidAccessPortFilterProtocol, 9, 12,1,3),
	ZCOM_OID_FIX_INFO(0,			MIB_SRC_PORTFILTER,					ASN_OCTET_STR, 	RWRITE,2,	ZComOidAccessPortFilterComment, 9, 12,1,4),

	//dest port filter
	ZCOM_OID_FIX_INFO(0,			MIB_PORTFILTER_ENABLED,			ASN_INTEGER, 	RWRITE,	,	ZComOidAccessBoolean, 9,13),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_PORTFILTER_CLI_SNMP_ADD,	ASN_OCTET_STR,	RWRITE, , 	ZComOidAccessFirewallAdd),
	ZCOM_OID_SUB_END_INFO(0,		MIB_PORTFILTER_CLI_SNMP_DEL,	ASN_INTEGER,	RWRITE, ,	ZComOidAccessGeneric,1),
	ZCOM_OID_FIX_INFO(0,			MIB_PORTFILTER_NUM,				ASN_INTEGER, 	RWRITE,2,	ZComOidAccessPortFilterSport, 9, 16,1,1),
	ZCOM_OID_FIX_INFO(0,			MIB_PORTFILTER_NUM,				ASN_INTEGER, 	RWRITE,2,	ZComOidAccessPortFilterEport, 9, 16,1,2),
	ZCOM_OID_FIX_INFO(0,			MIB_PORTFILTER_NUM,				ASN_INTEGER, 	RWRITE,2,	ZComOidAccessPortFilterProtocol, 9, 16,1,3),
	ZCOM_OID_FIX_INFO(0,			MIB_PORTFILTER,					ASN_OCTET_STR, 	RWRITE,2,	ZComOidAccessPortFilterComment, 9, 16,1,4),

	//port forward
	ZCOM_OID_FIX_INFO(0,			MIB_PORTFW_ENABLED,		ASN_INTEGER, 	RWRITE,	,	ZComOidAccessBoolean, 9,17),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_PORTFW_CLI_SNMP_ADD,	ASN_OCTET_STR,	RWRITE, , 	ZComOidAccessFirewallAdd),
	ZCOM_OID_SUB_END_INFO(0,		MIB_PORTFW_CLI_SNMP_DEL,	ASN_INTEGER,	RWRITE, ,	ZComOidAccessGeneric,1),
	ZCOM_OID_FIX_INFO(0,			MIB_PORTFW_NUM,			ASN_IPADDRESS, 	RWRITE,2,	ZComOidAccessPortForwardIp, 9, 20,1,1),
	ZCOM_OID_FIX_INFO(0,			MIB_PORTFW_NUM,			ASN_INTEGER, 	RWRITE,2,	ZComOidAccessPortForwardSport, 9, 20,1,2),
	ZCOM_OID_FIX_INFO(0,			MIB_PORTFW_NUM,			ASN_INTEGER, 	RWRITE,2,	ZComOidAccessPortForwardEport, 9, 20,1,3),
	ZCOM_OID_FIX_INFO(0,			MIB_PORTFW_NUM,			ASN_INTEGER, 	RWRITE,2,	ZComOidAccessPortForwardProtocol, 9, 20,1,4),
	ZCOM_OID_FIX_INFO(0,			MIB_PORTFW,					ASN_OCTET_STR, 	RWRITE,2,	ZComOidAccessPortForwardComment, 9, 20,1,5),

	ZCOM_OID_FIX_INFO(0,			MIB_DMZ,		ASN_INTEGER, 	RWRITE,	,	ZComOidAccessBoolean, 9,21),
	ZCOM_OID_SUB_END_INFO(0,		MIB_DMZ_IP,		ASN_IPADDRESS,	RWRITE, ,	ZComOidAccessIPAddress,1),
	
	//timeSettings
	ZCOM_OID_FIX_INFO(0,		MIB_NTP_ENABLED,	ASN_INTEGER,	RWRITE, , ZComOidAccessBoolean, 10, 1),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_NTP_TIMEZONE,	ASN_OCTET_STR,	RWRITE, , ZComOidAccessTimezone),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_TIME,			ASN_OCTET_STR,	RONLY, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_NTP_SERVER_ID,	ASN_INTEGER,	RWRITE, , ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_NTP_SERVER_IP1,	ASN_IPADDRESS,	RWRITE, , ZComOidAccessNtpServerIP1),
	ZCOM_OID_SUB_END_INFO (0,	MIB_NTP_SERVER_IP2,	ASN_IPADDRESS,	RWRITE, , ZComOidAccessIPAddress, 1),
	//remote console
	ZCOM_OID_FIX_INFO(0,		MIB_REMOTE_MGMT_MODE,ASN_INTEGER,	RWRITE, , ZComOidAccessGeneric, 11, 1, 1),
	ZCOM_OID_CONTINUE_INFO(0, 	MIB_TELNET_DAEMON, 	ASN_INTEGER,	RWRITE,	, ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0, 	MIB_SNMP_DAEMON, 	ASN_INTEGER,	RWRITE,	, ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0, 	MIB_FTP_DAEMON, 	ASN_INTEGER,	RWRITE,	, ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0, 	MIB_SSH_DAEMON, 	ASN_INTEGER,	RWRITE,	, ZComOidAccessBoolean),
	ZCOM_OID_CONTINUE_INFO(0, 	MIB_HTTPS_DAEMON, 	ASN_INTEGER,	RWRITE,	, ZComOidAccessBoolean),
	ZCOM_OID_SUB_END_INFO (0,	MIB_WISE_DAEMON,	ASN_INTEGER,	RWRITE, , ZComOidAccessBoolean, 2),
	//SNMP management
	ZCOM_OID_FIX_INFO(0,			MIB_SNMPD_VERSION,			ASN_INTEGER,	RWRITE, ,	ZComOidAccessGeneric, 11, 2, 1),
	ZCOM_OID_CONTINUE_INFO(0,		MIB_SNMP_PORT,				ASN_INTEGER,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,		MIB_SNMPD_READ_COMMUNITY,	ASN_OCTET_STR,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,		MIB_SNMPD_WRITE_COMMUNITY,	ASN_OCTET_STR,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,		MIB_SNMPD_TRAP_COMMUNITY,	ASN_OCTET_STR,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,		MIB_SNMPD_TRAP_SERVER_LIST,	ASN_IPADDRESS,	RWRITE, ,	ZComOidAccessIPAddress),
	ZCOM_OID_CONTINUE_INFO(0,		MIB_SNMPD_USER1_ENABLE,		ASN_INTEGER,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(SNMPD_NAME,		MIB_SNMPD_USER1,	ASN_OCTET_STR,	RWRITE, ,	ZComOidSNMPUserInfo),
	ZCOM_OID_CONTINUE_INFO(SNMPD_ACCESS,	MIB_SNMPD_USER1,	ASN_INTEGER,	RWRITE, ,	ZComOidSNMPUserInfo),
	ZCOM_OID_CONTINUE_INFO(SNMPD_AUTH,		MIB_SNMPD_USER1,	ASN_INTEGER,	RWRITE, ,	ZComOidSNMPUserInfo),
	ZCOM_OID_CONTINUE_INFO(SNMPD_PASSWORD,	MIB_SNMPD_USER1,	ASN_OCTET_STR,	RWRITE, ,	ZComOidSNMPUserInfo),
	ZCOM_OID_CONTINUE_INFO(SNMPD_PRIV,		MIB_SNMPD_USER1,	ASN_INTEGER,	RWRITE, ,	ZComOidSNMPUserInfo),
	ZCOM_OID_CONTINUE_INFO(0,			MIB_SNMPD_USER2_ENABLE,	ASN_INTEGER,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(SNMPD_NAME,		MIB_SNMPD_USER2,	ASN_OCTET_STR,	RWRITE, ,	ZComOidSNMPUserInfo),
	ZCOM_OID_CONTINUE_INFO(SNMPD_ACCESS,	MIB_SNMPD_USER2,	ASN_INTEGER,	RWRITE, ,	ZComOidSNMPUserInfo),
	ZCOM_OID_CONTINUE_INFO(SNMPD_AUTH,		MIB_SNMPD_USER2,	ASN_INTEGER,	RWRITE, ,	ZComOidSNMPUserInfo),
	ZCOM_OID_CONTINUE_INFO(SNMPD_PASSWORD,	MIB_SNMPD_USER2,	ASN_OCTET_STR,	RWRITE, ,	ZComOidSNMPUserInfo),
	ZCOM_OID_CONTINUE_INFO(SNMPD_PRIV,		MIB_SNMPD_USER2,	ASN_INTEGER,	RWRITE, ,	ZComOidSNMPUserInfo),
	ZCOM_OID_SUB_END_INFO(0,				MIB_SNMP_DAEMON,	ASN_INTEGER,	RWRITE, ,	ZComOidAccessGeneric, 2),
#ifdef _ZCOM_CAPTIVE_POTAL_
	//CoovaChilli management
	ZCOM_OID_FIX_INFO(0,		MIB_CHILLI_DAEMON,					ASN_INTEGER,	RWRITE, ,	ZComOidAccessBoolean, 11, 3,1),
	ZCOM_OID_CONTINUE_INFO(0,MIB_CHILLI_RADIUS_SERVER1,			ASN_OCTET_STR,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,MIB_CHILLI_RADIUS_SERVER2,			ASN_OCTET_STR,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,MIB_CHILLI_RADIUS_AUTH_PORT,		ASN_INTEGER,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,MIB_CHILLI_RADIUS_ACCT_PORT,		ASN_INTEGER,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,MIB_CHILLI_RADIUS_SECRET,			ASN_OCTET_STR,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,MIB_CHILLI_RADIUS_NASID,			ASN_OCTET_STR,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,MIB_CHILLI_RADIUS_ADMIN_USER,		ASN_OCTET_STR,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,MIB_CHILLI_RADIUS_ADMIN_PASSWD,	ASN_OCTET_STR,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,MIB_CHILLI_UAM_URL,					ASN_OCTET_STR,	RWRITE, ,	ZComOidAccessGeneric),
	ZCOM_OID_SUB_END_INFO(0,	MIB_CHILLI_UAM_SECRET,				ASN_OCTET_STR,	RWRITE, ,	ZComOidAccessGeneric, 2),
#endif
	ZCOM_OID_FIX_INFO(0,		MIB_PASSWORD,				ASN_OCTET_STR,	RWRITE, , ZComOidAccessGeneric, 11, 4),
	


	//syslog remote setting
	ZCOM_OID_FIX_INFO(0,		MIB_SYSLOG_DAEMON,				ASN_INTEGER,	RWRITE, , ZComOidAccessBoolean, 12, 1),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_SYSLOG_SERVER_IP,			ASN_IPADDRESS,	RWRITE, , ZComOidAccessIPAddress),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_SYSLOG_SERVER_PORT, 		ASN_INTEGER,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_SUB_END_INFO(0,		MIB_SYSLOG_CLEAR, 		ASN_OCTET_STR,	RWRITE, , ZComOidAccessGeneric,1),

	//ping watchdog setting
	ZCOM_OID_FIX_INFO(0,		MIB_PINGWD_ENABLE,			ASN_INTEGER,	RWRITE, , ZComOidAccessBoolean, 13, 1),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_PINGWD_IP,				ASN_IPADDRESS,	RWRITE, , ZComOidAccessIPAddress),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_PINGWD_PING_INTERVAL,	ASN_INTEGER,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_CONTINUE_INFO(0,	MIB_PINGWD_STARTUP_DELAY,	ASN_INTEGER,	RWRITE, , ZComOidAccessGeneric),
	ZCOM_OID_SUB_END_INFO(0,	MIB_PINGWD_FAILURE_COUNT, 	ASN_INTEGER,	RWRITE, , ZComOidAccessGeneric,1),
#if 1
	//statistics -- WLAN1
	ZCOM_OID_FIX_INFO(NET_STAT_WIRELESS | NET_STAT_TX_TOTALPKT,
								MIB_WIRELESS_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics, 20, 1, 1),
	ZCOM_OID_CONTINUE_INFO(NET_STAT_WIRELESS | NET_STAT_RX_TOTALPKT,
								MIB_WIRELESS_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics),
	ZCOM_OID_CONTINUE_INFO(NET_STAT_WIRELESS | NET_STAT_TX_TOTALBYTES,
								MIB_WIRELESS_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics),
	ZCOM_OID_CONTINUE_INFO(NET_STAT_WIRELESS | NET_STAT_RX_TOTALBYTES,
								MIB_WIRELESS_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics),
	ZCOM_OID_CONTINUE_INFO(NET_STAT_WIRELESS | NET_STAT_TX_UNICAST,
								MIB_WIRELESS_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics),
	ZCOM_OID_CONTINUE_INFO(NET_STAT_WIRELESS | NET_STAT_RX_UNICAST,
								MIB_WIRELESS_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics),
	ZCOM_OID_CONTINUE_INFO(NET_STAT_WIRELESS | NET_STAT_TX_BROADCAST,
								MIB_WIRELESS_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics),
	ZCOM_OID_CONTINUE_INFO(NET_STAT_WIRELESS | NET_STAT_RX_BROADCAST,
								MIB_WIRELESS_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics),
	ZCOM_OID_CONTINUE_INFO(NET_STAT_WIRELESS | NET_STAT_TX_MULTICAST,
								MIB_WIRELESS_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics),
	ZCOM_OID_SUB_END_INFO(NET_STAT_WIRELESS | NET_STAT_RX_MULTICAST,
								MIB_WIRELESS_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics, 1),
	//statistics -- LAN1
	ZCOM_OID_FIX_INFO(NET_STAT_ETHERNET1 | NET_STAT_TX_TOTALPKT,
								MIB_ETHERNETLAN_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics, 20, 2, 1),
	ZCOM_OID_CONTINUE_INFO(NET_STAT_ETHERNET1 | NET_STAT_RX_TOTALPKT,
								MIB_ETHERNETLAN_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics),
	ZCOM_OID_CONTINUE_INFO(NET_STAT_ETHERNET1 | NET_STAT_TX_TOTALBYTES,
								MIB_ETHERNETLAN_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics),
	ZCOM_OID_SUB_END_INFO(NET_STAT_ETHERNET1 | NET_STAT_RX_TOTALBYTES,
								MIB_ETHERNETLAN_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics, 1),
	//statistics -- LAN2
	ZCOM_OID_FIX_INFO(NET_STAT_ETHERNET2 | NET_STAT_TX_TOTALPKT,
								MIB_ETHERNETLAN_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics, 20, 3, 1),
	ZCOM_OID_CONTINUE_INFO(NET_STAT_ETHERNET2 | NET_STAT_RX_TOTALPKT,
								MIB_ETHERNETLAN_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics),
	ZCOM_OID_CONTINUE_INFO(NET_STAT_ETHERNET2 | NET_STAT_TX_TOTALBYTES,
								MIB_ETHERNETLAN_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics),
	ZCOM_OID_SUB_END_INFO(NET_STAT_ETHERNET2 | NET_STAT_RX_TOTALBYTES,
								MIB_ETHERNETLAN_STATS,		ASN_INTEGER,	RONLY, , ZComOidStatistics, 1),
#endif
	//userCommand
	ZCOM_OID_FIX_INFO(0,	MIB_REBOOT,				ASN_OCTET_STR, RWRITE,	,	ZComOidAccessGeneric, 30, 1),
	ZCOM_OID_SUB_END_INFO(0,MIB_RESTORE_FACTORY,	ASN_OCTET_STR, RWRITE,	,	ZComOidAccessGeneric, 1),
	
};

///////////////////////////////////////////////////////////////////////////////
// Oid Dispatch routines
///////////////////////////////////////////////////////////////////////////////
static const char	s_cszZCN1523ModuleName[]	= "zcn1523";
static oid			s_cZCN1523OidPrefix[8]	= {1,3,6,1,4,1};

#if defined(ZCOMSNMPTRAP)
extern void snmpTrapGetSysLogPos(void);
#endif//ZCOMSNMPTRAP

void InitNBZCN1523(void)
{
	static const char*	cszModuleName = NULL;

	ZComOidInfoInit(ZCN1523OidInfos, TABLE_COUNT(ZCN1523OidInfos), ZCN1523FindMethod);
	
	cszModuleName = s_cszZCN1523ModuleName;
	s_cZCN1523OidPrefix[6] = 1567;
	s_cZCN1523OidPrefix[7] = 1523;
	
	REGISTER_MIB(cszModuleName, ZCN1523OidInfos, ZComOidInfo_t, s_cZCN1523OidPrefix);

#ifdef	_DEBUG
	printf("\n\rTotal Oids: %d\r\n", TABLE_COUNT(ZCN1523OidInfos));
#endif//_DEBUG

#if defined(ZCOMSNMPTRAP)
	snmpTrapGetSysLogPos();
#endif//ZCOMSNMPTRAP
}

static void	SubOidIncrease(oid *pSubOid, size_t iSubOidLen)
{
	if (iSubOidLen>0)
	{
		pSubOid[0]++;
	}
}

static bool_t	ZComOidCheck(
	ZComOidInfo_t	*pOidInfo,
	oid				*name,
	size_t			*pLength,
	bool_t			fIsGet
	)
{
	oid current[MAX_OID_LEN] = {0};
	int	namelen = TABLE_COUNT(s_cZCN1523OidPrefix);
	int	iSubOidLen = (0==pOidInfo->uchSubOidLen)?1:pOidInfo->uchSubOidLen;
	int result = 0;

	memcpy(current, s_cZCN1523OidPrefix, sizeof(s_cZCN1523OidPrefix));
	memcpy(current+namelen, pOidInfo->name, sizeof(oid)*pOidInfo->namelen);
	namelen += pOidInfo->namelen;

	result = snmp_oid_compare(name,
		(*pLength>namelen)?namelen:*pLength, current, namelen);

	if (result>0)
	{
		return FALSE;
	}
	
	// Get
	if (fIsGet)
	{
		return 0==result
			&& (namelen+iSubOidLen)==(*pLength)
			&& (0!=pOidInfo->uchSubOidLen || 0==name[namelen]);
	}

	// Get Next
	if (result<0 || (*pLength)<(namelen+iSubOidLen))
	{
		*pLength = namelen+iSubOidLen;
		memcpy(name, current, sizeof(oid)*namelen);
		name += namelen;
		while (iSubOidLen-->=0)
		{
			*name++ = (0!=pOidInfo->uchSubOidLen)?1:0;
		}
		return TRUE;
	}

	// result==0, prefix is same
	if ((0==pOidInfo->uchSubOidLen) || (*pLength)>(namelen+iSubOidLen))
	{
		return FALSE;
	}
	
	// Increase Sub Oids
	SubOidIncrease(name+namelen, pOidInfo->uchSubOidLen);
	return TRUE;
}

static ZComOidInfo_t	*s_pLastOidInfo = NULL;

static WriteMethod	ZCN1523WriteMethod;

static uint8_t*	ZCN1523FindMethod(
	struct variable	*vp,
	oid				*name,
	size_t			*length,
	int				fIsGet,		// 1: Get 0: Get Next
	size_t			*var_len,
	WriteMethod		**write_method
	)
{
	ZComOidInfo_t	*pOidInfo = &ZCN1523OidInfos[vp->magic-1];
	void			*pOidVar = NULL;
	oid				*pSubOid = name+vp->namelen;

	if (vp->magic>TABLE_COUNT(ZCN1523OidInfos))
	{
		return NULL;
	}

#ifdef	_DEBUG
	OidTrace(fIsGet?"get ":"get next ", name, *length);
	OidTrace("of ", vp->name, vp->namelen);
#endif//_DEBUG

	if (!ZComOidCheck(pOidInfo, name, length, fIsGet))
	{
		return NULL;
	}

	*write_method = NULL;
	*var_len = 0;

	if (SNMP_ERR_NOERROR!=pOidInfo->ZComOidAccess(
		pOidInfo, &pOidVar, var_len, pSubOid, pOidInfo->uchSubOidLen))
	{
		pOidVar = NULL;
		*var_len = 0;

		if (!fIsGet && 2==pOidInfo->uchSubOidLen)
		{
		
#ifdef	_DEBUG
			OidTrace("fail on ", name, *length);
#endif//_DEBUG

			SubOidIncrease(pSubOid, pOidInfo->uchSubOidLen);
			if (SNMP_ERR_NOERROR!=pOidInfo->ZComOidAccess(
				pOidInfo, &pOidVar, var_len, pSubOid, pOidInfo->uchSubOidLen))
			{
				pOidVar = NULL;
				*var_len = 0;
			}
		}
	}

	if (NULL!=pOidVar && RWRITE==(RWRITE&pOidInfo->acl))
	{
		s_pLastOidInfo = pOidInfo;	// save the OidInfo for write routine.
		*write_method = ZCN1523WriteMethod;
	}

#ifdef	_DEBUG
	OidTrace((NULL!=pOidVar)?"current ":"fail on ", name, *length);
#endif//_DEBUG

	return pOidVar;
}

static ZComOidInfo_t*	ZComOidInfoFind(
	ZComOidInfo_t	*pOidInfo,	// Preferred OidInfo
	oid				*name,
	size_t			namelen
	)
{
	if (NULL==name
		|| namelen<=TABLE_COUNT(s_cZCN1523OidPrefix)
		|| 0!=memcmp(name, s_cZCN1523OidPrefix, sizeof(s_cZCN1523OidPrefix))
		)
	{
		return NULL;
	}

	namelen -= TABLE_COUNT(s_cZCN1523OidPrefix);
	name += TABLE_COUNT(s_cZCN1523OidPrefix);

	if (NULL!=pOidInfo
		&& namelen==pOidInfo->namelen+((0==pOidInfo->uchSubOidLen)?1:pOidInfo->uchSubOidLen)
		&& 0==memcmp(name, pOidInfo->name, sizeof(oid)*pOidInfo->namelen)
		)
	{
		return pOidInfo;
	}

	pOidInfo = ZCN1523OidInfos;
	while (pOidInfo<(ZCN1523OidInfos+TABLE_COUNT(ZCN1523OidInfos)))
	{
		if (NULL!=pOidInfo
			&& namelen==pOidInfo->namelen+((0==pOidInfo->uchSubOidLen)?1:pOidInfo->uchSubOidLen)
			&& 0==memcmp(name, pOidInfo->name, sizeof(oid)*pOidInfo->namelen)
			)
		{
			return pOidInfo;
		}
		pOidInfo++;
	}
	return NULL;
}

static int	ZCN1523WriteMethod(
	int		action,
	u_char	*var_val,
	u_char	var_val_type,
	size_t	var_val_len,
	u_char	*statP,			// returned from ZCN1523FindMethod
	oid		*name,
	size_t	name_len
	)
{
	ZComOidInfo_t	*pOidInfo = ZComOidInfoFind(s_pLastOidInfo, name, name_len);
	oid				*pSubOid = name + TABLE_COUNT(s_cZCN1523OidPrefix);
	char			szDummy[4] = "";

#ifdef	_DEBUG
	OidTrace("Write ", name, name_len);
	printf("%s type:%d var", s_cszWriteAction[action], var_val_type);
	HexTrace(NULL, var_val, var_val_len);
	//printf("\tstatP");
	//HexTrace(NULL, statP, var_val_len);
	printf("\r\n");
#endif//_DEBUG

	if (NULL==pOidInfo)
	{
		printf("missed oid!\r\n");
		return SNMP_ERR_NOTWRITABLE;
	}

	pSubOid += pOidInfo->namelen;

	if (RWRITE!=(RWRITE&pOidInfo->acl))
	{
		printf("not writable oid!\r\n");
		return SNMP_ERR_NOTWRITABLE;
	}
	if (var_val_type!=pOidInfo->type)
	{
		printf("missed oid type: %d vs. %d!\r\n", var_val_type, pOidInfo->type);
		return SNMP_ERR_WRONGTYPE;
	}

	if (COMMIT!=action)
	{
		return SNMP_ERR_NOERROR;
	}
	if (NULL==var_val)
	{
		var_val = szDummy;
		var_val_len = strlen(var_val);
	}
	return pOidInfo->ZComOidAccess(pOidInfo,
		(void**)&var_val, &var_val_len,	pSubOid, pOidInfo->uchSubOidLen);
}

///////////////////////////////////////////////////////////////////////////////
// Oid Access routines
///////////////////////////////////////////////////////////////////////////////
/*
static ZCOM_OID_ACCESS_DEFINE(ZComOidAccessStaList)
{
	char			szSSID[20] = {0};
	AssocStaEntry_t	*pAssocSTA = NULL;
	int32_t			lClientIndex = pOid[0]-1;

	if (NULL == *ppVar
		&& SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM)
		&& NULL != *ppVar
		)
	{
		pAssocSTA = (AssocStaEntry_t *)*ppVar + lClientIndex;
		if (0 != pAssocSTA->lIndex)
		{
			switch (pOidInfo->name[pOidInfo->namelen - 1])
			{
				case 1: // pwStationIndex
					*((uint32_t*)*ppVar) = pAssocSTA->lIndex;
					*pVarLen = sizeof(uint32_t);
					return SNMP_ERR_NOERROR;
				case 2: // pwStationMacAddress
					memcpy(*ppVar, pAssocSTA->Station, sizeof(MacAddr_t));
					*pVarLen = sizeof(MacAddr_t);
					return SNMP_ERR_NOERROR;
				case 3: // pwStationAssociateTime
					*pVarLen = 0;
					*pVarLen += sprintf(*ppVar + *pVarLen, "%d:", (pAssocSTA->ulAssocTime) / 3600);
					*pVarLen += sprintf(*ppVar + *pVarLen, "%d:", ((pAssocSTA->ulAssocTime) % 3600) / 60);
					*pVarLen += sprintf(*ppVar + *pVarLen, "%d", ((pAssocSTA->ulAssocTime) % 3600) % 60);
					return SNMP_ERR_NOERROR;
				case 4: // pwStationSSID
					CONF_READ_STRING(0, MIB_WLAN_SSID, szSSID);
					memcpy(*ppVar, szSSID, strlen(szSSID));		
					*pVarLen = strlen(szSSID);
					return SNMP_ERR_NOERROR;
				case 5: // pwStationStatus
					*((uint32_t*)*ppVar) = pAssocSTA->ulDutStatus;		
					*pVarLen = sizeof(uint32_t);
					return SNMP_ERR_NOERROR;
				default:
					return SNMP_ERR_GENERR;
			}
		}
		else
		{
			return SNMP_ERR_GENERR;
		}
	}

	return SNMP_ERR_GENERR;
}
*/

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessNetIPAddress)
{
			
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{
			char		*szIP = *ppVar;
			uint32_t	ulIP = 0;
			if (NULL!=*ppVar && Str2IP(&ulIP, szIP))
			{
				*pVarLen = sizeof(uint32_t);
				*((uint32_t*)szIP) = ulIP;
				return SNMP_ERR_NOERROR;
			}
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		char wan_ip[16],wan_mask[16],lan_ip[16],lan_mask[16],szIP[20];
		in_addr_t ulIP;
		int32_t mode;
		
		if (4 != *pVarLen)
			return SNMP_ERR_GENERR;
		
		ulIP = *((uint32_t*)*ppVar);
		ConfigReadInteger(0, MIB_ROUTE_MODE, &mode);
		if(mode != BRIDGE_MODE)
		{
			CONF_READ_STRING(DEV_PORT_WAN,MIB_NET_IP_STATUS, wan_ip);
			CONF_READ_STRING(DEV_PORT_WAN,MIB_NET_MASK_STATUS, wan_mask);
			CONF_READ_STRING(DEV_PORT_BRIDGE,MIB_NET_IP, lan_ip);
			CONF_READ_STRING(DEV_PORT_BRIDGE,MIB_NET_MASK, lan_mask);

			switch(pOidInfo->uchIndex)
			{
				case DEV_PORT_BRIDGE:
				{
					switch(pOidInfo->ulMIB)
					{
						case MIB_NET_IP:
							if(checkIPSubnet(StrSwitchIP(wan_ip),StrSwitchIP(wan_mask),ulIP,StrSwitchIP(lan_mask))==FALSE)
								return SNMP_ERR_GENERR;
							break;
						case MIB_NET_MASK:
							if(checkIPSubnet(StrSwitchIP(wan_ip),StrSwitchIP(wan_mask),StrSwitchIP(lan_ip),ulIP)==FALSE)
								return SNMP_ERR_GENERR;
							break;
					}
				}
				break;
				case DEV_PORT_WAN:
				{
					switch(pOidInfo->ulMIB)
					{
						case MIB_NET_IP:
							if(checkIPSubnet(ulIP,StrSwitchIP(wan_mask),StrSwitchIP(lan_ip),StrSwitchIP(lan_mask))==FALSE)
								return SNMP_ERR_GENERR;
							break;
						case MIB_NET_MASK:
							if(checkIPSubnet(StrSwitchIP(wan_ip),ulIP,StrSwitchIP(lan_ip),StrSwitchIP(lan_mask))==FALSE)
								return SNMP_ERR_GENERR;
							break;
					}
				}
				break;
				default:
					return SNMP_ERR_GENERR;
			}
		}
		
		IP2Str(szIP, *((uint32_t*)*ppVar));
		*ppVar = szIP;
		*pVarLen = strlen(szIP);
		return ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM);
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessDhcpdIPAddress)
{
			
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{
			char		*szIP = *ppVar;
			uint32_t	ulIP = 0;
			if (NULL!=*ppVar && Str2IP(&ulIP, szIP))
			{
				*pVarLen = sizeof(uint32_t);
				*((uint32_t*)szIP) = ulIP;
				return SNMP_ERR_NOERROR;
			}
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		char dhcp_start_ip[16],dhcp_end_ip[16],lan_ip[16],lan_mask[16],szIP[20];
		in_addr_t ulIP;
		int32_t mode,dhcpd_enabled;
		
		if (4 != *pVarLen)
			return SNMP_ERR_GENERR;
		
		ulIP = *((uint32_t*)*ppVar);
		ConfigReadInteger(0, MIB_ROUTE_MODE, &mode);
		ConfigReadInteger(0, MIB_DHCPS_DAEMON, &dhcpd_enabled);
		if((mode != BRIDGE_MODE)&&(dhcpd_enabled))
		{
			CONF_READ_STRING(DEV_PORT_BRIDGE,MIB_NET_IP, lan_ip);
			CONF_READ_STRING(DEV_PORT_BRIDGE,MIB_NET_MASK, lan_mask);
			CONF_READ_STRING(DEV_PORT_BRIDGE,MIB_DHCPS_IP_RANGE_START, dhcp_start_ip);
			CONF_READ_STRING(DEV_PORT_BRIDGE,MIB_DHCPS_IP_RANGE_END, dhcp_end_ip);
			
			if(checkIPSubnet(StrSwitchIP(lan_ip),StrSwitchIP(lan_mask),ulIP,StrSwitchIP(lan_mask))==TRUE)
					return SNMP_ERR_GENERR;
			
			switch(pOidInfo->ulMIB)
			{
				case MIB_DHCPS_IP_RANGE_START:
					if(ulIP>StrSwitchIP(dhcp_end_ip))
						return SNMP_ERR_WRONGVALUE;
					break;
				case MIB_DHCPS_IP_RANGE_END:
					if(ulIP<StrSwitchIP(dhcp_start_ip))
						return SNMP_ERR_WRONGVALUE;
					break;
			}
		}
		else
			return SNMP_ERR_GENERR;
		
		IP2Str(szIP, *((uint32_t*)*ppVar));
		*ppVar = szIP;
		*pVarLen = strlen(szIP);
		return ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM);
	}
}

static ZCOM_OID_ACCESS_DEFINE(ZComOidAccessACL)
{
#define	WLAN_ACL_APPEND_INDEX	9999
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{
			if (WLAN_ACL_APPEND_INDEX==pOid[1])
			{
				memset(*ppVar, 0, sizeof(MacAddr_t));
			}
			else
			{
				char	*szAclMAC = strtok(*ppVar, " ");
				
				int32_t	lAclIndex = pOid[1]-1;

				while (NULL!=szAclMAC && lAclIndex-->0)
				{
					szAclMAC = strtok(NULL, " ");
				}
				if (NULL==szAclMAC)
				{
					return SNMP_ERR_GENERR;
				}
				Str2Mac(*ppVar, szAclMAC);
			}
			*pVarLen = sizeof(MacAddr_t);
			return SNMP_ERR_NOERROR;
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		char	szMacNew[20];
		char	szMacOld[20];

		// pOid[0]-1 : wireless interface index
		// pOid[1]-1 : Acl Index
		if (6 != *pVarLen)
		{
			return SNMP_ERR_GENERR;
		}
		Mac2Str(szMacNew, *((MacAddr_t*)*ppVar));

		if (WLAN_ACL_APPEND_INDEX==pOid[1])
		{
			//Append one
			ConfigWriteString(pOid[0]-1, pOidInfo->ulMIB, szMacNew);
			return SNMP_ERR_NOERROR;
		}

		// Get old MacAddress at current location
		*ppVar = NULL;
		*pVarLen = 0;
		if (SNMP_ERR_NOERROR!=ZComOidAccessACL(ZCOM_OID_ACCESS_PARAM))
		{
			return SNMP_ERR_GENERR;
		}

		Mac2Str(szMacOld, *((MacAddr_t*)*ppVar));

		if (0==strcmp(szMacNew, szMacOld))
		{
			// Same as original, nothing to do.
			return SNMP_ERR_NOERROR;
		}

		// Remove old MacAddress
		ConfigRemoveString(pOid[0]-1, pOidInfo->ulMIB, szMacOld);
		if (0!=strcmp(szMacNew, "00:00:00:00:00:00"))
		{
			// append new MacAddress
			ConfigWriteString(pOid[0]-1, pOidInfo->ulMIB, szMacNew);
		}
		return SNMP_ERR_NOERROR;
	}
}

static ZCOM_OID_ACCESS_DEFINE(ZComOidAccessVlanID)
{
	if (NULL==*ppVar
		&& SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM)
		&& NULL!=*ppVar
		)
	{
		VlanParams_t* pVlanEntry = (VlanParams_t *)*ppVar + (pOid[1] - 1);
		*((int32_t*)*ppVar) = pVlanEntry->usVlanID;
		*pVarLen = sizeof(*ppVar);
		return SNMP_ERR_NOERROR;
	}
	else if(NULL!=*ppVar)
	{
		VlanParams_t vlanEntry;
		vlanEntry.lindex = pOid[1];
		if ( 0 != *((int32_t *)*ppVar) )
		{
			vlanEntry.uchPriority = 0;
			vlanEntry.usVlanID = *((int32_t *)*ppVar);
			ConfigWriteStruct(0,MIB_WLAN_VAP_VLAN_PARAM,(uint8_t*)&vlanEntry,sizeof(VlanParams_t));
			return SNMP_ERR_NOERROR;
		}
		else
		{
			if (CONF_RESULT_OK==ConfigExchange(CONF_REQUEST_REMOVE, pOid[0] - 1, MIB_WLAN_VAP_VLAN_PARAM,
				(uint8_t*)&vlanEntry, sizeof(vlanEntry), 0))
			{
				return SNMP_ERR_NOERROR;
			}
		}
	}
	return SNMP_ERR_GENERR;
}

static ZCOM_OID_ACCESS_DEFINE(ZComOidAccessKeyType)
{
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM)){
			switch(*((uint32_t*)*ppVar))
			{
				case WEP_KEY_64HEX:
				case WEP_KEY_64ALPHA:
				case WEP_KEY_64PHRASE:
					*((uint32_t*)*ppVar) = WEP_KEY_64HEX;
					break;
				case WEP_KEY_128HEX:
				case WEP_KEY_128ALPHA:
				case WEP_KEY_128PHRASE:
					*((uint32_t*)*ppVar) = WEP_KEY_128HEX;
					break;
				case WEP_KEY_152HEX:
				case WEP_KEY_152ALPHA:
				case WEP_KEY_152PHRASE:
					//*((uint32_t*)*ppVar) = WEP_KEY_152HEX;
					break;
				default:
					*((uint32_t*)*ppVar) = 0;
			}
			*pVarLen = sizeof(uint32_t);
			return SNMP_ERR_NOERROR;
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		return ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM);
	}
}

static ZCOM_OID_ACCESS_DEFINE(ZComOidAccessVapIndex)
{
	if (NULL==*ppVar
		&& SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM)
		&& NULL!=*ppVar
		)
	{
		*((uint32_t*)*ppVar) = pOid[0];
		*pVarLen = sizeof(uint32_t);
		return SNMP_ERR_NOERROR;
	}
	return SNMP_ERR_GENERR;
}

static ZCOM_OID_ACCESS_DEFINE(ZComOidAccessWlanControl)
{
	if (NULL == *ppVar
		&& SNMP_ERR_NOERROR==ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM)
		&& NULL != *ppVar
		)
	{
		switch (pOidInfo->name[pOidInfo->namelen - 1])
		{
			case 2: // pwWlanChipIndex
				*((uint32_t*)*ppVar) = pOid[0];
				*pVarLen = sizeof(uint32_t);
				return SNMP_ERR_NOERROR;
			default:
				return SNMP_ERR_GENERR;
		}
		return SNMP_ERR_NOERROR;
	}

	return SNMP_ERR_GENERR;
}

static ZCOM_OID_ACCESS_DEFINE(ZComOidRebootAP)
{
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM) && NULL!=*ppVar)
		{
			*((uint32_t*)*ppVar)=0;
			*pVarLen = sizeof(uint32_t);
			return SNMP_ERR_NOERROR;
		}
		else return SNMP_ERR_GENERR;
	}
	else
	{
		if( *((uint32_t*)*ppVar)==0 )
			return SNMP_ERR_NOERROR;
		if( *((uint32_t*)*ppVar)!=1 )
			return SNMP_ERR_GENERR;
		
		*ppVar=NULL;
		ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM);
		*pVarLen = strlen(*ppVar);		
		
		return ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM);
	}
	
	return SNMP_ERR_GENERR;
}

static ZCOM_OID_ACCESS_DEFINE(ZComOidUsage)
{
	if (NULL==*ppVar
		&& SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM)
		&& NULL!=*ppVar
		)
	{
		return SNMP_ERR_NOERROR;
	}
	
	return SNMP_ERR_GENERR;
}

static ZCOM_OID_ACCESS_DEFINE(ZComOidSNMPUserInfo)
{
	char *space = NULL, idx = pOidInfo->uchIndex, i;
	
	if (idx > SNMPD_START && idx < SNMPD_END)
	{
		pOidInfo->uchIndex = 0;
	}

	if (NULL == *ppVar)
	{
		if (SNMP_ERR_NOERROR!=ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM) || NULL==*ppVar)
		{
			goto _err;
		}
		space = strchr(*ppVar, ' ');
		for(i=1; space!= NULL && i < idx; i++)
		{
			*ppVar = space + 1;
			space = strchr(*ppVar, ' ');
		}
		if (space != NULL)
		{
			*space = '\0';
		}
		switch(pOidInfo->type)
		{
		case ASN_INTEGER:
			i = atoi(*ppVar);
			memcpy(*ppVar, &i, sizeof(i));
			*pVarLen = sizeof(i);
			break;
		case ASN_OCTET_STR:
			*pVarLen = strlen(*ppVar);
			break;
		default:
			;
		}
		pOidInfo->uchIndex = idx;
		return SNMP_ERR_NOERROR;
	}
	else
	{
		char *userInfo = NULL, *fieldPos;	// fieldPos: insert data field postion
		size_t fieldLen = *pVarLen;			// insert data field len
		int tmp_value = (*(int*)(*ppVar)); 
		
		// get user info
		if (SNMP_ERR_NOERROR!=ZComOidAccessGeneric(pOidInfo, &userInfo, pVarLen, pOid, OidLen)
			|| NULL==userInfo)
		{
			goto _err;
		}

		// find the field postion, (field data: new insert data)
		fieldPos = userInfo;
		space = strchr(fieldPos, ' ');
		for(i=SNMPD_START+1; space!= NULL && i < idx; i++)
		{
			fieldPos = space + 1;
			space = strchr(fieldPos, ' ');
		}
		// field data to string
		
		switch(pOidInfo->type)
		{
			case ASN_INTEGER:		
			{
				switch(idx)
				{
					case SNMPD_ACCESS:
						if((tmp_value!=0)&&(tmp_value!=1))
						{
							return SNMP_ERR_WRONGVALUE;
						}
						break;
					case SNMPD_AUTH:
						if((tmp_value!=0)&&(tmp_value!=1)&&(tmp_value!=2))
						{
							return SNMP_ERR_WRONGVALUE;
						}
						break;
					case SNMPD_PRIV:
						if((tmp_value!=0)&&(tmp_value!=1))
						{
							return SNMP_ERR_WRONGVALUE;
						}
						break;
					default:
						break;
				}
			}
			i = (*(int*)(*ppVar))+'0';
			memcpy(*ppVar, &i, sizeof(i));
			fieldLen = sizeof(i);
			break;
			case ASN_OCTET_STR:
			{
				switch(idx)
				{
					case SNMPD_NAME:
						if(fieldLen<1||fieldLen>16)
							return SNMP_ERR_WRONGLENGTH;
						break;
					case SNMPD_PASSWORD:
						if(fieldLen<8||fieldLen>64)
							return SNMP_ERR_WRONGLENGTH;
						break;
					default:
						break;
				}
			}
			break;
		default:
			;
		}
		// re-arrange the data which after the inserting field
		if (space != NULL)
		{
			if (fieldLen < space - fieldPos)			// move forward
			{
				for(i=0; i<*pVarLen-(space-userInfo); i++)
					fieldPos[fieldLen+i] = space[i];
			}
			else if (fieldLen > space - fieldPos)		// move backward
			{
				for(i=*pVarLen-(space-userInfo); i>0; i--)
				{
					fieldPos[fieldLen+i] = space[i];
				}
			}
			*pVarLen = *pVarLen - (space - fieldPos) + fieldLen;
			fieldPos[fieldLen] = ' ';
		}
		else
		{
			*pVarLen = fieldPos - userInfo + fieldLen;
		}
		// insert the field data
		memmove((char*)fieldPos, (char*)*ppVar, fieldLen);
		// set user info
		i = ZComOidAccessGeneric(pOidInfo, &userInfo, pVarLen, pOid, OidLen);
		pOidInfo->uchIndex = idx;
		return i;
	}
_err:
	pOidInfo->uchIndex = idx;
	return SNMP_ERR_GENERR;
}
static const ExchangeFieldInfo_t* GetFieldInfo(
	const uint8_t	uchIndex,
	const uint32_t	ulMIB
	)
{
	static uint32_t Buf[MAX_EXCHANGE_SIZE/sizeof(uint32_t)];
	static ExchangeFieldInfo_t *pFieldInfo = (ExchangeFieldInfo_t *)Buf;
	if (CONF_RESULT_OK!=ConfigRequestFieldInfo(uchIndex, ulMIB, (uint8_t*)pFieldInfo, sizeof(Buf)))
	{
		printf("%s: GetFieldInfo Fail idx=%d, MIB=%d  (MIB_FIRMWARE_VERSION=%d)!\n", __FUNCTION__, uchIndex, ulMIB, MIB_FIRMWARE_VERSION);
		pFieldInfo->ulFieldType = CONF_FIELD_UNKNOWN;
	}
	return pFieldInfo;
}

//added for Timezone list and NtpServerip1 by huang 2010-03-16
typedef struct stringEntry_t {
	const char *cszStringDescrip;
	const char *stringValue;
} stringEntry_t;

stringEntry_t timeZoneTable[] =
	{
		{"(GMT-12:00)Eniwetok, Kwajalein","12 1"},
		{"(GMT-11:00)Midway Island, Samoa","11 1"},
		{"(GMT-10:00)Hawaii", "10 1"},
		{"(GMT-09:00)Alaska", "9 1"},
		{"(GMT-08:00)Pacific Time (US & Canada); Tijuana", "8 1"},
		{"(GMT-07:00)Arizona", "7 1"},
		{"(GMT-07:00)Mountain Time (US & Canada)", "7 2"},
		{"(GMT-06:00)Central Time (US & Canada)", "6 1"},
		{"(GMT-06:00)Mexico City, Tegucigalpa", "6 2"},
		{"(GMT-06:00)Saskatchewan", "6 3"},
		{"(GMT-05:00)Bogota, Lima, Quito", "5 1"},
		{"(GMT-05:00)Eastern Time (US & Canada)", "5 2"},
		{"(GMT-05:00)Indiana (East)", "5 3"},
		{"(GMT-04:00)Atlantic Time (Canada)", "4 1"},
		{"(GMT-04:00)Caracas, La Paz", "4 2"},
		{"(GMT-04:00)Santiago", "4 3"},
		{"(GMT-03:30)Newfoundland", "3:30 1"},
		{"(GMT-03:00)Brasilia", "3 2"},
		{"(GMT-03:00)Buenos Aires, Georgetown", "3 3"},
		{"(GMT-02:00)Mid-Atlantic", "2 1"},
		{"(GMT-01:00)Azores, Cape Verde Is.", "1 1"},
		{"(GMT)Casablanca, Monrovia", "0 1"},
		{"(GMT)Greenwich Mean Time: Dublin, Edinburgh, Lisbon, London", "0 2"},
		{"(GMT+01:00)Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna", "-1 1"},
		{"(GMT+01:00)Belgrade, Bratislava, Budapest, Ljubljana, Prague", "-1 2"},
		{"(GMT+01:00)Barcelona, Madrid", "-1 3"},
		{"(GMT+01:00)Brussels, Copenhagen, Madrid, Paris, Vilnius", "-1 4"},
		{"(GMT+01:00)Paris", "-1 5"},
		{"(GMT+01:00)Sarajevo, Skopje, Sofia, Warsaw, Zagreb", "-1 6"},
		{"(GMT+02:00)Athens, Istanbul, Minsk", "-2 1"},
		{"(GMT+02:00)Bucharest", "-2 2"},
		{"(GMT+02:00)Cairo", "-2 3"},
		{"(GMT+02:00)Harare, Pretoria", "-2 4"},
		{"(GMT+02:00)Helsinki, Riga, Tallinn", "-2 5"},
		{"(GMT+02:00)Jerusalem", "-2 6"},
		{"(GMT+03:00)Baghdad, Kuwait, Riyadh", "-3 1"},
		{"(GMT+03:00)Moscow, St. Petersburg, Volgograd", "-3 2"},
		{"(GMT+03:00)Nairobi", "-3 3"},
		{"(GMT+03:30)Tehran", "-3:30 4"},
		{"(GMT+04:00)Abu Dhabi, Muscat", "-4 1"},
		{"(GMT+04:00)Baku, Tbilisi", "-4 2"},
		{"(GMT+04:30)Kabul", "-4:30 3"},
		{"(GMT+05:00)Ekaterinburg", "-5 1"},
		{"(GMT+05:00)Islamabad, Karachi, Tashkent", "-5 2"},
		{"(GMT+05:30)Bombay, Calcutta, Madras, New Delhi", "-5:30 3"},
		{"(GMT+06:00)Astana, Almaty, Dhaka", "-6 1"},
		{"(GMT+06:00)Colombo", "-6 2"},
		{"(GMT+07:00)Bangkok, Hanoi, Jakarta", "-7 1"},
		{"(GMT+08:00)Beijing, Chongqing, Hong Kong, Urumchi", "-8 1"},
		{"(GMT+08:00)Perth", "-8 2"},
		{"(GMT+08:00)Singapore", "-8 3"},
		{"(GMT+08:00)Taipei", "-8 4"},
		{"(GMT+09:00)Osaka, Sapporo, Tokyo", "-9 1"},
		{"(GMT+09:00)Seoul", "-9 2"},
		{"(GMT+09:00)Yakutsk", "-9 3"},
		{"(GMT+09:30)Adelaide", "-9:30 4"},
		{"(GMT+09:30)Darwin", "-9:30 5"},
		{"(GMT+10:00)Brisbane", "-10 1"},
		{"(GMT+10:00)Canberra, Melbourne, Sydney", "-10 2"},
		{"(GMT+10:00)Guam, Port Moresby", "-10 3"},
		{"(GMT+10:00)Hobart", "-10 4"},
		{"(GMT+10:00)Vladivostok", "-10 5"},
		{"(GMT+11:00)Magana, Solomon Is., New Caledonia", "-11 1"},
		{"(GMT+12:00)Auckland, Wellington", "-12 1"},
		{"(GMT+12:00)Fiji, Kamchatka, Marshall Is.", "-12 2"}
	};

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessTimezone)
{
	int num_id, add_id;
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{	
			//char buffer[50]={0};
			//char szStr[50]={0};
			//CONF_READ_STRING0(pOidInfo->ulMIB, szStr);
			//strcpy(*ppVar, szStr);
			//*pVarLen = strlen(*ppVar);
			return SNMP_ERR_NOERROR;
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		if (*pVarLen>10 || *pVarLen<0)
		{
			return SNMP_ERR_WRONGLENGTH;
		}
		for(num_id=0;num_id<sizeof(timeZoneTable)/sizeof(stringEntry_t);num_id++)
		{
			if(strlen(timeZoneTable[num_id].stringValue)!=*pVarLen)
				continue;
			if(0!=strncasecmp(*ppVar, timeZoneTable[num_id].stringValue, strlen(timeZoneTable[num_id].stringValue)))
				continue;
			else
			{
				if(ConfigWriteString(0, pOidInfo->ulMIB, *ppVar)==CONF_RESULT_OK)
					return SNMP_ERR_NOERROR;
				else
					return SNMP_ERR_GENERR;
			}
		}
		return SNMP_ERR_WRONGVALUE;
		
	}
}

stringEntry_t timeIp1Table[] =
{
	{"192.5.41.41    - North America", "192.5.41.41"},
	{"192.5.41.209   - North America", "192.5.41.209"},
	{"208.184.49.9   - North America", "208.184.49.9"},
	{"131.188.3.220  - Europe", "131.188.3.220"},
	{"130.149.17.8   - Europe", "130.149.17.8"},
	{"203.60.1.2  - Australia", "203.60.1.2"},
	{"203.117.180.36 - Asia Pacific", "203.117.180.36"}
};

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessNtpServerIP1)
{
	int num_id, add_id;
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{
			char		*szIP = *ppVar;
			uint32_t	ulIP = 0;
			if (NULL!=*ppVar && Str2IP(&ulIP, szIP))
			{
				*pVarLen = sizeof(uint32_t);
				*((uint32_t*)szIP) = ulIP;
				return SNMP_ERR_NOERROR;
			}
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		char szIP[20];
		if (4 != *pVarLen)
			return SNMP_ERR_WRONGLENGTH;
		IP2Str(szIP, *((uint32_t*)*ppVar));
		for(num_id=0;num_id<sizeof(timeIp1Table)/sizeof(stringEntry_t);num_id++)
		{
			if(strlen(timeIp1Table[num_id].stringValue)!=strlen(szIP))
				continue;
			if(0!=strncasecmp(szIP, timeIp1Table[num_id].stringValue, strlen(timeIp1Table[num_id].stringValue)))
				continue;
			else
			{
				if(ConfigWriteString(0, pOidInfo->ulMIB, szIP)==CONF_RESULT_OK)
					return SNMP_ERR_NOERROR;
				else
					return SNMP_ERR_GENERR;
			}
		}
		return SNMP_ERR_WRONGVALUE;
		
	}
}

//added for acl by huang 2010-07-06

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessAclAdd)
{
	ACL_t entry;
	uint8_t *mac;
	char szStr[10]={0};
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{	
			memset(szStr,0xff,sizeof(szStr));
			strcpy(*ppVar, szStr);
			*pVarLen = sizeof(MacAddr_t);
			return SNMP_ERR_NOERROR;
		}
		else
			return SNMP_ERR_GENERR;
	}
	else
	{	
		char	szMacAddress[20];
		if (6 != *pVarLen)
		{
			return SNMP_ERR_GENERR;
		}
		Mac2Str(szMacAddress, *((MacAddr_t*)*ppVar));
		int i,j=0;
		for (i=0;i<17;i++){
			if ((i+1)%3 == 0) continue;
			if (szMacAddress[i]=='0') j++;
		}
		if (j>=12) return SNMP_ERR_GENERR;
		mac =  *ppVar;
		entry.selectid = 0;
		memcpy(entry.macFilter,mac,sizeof(entry.macFilter));
		if(ConfigWriteStruct(0, pOidInfo->ulMIB, (uint8_t *)&entry,sizeof(entry))==CONF_RESULT_OK)
			return SNMP_ERR_NOERROR;
		else
			return SNMP_ERR_GENERR;
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessAcldel)
{
	uint8_t mac[6];
	char entry_buf[1600] = {0},*entry;
	unsigned int index = 0,num = 0;
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{
			(*(int*)(*ppVar)) = 0;
			return SNMP_ERR_NOERROR;
		}
		else
			return SNMP_ERR_GENERR;
	}
	else
	{	
		index = (*(int*)(*ppVar)); 
		if(index>32)
		{
			return SNMP_ERR_GENERR;
		}
		
		if(index == 0)
			ConfigWriteInteger(0, MIB_WLAN_ACL_DELALL, 0);
		else
		{
			CONF_READ_STRING(0, MIB_WLAN_ACL_ALLOW_LIST, entry_buf);
			num = entry_buf[0];
			if(index>num)
				return SNMP_ERR_GENERR;
			
			entry = entry_buf+(index-1) * sizeof(mac) + 1;
			memcpy(mac,entry,sizeof(mac));

			ConfigWriteStruct(0, MIB_WLAN_ACL_DEL, mac,sizeof(mac));
		}
		return SNMP_ERR_NOERROR;
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessAclMac)
{
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{	
			char entry_buf[1600] = {0},*entry = (char*)*ppVar;;
			int32_t	ulIndex = pOid[0]-1,ulRuleNum;
			
			ulRuleNum = entry[0];
			if(ulRuleNum>32)
				return SNMP_ERR_GENERR;
				
			if(pOid[0]>ulRuleNum)
				return SNMP_ERR_GENERR;

			entry = entry + ulIndex * sizeof(MacAddr_t) + 1;
			memcpy(*ppVar,entry,sizeof(MacAddr_t));
			*pVarLen =sizeof(MacAddr_t);
			return SNMP_ERR_NOERROR;
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		ACL_t entry_tmp;
		int32_t	ulIndex = pOid[0];
		uint8_t *mac;
		
		if (6 != *pVarLen)
		{
			return SNMP_ERR_GENERR;
		}

		mac =  *ppVar;
		entry_tmp.selectid = ulIndex;
		memcpy(entry_tmp.macFilter,mac,sizeof(entry_tmp.macFilter));
		if(ConfigWriteStruct(0, pOidInfo->ulMIB, (uint8_t *)&entry_tmp,sizeof(entry_tmp))==CONF_RESULT_OK)
			return SNMP_ERR_NOERROR;
		else
			return SNMP_ERR_GENERR;
	}
}
//added for firewall by huang 2010-01-27

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessIpFilterAdd)
{
	
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
			return SNMP_ERR_NOERROR;
		else
			return SNMP_ERR_GENERR;
	}
	else
	{	
		if (*pVarLen>100 || *pVarLen<10)
		{
			return SNMP_ERR_WRONGLENGTH;
		}
		
		if(ConfigWriteString(0, pOidInfo->ulMIB, *ppVar)==CONF_RESULT_OK)
			return SNMP_ERR_NOERROR;
		else
			return SNMP_ERR_GENERR;
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessIpFilterIp)
{
	//console_printf("huang>>>> OidLen=%d,pOid[1]=%d,pOid[0]=%d,%s(len=%d)\n",OidLen,pOid[0],pOid[0],*ppVar,*pVarLen);
	int  add_id,data_id;
	switch(pOidInfo->ulMIB)
	{
		case MIB_IPFILTER_NUM:
			add_id = MIB_IPFILTER_ADD;
			data_id = MIB_IPFILTER;
			break;
		case MIB_DSTIPFILTER_NUM:
			add_id = MIB_DSTIPFILTER_ADD;
			data_id = MIB_DSTIPFILTER;
			break;
		default:
			break;
	}
	
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{	
			int32_t	ulIndex = pOid[0]-1,ulRuleNum;
			IpFilter_t *pIpFilterList;
			char entry_buf[1024]={0};
			
			ConfigReadInteger(0, pOidInfo->ulMIB, &ulRuleNum);
			if(pOid[0]>ulRuleNum)
				return SNMP_ERR_GENERR;
			ConfigReadStruct(0, data_id, (uint8_t *)&entry_buf,sizeof(IpFilter_t)*ulRuleNum);
			pIpFilterList = (IpFilter_t *)&entry_buf;
			pIpFilterList+=ulIndex;
			*pVarLen = sizeof(uint32_t);
			(*(uint32_t*)(*ppVar)) = pIpFilterList->inIpFilter;
			return SNMP_ERR_NOERROR;
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		int32_t	ulIndex = pOid[0],ulRuleNum,val;
		IpFilterAccess_t ipFilterEntry;
		IpFilter_t *p=NULL;
		char buffer[20]={0},szIP[20] = {0},entry_buf[1024] = {0};
		
		if (4 != *pVarLen)
			return SNMP_ERR_GENERR;

		IP2Str(szIP, *((uint32_t*)*ppVar));
		memset(&ipFilterEntry, '\0', sizeof(ipFilterEntry));
		ConfigReadInteger(0, pOidInfo->ulMIB, &ulRuleNum);
		if(ulIndex>ulRuleNum)
			return SNMP_ERR_GENERR;

		CONF_READ_STRING(DEV_PORT_BRIDGE, MIB_NET_IP, buffer);
		if(strcmp(szIP,buffer)==0)
			return SNMP_ERR_WRONGVALUE;
		ConfigReadInteger(DEV_PORT_WAN, MIB_NET_TYPE, &val);
		if(val == 0)	//network is static ip,then check wanip
		{
			CONF_READ_STRING(DEV_PORT_WAN, MIB_NET_IP, buffer);
			if(strcmp(szIP,buffer)==0)
				return SNMP_ERR_WRONGVALUE;
		}
		
		ConfigReadStruct(0, data_id, (uint8_t *)&entry_buf,sizeof(IpFilter_t)*ulRuleNum);
		p = (IpFilter_t *)&entry_buf + (ulIndex-1);
		memcpy(&ipFilterEntry,p,sizeof(IpFilter_t));
		ipFilterEntry.inIpFilter = *((uint32_t*)*ppVar);
		ipFilterEntry.selectid = ulIndex;

		if(ConfigWriteStruct(0, add_id, (uint8_t *)(&ipFilterEntry),sizeof(ipFilterEntry))==CONF_RESULT_OK)
			return SNMP_ERR_NOERROR;
		else
			return SNMP_ERR_GENERR;
	}
}


ZCOM_OID_ACCESS_DEFINE(ZComOidAccessIpFilterComment)
{
	int num_id, add_id;
	switch(pOidInfo->ulMIB)
	{
		case MIB_IPFILTER:
			num_id = MIB_IPFILTER_NUM;
			add_id = MIB_IPFILTER_ADD;
			break;
		case MIB_DSTIPFILTER:
			num_id = MIB_DSTIPFILTER_NUM;
			add_id = MIB_DSTIPFILTER_ADD;
			break;
		default:
			break;
	}
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{	
			int32_t	ulIndex = pOid[0]-1,ulRuleNum;
			IpFilter_t *pIpFilterList = (IpFilter_t *)*ppVar;
			char szStr[105]={0},szIp[32]={0};
			
			ConfigReadInteger(0, num_id, &ulRuleNum);
			
			if(pOid[0]>ulRuleNum)
				return SNMP_ERR_GENERR;
			pIpFilterList+=ulIndex;
			sprintf(szStr, "%s",pIpFilterList->szComment);
			
			strcpy(*ppVar, szStr);
			*pVarLen = strlen(*ppVar);
			
			return SNMP_ERR_NOERROR;
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		int32_t	ulIndex = pOid[0],ulRuleNum;
		IpFilterAccess_t ipFilterEntry;
		IpFilter_t *p;
		char	entry_buf[1024] = {0};

		if (*pVarLen>20 || *pVarLen<0)
		{
			return SNMP_ERR_WRONGLENGTH;
		}
		
		memset(&ipFilterEntry, '\0', sizeof(ipFilterEntry));
		
		ConfigReadInteger(0, num_id, &ulRuleNum);
		if(ulIndex>ulRuleNum)
			return SNMP_ERR_GENERR;
		
		ConfigReadStruct(0, pOidInfo->ulMIB, (uint8_t *)&entry_buf,sizeof(IpFilter_t)*ulRuleNum);
		p = (IpFilter_t *)&entry_buf + (ulIndex-1);

		memcpy(&ipFilterEntry,p,sizeof(IpFilter_t));
		strcpy(ipFilterEntry.szComment, *ppVar);
		ipFilterEntry.selectid = ulIndex;

		if(ConfigWriteStruct(0, add_id, (uint8_t *)(&ipFilterEntry),sizeof(ipFilterEntry))==CONF_RESULT_OK)
			return SNMP_ERR_NOERROR;
		else
			return SNMP_ERR_GENERR;
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessFirewallAdd)
{
	
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{
			char szStr[105]={0};
			sprintf(szStr, "%s",*ppVar);
			strcpy(*ppVar, szStr);
			*pVarLen = strlen(*ppVar);
			return SNMP_ERR_NOERROR;
		}
		else
			return SNMP_ERR_GENERR;
	}
	else
	{	
		if (*pVarLen>100 || *pVarLen<10)
		{
			return SNMP_ERR_WRONGLENGTH;
		}
		if(ConfigWriteString(0, pOidInfo->ulMIB, *ppVar)==CONF_RESULT_OK)
			return SNMP_ERR_NOERROR;
		else
			return SNMP_ERR_GENERR;
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessPortFilterSport)
{
	//console_printf("huang>>>> OidLen=%d,pOid[1]=%d,pOid[0]=%d,%s(len=%d)\n",OidLen,pOid[0],pOid[0],*ppVar,*pVarLen);
	int add_id,data_id;
	switch(pOidInfo->ulMIB)
	{
		case MIB_SRC_PORTFILTER_NUM:
			add_id = MIB_SRC_PORTFILTER_ADD;
			data_id = MIB_SRC_PORTFILTER;
			break;
		case MIB_PORTFILTER_NUM:
			add_id = MIB_PORTFILTER_ADD;
			data_id = MIB_PORTFILTER;
			break;
		default:
			break;
	}
	
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{	
			int32_t	ulIndex = pOid[0]-1,ulRuleNum;
			PortFilter_t *pPortFilterList ;
			char szStr[105]={0},szPort[10]={0},entry_buf[1024]={0};
			
			ConfigReadInteger(0, pOidInfo->ulMIB, &ulRuleNum);
			if(pOid[0]>ulRuleNum)
				return SNMP_ERR_GENERR;
			
			ConfigReadStruct(0, data_id, (uint8_t *)&entry_buf,sizeof(PortFilter_t)*ulRuleNum);
			pPortFilterList = (PortFilter_t *)&entry_buf;
			pPortFilterList+=ulIndex;
			(*(int*)(*ppVar)) = pPortFilterList->usFromPort;
			*pVarLen = sizeof(int);
			return SNMP_ERR_NOERROR;
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		int32_t	ulIndex = pOid[0],ulRuleNum;
		PortFilterAccess_t portFilterEntry;
		PortFilter_t *p;
		char	entry_buf[1024] = {0};

		memset(&portFilterEntry, '\0', sizeof(portFilterEntry));
		
		ConfigReadInteger(0, pOidInfo->ulMIB, &ulRuleNum);
		if(ulIndex>ulRuleNum)
			return SNMP_ERR_GENERR;
		
		ConfigReadStruct(0, data_id, (uint8_t *)&entry_buf,sizeof(PortFilter_t)*ulRuleNum);
		p = (PortFilter_t *)&entry_buf + (ulIndex-1);
		memcpy(&portFilterEntry,p,sizeof(PortFilter_t));
		
		portFilterEntry.usFromPort = (*(int*)(*ppVar));
		if(portFilterEntry.usFromPort>0)
		{
			if((portFilterEntry.usFromPort<=65535)&&(portFilterEntry.usFromPort<=portFilterEntry.usToPort))
				portFilterEntry.selectid = ulIndex;
			else
				return SNMP_ERR_WRONGVALUE;
		}
		else
			return SNMP_ERR_WRONGVALUE;
		
		if(ConfigWriteStruct(0, add_id, (uint8_t *)(&portFilterEntry),sizeof(portFilterEntry))==CONF_RESULT_OK)
			return SNMP_ERR_NOERROR;
		else
			return SNMP_ERR_GENERR;
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessPortFilterEport)
{
	//console_printf("huang>>>> OidLen=%d,pOid[1]=%d,pOid[0]=%d,%s(len=%d)\n",OidLen,pOid[0],pOid[0],*ppVar,*pVarLen);
	int add_id,data_id;
	switch(pOidInfo->ulMIB)
	{
		case MIB_SRC_PORTFILTER_NUM:
			add_id = MIB_SRC_PORTFILTER_ADD;
			data_id = MIB_SRC_PORTFILTER;
			break;
		case MIB_PORTFILTER_NUM:
			add_id = MIB_PORTFILTER_ADD;
			data_id = MIB_PORTFILTER;
			break;
		default:
			break;
	}
	
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{	
			int32_t	ulIndex = pOid[0]-1,ulRuleNum;
			PortFilter_t *pPortFilterList ;
			char szStr[105]={0},szPort[10]={0},entry_buf[1024]={0};
			
			ConfigReadInteger(0, pOidInfo->ulMIB, &ulRuleNum);
			if(pOid[0]>ulRuleNum)
				return SNMP_ERR_GENERR;
			
			ConfigReadStruct(0, data_id, (uint8_t *)&entry_buf,sizeof(PortFilter_t)*ulRuleNum);
			pPortFilterList = (PortFilter_t *)&entry_buf;
			pPortFilterList+=ulIndex;
			(*(int*)(*ppVar)) = pPortFilterList->usToPort;
			*pVarLen = sizeof(int);
			return SNMP_ERR_NOERROR;
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		int32_t	ulIndex = pOid[0],ulRuleNum;
		PortFilterAccess_t portFilterEntry;
		PortFilter_t *p;
		char	entry_buf[1024] = {0};

		memset(&portFilterEntry, '\0', sizeof(portFilterEntry));
		
		ConfigReadInteger(0, pOidInfo->ulMIB, &ulRuleNum);
		if(ulIndex>ulRuleNum)
			return SNMP_ERR_GENERR;
		
		ConfigReadStruct(0, data_id, (uint8_t *)&entry_buf,sizeof(PortFilter_t)*ulRuleNum);
		p = (PortFilter_t *)&entry_buf + (ulIndex-1);
		memcpy(&portFilterEntry,p,sizeof(PortFilter_t));
		
		portFilterEntry.usToPort = (*(int*)(*ppVar));
		if(portFilterEntry.usToPort>0)
		{
			if((portFilterEntry.usToPort<=65535)&&(portFilterEntry.usFromPort<=portFilterEntry.usToPort))
				portFilterEntry.selectid = ulIndex;
			else
				return SNMP_ERR_WRONGVALUE;
		}
		else
			return SNMP_ERR_WRONGVALUE;
		
		if(ConfigWriteStruct(0, add_id, (uint8_t *)(&portFilterEntry),sizeof(portFilterEntry))==CONF_RESULT_OK)
			return SNMP_ERR_NOERROR;
		else
			return SNMP_ERR_GENERR;
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessPortFilterProtocol)
{
	//console_printf("huang>>>> OidLen=%d,pOid[1]=%d,pOid[0]=%d,%s(len=%d)\n",OidLen,pOid[0],pOid[0],*ppVar,*pVarLen);
	int add_id,data_id;
	switch(pOidInfo->ulMIB)
	{
		case MIB_SRC_PORTFILTER_NUM:
			add_id = MIB_SRC_PORTFILTER_ADD;
			data_id = MIB_SRC_PORTFILTER;
			break;
		case MIB_PORTFILTER_NUM:
			add_id = MIB_PORTFILTER_ADD;
			data_id = MIB_PORTFILTER;
			break;
		default:
			break;
	}
	
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{	
			int32_t	ulIndex = pOid[0]-1,ulRuleNum;
			PortFilter_t *pPortFilterList = NULL;
			char szStr[105]={0},szProtocol[10]={0},entry_buf[1024]={0};
			
			ConfigReadInteger(0, pOidInfo->ulMIB, &ulRuleNum);
			if(pOid[0]>ulRuleNum)
				return SNMP_ERR_GENERR;
			ConfigReadStruct(0, data_id, (uint8_t *)&entry_buf,sizeof(PortFilter_t)*ulRuleNum);
			pPortFilterList = (PortFilter_t *)&entry_buf;
			pPortFilterList+=ulIndex;
			(*(int*)(*ppVar)) = pPortFilterList->ucProtocolType;
			*pVarLen = sizeof(int);
			return SNMP_ERR_NOERROR;
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		int32_t	ulIndex = pOid[0],ulRuleNum;
		PortFilterAccess_t portFilterEntry;
		PortFilter_t *p;
		char	entry_buf[1024] = {0};
		
		memset(&portFilterEntry, '\0', sizeof(portFilterEntry));
		
		ConfigReadInteger(0, pOidInfo->ulMIB, &ulRuleNum);
		if(ulIndex>ulRuleNum)
			return SNMP_ERR_GENERR;
		
		ConfigReadStruct(0, data_id, (uint8_t *)&entry_buf,sizeof(PortFilter_t)*ulRuleNum);
		p = (PortFilter_t *)&entry_buf + (ulIndex-1);
		
		memcpy(&portFilterEntry,p,sizeof(PortFilter_t));
		portFilterEntry.ucProtocolType = (*(int*)(*ppVar));
		
		if ((portFilterEntry.ucProtocolType>0)&&(portFilterEntry.ucProtocolType<4))
		{
			portFilterEntry.selectid = ulIndex;
		}
		else
			return SNMP_ERR_WRONGVALUE;

		if(ConfigWriteStruct(0, add_id, (uint8_t *)(&portFilterEntry),sizeof(portFilterEntry))==CONF_RESULT_OK)
			return SNMP_ERR_NOERROR;
		else
			return SNMP_ERR_GENERR;
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessPortFilterComment)
{
	//console_printf("huang>>>> OidLen=%d,pOid[1]=%d,pOid[0]=%d,%s(len=%d)\n",OidLen,pOid[0],pOid[0],*ppVar,*pVarLen);
	int num_id, add_id;
	switch(pOidInfo->ulMIB)
	{
		case MIB_SRC_PORTFILTER:
			num_id = MIB_SRC_PORTFILTER_NUM;
			add_id = MIB_SRC_PORTFILTER_ADD;
			break;
		case MIB_PORTFILTER:
			num_id = MIB_PORTFILTER_NUM;
			add_id = MIB_PORTFILTER_ADD;
			break;
		default:
			break;
	}
	
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{	
			int32_t	ulIndex = pOid[0]-1,ulRuleNum;
			PortFilter_t *pPortFilterList = (PortFilter_t *)*ppVar;
			char szStr[105]={0},szPort[10]={0};
			
			ConfigReadInteger(0, num_id, &ulRuleNum);
			
			if(pOid[0]>ulRuleNum)
				return SNMP_ERR_GENERR;
			pPortFilterList+=ulIndex;
			
			sprintf(szStr, "%s",pPortFilterList->szComment);
			
			strcpy(*ppVar, szStr);
			*pVarLen = strlen(*ppVar);
			return SNMP_ERR_NOERROR;
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		int32_t	ulIndex = pOid[0],ulRuleNum;
		PortFilterAccess_t portFilterEntry;
		PortFilter_t *p;
		char	entry_buf[1024] = {0};
		
		if (*pVarLen>20 || *pVarLen<0)
		{
			return SNMP_ERR_WRONGLENGTH;
		}
		
		memset(&portFilterEntry, '\0', sizeof(portFilterEntry));
		
		ConfigReadInteger(0, num_id, &ulRuleNum);
		if(ulIndex>ulRuleNum)
			return SNMP_ERR_GENERR;
		
		ConfigReadStruct(0, pOidInfo->ulMIB, (uint8_t *)&entry_buf,sizeof(PortFilter_t)*ulRuleNum);
		p = (PortFilter_t *)&entry_buf + (ulIndex-1);

		memcpy(&portFilterEntry,p,sizeof(PortFilter_t));
		strcpy(portFilterEntry.szComment, *ppVar);
		portFilterEntry.selectid = ulIndex;

		if(ConfigWriteStruct(0, add_id, (uint8_t *)(&portFilterEntry),sizeof(portFilterEntry))==CONF_RESULT_OK)
			return SNMP_ERR_NOERROR;
		else
			return SNMP_ERR_GENERR;
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessPortForwardIp)
{	
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{	
			int32_t	ulIndex = pOid[0]-1,ulRuleNum;
			PortForward_t *pPortForwardList = NULL;
			char szStr[105]={0},szIp[32]={0},entry_buf[1024]={0};
			
			ConfigReadInteger(0, pOidInfo->ulMIB, &ulRuleNum);
			ConfigReadStruct(0, MIB_PORTFW, (uint8_t *)&entry_buf,sizeof(PortForward_t)*ulRuleNum);
			pPortForwardList = (PortForward_t *)&entry_buf;
			
			if(pOid[0]>ulRuleNum)
				return SNMP_ERR_GENERR;

			pPortForwardList+=ulIndex;
			*pVarLen = sizeof(uint32_t);
			(*(uint32_t*)(*ppVar)) = pPortForwardList->inPortForwareIp;
			
			return SNMP_ERR_NOERROR;
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		int32_t	ulIndex = pOid[0],ulRuleNum,val;
		PortForwardAccess_t ipPortForwardEntry;
		PortForward_t *p=NULL;
		char buffer[20] = {0},szIP[20] = {0},entry_buf[1024] = {0};

		if (4 != *pVarLen)
			return SNMP_ERR_GENERR;
		
		IP2Str(szIP, *((uint32_t*)*ppVar));
		memset(&ipPortForwardEntry, '\0', sizeof(ipPortForwardEntry));
		ConfigReadInteger(0,  pOidInfo->ulMIB, &ulRuleNum);
		if(ulIndex>ulRuleNum)
			return SNMP_ERR_GENERR;

		CONF_READ_STRING(DEV_PORT_BRIDGE, MIB_NET_IP, buffer);
		if(strcmp(szIP,buffer)==0)
			return SNMP_ERR_WRONGVALUE;
		ConfigReadInteger(DEV_PORT_WAN, MIB_NET_TYPE, &val);
		if(val == 0)
		{
			CONF_READ_STRING(DEV_PORT_WAN, MIB_NET_IP, buffer);
			if(strcmp(szIP,buffer)==0)
				return SNMP_ERR_WRONGVALUE;
		}
		ConfigReadStruct(0, MIB_PORTFW, (uint8_t *)&entry_buf,sizeof(PortForward_t)*ulRuleNum);
		p = (PortForward_t *)&entry_buf + (ulIndex-1);
		memcpy(&ipPortForwardEntry,p,sizeof(PortForward_t));
		ipPortForwardEntry.inPortForwareIp = *((uint32_t*)*ppVar);
		ipPortForwardEntry.selectid = ulIndex;

		if(ConfigWriteStruct(0, MIB_PORTFW_ADD, (uint8_t *)(&ipPortForwardEntry),sizeof(ipPortForwardEntry))==CONF_RESULT_OK)
			return SNMP_ERR_NOERROR;
		else
			return SNMP_ERR_GENERR;
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessPortForwardSport)
{
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{	
			int32_t	ulIndex = pOid[0]-1,ulRuleNum;
			PortForward_t *pPortForwardList = NULL;
			char szStr[105]={0},szPort[10]={0},entry_buf[1024]={0};
			
			ConfigReadInteger(0, pOidInfo->ulMIB, &ulRuleNum);
			if(pOid[0]>ulRuleNum)
				return SNMP_ERR_GENERR;
			ConfigReadStruct(0, MIB_PORTFW, (uint8_t *)&entry_buf,sizeof(PortForward_t)*ulRuleNum);
			pPortForwardList = (PortForward_t *)&entry_buf;
			pPortForwardList+=ulIndex;
			(*(int*)(*ppVar)) = pPortForwardList->usFromPort;
			*pVarLen = sizeof(int);
			
			return SNMP_ERR_NOERROR;
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		int32_t	ulIndex = pOid[0],ulRuleNum;
		PortForwardAccess_t portForwardEntry;
		PortForward_t *p;
		char	entry_buf[1024] = {0};
		
		memset(&portForwardEntry, '\0', sizeof(portForwardEntry));
		
		ConfigReadInteger(0, pOidInfo->ulMIB, &ulRuleNum);
		if(ulIndex>ulRuleNum)
			return SNMP_ERR_GENERR;
		ConfigReadStruct(0, MIB_PORTFW, (uint8_t *)&entry_buf,sizeof(PortForward_t)*ulRuleNum);
		p = (PortForward_t *)&entry_buf + (ulIndex-1);

		memcpy(&portForwardEntry,p,sizeof(PortForward_t));
		portForwardEntry.usFromPort = (*(int*)(*ppVar));
		if(portForwardEntry.usFromPort>0)
		{
			if((portForwardEntry.usFromPort<=65535)&&(portForwardEntry.usFromPort<=portForwardEntry.usToPort))
				portForwardEntry.selectid = ulIndex;
			else
				return SNMP_ERR_WRONGVALUE;
		}
		else
			return SNMP_ERR_WRONGVALUE;

		if(ConfigWriteStruct(0, MIB_PORTFW_ADD, (uint8_t *)(&portForwardEntry),sizeof(portForwardEntry))==CONF_RESULT_OK)
			return SNMP_ERR_NOERROR;
		else
			return SNMP_ERR_GENERR;
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessPortForwardEport)
{
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{	
			int32_t	ulIndex = pOid[0]-1,ulRuleNum;
			PortForward_t *pPortForwardList = NULL;
			char szStr[105]={0},szPort[10]={0},entry_buf[1024]={0};
			
			ConfigReadInteger(0, pOidInfo->ulMIB, &ulRuleNum);
			if(pOid[0]>ulRuleNum)
				return SNMP_ERR_GENERR;
			ConfigReadStruct(0, MIB_PORTFW, (uint8_t *)&entry_buf,sizeof(PortForward_t)*ulRuleNum);
			pPortForwardList = (PortForward_t *)&entry_buf;
			pPortForwardList+=ulIndex;
			(*(int*)(*ppVar)) = pPortForwardList->usToPort;
			*pVarLen = sizeof(int);
			
			return SNMP_ERR_NOERROR;
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		int32_t	ulIndex = pOid[0],ulRuleNum;
		PortForwardAccess_t portForwardEntry;
		PortForward_t *p;
		char	entry_buf[1024] = {0};
		
		memset(&portForwardEntry, '\0', sizeof(portForwardEntry));
		
		ConfigReadInteger(0,  pOidInfo->ulMIB, &ulRuleNum);
		if(ulIndex>ulRuleNum)
			return SNMP_ERR_GENERR;
		ConfigReadStruct(0, MIB_PORTFW, (uint8_t *)&entry_buf,sizeof(PortForward_t)*ulRuleNum);
		p = (PortForward_t *)&entry_buf + (ulIndex-1);

		memcpy(&portForwardEntry,p,sizeof(PortForward_t));
		portForwardEntry.usToPort = (*(int*)(*ppVar));
		if(portForwardEntry.usToPort>0)
		{
			if((portForwardEntry.usToPort<=65535)&&(portForwardEntry.usFromPort<=portForwardEntry.usToPort))
				portForwardEntry.selectid = ulIndex;
			else
				return SNMP_ERR_WRONGVALUE;
		}
		else
			return SNMP_ERR_WRONGVALUE;

		if(ConfigWriteStruct(0, MIB_PORTFW_ADD, (uint8_t *)(&portForwardEntry),sizeof(portForwardEntry))==CONF_RESULT_OK)
			return SNMP_ERR_NOERROR;
		else
			return SNMP_ERR_GENERR;
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessPortForwardProtocol)
{

	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{	
			int32_t	ulIndex = pOid[0]-1,ulRuleNum;
			PortForward_t *pPortForwardList = NULL;
			char szStr[105]={0},szProtocol[10]={0},entry_buf[1024]={0};
			
			ConfigReadInteger(0, pOidInfo->ulMIB, &ulRuleNum);
			if(pOid[0]>ulRuleNum)
				return SNMP_ERR_GENERR;
			
			ConfigReadStruct(0, MIB_PORTFW, (uint8_t *)&entry_buf,sizeof(PortForward_t)*ulRuleNum);
			pPortForwardList = (PortForward_t *)&entry_buf;
			pPortForwardList+=ulIndex;
			(*(int*)(*ppVar)) = pPortForwardList->ucProtocolType;
			*pVarLen = sizeof(int);
			
			return SNMP_ERR_NOERROR;
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		int32_t	ulIndex = pOid[0],ulRuleNum;
		PortForwardAccess_t portForwardEntry;
		PortForward_t *p;
		char	entry_buf[1024] = {0};
		
		memset(&portForwardEntry, '\0', sizeof(portForwardEntry));
		
		ConfigReadInteger(0, pOidInfo->ulMIB, &ulRuleNum);
		if(ulIndex>ulRuleNum)
			return SNMP_ERR_GENERR;
		ConfigReadStruct(0, MIB_PORTFW, (uint8_t *)&entry_buf,sizeof(PortForward_t)*ulRuleNum);
		p = (PortForward_t *)&entry_buf + (ulIndex-1);
		
		memcpy(&portForwardEntry,p,sizeof(PortForward_t));
		portForwardEntry.ucProtocolType = (*(int*)(*ppVar));
		
		if ((portForwardEntry.ucProtocolType>0)&&(portForwardEntry.ucProtocolType<4))
		{
			portForwardEntry.selectid = ulIndex;
		}
		else
			return SNMP_ERR_WRONGVALUE;

		if(ConfigWriteStruct(0, MIB_PORTFW_ADD, (uint8_t *)(&portForwardEntry),sizeof(portForwardEntry))==CONF_RESULT_OK)
			return SNMP_ERR_NOERROR;
		else
			return SNMP_ERR_GENERR;
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessPortForwardComment)
{
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{	
			int32_t	ulIndex = pOid[0]-1,ulRuleNum;
			PortForward_t *pPortForwardList = (PortForward_t *)*ppVar;
			char szStr[105]={0},szPort[10]={0};
			
			ConfigReadInteger(0, MIB_PORTFW_NUM, &ulRuleNum);
			
			if(pOid[0]>ulRuleNum)
				return SNMP_ERR_GENERR;
			pPortForwardList+=ulIndex;
			
			sprintf(szStr, "%s",pPortForwardList->szComment);
			
			strcpy(*ppVar, szStr);
			*pVarLen = strlen(*ppVar);
			return SNMP_ERR_NOERROR;
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		int32_t	ulIndex = pOid[0],ulRuleNum;
		PortForwardAccess_t portForwardEntry;
		PortForward_t *p;
		char	entry_buf[1024] = {0};
		
		if (*pVarLen>20 || *pVarLen<0)
		{
			return SNMP_ERR_WRONGLENGTH;
		}
		
		memset(&portForwardEntry, '\0', sizeof(portForwardEntry));
		
		ConfigReadInteger(0, MIB_PORTFW_NUM, &ulRuleNum);
		if(ulIndex>ulRuleNum)
			return SNMP_ERR_GENERR;
		
		ConfigReadStruct(0, pOidInfo->ulMIB, (uint8_t *)&entry_buf,sizeof(PortForward_t)*ulRuleNum);
		p = (PortForward_t *)&entry_buf + (ulIndex-1);

		memcpy(&portForwardEntry,p,sizeof(PortForward_t));
		strcpy(portForwardEntry.szComment, *ppVar);
		portForwardEntry.selectid = ulIndex;

		if(ConfigWriteStruct(0, MIB_PORTFW_ADD, (uint8_t *)(&portForwardEntry),sizeof(portForwardEntry))==CONF_RESULT_OK)
			return SNMP_ERR_NOERROR;
		else
			return SNMP_ERR_GENERR;
	}
}
//added for firewall by huang 2010-01-27 end


static ZCOM_OID_ACCESS_DEFINE(ZComOidStatistics)
{
	uint8_t uchIndex = pOidInfo->uchIndex;
	uint32_t ulValue = 0;
	NetDeviceStats_t *stats = NULL;

	if (NULL != *ppVar)
	{
		goto _err;
	}

	switch (uchIndex & NET_STAT_INTERFACE_MASK)
	{
	case NET_STAT_WIRELESS:
		pOidInfo->uchIndex = 0;
		break;
	case NET_STAT_ETHERNET1:
		pOidInfo->uchIndex = 1;
		break;
	case NET_STAT_ETHERNET2:
		{
			uint32_t ulNum = 0;

			ConfigReadInteger(0, MIB_SPEC_ETHERNET_NUM, &ulNum);
			if (ulNum < 2)
				goto _err;
		}
		break;
	default:
		goto _err;
	}

	if (SNMP_ERR_NOERROR!=ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM) || NULL==*ppVar)
	{
		goto _err;
	}

	stats = (NetDeviceStats_t *)*ppVar;
	switch (uchIndex & NET_STAT_TYPE_MASK)
	{
	case NET_STAT_TX_UNICAST:
		ulValue = stats->Tx.ullPacketsUnicast;
		break;
	case NET_STAT_RX_UNICAST:
		ulValue = stats->Rx.ullPacketsUnicast;
		break;
	case NET_STAT_TX_BROADCAST:
		ulValue = stats->Tx.ullPacketsBroadcast;
		break;
	case NET_STAT_RX_BROADCAST:
		ulValue = stats->Rx.ullPacketsBroadcast;
		break;
	case NET_STAT_TX_MULTICAST:
		ulValue = stats->Tx.ullPacketsMulticast;
		break;
	case NET_STAT_RX_MULTICAST:
		ulValue = stats->Rx.ullPacketsMulticast;
		break;
	case NET_STAT_TX_TOTALPKT:
		ulValue = stats->Tx.ullPacketsTotal;
		break;
	case NET_STAT_RX_TOTALPKT:
		ulValue = stats->Rx.ullPacketsTotal;
		break;
	case NET_STAT_TX_TOTALBYTES:
		ulValue = stats->Tx.ullBytes;
		break;
	case NET_STAT_RX_TOTALBYTES:
		ulValue = stats->Rx.ullBytes;
		break;
	}
	memcpy(*ppVar, &ulValue, sizeof(ulValue));
	*pVarLen = sizeof(ulValue);
	pOidInfo->uchIndex = uchIndex;
	return SNMP_ERR_NOERROR;

_err:
	pOidInfo->uchIndex = uchIndex;
	return SNMP_ERR_GENERR;
}


//wind  Լӵ
static ZCOM_OID_ACCESS_DEFINE(ZComOidAccessUpgradeFwState)
{
	int  fd;
	int  ulState = FIRMWARE_STATE_UNKNOWN;

	fd = open(FIRMWARE_STATE_FILE, O_RDONLY);
	if(-1 == fd)
	{
		printf("fail to open cli_talk \n");
	}
	else
	{
		char szbuf[8];

		read(fd, szbuf, sizeof(szbuf));
		ulState = atoi(szbuf);
		close(fd);
	}

	if (NULL==*ppVar)    //SNMP ִGET ɵĶֵ״̬ļ ֵ
	{
		*ppVar=&ulState;
		*pVarLen = sizeof(ulState);
		return SNMP_ERR_NOERROR;
	}
	return SNMP_ERR_GENERR;
}

