//	wag302lib.c
//   
//if define SYS_MSG, so use MSG (0:block  1:delay) ,or use SOCKET.   
#define SYSV_MSG  0


#include <stdio.h>
#include <stdlib.h>

#ifdef	WIN32

#define WIN32_LEAN_AND_MEAN
#include <winsock2.h>

#else//Linux

#include <unistd.h>		// for close
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#ifdef  SYSV_MSG
#include <sys/ipc.h>    
#include <sys/msg.h>
#include <sys/stat.h>
#include <unistd.h> 

#define KEY_REQ  60000
#define KEY_RESP  60001

#ifndef	INVALID_MSG
#define	INVALID_MSG	 -1
#endif  //!INVALID_MSG

typedef	int	MSG;
static MSG Msg_Request = INVALID_MSG;
static MSG Msg_Respond = INVALID_MSG;
#endif  //!MSG

// Compatible with window socket 2
typedef	int	SOCKET;

#define	closesocket	close

#ifndef	INVALID_SOCKET
#define	INVALID_SOCKET	-1
#endif//!INVALID_SOCKET

#endif//!WIN32

#include "wag302client.h"
#include "wag302server.h"
#include <errno.h>

#define	PERROR	printf("%s:%d ", GetProcessName(), __LINE__); printf
//#define	PERROR(f...)

///////////////////////////////////////////////////////////////////////////////
//	IPC setting routine
///////////////////////////////////////////////////////////////////////////////
#ifdef SYSV_MSG
typedef struct  
 {
    long MsgType;      /* message type, must be > 0 */
    uint8_t MsgText[MAX_EXCHANGE_SIZE];  /* message data */
 }MsgBuf;
static  MsgBuf  MsgBuf_Req ;   //= {0,0,0,0,CONFIG_VERSION};
static  MsgBuf  MsgBuf_Resp;  // = {0,0,0,0,CONFIG_VERSION};
static  ExchangeHdr_t *s_pReqHdr	= (ExchangeHdr_t *)MsgBuf_Req.MsgText;
static  ExchangeHdr_t *s_pRespHdr= (ExchangeHdr_t *)MsgBuf_Resp.MsgText;
#else
static uint8_t	s_Request[MAX_EXCHANGE_SIZE]	= {CONFIG_VERSION};
static uint8_t	s_Response[MAX_EXCHANGE_SIZE] = {CONFIG_VERSION};

static ExchangeHdr_t *s_pReqHdr	= (ExchangeHdr_t *)s_Request;
static ExchangeHdr_t *s_pRespHdr= (ExchangeHdr_t *)s_Response;
static SOCKET s_iClientSocket = INVALID_SOCKET;
static SOCKET s_iServerSocket = INVALID_SOCKET;
static struct sockaddr_in s_ServerAddr = {0};
#endif
static int  s_IsRemoteAddressFilled = 0;
static struct sockaddr_in s_ClientAddr = {0};

static const char *GetProcessName(void)
{
#ifdef	WIN32
	static char szProcessName[] = __FILE__;
#else
	static char	szProcessName[64] = {0};
	if (0==szProcessName[0])
	{
		FILE	*pFile = NULL;
		char	szFileName[128];
		char	szBuf[128];

		sprintf(szFileName, "/proc/%d/status", getpid());
		if (NULL==(pFile=fopen(szFileName, "rx")))
		{
			sprintf(szProcessName, "%d", getpid());
		}
		else
		{
			fread(szBuf, sizeof(szBuf), sizeof(char), pFile);
			fclose(pFile);
			strtok(szBuf, "\t");	// ignore "Name:\t"
			strcpy(szProcessName, strtok(NULL,  "\r\n"));
		}
	}
#endif//!WIN32
	return szProcessName;
}

ExchangeResult_t ConfigRemoteSetting(const char	*cszServerIP, uint16_t usPort)
{
	struct in_addr IPAddress;

	if (usPort<1024)
	{
		PERROR("Port %d is small than 1024.\n", usPort);
		return CONF_RESULT_IPC_ERROR;
	}

	if (INADDR_NONE==(IPAddress.s_addr = inet_addr(cszServerIP)))
	{
		PERROR("IP %s is invalid.\n", cszServerIP);
		return CONF_RESULT_IPC_ERROR;
	}

	s_ClientAddr.sin_family = AF_INET;
	s_ClientAddr.sin_port = htons(usPort);
	s_ClientAddr.sin_addr = IPAddress;

	s_IsRemoteAddressFilled = 1;

	return CONF_RESULT_OK;
}

///////////////////////////////////////////////////////////////////////////////
//	General Config Exchange routines
///////////////////////////////////////////////////////////////////////////////

static ExchangeInfoHook_t s_ExchangeInfoHook = NULL;

ExchangeInfoHook_t ExchangeInfoHookSet(ExchangeInfoHook_t pHook)
{
	ExchangeInfoHook_t	OrignalHook = s_ExchangeInfoHook;
	s_ExchangeInfoHook = pHook;
	return OrignalHook;
}


#ifndef  SYSV_MSG
static void PrintSocketError(char *szPrefix)
{
#ifdef	WIN32
	printf(szPrefix);
	printf(": %d!\n", WSAGetLastError());
#else
	perror(szPrefix);
#endif//!WIN32
}
#endif

#ifdef	WIN32
static void Win32SocketClean(void)
{
	WSACleanup();
}

static void Win32SocketStartup(void)
{
	static int	iIsSocketInited = 0;
	if (!iIsSocketInited)
	{
		WSADATA wsaData;
		if (0!=WSAStartup(MAKEWORD(2,1), &wsaData))
		{
			printf("not find a usable WinSock DLL!\n");
			exit(-1);
		}
		atexit(Win32SocketClean);
		iIsSocketInited = 1;
	}
}
#endif//WIN32

void ExchangeDataEndian(ExchangeHdr_t *pHdr);

static void ExchangeHeaderEndian(ExchangeHdr_t *pExchangeHdr)
{
	pExchangeHdr->ulMIB			= htonl(pExchangeHdr->ulMIB);
	pExchangeHdr->usDataLength	= htons(pExchangeHdr->usDataLength);
}

#ifdef  SYSV_MSG
static ExchangeResult_t SendData(MSG Msg, MsgBuf *Buf, uint32_t ulLength)  
{
	int iReturn = -1;
	ExchangeHdr_t *pHdr = (ExchangeHdr_t*)Buf->MsgText;
#if  SYSV_MSG
	int i = 0;
#endif

	ExchangeDataEndian(pHdr);
	ExchangeHeaderEndian(pHdr);

#if  SYSV_MSG
       for(i = 0; i<60000; i++)
       {
		errno = 0;
		iReturn = msgsnd(Msg,Buf,ulLength,IPC_NOWAIT);
		if(errno == ENOMSG )
		{
			usleep(10);
		}
			else 
			break;
        }
#else
	iReturn = msgsnd(Msg,Buf,ulLength,0);
#endif

	if (-1 == iReturn)
	{
		printf("call to send error \n ");	
		printf("errno = %d \n",errno);
		return CONF_RESULT_IPC_ERROR;
	}
	return CONF_RESULT_OK;
}
#else
static ExchangeResult_t SendData(uint8_t *pData, uint32_t ulLength)
{
	// Original data allways host endian.
	ExchangeHdr_t *pHdr = (ExchangeHdr_t*)pData;
	ExchangeDataEndian(pHdr);
	ExchangeHeaderEndian(pHdr);

	while(0!=ulLength)
	{
		int	iReturn = send(s_iClientSocket, pData, ulLength, 0);
		if (-1==iReturn)
		{
			PrintSocketError("call to send");
			return CONF_RESULT_IPC_ERROR;
		}
		if (iReturn>=(int)ulLength)
		{
			return CONF_RESULT_OK;
		}
		pData += iReturn;
		ulLength -= iReturn;
	}
	return CONF_RESULT_OK;
}
#endif

ExchangeResult_t	ConfigExchange(
	ExchangeRequestType_t	Request, 
	uint8_t		uchIndex,
	uint32_t	ulMIB,
	uint8_t		*pData,
	uint32_t	ulSndSize,
	uint32_t	ulRcvSize
	)
{
#ifdef  SYSV_MSG
	int  iReturn = -1;
	int  PID_NUM = getpid();
#if  SYSV_MSG
	int i=0;
#endif
	if (MAX_EXCHANGE_SIZE < ulSndSize || MAX_EXCHANGE_SIZE < ulRcvSize)
	{
		return CONF_RESULT_IPC_ERROR;
	}

	if (NULL==pData && 0!=(ulSndSize|ulRcvSize))
	{
		PERROR("error data buffer not exist! send(%d) receive(%d) 0x%08x\n",\
			ulSndSize, ulRcvSize, ulMIB);
		return CONF_RESULT_DATA_TOO_LONG;
	}
	
	if ((0!=(ulSndSize&ulRcvSize)) && ulSndSize!=ulRcvSize)
	{
		PERROR("warning buffer size panic! send(%d)!=receive(%d) 0x%08x\n",\
			ulSndSize, ulRcvSize, ulMIB);
	}

	// set the flag for GetLastExchangeResponse();
	s_pRespHdr->uchResult = CONF_RESULT_IPC_ERROR;

	// build the request header
	s_pReqHdr->ulMIB			= ulMIB;
	s_pReqHdr->usDataLength	= (uint16_t)ulSndSize;
	s_pReqHdr->uchIndex		= uchIndex;
	s_pReqHdr->uchRequest		= Request;
	s_pReqHdr->uchResult		= CONF_RESULT_OK;

	if (ulSndSize>0)
	{
		memcpy((uint8_t*)(s_pReqHdr+1), pData, ulSndSize);
	}

	// send request
	Msg_Request = msgget(KEY_REQ,0);
        Msg_Respond = msgget(KEY_RESP,0);

       if(Msg_Request == -1 ||Msg_Respond == -1) 
	{
	  perror("open msg error \n ");
	  printf("errno = %d \n",errno);
	  return CONF_RESULT_IPC_ERROR;
	}
       
	MsgBuf_Req.MsgType = PID_NUM;

	if (CONF_RESULT_OK!=SendData(Msg_Request,&MsgBuf_Req, ulSndSize +sizeof(ExchangeHdr_t)))
	{
		printf("ConfigExchange SendData Error \n");
		printf("errno = %d \n",errno);
		return CONF_RESULT_IPC_ERROR;
	}
        
#if   SYSV_MSG
	for(i = 0; i<60000; i++)
	{
		errno = 0;
		iReturn = msgrcv(Msg_Respond,&MsgBuf_Resp,MAX_EXCHANGE_SIZE,PID_NUM,IPC_NOWAIT);
		if(errno == ENOMSG )
		{
			usleep(10);
		}
		else break;
	}
#else
	iReturn = msgrcv(Msg_Respond,&MsgBuf_Resp,MAX_EXCHANGE_SIZE,PID_NUM,0);
#endif

	if(-1 == iReturn)
	{
		printf("msgrcv at ConfigExchange errno = %d \n",errno);
		return CONF_RESULT_IPC_ERROR;
	}
#else
	int		iReturn = 0;
	fd_set	RcvFdSet;
	struct	timeval timeout = {0};

	if (MAX_EXCHANGE_SIZE < ulSndSize || MAX_EXCHANGE_SIZE < ulRcvSize)
	{
		return CONF_RESULT_IPC_ERROR;
	}

	if (!s_IsRemoteAddressFilled && CONF_RESULT_OK!=ConfigRemoteSetting(
			DEFAULT_CONFIG_SERVER, DEFAULT_CONFIG_PORT))
	{
		return CONF_RESULT_IPC_ERROR;
	}

	if (NULL==pData && 0!=(ulSndSize|ulRcvSize))
	{
		PERROR("error data buffer not exist! send(%d) receive(%d) 0x%08x\n",
			ulSndSize, ulRcvSize, ulMIB);
		return CONF_RESULT_DATA_TOO_LONG;
	}
	
	if ((0!=(ulSndSize&ulRcvSize)) && ulSndSize!=ulRcvSize)
	{
		PERROR("warning buffer size panic! send(%d)!=receive(%d) 0x%08x\n",
			ulSndSize, ulRcvSize, ulMIB);
	}

#ifdef	WIN32
	Win32SocketStartup();
#endif//WIN32

	s_iClientSocket = socket(AF_INET, SOCK_STREAM, 0);
	if (INVALID_SOCKET == s_iClientSocket)
	{
		PrintSocketError("call to socket");
		return CONF_RESULT_IPC_ERROR;
	}
	if (connect(s_iClientSocket, (struct sockaddr*)&s_ClientAddr, sizeof(s_ClientAddr))<0)
	{
		PrintSocketError("call to connect");
		return CONF_RESULT_IPC_ERROR;
	}

	// set the flag for GetLastExchangeResponse();
	s_pRespHdr->uchResult = CONF_RESULT_IPC_ERROR;

	// build the request header
	s_pReqHdr->ulMIB			= ulMIB;
	s_pReqHdr->usDataLength		= (uint16_t)ulSndSize;
	s_pReqHdr->uchIndex			= uchIndex;
	s_pReqHdr->uchRequest		= Request;
	s_pReqHdr->uchResult		= CONF_RESULT_OK;

	if (ulSndSize>0)
	{
		memcpy((uint8_t*)(s_pReqHdr+1), pData, ulSndSize);
	}

	// send request
	if (CONF_RESULT_OK!=SendData(s_Request, ulSndSize +sizeof(ExchangeHdr_t)))
	{
		return CONF_RESULT_IPC_ERROR;
	}
	
	// Receive Response
	FD_ZERO(&RcvFdSet);
	FD_SET(s_iClientSocket, &RcvFdSet);
	timeout.tv_sec = 20; //seconds
	select(s_iClientSocket + 1, &RcvFdSet, NULL, NULL, &timeout);
	iReturn = (FD_ISSET(s_iClientSocket, &RcvFdSet))?
		recv(s_iClientSocket, s_Response, sizeof(s_Response), 0) : -1;

	closesocket(s_iClientSocket);
#endif

	iReturn -= sizeof(ExchangeHdr_t);
	if (iReturn < 0)
	{
		PERROR("response shorter than header size! ulMIB=%08X\n", ulMIB);
		return CONF_RESULT_IPC_ERROR;
	}

	// Decode the response
	if (s_pRespHdr->ulMIB != s_pReqHdr->ulMIB)
	{
		PERROR("response MIB mismatch!\n");
		s_pRespHdr->uchResult = CONF_RESULT_UNKNOWN;
		return s_pRespHdr->uchResult;
	}
	
	ExchangeHeaderEndian(s_pRespHdr);
	if (iReturn<s_pRespHdr->usDataLength)
	{
		PERROR("response size too short!\n");
		s_pRespHdr->uchResult = CONF_RESULT_UNKNOWN;
		return CONF_RESULT_UNKNOWN;
	}

	ExchangeDataEndian(s_pRespHdr);

	if (iReturn>s_pRespHdr->usDataLength)
	{
		if (CONF_RESULT_INFO&s_pRespHdr->uchResult)
		{
			if (NULL!=s_ExchangeInfoHook)
			{
				char	*szInfo = (char *)(s_pRespHdr + 1);

				szInfo[iReturn] = '\0';
				szInfo += s_pRespHdr->usDataLength;
				s_ExchangeInfoHook(szInfo);
			}
		}
		else
		{
			PERROR("warning need IMPROVE the server! 0x%08x\n", ulMIB);
		}
	}
	
	s_pRespHdr->uchResult &= ~CONF_RESULT_INFO;

	if (CONF_RESULT_OK==s_pRespHdr->uchResult)
	{
		if (s_pRespHdr->usDataLength>0)
		{
			uint8_t	*pResult = (uint8_t*)(s_pRespHdr+1); 

			if (NULL==pData)
			{
				if (0!=ulRcvSize)
				{
					PERROR("required receive buffer %d! 0x%08x\n",
						ulRcvSize, ulMIB);
				}
				return CONF_RESULT_DATA_TOO_SHORT;
			}
			if (ulRcvSize<s_pRespHdr->usDataLength)
			{
				memcpy(pData, pResult, ulRcvSize);
				PERROR("receive buffer %d too short, required %d! 0x%08x\n",
						ulRcvSize, s_pRespHdr->usDataLength, ulMIB);
				return CONF_RESULT_DATA_TOO_SHORT;
			}

			memcpy(pData, pResult, s_pRespHdr->usDataLength);
			
			if (ulRcvSize>s_pRespHdr->usDataLength)
			{
				pData[s_pRespHdr->usDataLength] = '\0';
			}
			return CONF_RESULT_OK;
		}

		if ( 0 < ulRcvSize)
		{
			PERROR("warning no expected data! MIB: 0x%08x\n", ulMIB);
		}
	}

	return s_pRespHdr->uchResult;
}

int	GetLastExchangeResponse(
	uint32_t ulMIB, 
	uint8_t *pData,
	uint32_t ulOffset,
	uint32_t ulSize
	)
{
	uint8_t	*pResult = (uint8_t*)(s_pRespHdr+1) + ulOffset;
	int	iRemainderSize = s_pRespHdr->usDataLength - ulOffset;

	if (CONF_RESULT_OK!=s_pRespHdr->uchResult || 0==s_pRespHdr->usDataLength)
	{
		return 0;
	}

	if (ulMIB!=s_pRespHdr->ulMIB)
	{
		return -CONF_RESULT_MIB_UNKNOWN;
	}

	if (iRemainderSize<0)
	{
		iRemainderSize = 0;
	}

	if (0!=(ulSize&iRemainderSize) && (uint32_t)iRemainderSize>ulSize)
	{
		iRemainderSize = ulSize;
	}

	if (NULL!=pData && 0!=iRemainderSize)
	{
		memcpy(pData, pResult, iRemainderSize);
	}
	return iRemainderSize;
}

ExchangeResult_t ConfigRequestFieldInfo(
	uint8_t		uchIndex,
	uint32_t	ulMIB,
	uint8_t		*pData,
	uint32_t	ulSize
	)
{
	ExchangeFieldInfo_t *pFieldInfo = (ExchangeFieldInfo_t *)pData;

	ExchangeResult_t ExchangeResult = ConfigExchange(
		CONF_REQUEST_FIELD_INFO,
		uchIndex,
		ulMIB,
		pData,
		0,
		ulSize
		);

	if (CONF_RESULT_OK!=ExchangeResult)
	{
		//memset(pulData, 0 , ulSize);
		return ExchangeResult;
	}
	if (CONF_FIELD_ENUM == pFieldInfo->ulFieldType)
	{
		ExchangeEnumInfo_t *pEnumInfo = pFieldInfo->InfoEnum.EnumInfos;
		uint32_t ulIndex;

		for (ulIndex=0; ulIndex<pFieldInfo->InfoEnum.ulCount; ulIndex++)
		{
			pEnumInfo[ulIndex].szNameOrOffset += (uint32_t)pData;
		}
	}
	return CONF_RESULT_OK;
}

///////////////////////////////////////////////////////////////////////////////
//	Server Config Exchange routines
///////////////////////////////////////////////////////////////////////////////
static ServerExchangeHook_t	s_ServerExchangeHook = NULL;

ExchangeResult_t ServerStartup(ServerExchangeHook_t ServerExchangeHook)
{
#ifdef  SYSV_MSG
	if ((Msg_Request=msgget(KEY_REQ, 0)) < 0)
	{
		Msg_Request = msgget(KEY_REQ, IPC_CREAT | IPC_EXCL | 0660);
	}
	if ((Msg_Respond=msgget(KEY_RESP, 0)) < 0)
	{
		Msg_Respond = msgget(KEY_RESP, IPC_CREAT | IPC_EXCL | 0660);
	}
	if(Msg_Request == -1 || Msg_Respond == -1) 
	{
		printf("Error  for Creat msg, errno = %d \n",errno);
		return CONF_RESULT_IPC_ERROR;
	}
#else
	s_ServerAddr.sin_family = AF_INET;
	s_ServerAddr.sin_port = htons(DEFAULT_CONFIG_PORT);
	s_ServerAddr.sin_addr.s_addr = inet_addr("127.0.0.1");//INADDR_LOOPBACK;

	s_iServerSocket = socket(AF_INET, SOCK_STREAM, 0);

	if (INVALID_SOCKET==s_iServerSocket)
	{
		PrintSocketError("call to socket");
		return CONF_RESULT_IPC_ERROR;
	}

	if (-1==bind(s_iServerSocket, (struct sockaddr*)&s_ServerAddr, 
		sizeof(struct sockaddr_in)))
	{
		PrintSocketError("call to bind");
		return CONF_RESULT_IPC_ERROR;
	}

	if (-1==listen(s_iServerSocket, 10))
	{
		PrintSocketError("call to listen");
		return CONF_RESULT_IPC_ERROR;
	}
	
#endif
	s_ServerExchangeHook = ServerExchangeHook;

	return CONF_RESULT_OK;
}

void ServerCleanup(void)
{
#ifdef  SYSV_MSG
	if (INVALID_MSG != Msg_Request)
	{
		msgctl(Msg_Request,IPC_RMID,NULL);
		Msg_Request = INVALID_MSG;
	}
	if (INVALID_MSG != Msg_Respond)
	{
		msgctl(Msg_Respond,IPC_RMID,NULL);
		Msg_Respond = INVALID_MSG;
	}
#else
	if (INVALID_SOCKET!=s_iServerSocket)
	{
		closesocket(s_iServerSocket);
		s_iServerSocket = INVALID_SOCKET;
	}
#endif
}

void ServerMonitor(void)
{
	int iLen = 0;
#ifdef   SYSV_MSG
	errno = 0;
	iLen = msgrcv(Msg_Request,&MsgBuf_Req,MAX_EXCHANGE_SIZE,0,IPC_NOWAIT);

	if(errno == ENOMSG)
	{
		usleep(1);
		return;
	}

	if (-1 == iLen)
	{
		printf("ServerMonitor call to recv\n");
		printf("errno = %d \n",errno);
		return;
	}
	
	MsgBuf_Resp.MsgType = MsgBuf_Req.MsgType;
	
        if (iLen>=sizeof(ExchangeHdr_t) && NULL!=s_ServerExchangeHook)
	{
		ExchangeHeaderEndian(s_pReqHdr);
		ExchangeDataEndian(s_pReqHdr);
		iLen -= sizeof(ExchangeHdr_t);
		iLen = s_ServerExchangeHook(s_pReqHdr, iLen, s_pRespHdr);
		
		if (iLen>=0)
		{
			if( CONF_RESULT_OK != SendData(Msg_Respond,&MsgBuf_Resp, iLen+sizeof(ExchangeHdr_t)))
			{
				printf("ServerMonitor  SendData  Error \n");
				printf("errno = %d \n",errno);
			}
		}
	}
#else
	int		iAddrSize = sizeof(s_ClientAddr);
	fd_set	RcvFdSet;
	struct	timeval timeout = {0};
	
	FD_ZERO(&RcvFdSet);
	FD_SET(s_iServerSocket, &RcvFdSet);
	timeout.tv_sec = 0;			//seconds
	timeout.tv_usec = 10000;	//10 ms
	select(s_iServerSocket + 1, &RcvFdSet, NULL, NULL, &timeout);
	if (!FD_ISSET(s_iServerSocket, &RcvFdSet))
	{
		return;
	}
	
	s_iClientSocket = accept(s_iServerSocket, 
		(struct sockaddr*)&s_ClientAddr, &iAddrSize);

	if (-1==s_iClientSocket)
	{
		PrintSocketError("call to accept");
		return;
	}

	iLen = recv(s_iClientSocket, s_Request, sizeof(s_Request), 0);

	if (-1 == iLen)
	{
		PrintSocketError("call to recv");
	}
	else if (iLen>=sizeof(ExchangeHdr_t) && NULL!=s_ServerExchangeHook)
	{
		ExchangeHeaderEndian(s_pReqHdr);
		ExchangeDataEndian(s_pReqHdr);
		iLen -= sizeof(ExchangeHdr_t);
		iLen = s_ServerExchangeHook(s_pReqHdr, iLen, s_pRespHdr);
		if (iLen>=0)
		{
			SendData(s_Response, iLen+sizeof(ExchangeHdr_t));
		}
	}

	closesocket(s_iClientSocket);	
#endif
}
