/*
 * zcommisc.h
 */
#ifndef	__ZCOMMISC_H__
#define	__ZCOMMISC_H__

#define	ZCOM_MISC_NAME		"zcommisc"
#define	ZCOM_MISC_FULLNAME	"/dev/"ZCOM_MISC_NAME

#define GPIO_PIN_MAX		16

typedef enum ZComMiscID
{
	ZCOM_MISC_GPIO_SET,
	ZCOM_MISC_GPIO_GET,
	ZCOM_MISC_LOG_CLEAR,
	ZCOM_MISC_PLATFORM_ID,
}ZComMiscID_t;

typedef enum ZComGpioLine
{
	GPIO_LINE_INIT_LED,
	GPIO_LINE_WLAN_WEAK,
	GPIO_LINE_WLAN_MEDIUM,
	GPIO_LINE_WLAN_STRONG,
	GPIO_LINE_RESET_BTN,
	GPIO_LINE_WPS_BTN,
	GPIO_LINE_POE_SWITCH,
}ZComGpioLine_t;

typedef	enum ZComGpioStatus
{
	GPIO_BTN_PRESSED	= 0,
	GPIO_BTN_RELEASED	= 1,
	GPIO_LED_ON			= 0,
	GPIO_LED_OFF		= 1,
	GPIO_SWITCH_ON 		= 1,
	GPIO_SWITCH_OFF		= 0,
}ZComGpioStatus_t;

typedef struct LedBlinkInfo_t
{
#define	ZCOM_LED_BLINK_NEVER	0
#define	ZCOM_LED_BLINK_FOREVER	0
	uint32_t	ulLedBlinkPeriod;	//in millisecond. if !0 blink
	uint32_t	ulLedBlinkTimes;	//0 always blink, 
									//else blink ulTimes then off
}LedBlinkInfo_t;

typedef	struct ZComGpioIoReq_t
{
	uint32_t	ulGpioLine;
	uint32_t	ulStatus;

	union
	{
		uint32_t	ulBtnDuration;	// Button Status Duration in millisecond.
		LedBlinkInfo_t LedBlinkInfo;
	};
}ZComGpioIoReq_t;

typedef	struct	ZComGpioInfo_t
{
	struct ZComGpioIoReq_t req;
	uint32_t	ulLedDuration;	// in jiffies
}ZComGpioInfo_t;

#endif//__ZCOMMISC_H__
