/*
 *	wag302type.h
 */
#ifndef	__WAG302TYPE_H__
#define	__WAG302TYPE_H__

#include <stdint.h>
#include "os_type.h"

typedef	enum ExchangeRequestType_t
{
	// Exchange Request Type
	CONF_REQUEST_FIELD_INFO = 0,
	CONF_REQUEST_READ,
	CONF_REQUEST_WRITE,
	CONF_REQUEST_REMOVE,
	CONF_REQUEST_HIT
} ExchangeRequestType_t;

typedef	enum ExchangeResult_t
{
	// Exchange Result
	CONF_RESULT_OK = 0,
	CONF_RESULT_IPC_ERROR,
	CONF_RESULT_VERSION_MISMATCH,
	CONF_RESULT_MIB_UNKNOWN,
	CONF_RESULT_REQUEST_DENY,
	CONF_RESULT_REQUEST_NOT_HANDLE,
	CONF_RESULT_INDEX_OUT_OF_RANGE,
	CONF_RESULT_DATA_TOO_SHORT,
	CONF_RESULT_DATA_TOO_LONG,
	CONF_RESULT_DATA_INVALID,
	CONF_RESULT_UNKNOWN,
	CONF_RESULT_INFO = 0x80
} ExchangeResult_t;

#define	MAX_EXCHANGE_SIZE	10240*3

typedef	enum ExchangeFieldType_t
{
	CONF_FIELD_UNKNOWN = 0,
	CONF_FIELD_INTEGER,
	CONF_FIELD_ENUM,
	CONF_FIELD_BITMAP,	//same as enum, only different is reuqired to bit test.
	CONF_FIELD_STRING,
	CONF_FIELD_ARRAY,
	CONF_FIELD_STRUCT
} ExchangeFieldType_t;

typedef	struct ExchangeFieldInfoInteger_t
{
	//uint32_t	ulDefault;
	uint32_t	ulMin;
	uint32_t	ulMax;
	uint32_t	ulStep;
} ExchangeFieldInfoInteger_t;

typedef	struct ExchangeEnumInfo_t
{
	uint32_t	ulValue;
	char		*szNameOrOffset;
} ExchangeEnumInfo_t;

typedef	struct ExchangeFieldInfoEnum_t
{
	uint32_t	ulCount;
	ExchangeEnumInfo_t	EnumInfos[1];
	// following is the string table
} ExchangeFieldInfoEnum_t;

typedef	struct ExchangeFieldInfoString_t
{
	uint32_t	ulLengthMin;	// include '\0'
	uint32_t	ulLengthMax;	// include '\0'
} ExchangeFieldInfoString_t;

typedef	struct ExchangeFieldInfoArray_t
{
	uint32_t	ulUnitCountMin;
	uint32_t	ulUnitCountMax;
	uint32_t	ulUnitSize;
} ExchangeFieldInfoArray_t;

typedef	struct ExchangeFieldInfo_t
{
	uint32_t	ulFieldType;
	union
	{
		ExchangeFieldInfoInteger_t	InfoInteger;
		ExchangeFieldInfoEnum_t		InfoEnum;
		ExchangeFieldInfoString_t	InfoString;
		ExchangeFieldInfoArray_t	InfoArray;
	};
} ExchangeFieldInfo_t;

#endif//!__WAG302TYPE_H__
