/*
 *	wag302mib.h
 */
#ifndef __WAG302MIB_H__
#define __WAG302MIB_H__

#include "wag302def.h"

///////////////////////////////////////////////////////////////////////////////
//	Config server and client revision
///////////////////////////////////////////////////////////////////////////////
// if the MIB IDs' definition updated, CONFIG_REVISION will be increased
#define	CONFIG_REVISION		"2.1.4"

///////////////////////////////////////////////////////////////////////////////
//	Config server MIB IDs
///////////////////////////////////////////////////////////////////////////////
#define MIB_WG302_BASE		0x60b30000	//Z-Com Vendor ID of Mac Address

typedef enum MIBSystem_t
{
	MIB_SYSTEM_FIRST		= MIB_WG302_BASE + 0x0000,

	MIB_PRODUCT				= MIB_SYSTEM_FIRST,	// read-only
	MIB_PRODUCT_NAME,
	MIB_HOST_NAME_PERMANENT,
	MIB_HOST_NAME,
	MIB_FIRMWARE_VERSION,
	MIB_SYS_COUNTRY,
	MIB_USER_NAME,
	MIB_PASSWORD,				// remove means set to default
	MIB_SUPER_NAME,
	MIB_SUPER_PASSWORD,
	MIB_DEBUGER_TOKEN,
	MIB_SYSTEM_PRIVILEGE,

	MIB_NTP_ENABLED,			//bool
	MIB_NTP_SERVER_ID,			//unsigned long (0,1) default is 1
	MIB_NTP_TIMEZONE,			//unsigned long (0,64) default is 21
	MIB_NTP_DST,				//0 disable,1 enable
	MIB_NTP_SERVER_IP1,			//unsigned long (0,6) default is 0
	MIB_NTP_SERVER_IP2,			//ip
	MIB_TIME,
	MIB_SYSTEM_TIMEOUT,
	
	MIB_REBOOT,					// write-only
	MIB_RESTORE_FACTORY,		// write-only

	//Config File/Firmware and so on
	MIB_FILE_ACCESS_START,
	MIB_FILE_ACCESS_FINISH,
	MIB_CERT_NAME,
	
	MIB_SYSTEM_RESET_TIME,
	MIB_SYSTEM_PORT_STATUS,
	MIB_SYSTEM_MODEL_NAME,
	MIB_SYSTEM_LAN_MAC,
	MIB_SYSTEM_WAN_MAC,
	MIB_SYSTEM_DOMAIN,

	MIB_MFG_TESTLED,
	MIB_SPEC_ETHERNET_NUM,
	MIB_SPEC_ETHERNET_MAXRATE,
	MIB_SPEC_POE_POWER,
	MIB_SYSTEM_POE_POWER,

	MIB_PINGWD_ENABLE,
	MIB_PINGWD_PING_INTERVAL,
	MIB_PINGWD_STARTUP_DELAY,
	MIB_PINGWD_FAILURE_COUNT,
	MIB_PINGWD_IP,

	MIB_GPS_LATITUDE,
	MIB_GPS_LONGITUDE,

	MIB_SPEED_TEST_SERVER,
	MIB_SPEED_TEST_DEST_IP,
	MIB_SPEED_TEST_DUPLEX,

	MIB_SYS_ERASE_OEMINFO,

	MIB_SYSTEM_LAST
} MIBSystem_t;

typedef enum MIBNetwork_t
{
	MIB_NETWORK_FIRST		= MIB_WG302_BASE + 0x0100,

	MIB_SYS_MAC_ADDRESS		= MIB_NETWORK_FIRST,

	MIB_BRIDGE_SPANNING_TREE,

	MIB_ROUTE_MODE,
	MIB_ANYIP_ON_ROUTE,

	MIB_NET_TYPE,
	MIB_NET_IP,
	MIB_NET_MASK,
	MIB_NET_GATEWAY,
	MIB_NET_DNS_PRIMARY,
	MIB_NET_DNS_SECONDARY,

#if defined(_ZCOM_DHCPS_)
	MIB_DHCPS_DAEMON,
	MIB_DHCPS_DOMAIN,
	MIB_DHCPS_ANYIP,
	MIB_DHCPS_IP_RANGE_START,
	MIB_DHCPS_IP_RANGE_END,
	MIB_DHCPS_NETMASK,
	MIB_DHCPS_GATEWAY,
	MIB_DHCPS_DNS_PRIMARY,
	MIB_DHCPS_DNS_SECONDARY,
	MIB_DHCPS_WINS_PRIMARY,
	MIB_DHCPS_WINS_SECONDARY,
	MIB_DHCPS_LEASE,			// in minutes
	MIB_DHCPS_LIST,

#endif
#ifdef _ZCOM_DHCP_RELAY_
	MIB_DHCP_RELAY_DAEMON,
	MIB_DHCP_SERVER_IP,
#endif
	MIB_ETHERNETLAN_STATS,		// read-only
	MIB_ETHERNETWAN_STATS,		//add for statistics
	MIB_WIRELESS_STATS,			//add for statistics

	//wan
	MIB_WAN_CLONED_ENABLE,
	MIB_WAN_CLONED_MAC,

#ifdef _ZCOM_PPP_
	MIB_FIXED_IP_MTU_SIZE,
	MIB_DHCPC_MTU_SIZE,
	MIB_PPPOE_MTU_SIZE,
	MIB_PPTP_MTU_SIZE,
	MIB_WAN_CONN_STATUS,
	MIB_PPP_BUTTONSTATUS,
	MIB_WAN_PPP_LOCALIP,
	MIB_PPP_IP,
	MIB_PPPOE_STATICIP,
	MIB_PPPOE_USERNAME,
	MIB_PPPOE_PASSWD,
	MIB_PPPOE_TIMEOUT,
	MIB_PPPOE_RETRY,
	MIB_PPPOE_IDLE_TIME,
	MIB_PPPOE_CONNECT_TYPE,
	MIB_PPPOE_SERVICE,
	MIB_PPPOE_CONNECT_STATUS,
	MIB_PPTP_USERNAME,
	MIB_PPTP_PASSWD,
	MIB_PPTP_SERVERIP,
	MIB_PPTP_SECURITY_ENABLED,
	MIB_PPTP_CONNECT_STATUS,
	MIB_L2TP_USERNAME,
	MIB_L2TP_PASSWD,
	MIB_L2TP_SERVERIP,
	MIB_L2TP_MTU_SIZE,
	MIB_L2TP_CONNECT_STATUS,
#endif

#ifdef _ZCOM_FIREWALL_
	MIB_VPN_PASSTHRU_IPSEC_ENABLED,
	MIB_VPN_PASSTHRU_PPTP_ENABLED,
	MIB_VPN_PASSTHRU_L2TP_ENABLED,
	MIB_DDNS_ENABLED,
	MIB_DDNS_TYPE,
	MIB_DDNS_USER,
	MIB_DDNS_PASSWORD,
	MIB_DDNS_DOMAIN_NAME,
	MIB_MACFILTER_ENABLED,
	MIB_MACFILTER_NUM,
	MIB_MACFILTER,
	MIB_MACFILTER_ADD,
	MIB_MACFILTER_DEL,
	MIB_MACFILTER_DELALL,
	
	MIB_URLFILTER_ENABLED,
	MIB_URLFILTER_NUM,
	MIB_URLFILTER,
	MIB_URLFILTER_ADD,
	MIB_URLFILTER_DEL,
	MIB_URLFILTER_DELALL,
	
	MIB_IPFILTER_ENABLED,
	MIB_IPFILTER_NUM,
	MIB_IPFILTER,
	MIB_IPFILTER_ADD,
	MIB_IPFILTER_CLI_SNMP_ADD,
	MIB_IPFILTER_DEL,
	MIB_IPFILTER_CLI_SNMP_DEL,
	MIB_IPFILTER_DELALL,

	MIB_DSTIPFILTER_ENABLED,
	MIB_DSTIPFILTER_NUM,
	MIB_DSTIPFILTER,
	MIB_DSTIPFILTER_ADD,
	MIB_DSTIPFILTER_CLI_SNMP_ADD,
	MIB_DSTIPFILTER_DEL,
	MIB_DSTIPFILTER_CLI_SNMP_DEL,
	MIB_DSTIPFILTER_DELALL,

	MIB_SRC_PORTFILTER_ENABLED,
	MIB_SRC_PORTFILTER_NUM,
	MIB_SRC_PORTFILTER,
	MIB_SRC_PORTFILTER_ADD,
	MIB_SRC_PORTFILTER_CLI_SNMP_ADD,
	MIB_SRC_PORTFILTER_DEL,
	MIB_SRC_PORTFILTER_CLI_SNMP_DEL,
	MIB_SRC_PORTFILTER_DELALL,

	MIB_PORTFILTER_ENABLED,
	MIB_PORTFILTER_NUM,
	MIB_PORTFILTER,
	MIB_PORTFILTER_ADD,
	MIB_PORTFILTER_CLI_SNMP_ADD,
	MIB_PORTFILTER_DEL,
	MIB_PORTFILTER_CLI_SNMP_DEL,
	MIB_PORTFILTER_DELALL,

	MIB_PORTFW_ENABLED,
	MIB_PORTFW_NUM,
	MIB_PORTFW,
	MIB_PORTFW_ADD,
	MIB_PORTFW_CLI_SNMP_ADD,
	MIB_PORTFW_DEL,
	MIB_PORTFW_CLI_SNMP_DEL,
	MIB_PORTFW_DELALL,
	MIB_SPI_FIREWALL,
	MIB_DOS_ENABLED,
	MIB_DOS_SYSSYN_FLOOD,
	MIB_DOS_SYSFIN_FLOOD,
	MIB_DOS_SYSUDP_FLOOD,
	MIB_DOS_SYSICMP_FLOOD,
	MIB_DOS_PIPSYN_FLOOD,
	MIB_DOS_PIPFIN_FLOOD,
	MIB_DOS_PIPUDP_FLOOD,
	MIB_DOS_PIPICMP_FLOOD,
	MIB_DOS_BLOCK_TIME,
	MIB_DMZ,
	MIB_DMZ_IP,
	MIB_NAT_ENABLED,
#endif

	//bandwidth control(QOS)
	MIB_BW_ENABLED,
	MIB_BW_DOWN_STREAM,
	MIB_BW_UP_STREAM,
	MIB_BW_DOWN_BURST,
	MIB_BW_UP_BURST,

	MIB_NET_IP_STATUS,
	MIB_NET_MASK_STATUS,
	MIB_NET_GATEWAY_STATUS,
	MIB_NET_DNS_PRIMARY_STATUS,
	MIB_NET_DNS_SECONDARY_STATUS,

	MIB_UPNP_ENABLED,
	MIB_PING_WAN_ACCESS_ENABLED,
	MIB_WEB_WAN_ACCESS_ENABLED,
#ifdef _ZCOM_DYNROUTING_
	MIB_DYNROUTING_ENABLED,
	MIB_DYNROUTING_PROTOCOL,
	MIB_DYNROUTING_WAN_RIP_ENABLED,
	MIB_DYNROUTING_LAN_RIP_ENABLED,
	MIB_DYNROUTING_WAN_OSPF_ENABLED,
	MIB_DYNROUTING_WAN_AREA,
	MIB_DYNROUTING_LAN_OSPF_ENABLED,
	MIB_DYNROUTING_LAN_AREA,
	MIB_DYNROUTING_BGP4,
	MIB_DYNROUTING_NEIGHBORIP,
	MIB_DYNROUTING_REMOTEAS,
	MIB_DYNROUTING_WAN_BGP4_ENABLED,
	MIB_DYNROUTING_LAN_BGP4_ENABLED,
	MIB_DYNROUTING_ID,
	MIB_DYNROUTING_TIME,
#endif
#ifdef _ZCOM_STAROUTING_
	MIB_STAROUTING_ENABLED,
	MIB_STAROUTING_NUM,
	MIB_STAROUTING,
	MIB_STAROUTING_ADD,
	MIB_STAROUTING_DEL,
	MIB_STAROUTING_DELALL,
#endif
	MIB_CONNECTED_TIME,
	MIB_DHCP_ACTION,
	MIB_IGMP_MULTICAST,

	MIB_VLAN_ENABLE,
	MIB_VLAN_MANAGE_ID,
	MIB_STP_FORWARD_DELAY,
	MIB_NETWORK_LAST
} MIBNetwork_t;

typedef enum MIBRemote_t
{
	MIB_REMOTE_FIRST		= MIB_WG302_BASE + 0x0200,

	MIB_RADIUS_IP			= MIB_REMOTE_FIRST,
	MIB_RADIUS_PORT,
	MIB_RADIUS_SECRET,

	MIB_SNMPD_VERSION,
	MIB_SNMPD_USER_LIST,
	MIB_SNMPD_USER1,
	MIB_SNMPD_USER2,
	MIB_SNMPD_USER1_ENABLE,
	MIB_SNMPD_USER2_ENABLE,
	MIB_SNMPD_READ_COMMUNITY,
	MIB_SNMPD_WRITE_COMMUNITY,
	MIB_SNMPD_TRAP_COMMUNITY,
	MIB_SNMPD_TRAP_SERVER_LIST,
	MIB_SNMP_PORT,
	MIB_TRAFFIC_PORT,
	MIB_TRAFFIC_TIME,
	
	MIB_SYSLOG_DAEMON,
	MIB_SYSLOG_SERVER_IP,
	MIB_SYSLOG_SERVER_PORT,
	MIB_SYSLOG_CLEAR,

	MIB_REMOTE_MGMT_MODE,
	MIB_TELNET_DAEMON,
	MIB_SNMP_DAEMON,
	MIB_FTP_DAEMON,
	MIB_SSH_DAEMON,
	MIB_HTTPS_DAEMON,
	MIB_WISE_DAEMON,

#ifdef _ZCOM_CAPTIVE_POTAL_
	MIB_CHILLI_DAEMON,
	MIB_CHILLI_RADIUS_SERVER1,
	MIB_CHILLI_RADIUS_SERVER2,
	MIB_CHILLI_RADIUS_AUTH_PORT,
	MIB_CHILLI_RADIUS_ACCT_PORT,
	MIB_CHILLI_RADIUS_SECRET,
	MIB_CHILLI_RADIUS_NASID,
	MIB_CHILLI_RADIUS_ADMIN_USER,
	MIB_CHILLI_RADIUS_ADMIN_PASSWD,
	MIB_CHILLI_UAM_URL,
	MIB_CHILLI_UAM_SECRET,
	MIB_CHILLI_UAM_AAA_URL,
	MIB_CHILLI_UAM_ALLOW_HOSTS,
	MIB_CHILLI_UAM_ALLOW_DOMAINS,
#endif	
	
	MIB_REMOTE_LAST
} MIBRemote;

typedef enum MIBWireless_t
{
	MIB_WLAN_FIRST			= MIB_WG302_BASE + 0x0300,

	MIB_WLAN_VERSION		= MIB_WLAN_FIRST,

	MIB_WLAN_RADIO_ENABLE,
	MIB_SPEC_OPERATION_MODE,
	MIB_WLAN_OPERATION_MODE,
	MIB_SPEC_WIRELESS_MODE,
	MIB_WLAN_WIRELESS_MODE,
	MIB_WLAN_SSID,
	MIB_WLAN_SSID_SUPPRESS,
	MIB_WLAN_CHANNEL,
	MIB_WLAN_SUPPORTED_CHANNELS,

	MIB_SPEC_CHAIN_NUM,
	MIB_WLAN_TRANSMIT_RATE,
	MIB_WLAN_TRANSMIT_POWER,
	MIB_WLAN_ANTENNA_GAIN,

	MIB_WLAN_WMM,
	MIB_WLAN_RTS_THRESHOLD,
	MIB_WLAN_FRAGMENT_THRESHOLD,
	MIB_WLAN_BEACON_INTERVAL,
	MIB_WLAN_DTIM_INTERVAL,
	MIB_SPEC_ANTENNA,
	MIB_WLAN_ANTENNA,
	MIB_WLAN_PREAMBLE,
	MIB_WLAN_SUPER_AG_ENABLE,
	MIB_WLAN_WIRELESS_ISOLATION,
	
	MIB_CHANNEL_MODE,
	MIB_CHANNEL_OFFSET,
	MIB_CHANNEL_PRO_SPACING,
	MIB_CHANNEL_PROTECT,
	MIB_CHANNEL_THRES,
	MIB_STATE_MACHINE,

	MIB_WLAN_ACL_MODE,
	MIB_WLAN_ACL_NUM,
	MIB_WLAN_ACL_ALLOW_LIST,
	MIB_WLAN_ACL_DEL,
	MIB_WLAN_ACL_DELALL,

	MIB_WLAN_ASSOCIATION_LIST,	// read-only
	MIB_WLAN_AP_LIST,			//DOT11_ZCOM_SCAN_RESULT, 1f
	MIB_WLAN_REMOTE_AP,
	MIB_WLAN_WDS_ISOLATION,
	MIB_WLAN_CHANNEL_STATUS,
	MIB_WLAN_AMPDU,
	MIB_WLAN_AMSDU,
	MIB_WLAN_SHORTGI,
	MIB_WLAN_HTPROT,
	MIB_WLAN_RIFS,
	MIB_WLAN_LINK_INTEGRATION,
	MIB_WLAN_MAX_STATION_NUM,
	MIB_WLAN_SPACE_IN_METER,
	//MIB_WLAN_STA_BW_CONTROL,
	//MIB_WLAN_TX_FLOW_RATE,
	MIB_CHANNEL_BW,
#ifdef _ZCOM_MSSID_
	MIB_WLAN_VAP_ENABLE,
	MIB_WLAN_PRONAME,
	MIB_WLAN_VAP_VLAN_PARAM,
#endif
	MIB_WLAN_IGMP_SNOOPING,

	MIB_WLAN_RADIOTEST_ENABLE,
	MIB_WLAN_RADIOTEST_MAC,
	MIB_WLAN_RADIOTEST_TOTAL,

	MIB_WLAN_POWER_CTL,
	MIB_WLAN_CHANNEL_CTL,
	MIB_SPEC_DFS,
	MIB_WLAN_DFS_ENABLE,

	MIB_WLAN_ACKTIMEOUT,
	MIB_WLAN_SIGNAL_INFO,
#ifdef _ZCOM_LINKTEST_
	MIB_WLAN_LINK_ACTION,
	MIB_WLAN_LINK_RESULT,
	MIB_WLAN_LINK_TIME,
	MIB_WLAN_LINK_PKT_SIZE, 		// LinkTest Pkt's size
	MIB_WLAN_LINK_TEST_INTERVAL,	// LinkTest Send Pkt's interval
	MIB_WLAN_LINK_TEST_REMOTEMAC,
#endif
	
#ifdef ZCOM_TDM_COORDINATION	//add for STDM
	MIB_WLAN_STDM,
#endif
#ifdef _ZCOM_TDM_WDS_
	MIB_WDS_STDM_MODE,
#endif
	MIB_WLAN_CPE_TYPE,
	MIB_WLAN_KICK_MAC,  //add by jxq for kick station by special mac address
	MIB_WLAN_RATE_TO_SIGNAL, //add by jxq for map rate to signal
	MIB_WLAN_STA_NUM_LMT,	//Station number limitation - Qiao Zheng
	MIB_WLAN_CHAIN_MASK,
	MIB_WLAN_RESET_TIMER,  //add by jxq for control the wlan reset timer

	MIB_WLAN_LAST
} MIBWireless_t;

typedef enum MIBSecurity_t
{
	MIB_SECURITY_FIRST	= MIB_WG302_BASE + 0x0400,

	MIB_WLAN_AUTHENTICATION	= MIB_SECURITY_FIRST,
	MIB_WLAN_ENCRYPTION,

	MIB_WEP_KEY_TYPE,
	MIB_WEP_KEY_DEFAULT,
	MIB_WEP_KEY_PASS_PHRASE,
	MIB_WEP_KEY1,
	MIB_WEP_KEY2,
	MIB_WEP_KEY3,
	MIB_WEP_KEY4,

	MIB_WPA_PSK,
	MIB_WPA_RE_AUTH_SECONDS,
	MIB_WPA_GKEY_UPDATE_CONDITION,
	MIB_WPA_GKEY_UPDATE_SECONDS,
	MIB_WPA_GKEY_UPDATE_PACKETS,
	MIB_WPA_EAP_TYPE,
	MIB_WPA_EAP_INNER_TYPE,
	MIB_WPA_USERNAME,
	MIB_WPA_LOGINNAME,
	MIB_WPA_PASSWORD,
	MIB_WPA_USERCERT,
	MIB_WPA_PRIVATEKEY_PASSWORD,

	MIB_WLAN_WDS_ENCRYPT,

	MIB_SECURITY_LAST
} MIBSecurity_t;


#endif//!__WAG302MIB_H__
