/*
 *	wag302def.h
 */
#ifndef	__WAG302DEF_H__
#define	__WAG302DEF_H__

#include <stdint.h>

///////////////////////////////////////////////////////////////////////////////
//	Detailed definitions
///////////////////////////////////////////////////////////////////////////////
//MTD Partitions
#define PARTITION_UBOOT			"/dev/mtd0"			//"/dev/mtdblock0"
#define PARTITION_ENV			"/dev/mtd1"
#define PARTITION_ROOTFS		"/dev/mtd2"
#define PARTITION_KERNEL		"/dev/mtd3"
#define PARTITION_CFG			"/dev/mtd4"
#define PARTITION_MFG			"/dev/mtd5"
#define PARTITION_EEPROM		"/dev/mtd6"
#define PARTITION_BLOCK_ENV		"/dev/mtdblock1"
#define PARTITION_BLOCK_CFG		"/dev/mtdblock4"
#define KERNEL_OFFSET	 		0x100000
#define OEM_MAX_SIZE			0x70000
#define OEM_MAGIC				0xbbbb
#define OEM_VERSION				0x0002

enum OemId_t
{
	OEM_ID_NONE,
	OEM_ID_PICTURE,
	OEM_ID_OEMNAME,
	OEM_ID_MAX,
};


#define CLI_FULLNAME			"/usr/sbin/cli"
#define CERT_FILE_PATH			"/var/cert"
#define WEBS_PAGES_PATH			"/var/webpages"
#define WEBS_LOGO_NAME			WEBS_PAGES_PATH"/images/logo.jpg"
#define MULTI_DEV_FULLNAME		"/dev/multi_drv"

// Atheros RF Device
#define AR5416_DEVID_AR9280_PCIE  0x002a        /* PCIE (Merlin) */
#define AR5416_DEVID_AR9285_PCIE  0x002b        /* PCIE (Kite) */

enum ProductAttribute_t
{
	PRODUCT_ATTR_LAN_NONE		= 0,
	PRODUCT_ATTR_LAN_1000M		= 1,
	PRODUCT_ATTR_LAN2_POEPOWER	= 2,
};

//MIB_PRODUCT
typedef enum Product_t
{
	PRODUCT_AUTO	= 0,
	PRODUCT_WG302	= 302,
	PRODUCT_WAG302,
	PRODUCT_AP100,
	PRODUCT_XN1520 = 1520,
	PRODUCT_AN1521,
	PRODUCT_ZCN1523_2_8 = 1523,
	PRODUCT_ZCN1523_5_16,
	PRODUCT_XN2521 = 2520,
	PRODUCT_XN2520,
	PRODUCT_XA3120	= 3120,
	PRODUCT_XG3120,
	PRODUCT_AG3220,
	PRODUCT_XG3620,
	PRODUCT_ZWL9300,
	PRODUCT_ZTE_W640A,
	PRODUCT_ZA5000	= 5000,
	PRODUCT_ZG5000,
	PRODUCT_ZA5000E1,
	PRODUCT_ZA5000D,
	PRODUCT_ZA5000EW,		// Russia 6G Product
	PRODUCT_BWA9100A,		// OEM ZA-5000-E
	PRODUCT_BWA9110A,		// OEM ZA-5000-I
	PRODUCT_BWA9100G,		// OEM ZG-5000-E
	PRODUCT_BWA9110G,		// OEM ZG-5000-I
	PRODUCT_ZWL9100AG,		// OEM ZA-5000-D
	PRODUCT_ZAG5000IE,		// ZDC, ZA-5000-D
	PRODUCT_ZA5000IW,		// ZA-5000, not buzzer switch
	PRODUCT_W640A,			//ZG-5000 for ZTE
	PRODUCT_GWL2010,		//ZG-5000 for Powercom
	PRODUCT_ZWL9200A= 8110,
	PRODUCT_ZWL9200G
} Product_t;

typedef	enum IPStr_t
{
	IP_STR_MIN_LEN = 8,	// includes '\0'
	IP_STR_MAX_LEN = 16	// includes '\0'
} IPStr_t;

//MIB_FILE_ACCESS_START && MIB_FILE_ACCESS_FINISH
typedef	enum FileAccessIndex_t
{
	FILE_ACCESS_CONFIG = 0,		// read/write
	FILE_ACCESS_FIRMWARE,		// write-only
	FILE_ACCESS_VERSION,		// read-only
	FILE_ACCESS_CERTIFICATE,	//write-only
	FILE_ACCESS_SNMP_MIB,		// read-only
	FILE_ACCESS_FACTORY_SETTING,// read/write
	FILE_ACCESS_STATUS,			// read-only
	FILE_ACCESS_OEM,

	FILE_ACCESS_LAST
} FileAccessIndex_t;

typedef	enum RadiusIndex_t
{
	RADIUS_AUTH_PRIMARY =0,
	RADIUS_AUTH_SECONDARY,
	RADIUS_ACCOUNT_PRIMARY,
	RADIUS_ACCOUNT_SECONDARY,
	RADIUS_LAST
} RadiusIndex_t;

///////////////////////////////////////////////////////////////////////////////
// SNMP definitions
///////////////////////////////////////////////////////////////////////////////
#define SNMPD_TRAP_NUM	1
#define SNMPD_USER_NUM	2

typedef enum SnmpdVersion_t
{
	SNMPD_V1_V2	= 2,
	SNMPD_V3	= 3
} SnmpdVersion_t;

typedef enum SnmpdAccess_t
{
	SNMPD_ACCESS_DISABLE	= 0,
	SNMPD_ACCESS_LAN,
	SNMPD_ACCESS_WAN,
	SNMPD_ACCESS_LAN_WAN
} SnmpdAccess_t;

typedef enum SnmpdUserAccess_t
{
	SNMPD_USER_ACCESS_RO	= 0,
	SNMPD_USER_ACCESS_RW,
} SnmpdUserAccess_t;

typedef enum SnmpdUserAuth_t
{
	SNMPD_USER_AUTH_NONE	= 0,
	SNMPD_USER_AUTH_MD5,
	SNMPD_USER_AUTH_SHA
} SnmpdUserAuthType_t;

typedef enum SnmpdUserEncrypt_t
{
	SNMPD_USER_ENCRYPT_NONE = 0,
	SNMPD_USER_ENCRYPT_DES,
	SNMPD_USER_ENCRYPT_AES
} SnmpdUserEncryptType_t;

///////////////////////////////////////////////////////////////////////////////
// Host Networking definitions
///////////////////////////////////////////////////////////////////////////////
typedef	enum DevPortIndex_t
{
	DEV_PORT_NONE = -1,
	DEV_PORT_BRIDGE	= 0,
	DEV_PORT_WAN,
	DEV_PORT_LAST
} DevPortIndex_t;

typedef	enum RouteMode_t
{
	BRIDGE_MODE	= 0,
	ROUTE_MODE_WAN_ETH,
	ROUTE_MODE_WAN_WLAN,

} RouteMode_t;

typedef	enum IPType_t
{
	IP_TYPE_STATIC_IP=0,
	IP_TYPE_DHCP_CLIENT,
	IP_TYPE_DHCP_SERVER,
	IP_TYPE_PPPOE,
	IP_TYPE_PPTP,
	IP_TYPE_L2TP,
} IPType_t;

typedef enum EthernetDataRate_t
{
	ETHER_TYPE_AUTO	= 0,
	ETHER_TYPE_10M	= 10,
	ETHER_TYPE_100M	= 100
} EthernetDataRate_t;
//MIB_WLAN_AP_SCAN

#define	AP_SCAN_STOP	0
#define	AP_SCAN_START	1

typedef enum MC_CUSTOMER_BEHAVIOUR {
	MC_MAP_TABLE_GET = 1,
	MC_MAC_CLONE_MANUAL_SET,
	MC_MAC_CLONE_MANUAL_CLEAR,
	MC_MAX_PPPOE_NUM_SET,
	MC_MAX_PPPOE_NUM_GET
} MC_CUSTOMER_BEHAVIOUR_t;

///////////////////////////////////////////////////////////////////////////////
// Wireless definitions
///////////////////////////////////////////////////////////////////////////////
//MIB_WLAN_OPERATION_MODE
typedef	enum WlanOperationMode_t
{
	WLAN_OPERATION_AP = 0,
	WLAN_OPERATION_AP_CLIENT,
	WLAN_OPERATION_P2P,
	WLAN_OPERATION_P2P_AP,
/*	WLAN_OPERATION_P2MP,
	WLAN_OPERATION_P2MP_AP,
	WLAN_OPERATION_REPEATER,
	WLAN_OPERATION_AUTOWDS,
	WLAN_OPERATION_UREPETER*/
} WlanOperationMode_t;

//MIB_WLAN_WIRELESS_MODE
typedef	enum WlanWirelessMode_t
{
	WIRELESS_MODE_AUTO = 0,		// 11b/g auto
	WIRELESS_MODE_11A,
	WIRELESS_MODE_11B_ONLY,
	WIRELESS_MODE_11G_ONLY,
	WIRELESS_MODE_11FH,			/* 2GHz, GFSK */
	WIRELESS_MODE_TURBO_A,		/* 5GHz, OFDM, 2x clock dynamic turbo */
	WIRELESS_MODE_TURBO_G,		/* 2GHz, OFDM, 2x clock  dynamic turbo*/
	WIRELESS_MODE_11NA,
	WIRELESS_MODE_11NG,
	WIRELESS_MODE_11NA_ONLY		= 19,
	WIRELESS_MODE_11NG_ONLY
} WlanWirelessMode_t;

//MIB_WLAN_TRANSMIT_POWER
#if 1
typedef	enum TransmitPower_t
{
	TX_POWER_FULL = 0,
	TX_POWER_HALF,
	TX_POWER_QUARTER,
	TX_POWER_EIGHTH,
	TX_POWER_MIN
} TransmitPower_t;
//#else
#define TX_POWER_MIN		12	//dBm
#define TX_POWER_MAX		30	//dBm
#endif

enum Wlan_cwm_mode
{
	WIRELESS_CWM_MODE20 = 0,
	WIRELESS_CWM_MODE2040,
	WIRELESS_CWM_MODE40,
	WIRELESS_CWM_MODEQUARTER,	
	WIRELESS_CWM_MODEHALF,
	WIRELESS_CWM_MODEMAX,
};

enum Wlan_cwm_offset
{
	WIRELESS_CWM_OFFSET_NONE,
	WIRELESS_CWM_OFFSET_LOWER,
	WIRELESS_CWM_OFFSET_UPPER,
	WIRELESS_CWM_OFFSET_MAX,
};

enum Wlan_cwm_extprotspacing
{
	WIRELESS_CWM_EXTPROTSPACING20,
	WIRELESS_CWM_EXTPROTSPACING25,
	WIRELESS_CWM_EXTPROTSPACINGMAX,
};

enum Wlan_cwm_extprotmode
{
	WIRELESS_CWM_EXTPROTNONE,
	WIRELESS_CWM_EXTPROTCTSONLY,
	WIRELESS_CWM_EXTPROTRTSCTS,
	WIRELESS_CWM_EXTPROTMAX,
};

//MIB_WLAN_BANDWIDTH
typedef	enum
{
	BANDWIDTH_NORMAL = 0,
	BANDWIDTH_HALF,
	BANDWIDTH_QUARTER
} WlanBandWidth_t;

//MIB_WLAN_PREAMBLE
typedef	enum Preamble_t
{
	PREAMBLE_LONG = 0,
	PREAMBLE_SHORT		// auto
} Preamble_t;

//MIB_WLAN_ANTENNA
typedef	enum Antenna_t
{
	ANTENNA_INDOOR_8DBI		= 0x01,
	ANTENNA_INDOOR_16DBI	= 0x02,
	ANTENNA_OUTDOOR_SMA		= 0x03,
	ANTENNA_OUTDOOR_NTYPE	= 0x04,
} Antenna_t;

//MIB_WLAN_ACL_MODE
typedef	enum ACLMode_t
{
	ACL_MODE_DISABLE = 0,
	ACL_MODE_ENABLE,
	ACL_MODE_STRICT,
	ACL_MODE_SERVER,
} ACLMode_t;

//MIB_WLAN_AUTHENTICATION
typedef enum Authentication_t
{
	AUTH_OPEN_SYSTEM	= 0x00,
	AUTH_SHARED_KEY		= 0x01,
	AUTH_802_1X			= 0x02,
	AUTH_WPA_RADIUS		= 0x04,
	AUTH_WPA2_RADIUS	= 0x08,
	AUTH_WPA1_2_RADIUS	= (AUTH_WPA_RADIUS|AUTH_WPA2_RADIUS),
	AUTH_WPA_PSK		= 0x10,
	AUTH_WPA2_PSK		= 0x20,
	AUTH_WPA1_2_PSK		= (AUTH_WPA_PSK|AUTH_WPA2_PSK),
	AUTH_ALL			= (AUTH_OPEN_SYSTEM|AUTH_SHARED_KEY|AUTH_802_1X
						  |AUTH_WPA1_2_RADIUS|AUTH_WPA1_2_PSK),
} Authentication_t;

//MIB_WLAN_ENCRYPTION
typedef enum Encryption_t
{
	ENCRYPT_NONE		= 0x00,
	ENCRYPT_WEP			= 0x01,
	ENCRYPT_TKIP		= 0x02,
	ENCRYPT_AES			= 0x04,
	ENCRYPT_AES_TKIP	= (ENCRYPT_TKIP|ENCRYPT_AES),
} Encryption_t;

//MIB_WEP_KEY_TYPE
typedef	enum WepKeyType_t
{
	// the first three types are for internal using.
	WEP_KEY_HEX			= 0,
	WEP_KEY_ALPHA,
	WEP_KEY_PHRASE,

	WEP_KEY_64HEX		= 40,
	WEP_KEY_64ALPHA,
	WEP_KEY_64PHRASE,
	WEP_KEY_128HEX		= 104,
	WEP_KEY_128ALPHA,
	WEP_KEY_128PHRASE,
	WEP_KEY_152HEX		= 128,
	WEP_KEY_152ALPHA,
	WEP_KEY_152PHRASE,
	WEP_KEY_DYNAMIC		=250,
} WepKeyType_t;

//MIB_WPA_GKEY_UPDATE_CONDITION
typedef	enum WPA_GKeyUpdateCondition_t
{
	WPA_GKEY_UPDATE_NEVER =0,
	WPA_GKEY_UPDATE_SECONDS,			// re-groupkey, after specified seconds.
	WPA_GKEY_UPDATE_PACKETS,			// re-groupkey, after specified packets.
	WPA_GKEY_UPDATE_DISCONNECT = 0x80,	// re-groupkey, after client disconnected.
										// can combine with SECONDS/PACKETS
	WPA_GKEY_UPDATE_SECONDS_DISCONNECT
			= (WPA_GKEY_UPDATE_SECONDS|WPA_GKEY_UPDATE_DISCONNECT),
	WPA_GKEY_UPDATE_PACKETS_DISCONNECT
			= (WPA_GKEY_UPDATE_PACKETS|WPA_GKEY_UPDATE_DISCONNECT),
} WPA_GKeyUpdateCondition_t;

//MIB_SYS_COUNTRY
typedef enum Country_t
{
    CTRY_DEBUG                = 0x1ff, /* debug */
    CTRY_ALBANIA              = 8,       /* Albania */
    CTRY_ALGERIA              = 12,      /* Algeria */
    CTRY_ARGENTINA            = 32,      /* Argentina */
    CTRY_ARMENIA              = 51,      /* Armenia */
    CTRY_AUSTRALIA            = 36,      /* Australia */
    CTRY_AUSTRIA              = 40,      /* Austria */
    CTRY_AZERBAIJAN           = 31,      /* Azerbaijan */
    CTRY_BAHRAIN              = 48,      /* Bahrain */
    CTRY_BANGLADESH           = 50,      /* Bangladesh */
    CTRY_BELARUS              = 112,     /* Belarus */
    CTRY_BELGIUM              = 56,      /* Belgium */
    CTRY_BELIZE               = 84,      /* Belize */
    CTRY_BOLIVIA              = 68,      /* Bolivia */
    CTRY_BOSNIA_HERZ          = 70,      /* Bosnia and Herzegowina */
    CTRY_BRAZIL               = 76,      /* Brazil */
    CTRY_BRUNEI_DARUSSALAM    = 96,      /* Brunei Darussalam */
    CTRY_BULGARIA             = 100,     /* Bulgaria */
    CTRY_CANADA               = 124,     /* Canada */
    CTRY_CHILE                = 152,     /* Chile */
    CTRY_CHINA                = 156,     /* People's Republic of China */
    CTRY_COLOMBIA             = 170,     /* Colombia */
    CTRY_COSTA_RICA           = 188,     /* Costa Rica */
    CTRY_CROATIA              = 191,     /* Croatia */
    CTRY_CYPRUS               = 196,
    CTRY_CZECH                = 203,     /* Czech Republic */
    CTRY_DENMARK              = 208,     /* Denmark */
    CTRY_DOMINICAN_REPUBLIC   = 214,     /* Dominican Republic */
    CTRY_ECUADOR              = 218,     /* Ecuador */
    CTRY_EGYPT                = 818,     /* Egypt */
    CTRY_EL_SALVADOR          = 222,     /* El Salvador */
    CTRY_ESTONIA              = 233,     /* Estonia */
    CTRY_FAEROE_ISLANDS       = 234,     /* Faeroe Islands */
    CTRY_FINLAND              = 246,     /* Finland */
    CTRY_FRANCE               = 250,     /* France */
    CTRY_GEORGIA              = 268,     /* Georgia */
    CTRY_GERMANY              = 276,     /* Germany */
    CTRY_GREECE               = 300,     /* Greece */
    CTRY_GUATEMALA            = 320,     /* Guatemala */
    CTRY_HONDURAS             = 340,     /* Honduras */
    CTRY_HONG_KONG            = 344,     /* Hong Kong S.A.R., P.R.C. */
    CTRY_HUNGARY              = 348,     /* Hungary */
    CTRY_ICELAND              = 352,     /* Iceland */
    CTRY_INDIA                = 356,     /* India */
    CTRY_INDONESIA            = 360,     /* Indonesia */
    CTRY_IRAN                 = 364,     /* Iran */
    CTRY_IRAQ                 = 368,     /* Iraq */
    CTRY_IRELAND              = 372,     /* Ireland */
    CTRY_ISRAEL               = 376,     /* Israel */
    CTRY_ITALY                = 380,     /* Italy */
    CTRY_JAMAICA              = 388,     /* Jamaica */
    CTRY_JAPAN                = 392,     /* Japan */
    CTRY_JORDAN               = 400,     /* Jordan */
    CTRY_KAZAKHSTAN           = 398,     /* Kazakhstan */
    CTRY_KENYA                = 404,     /* Kenya */
    CTRY_KOREA_NORTH          = 408,     /* North Korea */
    CTRY_KOREA_ROC            = 410,     /* South Korea */
    CTRY_KOREA_ROC2           = 411,     /* South Korea */
    CTRY_KOREA_ROC3           = 412,     /* South Korea */
    CTRY_KUWAIT               = 414,     /* Kuwait */
    CTRY_LATVIA               = 428,     /* Latvia */
    CTRY_LEBANON              = 422,     /* Lebanon */
    CTRY_LIBYA                = 434,     /* Libya */
    CTRY_LIECHTENSTEIN        = 438,     /* Liechtenstein */
    CTRY_LITHUANIA            = 440,     /* Lithuania */
    CTRY_LUXEMBOURG           = 442,     /* Luxembourg */
    CTRY_MACAU                = 446,     /* Macau */
    CTRY_MACEDONIA            = 807,     /* the Former Yugoslav Republic of Macedonia */
    CTRY_MALAYSIA             = 458,     /* Malaysia */
    CTRY_MALTA                = 470,     /* Malta */
    CTRY_MEXICO               = 484,     /* Mexico */
    CTRY_MONACO               = 492,     /* Principality of Monaco */
    CTRY_MOROCCO              = 504,     /* Morocco */
    CTRY_NEPAL                = 524,     /* Nepal */
    CTRY_NETHERLANDS          = 528,     /* Netherlands */
    CTRY_NETHERLANDS_ANTILLES = 530,     /* Netherlands-Antilles */
    CTRY_NEW_ZEALAND          = 554,     /* New Zealand */
    CTRY_NICARAGUA            = 558,     /* Nicaragua */
    CTRY_NORWAY               = 578,     /* Norway */
    CTRY_OMAN                 = 512,     /* Oman */
    CTRY_PAKISTAN             = 586,     /* Islamic Republic of Pakistan */
    CTRY_PANAMA               = 591,     /* Panama */
    CTRY_PAPUA_NEW_GUINEA     = 598,     /* Papua New Guinea */
    CTRY_PARAGUAY             = 600,     /* Paraguay */
    CTRY_PERU                 = 604,     /* Peru */
    CTRY_PHILIPPINES          = 608,     /* Republic of the Philippines */
    CTRY_POLAND               = 616,     /* Poland */
    CTRY_PORTUGAL             = 620,     /* Portugal */
    CTRY_PUERTO_RICO          = 630,     /* Puerto Rico */
    CTRY_QATAR                = 634,     /* Qatar */
    CTRY_ROMANIA              = 642,     /* Romania */
    CTRY_RUSSIA               = 643,     /* Russia */
    CTRY_SAUDI_ARABIA         = 682,     /* Saudi Arabia */
    CTRY_SERBIA_MONTENEGRO    = 891,     /* Serbia and Montenegro */
    CTRY_SINGAPORE            = 702,     /* Singapore */
    CTRY_SLOVAKIA             = 703,     /* Slovak Republic */
    CTRY_SLOVENIA             = 705,     /* Slovenia */
    CTRY_SOUTH_AFRICA         = 710,     /* South Africa */
    CTRY_SPAIN                = 724,     /* Spain */
    CTRY_SRI_LANKA            = 144,     /* Sri Lanka */
    CTRY_SWEDEN               = 752,     /* Sweden */
    CTRY_SWITZERLAND          = 756,     /* Switzerland */
    CTRY_SYRIA                = 760,     /* Syria */
    CTRY_TAIWAN               = 158,     /* Taiwan */
    CTRY_THAILAND             = 764,     /* Thailand */
    CTRY_TRINIDAD_Y_TOBAGO    = 780,     /* Trinidad y Tobago */
    CTRY_TUNISIA              = 788,     /* Tunisia */
    CTRY_TURKEY               = 792,     /* Turkey */
    CTRY_UAE                  = 784,     /* U.A.E. */
    CTRY_UKRAINE              = 804,     /* Ukraine */
    CTRY_UNITED_KINGDOM       = 826,     /* United Kingdom */
    CTRY_UNITED_STATES        = 840,     /* United States */
    CTRY_UNITED_STATES_FCC49  = 842,     /* United States (Public Safety)*/
    CTRY_URUGUAY              = 858,     /* Uruguay */
    CTRY_UZBEKISTAN           = 860,     /* Uzbekistan */
    CTRY_VENEZUELA            = 862,     /* Venezuela */
    CTRY_VIET_NAM             = 704,     /* Viet Nam */
    CTRY_YEMEN                = 887,     /* Yemen */
    CTRY_ZIMBABWE             = 716,     /* Zimbabwe */
	CTRY_EUROPEAN_UNION       = 900,	 /* Zcom add for European Union */

    /*
    ** Japan special codes.  Boy, do they have a lot
    */

    CTRY_JAPAN1               = 393,     /* Japan (JP1) */
    CTRY_JAPAN2               = 394,     /* Japan (JP0) */
    CTRY_JAPAN3               = 395,     /* Japan (JP1-1) */
    CTRY_JAPAN4               = 396,     /* Japan (JE1) */
    CTRY_JAPAN5               = 397,     /* Japan (JE2) */
    CTRY_JAPAN6               = 4006,    /* Japan (JP6) */
    CTRY_JAPAN7               = 4007,    /* Japan (J7) */
    CTRY_JAPAN8               = 4008,    /* Japan (J8) */
    CTRY_JAPAN9               = 4009,    /* Japan (J9) */
    CTRY_JAPAN10              = 4010,    /* Japan (J10) */
    CTRY_JAPAN11              = 4011,    /* Japan (J11) */
    CTRY_JAPAN12              = 4012,    /* Japan (J12) */
    CTRY_JAPAN13              = 4013,    /* Japan (J13) */
    CTRY_JAPAN14              = 4014,    /* Japan (J14) */
    CTRY_JAPAN15              = 4015,    /* Japan (J15) */
    CTRY_JAPAN16              = 4016,    /* Japan (J16) */
    CTRY_JAPAN17              = 4017,    /* Japan (J17) */
    CTRY_JAPAN18              = 4018,    /* Japan (J18) */
    CTRY_JAPAN19              = 4019,    /* Japan (J19) */
    CTRY_JAPAN20              = 4020,    /* Japan (J20) */
    CTRY_JAPAN21              = 4021,    /* Japan (J21) */
    CTRY_JAPAN22              = 4022,    /* Japan (J22) */
    CTRY_JAPAN23              = 4023,    /* Japan (J23) */
    CTRY_JAPAN24              = 4024,    /* Japan (J24) */
    CTRY_JAPAN25              = 4025,    /* Japan (J25) */
    CTRY_JAPAN26              = 4026,    /* Japan (J26) */
    CTRY_JAPAN27              = 4027,    /* Japan (J27) */
    CTRY_JAPAN28              = 4028,    /* Japan (J28) */
    CTRY_JAPAN29              = 4029,    /* Japan (J29) */
    CTRY_JAPAN30              = 4030,    /* Japan (J30) */
    CTRY_JAPAN31              = 4031,    /* Japan (J31) */
    CTRY_JAPAN32              = 4032,    /* Japan (J32) */
    CTRY_JAPAN33              = 4033,    /* Japan (J33) */
    CTRY_JAPAN34              = 4034,    /* Japan (J34) */
    CTRY_JAPAN35              = 4035,    /* Japan (J35) */
    CTRY_JAPAN36              = 4036,    /* Japan (J36) */
    CTRY_JAPAN37              = 4037,    /* Japan (J37) */
    CTRY_JAPAN38              = 4038,    /* Japan (J38) */
    CTRY_JAPAN39              = 4039,    /* Japan (J39) */
    CTRY_JAPAN40              = 4040,    /* Japan (J40) */
    CTRY_JAPAN41              = 4041,    /* Japan (J41) */
    CTRY_JAPAN42              = 4042,    /* Japan (J42) */
    CTRY_JAPAN43              = 4043,    /* Japan (J43) */
    CTRY_JAPAN44              = 4044,    /* Japan (J44) */
    CTRY_JAPAN45              = 4045,    /* Japan (J45) */
    CTRY_JAPAN46              = 4046,    /* Japan (J46) */
    CTRY_JAPAN47              = 4047,    /* Japan (J47) */
    CTRY_JAPAN48              = 4048,    /* Japan (J48) */
    CTRY_JAPAN49              = 4049,    /* Japan (J49) */
    CTRY_JAPAN50              = 4050,    /* Japan (J50) */
    CTRY_JAPAN51              = 4051,    /* Japan (J51) */
    CTRY_JAPAN52              = 4052,    /* Japan (J52) */
    CTRY_JAPAN53              = 4053,    /* Japan (J53) */
    CTRY_JAPAN54              = 4054,    /* Japan (J54) */
    CTRY_JAPAN55              = 4055,    /* Japan (J55) */
    CTRY_JAPAN56              = 4056,    /* Japan (J56) */
    CTRY_JAPAN57              = 4057,    /* Japan (J57) */
    CTRY_JAPAN58              = 4058,    /* Japan (J58) */
    CTRY_JAPAN59              = 4059,    /* Japan (J59) */

    /*
    ** "Special" codes for multiply defined countries, with the exception
    ** of Japan and US.
    */

    CTRY_AUSTRALIA2           = 5000,    /* Australia for AP only */
    CTRY_CANADA2              = 5001,    /* Canada for AP only */
    CTRY_BELGIUM2             = 5002     /* Belgium/Cisco implementation */    
} Country_t;


#define COUNTRY_NO_REGULATION_STR 		"No Regulation"
enum Zcom_Domain_t
{
	ZCOM_DOMAIN_NONE			= 0x0000,
	ZCOM_DOMAIN_DBG				= 0x01ff,
	ZCOM_DOMAIN_2G 				= 0x0100,
	ZCOM_DOMAIN_5G 				= 0x0200,
	ZCOM_DOMAIN_FCC				= 0x0010,
	ZCOM_DOMAIN_CE				= 0x0020,
	ZCOM_DOMAIN_5G_FCC 			= ZCOM_DOMAIN_5G | ZCOM_DOMAIN_FCC,
	ZCOM_DOMAIN_5G_CE			= ZCOM_DOMAIN_5G | ZCOM_DOMAIN_CE,
};

typedef enum PrivilegeType_t
{
	PRIVILEGE_NONE		= 0,
	PRIVILEGE_COMMON	= 2,
	PRIVILEGE_SUPER		= 3,
	PRIVILEGE_DEBUGER 	= 4,
} PrivilegeType_t;

//MIB_WLAN_CPE_TYPE
typedef enum StationMode_t
{
	CPE_TYPE_MULTICLI = 0,
	CPE_TYPE_LAN2LAN,
} StationMode_t;

///////////////////////////////////////////////////////////////////////////////
// Structure definitions
///////////////////////////////////////////////////////////////////////////////
//MIB_ETHERNET_STATS & MIB_WLAN_STATS
typedef	struct NetDeviceStats_t
{
	struct Stats_t
	{
		uint64_t	ullBytes;

		uint64_t	ullPacketsTotal;
		uint64_t	ullPacketsUnicast;
		uint64_t	ullPacketsMulticast;
		uint64_t	ullPacketsBroadcast;

		uint64_t	ulPacketsError;
		uint64_t	ulPacketsDropped;
	} Rx, Tx;
} NetDeviceStats_t;

typedef	struct
{
	int32_t			lindex;
	int32_t			dbm;
	uint32_t		channel;	
	uint32_t		wirelessmode;
	uint8_t			ssid[36];	//Max string length is 32 
	uint32_t		isWEP;
	char			bssid[18];
} ApScanList_t;


typedef	struct
{
#define VLAN_UPD_FLAG	0x10
#define VLAN_DEL_FLAG	0x20
	int32_t			lindex;
	uint16_t		usVlanID;
	uint16_t		uchPriority;
} VlanParams_t;

typedef struct dhcp_list_t
{
	char mac[6];
	uint32_t ipaddr;
	uint32_t expires;
} dhcp_list_t;

#define FIRMWARE_STATE_FILE		"/tmp/.firmware.stat"
enum FirmwareState_t
{
	FIRMWARE_STATE_UNKNOWN		= 0x00,
	FIRMWARE_STATE_VALID		= 0x03,
	FIRMWARE_STATE_INVALID		= 0x04,
	FIRMWARE_STATE_UPDATE_OK	= 0x05,
	FIRMWARE_STATE_UPDATE_FAIL	= 0x06,
};

enum ManagementPrivacyMode_t
{
	MGMT_PRIV_MODE_NORMAL		= 0,
	MGMT_PRIV_MODE_SECURE		= 1,
	MGMT_PRIV_MODE_COSTUMIZED	= 2,
};

#endif//!__WAG302DEF_H__
