/*
 *	wag302client.h
 */
#ifndef	__WAG302CLIENT_H__
#define	__WAG302CLIENT_H__

#include <string.h>

#include "wag302mib.h"
#include "wag302type.h"

///////////////////////////////////////////////////////////////////////////////
//	IPC setting routine
///////////////////////////////////////////////////////////////////////////////
//	
//	Note: uses the default, if not config IPC setting.
//	return CONF_RESULT_OK successfully, 
//	or CONF_RESULT_IPC_ERROR wrong IP or port.
//
#define	DEFAULT_CONFIG_SERVER	"127.0.0.1"
#define	DEFAULT_CONFIG_PORT		8800
ExchangeResult_t ConfigRemoteSetting(
	const char	*cszServerIP, 
	uint16_t	usPort
	);

///////////////////////////////////////////////////////////////////////////////
//	General Config Exchange routines
///////////////////////////////////////////////////////////////////////////////
typedef	void (*ExchangeInfoHook_t)(const char *cszInfo);

// return orignal Hook
ExchangeInfoHook_t ExchangeInfoHookSet(ExchangeInfoHook_t pHook);

ExchangeResult_t ConfigExchange(
	ExchangeRequestType_t	Request, 
	uint8_t		uchIndex,
	uint32_t	ulMIB,
	uint8_t		*pData,
	uint32_t	ulSndSize,
	uint32_t	ulRcvSize
	);

int	GetLastExchangeResponse(
	uint32_t ulMIB, 
	uint8_t *pData,
	uint32_t ulOffset,
	uint32_t ulSize
	);

//
// sometime the caller didn't know, how many buffer required.
// GetLastExchangeResponse is helpful.
//
//	Example: get association client list MIB_WLAN_ASSOCIATION_LIST
//
//	if (CONF_RESULT_DATA_TOO_SHORT==ConfigStructRead(0,
//		MIB_WLAN_ASSOCIATION_LIST, NULL, 0))
//	{
//		int	iSize = GetLastExchangeResponse(MIB_WLAN_ASSOCIATION_LIST, NULL, 0, 0);
//
//		if (iSize>0)
//		{
//			char	*szList = malloc(iSize);
//			if (NULL!=szList)
//			{
//				GetLastExchangeResponse(MIB_WLAN_ASSOCIATION_LIST, szList, 0, iSize);
//				//AddCode to decode association client list
//				free(szList);
//			}
//		}
//	}
//

ExchangeResult_t ConfigRequestFieldInfo(
	uint8_t		uchIndex,
	uint32_t	ulMIB,
	uint8_t		*pData,
	uint32_t	ulSize
	);

///////////////////////////////////////////////////////////////////////////////
//	Specific Config Exchange routines
///////////////////////////////////////////////////////////////////////////////
static __inline ExchangeResult_t ConfigReadInteger(
	uint8_t		uchIndex,
	uint32_t	ulMIB,
	uint32_t	*pulData
	)
{
	return ConfigExchange(
		CONF_REQUEST_READ,
		uchIndex,
		ulMIB,
		(uint8_t*)pulData,
		0,
		sizeof(uint32_t)
		);
}

static __inline ExchangeResult_t ConfigWriteInteger(
	uint8_t		uchIndex,
	uint32_t	ulMIB,
	uint32_t	ulData
	)
{
	uint32_t ulValue = ulData;
	return ConfigExchange(
		CONF_REQUEST_WRITE,
		uchIndex,
		ulMIB,
		(uint8_t*)&ulValue,
		sizeof(uint32_t),
		0
		);
}

#define	CONF_READ_STRING(INDEX, MIB, STRING)	\
	ConfigReadString(INDEX, MIB, STRING, sizeof(STRING))

#define	CONF_READ_STRING0(MIB, STRING)			\
	CONF_READ_STRING(0, MIB, STRING)

static __inline ExchangeResult_t ConfigReadString(
	uint8_t		uchIndex,
	uint32_t	ulMIB,
	char		*szString,
	uint32_t	ulSize
	)
{
	return ConfigExchange(
		CONF_REQUEST_READ,
		uchIndex,
		ulMIB,
		(uint8_t*)szString,
		0,
		ulSize
		);
}

static __inline ExchangeResult_t ConfigWriteString(
	uint8_t		uchIndex,
	uint32_t	ulMIB,
	char	*cszString
	)
{
	return ConfigExchange(
		CONF_REQUEST_WRITE,
		uchIndex,
		ulMIB,
		(uint8_t*)cszString,
		strlen(cszString)+1,
		0
		);
}

static __inline ExchangeResult_t ConfigRemoveString(
	uint8_t		uchIndex,
	uint32_t	ulMIB,
	char	*cszString
	)
{
	return ConfigExchange(
		CONF_REQUEST_REMOVE,
		uchIndex,
		ulMIB,
		(uint8_t*)cszString,
		(NULL!=cszString)?(strlen(cszString)+1):0,
		0
		);
}

static __inline ExchangeResult_t ConfigReadStruct(
	uint8_t		uchIndex,
	uint32_t	ulMIB,
	uint8_t		*pData,
	uint32_t	ulSize
	)
{
	return ConfigExchange(
		CONF_REQUEST_READ,
		uchIndex,
		ulMIB,
		pData,
		0,
		ulSize
		);
}

static __inline ExchangeResult_t ConfigWriteStruct(
	uint8_t		uchIndex,
	uint32_t	ulMIB,
	uint8_t		*pData,
	uint32_t	ulSize
	)
{
	return ConfigExchange(
		CONF_REQUEST_WRITE,
		uchIndex,
		ulMIB,
		pData,
		ulSize,
		0
		);
}

#endif//__WAG302CLIENT_H__
