 // linktest_msg.h
//

#ifndef	__LINKTESTMSG_H__
#define	__LINKTESTMSG_H__

#include <stdint.h>
#include "wag302type.h"

// TBD: Set LINKTEST_WDRV
// #define LINKTEST_WDRV		1			// Work in AP

#define	LINKTEST_LOOPBACK_PORT	8352		// UDP loop back port number		

// Unit: byte
#define LINKTEST_PKTSIZE_MIN	64
#define LINKTEST_PKTSIZE_MAX	1514
#define LINKTEST_PKTSIZE_DFT	LINKTEST_PKTSIZE_MIN

// Unit: millisecond
#define LINKTEST_INTERVAL_MIN	1			// 1 ms
#define LINKTEST_INTERVAL_MAX	(1000*60)	// 1 min
#define LINKTEST_INTERVAL_DFT	50			// Default: 50 ms

// Unit: second
#define LINKTEST_TESTTIME_MIN	60			// 1 min	
#define LINKTEST_TESTTIME_MAX	(3600*24)	// 24 hours
#define LINKTEST_TESTTIME_DFT	(60*5)		// Default: 5 min

#define LINKTEST_IFS_MAX		1	// 4			// Max. of interfaces
#define LINKTEST_LKS_MAX		1	//8			// Max. of links with a interface
#define LINKTEST_PKT_TYPE_MAX	4			// Max. of packet type numbers

#define SUPPORTED_RATE_NUMBER	29
#define LINKTEST_IDLE_SEC		8

#define	LEN_IFNAME				16

// Iterface name like "eth0, bridge0"
typedef char		IfName_t[16];

// Mac address like "00:E0:4C:E1:3F:8A"
typedef char 		MacStr_t[18];

// The definition of the command types (send to LinkTest)
typedef enum LinkTestState_t
{
	LINKTEST_STATE_FIRST		= 0x01,
	LINKTEST_STATE_START		= 0x01,		// Start LinkTest
	LINKTEST_STATE_STOP			= 0x02,		// Stop LinkTest
	LINKTEST_STATE_ALIGN_START	= 0x03,		// Start antenna alignment
	LINKTEST_STATE_ALIGN_STOP	= 0x04,		// Stop antenna alignment
	LINKTEST_STATE_BUSY   		= 0x0f,		// Test is Started as server
	LINKTEST_STATE_RESULT 		= 0x10, 	// Get result from LinkTest
	LINKTEST_STATE_LAST			= 0xff,
} LinkTestState_t;

// The definition of the role type of a link node
typedef enum LinkTestRoleType_t
{
	LINKTEST_ROLE_INIT			= 0x01,		// Initial Status
	LINKTEST_ROLE_CLIENT		= 0x02,		// Client: Send request
	LINKTEST_ROLE_SERVER		= 0x04,		// Server: Send response 
} LinkTestRoleType_t;

///////////////////////////////////////////////////////////////////////////////
// The definition of the command message (send to LinkTest)
///////////////////////////////////////////////////////////////////////////////
typedef struct LinkTestCmdMsg_t
{
	uint32_t			ulCmdType;			// Refer to LinkTestState_t
	uint32_t			ulRetCode;			// 0: OK, else: Error
	uint16_t			usLocalIfNum;		// Number of local interface to test
	MacAddr_t			LocalMac;			// Local Mac ,Olny support 1 First
	MacAddr_t			RemoteMac[LINKTEST_IFS_MAX];		  // Remote Mac(s) which you want to test
	uint32_t			ulCurrentRate;
	uint16_t			ulSupportRateNum;					  // Rate number < SUPPORTED_RATE_NUMBER
	uint32_t			ulSupportRate[SUPPORTED_RATE_NUMBER]; // 1*10^3 Kbps
	uint32_t			LocalWLANIfIndeces[LINKTEST_IFS_MAX]; 
} LinkTestCmdMsg_t;

///////////////////////////////////////////////////////////////////////////////
// The definition of the test result infomation
///////////////////////////////////////////////////////////////////////////////
typedef struct LinkTestResult_t
{
	uint16_t			usTestRole;			// for ECP
	uint8_t				uchPecent[LINKTEST_PKT_TYPE_MAX];			// 0100 the pecent of received packets
																// [0]-64 [1]-256 [2]-752 [3]-1472
	int8_t				chLocalRSSI;		// Unit: dbm
	int8_t				chRemoteRSSI;		// Unit: dbm
	uint32_t			ulLastRevTime[LINKTEST_PKT_TYPE_MAX];		// Last receive time for timeout
	uint32_t			ulLastSentPktCount[LINKTEST_PKT_TYPE_MAX];	// Request packets send last count
	uint32_t			ulSentPktCount[LINKTEST_PKT_TYPE_MAX];		// Request packets send count
	uint32_t			ulRecvPktCount[LINKTEST_PKT_TYPE_MAX];		// Response packets received count
} LinkTestResult_t;

///////////////////////////////////////////////////////////////////////////////
// The definition of the test result infomation
///////////////////////////////////////////////////////////////////////////////
typedef struct LinkTestLkResult_t
{
	MacAddr_t		 RemoteMac;									// Remote
	LinkTestResult_t Results[SUPPORTED_RATE_NUMBER];			// Refer to Rate index
}LinkTestLkResult_t;

///////////////////////////////////////////////////////////////////////////////
// The definition of the result infomation to return ( by interface )
///////////////////////////////////////////////////////////////////////////////
typedef struct LinkTestIfResult_t
{
	MacAddr_t			LocalMac;
	uint16_t			usIfStatus;			// Refer to LinkTestState_t
	uint16_t			usTestLinkNum;		// Number of links with the interface
	LinkTestLkResult_t	LinkResults[LINKTEST_LKS_MAX];			// Refer to RemoteMac Index 0 used
} LinkTestIfResult_t;

///////////////////////////////////////////////////////////////////////////////
// The definition of the whole result (return to configuration program)
///////////////////////////////////////////////////////////////////////////////
typedef struct LinkTestCmdRet_t
{
	uint16_t			usRetCode;			// 0: OK, else: Error
	uint16_t			usTestIfNum;		// Number of local interface	
	uint16_t			ulSupportRateNum;	// Rate number < SUPPORTED_RATE_NUMBER
	uint32_t			ulSupportRate[SUPPORTED_RATE_NUMBER];	// 1*10^3 Kbps
	LinkTestIfResult_t	IfResults[LINKTEST_IFS_MAX];			// Interface index
} LinkTestCmdRet_t;

// The definition of the errors occured in commands
typedef enum LinkTestErrType_t
{
	ERR_IFS_OVERFLOW		= 0x0001,		// Interface num overflow
	ERR_IFS_NOTEXIST		= 0x0002,		// Interface doesn't exist
	ERR_PKTSIZE_OVERFLOW	= 0x0004,		// PktSize overflow
	ERR_INTERVAL_OVERFLOW	= 0x0008,		// TestInterval overflow
	ERR_TESTTIME_OVERFLOW	= 0x0010,		// TestTime overflow
	ERR_CMDTYPE_UNKNOWN		= 0x0020,		// Undefined command type
	ERR_ENUM_LAST_VALUE		= 0x0040		// Program itself use only
} LinkTestErrType_t;

#endif // __LINKTESTMSG_H__
