/*
 *	dhcpd_msg.h
 */
#ifndef	__DHCPDMSG_H__
#define	__DHCPDMSG_H__

#include <stdint.h>
#include "wag302type.h"

// UDP loop back port number
#define	DHCPD_LOOPBACK_PORT		5555	// TBD

#define	DHCPD_EMPTY_IP		((IPAddr_t)0)

typedef	char DhcpdIfName_t[16];
typedef char HostName_t[16];

#ifndef __DHCPCMSG_H__
typedef	uint32_t IPAddr_t;
#endif

//typedef uint8_t MacAddr_t[6];

typedef enum DhcpdMsgType_t
{
	DHCPD_MSG_INVALID = 0,
	DHCPD_MSG_INTERFACE_CONFIG,
	DHCPD_MSG_INTERFACE_STATUS,
	DHCPD_MSG_INTERFACE_LIST,
	DHCPD_MSG_IP_LIST
} DhcpdMsgType_t;

typedef enum DhcpdConfigStatus_t
{
	DHCPD_CONFIG_DISABLE = 0,			// Disable DHCP Server
	DHCPD_CONFIG_ENABLE,				// Enable DHCP Server
	DHCPD_CONFIG_REMOVE,				// Remove Interface

	DHCPD_STATUS_DISABLE = 0,			// DHCP Server is disabled
	DHCPC_STATUS_ENABLE,				// DHCP Server is enabled
	DHCPD_STATUS_IF_OVERFLOW,			// Max interface number reached.
#define DHCPD_MAX_IP_NUM 255
	DHCPD_STATUS_IP_OVERFLOW,			// Max ip number reached.
	DHCPD_STATUS_IF_MISSED = 0x80000000	// Interface not found.
} DhcpdConfigStatus_t;

///////////////////////////////////////////////////////////////////////////////
// the definition of Config/Status Message
///////////////////////////////////////////////////////////////////////////////
typedef struct IPRange_t
{
	IPAddr_t		ulIPStart;
	IPAddr_t		ulIPEnd;
	IPAddr_t		ulNetmask;
	IPAddr_t		ulGateway;
} IPRange_t;

typedef	struct DhcpdIfSetting_t
{
	uint32_t		ulLeaseTime;
#define DHCPD_MAX_IP_RANGE 1
	IPRange_t 		IPRanges[DHCPD_MAX_IP_RANGE];

#define DHCPD_MAX_DNS_NUM 3
	IPAddr_t		ulDNSes[DHCPD_MAX_DNS_NUM];
#define DHCPD_MAX_WINS_NUM 3
	IPAddr_t		ulWINSes[DHCPD_MAX_WINS_NUM];
} DhcpdIfSetting_t;

typedef struct DhcpdMsgStatusReq_t
{
	uint32_t		ulMsgType;			// DHCPD_MSG_INTERFACE_STATUS
										// or DHCPD_MSG_INTERFACE_CONFIG
	DhcpdIfName_t	szIfName;
} DhcpdMsgStatusReq_t;

// Config request/response messages and Status response messages
typedef struct DhcpdMsgConfigStatus_t
{
	//DhcpdMsgStatusReq_t;				// include request info
	uint32_t		ulMsgType;			// DHCPD_MSG_INTERFACE_STATUS
										// or DHCPD_MSG_INTERFACE_CONFIG
	DhcpdIfName_t	szIfName;

	uint32_t			ulConfigStatus;	// refer to DhcpdConfigStatus_t
	DhcpdIfSetting_t	IfSetting;		// ignore when ulConfigStatus!=DHCPD_CONFIG_ENABLE
} DhcpdMsgConfigStatus_t;

///////////////////////////////////////////////////////////////////////////////
// the definition of Interface List Message
///////////////////////////////////////////////////////////////////////////////
typedef struct DhcpdMsgIfListReq_t
{
	uint32_t		ulMsgType;			// fixed: DHCPD_MSG_INTERFACE_LIST
} DhcpdMsgIfListReq_t;

typedef struct DhcpdMsgIfListResp_t
{
	//DhcpdMsgIfListReq_t;				// include request info
	uint32_t		ulMsgType;			// fixed: DHCPD_MSG_INTERFACE_LIST

	uint32_t		ulIfCount;			// count of szIfNames
#define	DHCPD_MAX_INTERFACE_NUM			16
	DhcpdIfName_t	szIfNames[DHCPD_MAX_INTERFACE_NUM];
} DhcpdMsgIfListResp_t;

///////////////////////////////////////////////////////////////////////////////
// the definition of IP List Message
///////////////////////////////////////////////////////////////////////////////
typedef enum DhcpdClientIPStatus_t
{
	DHCPD_CLIENT_IP_IF_MISSIED		= 0x00,
	DHCPD_CLIENT_IP_STATUS_FREE		= 0x01,
	DHCPD_CLIENT_IP_STATUS_RESERVED	= 0x02,
	DHCPD_CLIENT_IP_STATUS_ACKED	= 0x04,
	DHCPD_CLIENT_IP_STATUS_CLASH	= 0x08
} DhcpdClientIPStatus_t;

typedef struct DhcpdIPSetting_t
{
	IPAddr_t		ulIP;
	IPAddr_t		ulNetMask;
	IPAddr_t		ulGateway;
	IPAddr_t		ulDNSes[DHCPD_MAX_DNS_NUM];
	IPAddr_t		ulWINSes[DHCPD_MAX_WINS_NUM];
} DhcpdIPSetting_t;

typedef struct DhcpdIPInfo_t
{
	uint32_t		ulIPStatus;			// refer to DhcpdClientIPStatus_t	
	IPAddr_t 		ulIP;
#define	MAX_HOSTNAME_LEN	16
	char 			szHostName[MAX_HOSTNAME_LEN];	// friendly name
	MacAddr_t		MacAddress;			// Client Identifier
	uint32_t		ulLeaseStartTime;
	uint32_t		ulLeaseTime;
} DhcpdIPInfo_t;

typedef	struct DhcpdMsgIPListReq_t
{
	uint32_t		ulMsgType;			// fixed: DHCPD_MSG_IP_LIST
	DhcpdIfName_t	szIfName;
	uint32_t		ulRequestIPStatus;	// BITMAP
										// refer to DhcpdClientIPStatus_t
} DhcpdMsgIPListReq_t;

typedef	struct DhcpdMsgIPListResp_t
{
	//DhcpdMsgIPListReq_t;				// include request info
	uint32_t		ulMsgType;			// fixed: DHCPD_MSG_IP_LIST
	DhcpdIfName_t	szIfName;
	uint32_t		ulRequestIPStatus;	// BITMAP
	bool_t			fHaveMoreData;		// whether more data
	uint32_t		ulIPInfoCount;		// count of IPInfos
#define	DHCPD_MAX_IP_INFO_NUM	16
	DhcpdIPInfo_t	IPInfos[DHCPD_MAX_IP_INFO_NUM];
} DhcpdMsgIPListResp_t;

#endif//!__DHCPCMSG_H__
