/***************************************************************************
                          compatibility.h  -  description
                             -------------------
    begin                : Tue Apr 2 2002
    copyright            : (C) 2002 by Forrest
    email                : Team@ZCom.com.cn
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   Copyright (c) Nanjing Z-Com, Inc.                                     *
 *   http://www.zcom.com.cn                                                *
 *                                                                         *
 ***************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// define the base data type
/////////////////////////////////////////////////////////////////////////////
#if	!defined(__COMPATIBILITY_H__)
#include <linux/version.h>
      /* add1104 kanda */
#define	__COMPATIBILITY_H__


#define	COUNTOF(_A)			(sizeof(_A)/sizeof(_A[0]))

//Forrest: for a fixed size bool type
#define	FALSE	0
#define	TRUE	1
#define	False	0
#define	True	1

typedef	unsigned char	bool;
typedef	bool	BOOL;
typedef	bool	BOOLEAN;

typedef	unsigned char	BYTE;
typedef	unsigned short	WORD;
typedef	unsigned long	DWORD;

typedef	char	CHAR;
typedef	int		INT;
typedef char	INT8;
typedef	short	INT16;
typedef	long	INT32;
	
typedef	unsigned char		UCHAR;
typedef	unsigned int		UINT;
typedef	unsigned char		UINT8;
typedef	unsigned short		UINT16;
typedef	unsigned long		UINT32;	
typedef unsigned long long	UINT64;

typedef	char*			LPSTR;
typedef	const	char*	LPCSTR;

#define IN
#define OUT

#ifndef	OSTYPES_H //refer to porting/linux/include/ostypes.h
typedef	unsigned short      USHORT;
typedef	unsigned long       ULONG;	
typedef void				VOID;
#endif
typedef	unsigned char*    	PUCHAR;
typedef void*				PVOID;

#ifndef	NULL
#define NULL   				0x00000000
#endif

typedef	char		A_CHAR;
typedef char		A_INT8;
typedef char        A_RSSI;
typedef	short		A_INT16;
typedef	long		A_INT32;
typedef A_INT32     A_RSSI32;

typedef	UINT8		A_UCHAR;
typedef UINT8		A_UINT8;
typedef	UINT32		A_UINT;
typedef	UINT16	A_UINT16;
typedef	UINT32	A_UINT32;

typedef	BOOL		A_BOOL;
  							
typedef long long			A_INT64;
typedef unsigned long long	A_UINT64;
typedef A_UINT64            A_LONGSTATS;

typedef void*				FUNCPTR;

#define ERROR				(~0)

#define	IN					
#define	OUT					
#define	INOUT 					
#define LOCAL				//static

#ifndef	NULL
#define NULL				0x00000000
#endif

// Kernel compatibility defines, some common to David Hinds' PCMCIA package.
//   This is only in the support-all-kernels source code.
#if (LINUX_VERSION_CODE <= 0x20100)
  #ifndef __alpha__
    #define ioremap(a,b) \
    				(((a)<0x100000) ? (void *)((u_long)(a)) : vremap(a,b))
    #define iounmap(v) 										\
    				{															\
							if ((u_long)(v) > 0x100000) \
							{                           \
								vfree(v);                 \
							}                           \
						}
  #endif
#endif

#if LINUX_VERSION_CODE < 0x20138
  #define test_and_set_bit(val, addr) set_bit(val, addr)
  typedef long spinlock_t;
  #define SPIN_LOCK_UNLOCKED 0

  #define spin_lock(lock)
  #define spin_unlock(lock)
  #define spin_lock_irqsave(lock, flags)	save_flags(flags); cli();
  #define spin_unlock_irqrestore(lock, flags) restore_flags(flags);
#endif

#if LINUX_VERSION_CODE < 0x20155
	#define PCI_SUPPORT_VER1
#else
	#define PCI_SUPPORT_VER2
#endif

#if LINUX_VERSION_CODE < 0x20159
	#define dev_free_skb(skb) dev_kfree_skb (skb, FREE_WRITE);
#else  //incompatible changes should change the name.
	#define dev_free_skb(skb) dev_kfree_skb(skb);
#endif

#if ! defined(CAP_NET_ADMIN)
	#define capable(CAP_XXX) (suser())
#endif

#define virt_to_le32desc(addr)  cpu_to_le32(virt_to_bus(addr))
#define le32desc_to_virt(addr)  bus_to_virt(le32_to_cpu(addr))

#endif	//#if	!defined(__COMPATIBILITY_H__)


