/************************************************************************ */
/*                                                                        */
/*                                                                        */
/*           Copyright 1998 - 2001,                                       */
/*             Intoto, Inc, SANTACLARA, CA, USA                           */
/*                      ALL RIGHTS RESERVED                               */
/*                                                                        */
/*   Permission is hereby granted to licensees of Intoto,                 */
/*   Inc. products to use or abstract this computer program for the       */
/*   sole purpose of implementing a product based on                      */
/*   Intoto, Inc. products.No other rights to reproduce,                  */
/*   use,or disseminate this computer program, whether in part or in      */
/*   whole, are granted.                                                  */
/*                                                                        */
/*   Intoto, Inc. makes no representation or warranties                   */
/*   with respect to the performance of this computer program, and        */
/*   specifically disclaims any responsibility for any damages,           */
/*   special or consequential, connected with the use of this program.    */
/*                                                                        */
/************************************************************************ */

#ifndef _L2BR_GDF_H_
#define _L2BR_GDF_H_

       /*************************************************************
        *           BRIDGE -----  Global Data Structures            *
        *************************************************************/


/* General Usage MACROs  */

/*  Port States  */ 
#define L2BRIDGE_PORT_DISABLED_STATE         0x00
#define L2BRIDGE_PORT_LISTENING_STATE        0x01
#define L2BRIDGE_PORT_LEARNING_STATE         0x02
#define L2BRIDGE_PORT_FORWARD_STATE          0x03
#define L2BRIDGE_PORT_BLOCKING_STATE         0x04   

#define L2BRIDGE_DEFAULT_BRIDGE_PRIORITY   0x8000
#define L2BRIDGE_DEFAULT_PORT_PRIORITY       0x80
#define L2BRIDGE_DEFAULT_PORT_PATHCOST     100000

#define L2BRIDGE_ENABLE_ROUTES               0x01
#define L2BRIDGE_DISABLE_ROUTES              0x02
#define L2BRIDGE_INHERIT_ROUTES              0x03
#define L2BRIDGE_CONFIGURE_ROUTES            0x04

#define L2BRIDGE_CREATE_ALIAS                0x01
#define L2BRIDGE_DELETE_ALIAS                0x02
#define L2BRIDGE_MODIFY_ALIAS                0x03

#define MAX_BRIDGE_NAME_LEN                  16
#define MAX_BRIDGE_HASH_SIZE                 16
#define L2BRIDGE_MAC_ADDR_LEN                6
#define L2BRIDGE_TIMER_UPDATE_TIME           1  /* in secs for Bridge Layer */
#define L2BRIDGE_MIN_RECV_PKTLEN             60
#define L2BRIDGE_IP_ADDR_MASK_LEN            31

#define L2BRIDGE_IFADMIN_UP   IGW_IFADMIN_UP
#define L2BRIDGE_IFOPER_UP    IGW_IFOPER_UP

/* Commands  :  Bridge -> Bridge Interface */ 
#define L2BRIDGE_SET_IFCOMMAND_BASE                2000
#define L2BRIDGE_GET_IFCOMMAND_BASE                3000

   /* For Setting Iface Fields */
#define L2BRIDGE_SET_IFACE_OPFLAG            L2BRIDGE_SET_IFCOMMAND_BASE + 1
#define L2BRIDGE_SET_IFACE_BRPORT_FLAG       L2BRIDGE_SET_IFCOMMAND_BASE + 2
#define L2BRIDGE_RESET_IFACE_BRPORT_FLAG     L2BRIDGE_SET_IFCOMMAND_BASE + 3 
#define L2BRIDGE_SET_PROMISCUITY             L2BRIDGE_SET_IFCOMMAND_BASE + 4
#define L2BRIDGE_RESET_PROMISCUITY           L2BRIDGE_SET_IFCOMMAND_BASE + 5 
#define L2BRIDGE_SET_IFACE_MACADDR           L2BRIDGE_SET_IFCOMMAND_BASE + 6  
#define L2BRIDGE_SET_OPAQUEVAR               L2BRIDGE_SET_IFCOMMAND_BASE + 7

   /* For Getting Iface Fields */
#define L2BRIDGE_GET_IFACE_IFINDEX           L2BRIDGE_GET_IFCOMMAND_BASE + 1
#define L2BRIDGE_GET_IFACE_BRPORT_FLAG       L2BRIDGE_GET_IFCOMMAND_BASE + 2
#define L2BRIDGE_GET_IFACE_PORT_TYPE         L2BRIDGE_GET_IFCOMMAND_BASE + 3
#define L2BRIDGE_GET_IFACE_MACADDR           L2BRIDGE_GET_IFCOMMAND_BASE + 4
#define L2BRIDGE_GET_IFACE_IPADDR            L2BRIDGE_GET_IFCOMMAND_BASE + 5
#define L2BRIDGE_GET_IFACE_NETMASK           L2BRIDGE_GET_IFCOMMAND_BASE + 6
#define L2BRIDGE_GET_IFACE_BROADCAST         L2BRIDGE_GET_IFCOMMAND_BASE + 7
#define L2BRIDGE_GET_OPAQUEVAR               L2BRIDGE_GET_IFCOMMAND_BASE + 8

/* Commands  :  Bridge Interface -> Bridge  */ 
#define L2BRIDGE_SET_BRCOMMAND_BASE                4000
#define L2BRIDGE_GET_BRCOMMAND_BASE                5000

   /* For Getting Bridge Fields */
#define L2BRIDGE_GET_BRIDGE_ADMIN_STATUS     L2BRIDGE_GET_BRCOMMAND_BASE + 1
#define L2BRIDGE_GET_BRIDGE_OPER_STATUS      L2BRIDGE_GET_BRCOMMAND_BASE + 2
#define L2BRIDGE_GET_BRIDGE_PROMISC          L2BRIDGE_GET_BRCOMMAND_BASE + 3

/* Bridge Identifier */

typedef struct L2BridgeId_s
{
  T_UCHAR8   Prio[2];
  T_UCHAR8   Addr[6];
}L2BridgeId;

typedef T_UINT16  L2BrPortId;


/*  Bridge  Statistics  */
typedef struct L2BridgeStats_s
{
  T_CHAR8   BridgeName[MAX_BRIDGE_NAME_LEN+1];
  T_UINT32  ulFramesReceived;                             /* Frames Received  */
  T_UINT32  ulLargeDiscardInbound;         /* Large Discarded received frames */
  T_UINT32  ulDisabledDiscardInbound;   /* Disabled Discarded received frames */
  T_UINT32  ulSMBADiscardInbound;           /* SMBA Discarded received frames */
  T_UINT32  ulDiscardInbound;                   /*  Discarded received frames */
  T_UINT32  ulDMBAKickUps;                              /* DMBA Kicked frames */
  T_UINT32  ulDMUAKickUps;                              /* DMUA Kicked frames */
  T_UINT32  ulDMBARelayedFrames;                       /* DMBA Relayed frames */
  T_UINT32  ulDMUARelayedFrames;                       /* DMUA Relayed frames */
  T_UINT32  ulDisabledDiscardOutbound;       /* Disabled Discarded Out frames */
  T_UINT32  ulOutDiscards;                               /* Discards on Error */
} L2BridgeStats_t;

/*  Port  Statistics  */
typedef struct L2BridgePortStats_s
{
  T_CHAR8   BridgeName[MAX_BRIDGE_NAME_LEN+1];
  T_CHAR8   PortName[MAX_BRIDGE_NAME_LEN+1];              /* Port Name */
  T_UINT32  ulPortNumber;                      
  T_UINT32  ulFramesReceived;                             /* Frames Received  */
  T_UINT32  ulLargeDiscardInbound;         /* Large Discarded received frames */
  T_UINT32  ulDisabledDiscardInbound;   /* Disabled Discarded received frames */
  T_UINT32  ulSMBADiscardInbound;           /* SMBA Discarded received frames */
  T_UINT32  ulDiscardInbound;                   /*  Discarded received frames */
  T_UINT32  ulDMBAKickUps;                              /* DMBA Kicked frames */
  T_UINT32  ulDMUAKickUps;                              /* DMUA Kicked frames */
  T_UINT32  ulDMBARelayedFrames;                       /* DMBA Relayed frames */
  T_UINT32  ulDMUARelayedFrames;                       /* DMUA Relayed frames */
  T_UINT32  ulDisabledDiscardOutbound;       /* Disabled Discarded Out frames */
  T_UINT32  ulOutDiscards;                               /* Discards on Error */
} L2PortStats_t;

/* Port Information */
typedef struct L2BridgePortInfo_s
{
  T_CHAR8   PortName[MAX_BRIDGE_NAME_LEN+1];              /* Port Name */
  T_CHAR8   BridgeName[MAX_BRIDGE_NAME_LEN+1];            /* Bridge Name */
  T_BOOL8   bStaticPort;                                 /* Static or Dynamic */
  T_UINT32  ulPortNumber;                                      /* Port Number */
  T_UINT32  ulPortState;                                        /* Port State */
  T_UINT32  ulPortType;                                          /* Port Type */
/* STP */
#ifdef L2BRIDGE_STP_SUPPORT
  L2BrPortId  PortId;
  T_UINT32    ulPathCost;
  L2BridgeId  DesignatedRoot;
  T_UINT32    ulDesignatedCost;
  L2BridgeId  DesignatedBridge;
  L2BrPortId  DesignatedPort;
  T_BOOL8     bTopologyChangeAck;
  T_BOOL8     bConfigPending;
  T_UINT32    ulPriority;
#endif

} L2BridgePortInfo_t;

/*  Bridge  Information  */
typedef struct L2BridgeInfo_s
{
  T_CHAR8  BridgeName[MAX_BRIDGE_NAME_LEN+1];                  /* Bridge Name */
  T_UINT32 ulBridgeAddress;                              /* Bridge IP Address */
  T_UINT32 ulPortsCount;              /* No. of Ports attached to this bridge */
  T_UINT32 ulUpTime ;            /* When this bridge was made up -- not using */
  T_UINT32 ulFdbEntries ;                    /* No FDB Entries in this bridge */
  T_CHAR8  MacAddr[L2BRIDGE_MAC_ADDR_LEN];       /* MAC Address of the bridge */
  T_UINT32    ulAgeingTime;
  T_UINT32    IpAddr;                           /* Bridge IP Address */
  T_UINT32    NetMask;                                /* Net Mask */
  T_UINT32    BroadCast;                             /* BroadCast address */
  T_UINT32 bRipEnabled;  
  /* stp */

#ifdef L2BRIDGE_STP_SUPPORT
  T_UINT32    bStpEnabled;  
  T_UINT32    ulPriority;  
  L2BridgeId  DesignatedRoot;
  T_UINT32    ulRootPathCost;
  L2BrPortId  RootPort;
  T_UINT32    ulMaxAge;
  T_UINT32    ulHelloTime;
  T_UINT32    ulForwardDelay;
  L2BridgeId  BridgeId;
  T_UINT32    ulBridgeMaxAge;
  T_UINT32    ulBridgeHelloTime;
  T_UINT32    ulBridgeForwardDelay;
  T_BOOL8     bTopologyChangeDetected;
  T_BOOL8     bTopologyChange;
#endif /* STP SUPPORT */

#ifdef L2BRIDGE_ALIAS_SUPPORT 
   T_UINT32   bDynamicAliasIP;
   T_UINT32   ulAliasIpAddr;
   T_UINT32   ulAliasNetMask;
#endif

} L2BridgeInfo_t;              

/* FDB Entry Infomation */
typedef struct L2BridgeFDBInfo_s
{
   T_CHAR8   ucMacAddr[L2BRIDGE_MAC_ADDR_LEN];                 /* MAC Address */
   T_CHAR8   BridgeName[MAX_BRIDGE_NAME_LEN+1];                /* Bridge Name */
   T_CHAR8   PortName[MAX_BRIDGE_NAME_LEN+1];                    /* Port Name */
   T_BOOL8   bPortType;                                          /* Port Type */
   T_BOOL8   bSelf;                                                   /* Self */
   T_UINT32  ulAge;                                  /* Age of this FDB Entry */
   T_UINT32  ulHashValue;                       /* Hash Val of this FDB Entry */
}L2BridgeFDBInfo_t;

/* Intermediate structures for Http */ 
    
typedef struct PortName_s
{
  T_UINT32 bStatic;                        /* Flag indicates Port(old or new) */
  T_CHAR8 Name[MAX_BRIDGE_NAME_LEN + 1];                                              /* Port Name */
  struct PortName_s *pNext;                        /* Points to the Next port */
}PortName_t;

typedef struct L2BrFields_s
{
    T_CHAR8  BridgeName[16];                                   /* Bridge Name */
    T_UINT32 BridgeIpAddr;                               /* Bridge IP Address */
    T_UINT32 BridgeMask;                                          /* Net Mask */
    T_UINT32 BridgeBrCast;                               /* BroadCast address */
    T_UINT32 ulFdbEntries ;                  /* No FDB Entries in this bridge */
    PortName_t *AvailableList;                     /* List Of Ports available */
    PortName_t *SelectedList;                 /* List Of Ports in this bridge */
}L2BrFields_t;

    /******    Bridge Error Messages   *****/

typedef enum L2BridgeError
{
  L2BRIDGE_SUCCESS = 0,
  L2BRIDGE_NOSUCH_RECORD,
  L2BRIDGE_NOMORE_RECORD,
  L2BRIDGE_INPUT_ERROR,
  L2BRIDGE_DUPLICATE_RECORD,
  L2BRIDGE_SHORT_OF_RESOURCES,
  L2BRIDGE_NOROUTE_EXISTS, 
  L2BRIDGE_BRIDGE_NULL,
  L2BRIDGE_BRIDGE_NON_EXISTANT,
  L2BRIDGE_INVALID_BRIDGE_NAME,
  L2BRIDGE_NO_MORE_BRIDGES,
  L2BRIDGE_MAX_BRIDGES_EXCEEDED,
  L2BRIDGE_INVALID_IFACE,
  L2BRIDGE_INVALID_IFACE_TYPE,    
  L2BRIDGE_DUPLICATE_IFACE_ENTRY,
  L2BRIDGE_IFACE_ATTACH_FAILURE,
  L2BRIDGE_MAX_PORTS_EXCEEDED,
  L2BRIDGE_PORT_NULL,
  L2BRIDGE_PORT_NON_EXISTANT,
  L2BRIDGE_PORT_ALREADY_ATTACHED,
  L2BRIDGE_PORT_NOT_ATTACHED_TO_THIS_BRIDGE,
  L2BRIDGE_CALLOC_FAILURE,
  L2BRIDGE_ADDFDB_FAILURE,
  L2BRIDGE_MACADDRESS_NULL,
  L2BRIDGE_FDB_ENTRY_ALREADY_EXISTS,
  L2BRIDGE_FDB_ENTRY_NON_EXISTANT,
  L2BRIDGE_FDB_NON_EXISTANT, 
  L2BRIDGE_NOMORE_FDB_ENTRY_EXISTANT,
  L2BRIDGE_LOCAL_MACADDRESS,
  L2BRIDGE_NO_MATCH_FOR_MACADDRESS,
  L2BRIDGE_INVALID_NETMASK,
  L2BRIDGE_IP_ADDRESS_ALREADY_IN_USE,

  L2BRIDGE_PORT_ALREADY_ENABLED,
  L2BRIDGE_PORT_ALREADY_DISABLED,
  L2BRIDGE_BRIDGE_STP_DISABLED,
  L2BRIDGE_BRIDGE_STP_ENABLED,
  L2BRIDGE_BRIDGE_PRIORITY_TOOHIGH,
  L2BRIDGE_PORT_PRIORITY_TOOHIGH,
  L2BRIDGE_INVALID_PATHCOST,
  L2BRIDGE_BRIDGE_ADDING_BRIDGE_AS_PORT
}L2BridgeError_t;

#endif
