// os_mem.c
//

//
// Forrest: rewrite the system memory function,
// for tracing system memory leak, overlap or overflow
//

// TODO: Forrest, trace system memory leak, overlap or overflow

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "os_mem.h"

void *OsMemNew(uint32_t ulSize, bool_t fZero)
{
	void	*pMem = malloc(ulSize);
	if (NULL!=pMem && fZero)
	{
		memset(pMem, 0, ulSize);
	}
	return pMem;
}

void OsMemFree(void *pMem)
{
	if (NULL!=pMem)
	{
		free(pMem);
	}
}

void OsListFree(void *pList, void (*NodeClean)(void *pList))
{
	while (NULL!=pList)
	{
		void *pNext = *((void**)pList);
		if (NULL!=NodeClean)
		{
			NodeClean(pList);
		}
		OsMemFree(pList);
		pList = pNext;
	}
}

void OsTreeFree(void *pTree, void (*NodeClean)(void *pTree))
{
	while (NULL!=pTree)
	{
		void *pNext = *((void**)pTree);

		OsTreeFree(*((void**)pTree+1), NodeClean);	// free child
		if (NULL!=NodeClean)
		{
			NodeClean(pTree);
		}
		OsMemFree(pTree);
		pTree = pNext;
	}
}

char *OsStrdup(const char *cszStr, int32_t lLen)
{
	if (NULL!=cszStr)
	{
		uint32_t	ulSize = ((lLen<0)?strlen(cszStr):lLen)+1;
		char	*szDup = OsMemNew(ulSize, FALSE);
		if (NULL!=szDup)
		{
			memcpy(szDup, cszStr, ulSize);
			szDup[ulSize-1] = '\0';
		}
		return szDup;
	}
	return NULL;
}

int32_t	OsStrcasecmp(const char *cszStr1, const char *cszStr2)
{
#ifdef	WIN32
	return stricmp(cszStr1, cszStr2);
#else
	return strcasecmp(cszStr1, cszStr2);
#endif//!WIN32
}

int32_t	OsStrncasecmp(const char *cszStr1, const char *cszStr2, uint32_t ulSize)
{
#ifdef	WIN32
	return strnicmp(cszStr1, cszStr2, ulSize);
#else
	return strncasecmp(cszStr1, cszStr2, ulSize);
#endif//!WIN32
}

int32_t		OsStrToInt32(const char *cszString)
{
	return atoi(cszString);
}

uint32_t	OsStrToUint32(const char *cszString)
{
	return strtoul(cszString, NULL, 10);
}
