// os_getline.c
//

#include <string.h>

#include "os_mem.h"
#include "os_getline.h"

#define	BUF_STEP	32
int32_t OsGetLine(char **pszLine, int32_t *piSize, FILE *pStream)
{
	register int ch = 0;
	register int32_t	lRead = 0;

	do
	{
		switch (ch=fgetc(pStream))
		{
		case EOF:
			if (0==lRead)
			{
				return -1;
			}
			ch = 0;
			break;
		case '\r':
			continue;
		case '\n':
			ch = 0;
		default:
			break;
		}

		if (NULL==(*pszLine))
		{
			if (NULL==(*pszLine=(char*)OsMemNew(BUF_STEP, FALSE)))
			{
				return -1;
			}
			*piSize = BUF_STEP;
		}

		if (lRead>=(*piSize))
		{
			char *szLine = (char*)OsMemNew(*piSize + BUF_STEP, FALSE);
			if (NULL==szLine)
			{
				return -1;
			}
			memcpy(szLine, *pszLine, *piSize);
			OsMemFree(*pszLine);
			*pszLine = szLine;
			*piSize += BUF_STEP;
		}
		(*pszLine)[lRead++]= (char)ch;
	} while (0!=ch);
	return lRead;
}
