// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _PRE_TX_PHY_DESC_H_
#define _PRE_TX_PHY_DESC_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	chain_mask[3:0], paprd_chain_mask[7:4], bf_type[9:8], reserved_0a[10], implicit_bf[11], reserved_0b[14:12], dot11b_preamble_type[15], pkt_type[17:16], reserved_0c[20:18], res_for_bandwidth[22:21], res_ndp[23], reserved_0d[29:24], channel_capture[30], res_warm_tx[31]
//	1	tpc_init_pwr_cfg[2:0], dpd_enable[3], tx_pwr[10:4], clpc_en[11], measure_power[12], reserved_1[31:13]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_PRE_TX_PHY_DESC 2

struct pre_tx_phy_desc {
    volatile uint32_t chain_mask                      :  4, //[3:0]
                      paprd_chain_mask                :  4, //[7:4]
                      bf_type                         :  2, //[9:8]
                      reserved_0a                     :  1, //[10]
                      implicit_bf                     :  1, //[11]
                      reserved_0b                     :  3, //[14:12]
                      dot11b_preamble_type            :  1, //[15]
                      pkt_type                        :  2, //[17:16]
                      reserved_0c                     :  3, //[20:18]
                      res_for_bandwidth               :  2, //[22:21]
                      res_ndp                         :  1, //[23]
                      reserved_0d                     :  6, //[29:24]
                      channel_capture                 :  1, //[30]
                      res_warm_tx                     :  1; //[31]
    volatile uint32_t tpc_init_pwr_cfg                :  3, //[2:0]
                      dpd_enable                      :  1, //[3]
                      tx_pwr                          :  7, //[10:4]
                      clpc_en                         :  1, //[11]
                      measure_power                   :  1, //[12]
                      reserved_1                      : 19; //[31:13]
};

/*

chain_mask
			
			Chain mask to support up to 4 antennas. 
			
			<legal: 0-3>

paprd_chain_mask
			
			Chain mask for the PA predistortion function. 
			
			<legal: 0-3>  

bf_type
			
			<enum_typedef tx_phy_desc bf_type>
			
			<enum 0     NO_BF> Transmit a non-beamformed packet
			
			<enum 1     LEGACY_BF> Transmit a legacy beamformed
			packet.  This means beamforming starts at the L-STF.  The
			possible preamble formats are 11a, 11n mixed mode and 11ac. 
			This is used to support legacy implicit beamforming. 
			
			<enum 2     SU_BF> Transmit a single-user beamformed
			packet starting at the HT-STF or VHT-STF.
			
			<enum 3     MU_BF> Transmit a multi-user beamformed
			packet starting at the VHT-STF.
			
			<legal 0-3>

reserved_0a
			
			Reserved: <legal 0>

implicit_bf
			
			When this flag is set, the SVD module should perform
			implicit feedback computation on the next received packet.
			<legal 0-1>

reserved_0b
			
			Reserved: <legal 0>

dot11b_preamble_type
			
			Valid for 802.11b packets only.
			
			<enum_typedef tx_phy_desc dot11b_preamble_type>
			
			<enum 0     short_preamble>
			
			<enum 1     long_preamble>
			
			<legal 0-1>

pkt_type
			
			Packet type:
			
			<enum_typedef tx_phy_desc pkt_type>
			
			<enum 0     dot11a>
			
			<enum 1     dot11b>
			
			<enum 2     dot11n_mm>
			
			<enum 3     dot11ac>
			
			Note: HT Greenfield packet type is not supported
			
			<legal 0-3>

reserved_0c
			
			Reserved: <legal 0>

res_for_bandwidth
			
			Packet bandwidth:
			
			<enum_typedef tx_phy_desc bandwidth>
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Not supported
			
			<legal 0-2>

res_ndp
			
			Reserved for NDP flag. Field will be overwritten by TX
			PCU when generating the TX_PHY_DESC.
			
			<legal 0>

reserved_0d
			
			Reserved: <legal 0>

channel_capture
			
			Indicates that the BB should be armed to capture the
			channel on the next received packet. This channel estimate
			is passed to the MAC if the packet is successfully received.
			<legal 0-1>

res_warm_tx
			
			Field will be overwritten by TX PCU when generating the
			TX_PHY_DESC.
			
			
			
			Reserved_for warm_tx flag. <legal 0>

tpc_init_pwr_cfg
			
			Initial analog gain and PA configuration setting where 0
			has the highest power consumption and best EVM,  and 4 has
			the lowest power consumption and worst EVM <legal 0-4>

dpd_enable
			
			<enum 0     dpd_off> DPD profile not applied to current
			packet
			
			<enum 1     dpd_on> DPD profile applied to current
			packet if available
			
			<legal 0-1>

tx_pwr
			
			Transmit Power (signed value) in units of 0.5 dBm <legal
			all>

clpc_en
			
			This field enables closed-loop TPC operation by enabling
			CLPC adjustment of DAC gain for the next packet.
			
			<enum 0     clpc_off> TPC error update disabled
			
			<enum 1     clpc_on> TPC error will be applied to DAC
			gain setting for the next packet
			
			<legal 0-1>

measure_power
			
			This field enables the TPC to use power measurement for
			current packet in CLPC updates.
			
			<enum 0 measure_dis> TPC will not latch power
			measurement result for current packet
			
			<enum 1 measure_en> TPC will latch power measurement
			result for current packet

reserved_1
			
			Reserved<legal 0>
*/


/* Description		PRE_TX_PHY_DESC_0_CHAIN_MASK
			
			Chain mask to support up to 4 antennas. 
			
			<legal: 0-3>
*/
#define PRE_TX_PHY_DESC_0_CHAIN_MASK_OFFSET                          0x00000000
#define PRE_TX_PHY_DESC_0_CHAIN_MASK_LSB                             0
#define PRE_TX_PHY_DESC_0_CHAIN_MASK_MASK                            0x0000000f

/* Description		PRE_TX_PHY_DESC_0_PAPRD_CHAIN_MASK
			
			Chain mask for the PA predistortion function. 
			
			<legal: 0-3>  
*/
#define PRE_TX_PHY_DESC_0_PAPRD_CHAIN_MASK_OFFSET                    0x00000000
#define PRE_TX_PHY_DESC_0_PAPRD_CHAIN_MASK_LSB                       4
#define PRE_TX_PHY_DESC_0_PAPRD_CHAIN_MASK_MASK                      0x000000f0

/* Description		PRE_TX_PHY_DESC_0_BF_TYPE
			
			<enum_typedef tx_phy_desc bf_type>
			
			<enum 0     NO_BF> Transmit a non-beamformed packet
			
			<enum 1     LEGACY_BF> Transmit a legacy beamformed
			packet.  This means beamforming starts at the L-STF.  The
			possible preamble formats are 11a, 11n mixed mode and 11ac. 
			This is used to support legacy implicit beamforming. 
			
			<enum 2     SU_BF> Transmit a single-user beamformed
			packet starting at the HT-STF or VHT-STF.
			
			<enum 3     MU_BF> Transmit a multi-user beamformed
			packet starting at the VHT-STF.
			
			<legal 0-3>
*/
#define PRE_TX_PHY_DESC_0_BF_TYPE_OFFSET                             0x00000000
#define PRE_TX_PHY_DESC_0_BF_TYPE_LSB                                8
#define PRE_TX_PHY_DESC_0_BF_TYPE_MASK                               0x00000300

/* Description		PRE_TX_PHY_DESC_0_RESERVED_0A
			
			Reserved: <legal 0>
*/
#define PRE_TX_PHY_DESC_0_RESERVED_0A_OFFSET                         0x00000000
#define PRE_TX_PHY_DESC_0_RESERVED_0A_LSB                            10
#define PRE_TX_PHY_DESC_0_RESERVED_0A_MASK                           0x00000400

/* Description		PRE_TX_PHY_DESC_0_IMPLICIT_BF
			
			When this flag is set, the SVD module should perform
			implicit feedback computation on the next received packet.
			<legal 0-1>
*/
#define PRE_TX_PHY_DESC_0_IMPLICIT_BF_OFFSET                         0x00000000
#define PRE_TX_PHY_DESC_0_IMPLICIT_BF_LSB                            11
#define PRE_TX_PHY_DESC_0_IMPLICIT_BF_MASK                           0x00000800

/* Description		PRE_TX_PHY_DESC_0_RESERVED_0B
			
			Reserved: <legal 0>
*/
#define PRE_TX_PHY_DESC_0_RESERVED_0B_OFFSET                         0x00000000
#define PRE_TX_PHY_DESC_0_RESERVED_0B_LSB                            12
#define PRE_TX_PHY_DESC_0_RESERVED_0B_MASK                           0x00007000

/* Description		PRE_TX_PHY_DESC_0_DOT11B_PREAMBLE_TYPE
			
			Valid for 802.11b packets only.
			
			<enum_typedef tx_phy_desc dot11b_preamble_type>
			
			<enum 0     short_preamble>
			
			<enum 1     long_preamble>
			
			<legal 0-1>
*/
#define PRE_TX_PHY_DESC_0_DOT11B_PREAMBLE_TYPE_OFFSET                0x00000000
#define PRE_TX_PHY_DESC_0_DOT11B_PREAMBLE_TYPE_LSB                   15
#define PRE_TX_PHY_DESC_0_DOT11B_PREAMBLE_TYPE_MASK                  0x00008000

/* Description		PRE_TX_PHY_DESC_0_PKT_TYPE
			
			Packet type:
			
			<enum_typedef tx_phy_desc pkt_type>
			
			<enum 0     dot11a>
			
			<enum 1     dot11b>
			
			<enum 2     dot11n_mm>
			
			<enum 3     dot11ac>
			
			Note: HT Greenfield packet type is not supported
			
			<legal 0-3>
*/
#define PRE_TX_PHY_DESC_0_PKT_TYPE_OFFSET                            0x00000000
#define PRE_TX_PHY_DESC_0_PKT_TYPE_LSB                               16
#define PRE_TX_PHY_DESC_0_PKT_TYPE_MASK                              0x00030000

/* Description		PRE_TX_PHY_DESC_0_RESERVED_0C
			
			Reserved: <legal 0>
*/
#define PRE_TX_PHY_DESC_0_RESERVED_0C_OFFSET                         0x00000000
#define PRE_TX_PHY_DESC_0_RESERVED_0C_LSB                            18
#define PRE_TX_PHY_DESC_0_RESERVED_0C_MASK                           0x001c0000

/* Description		PRE_TX_PHY_DESC_0_RES_FOR_BANDWIDTH
			
			Packet bandwidth:
			
			<enum_typedef tx_phy_desc bandwidth>
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Not supported
			
			<legal 0-2>
*/
#define PRE_TX_PHY_DESC_0_RES_FOR_BANDWIDTH_OFFSET                   0x00000000
#define PRE_TX_PHY_DESC_0_RES_FOR_BANDWIDTH_LSB                      21
#define PRE_TX_PHY_DESC_0_RES_FOR_BANDWIDTH_MASK                     0x00600000

/* Description		PRE_TX_PHY_DESC_0_RES_NDP
			
			Reserved for NDP flag. Field will be overwritten by TX
			PCU when generating the TX_PHY_DESC.
			
			<legal 0>
*/
#define PRE_TX_PHY_DESC_0_RES_NDP_OFFSET                             0x00000000
#define PRE_TX_PHY_DESC_0_RES_NDP_LSB                                23
#define PRE_TX_PHY_DESC_0_RES_NDP_MASK                               0x00800000

/* Description		PRE_TX_PHY_DESC_0_RESERVED_0D
			
			Reserved: <legal 0>
*/
#define PRE_TX_PHY_DESC_0_RESERVED_0D_OFFSET                         0x00000000
#define PRE_TX_PHY_DESC_0_RESERVED_0D_LSB                            24
#define PRE_TX_PHY_DESC_0_RESERVED_0D_MASK                           0x3f000000

/* Description		PRE_TX_PHY_DESC_0_CHANNEL_CAPTURE
			
			Indicates that the BB should be armed to capture the
			channel on the next received packet. This channel estimate
			is passed to the MAC if the packet is successfully received.
			<legal 0-1>
*/
#define PRE_TX_PHY_DESC_0_CHANNEL_CAPTURE_OFFSET                     0x00000000
#define PRE_TX_PHY_DESC_0_CHANNEL_CAPTURE_LSB                        30
#define PRE_TX_PHY_DESC_0_CHANNEL_CAPTURE_MASK                       0x40000000

/* Description		PRE_TX_PHY_DESC_0_RES_WARM_TX
			
			Field will be overwritten by TX PCU when generating the
			TX_PHY_DESC.
			
			
			
			Reserved_for warm_tx flag. <legal 0>
*/
#define PRE_TX_PHY_DESC_0_RES_WARM_TX_OFFSET                         0x00000000
#define PRE_TX_PHY_DESC_0_RES_WARM_TX_LSB                            31
#define PRE_TX_PHY_DESC_0_RES_WARM_TX_MASK                           0x80000000

/* Description		PRE_TX_PHY_DESC_1_TPC_INIT_PWR_CFG
			
			Initial analog gain and PA configuration setting where 0
			has the highest power consumption and best EVM,  and 4 has
			the lowest power consumption and worst EVM <legal 0-4>
*/
#define PRE_TX_PHY_DESC_1_TPC_INIT_PWR_CFG_OFFSET                    0x00000004
#define PRE_TX_PHY_DESC_1_TPC_INIT_PWR_CFG_LSB                       0
#define PRE_TX_PHY_DESC_1_TPC_INIT_PWR_CFG_MASK                      0x00000007

/* Description		PRE_TX_PHY_DESC_1_DPD_ENABLE
			
			<enum 0     dpd_off> DPD profile not applied to current
			packet
			
			<enum 1     dpd_on> DPD profile applied to current
			packet if available
			
			<legal 0-1>
*/
#define PRE_TX_PHY_DESC_1_DPD_ENABLE_OFFSET                          0x00000004
#define PRE_TX_PHY_DESC_1_DPD_ENABLE_LSB                             3
#define PRE_TX_PHY_DESC_1_DPD_ENABLE_MASK                            0x00000008

/* Description		PRE_TX_PHY_DESC_1_TX_PWR
			
			Transmit Power (signed value) in units of 0.5 dBm <legal
			all>
*/
#define PRE_TX_PHY_DESC_1_TX_PWR_OFFSET                              0x00000004
#define PRE_TX_PHY_DESC_1_TX_PWR_LSB                                 4
#define PRE_TX_PHY_DESC_1_TX_PWR_MASK                                0x000007f0

/* Description		PRE_TX_PHY_DESC_1_CLPC_EN
			
			This field enables closed-loop TPC operation by enabling
			CLPC adjustment of DAC gain for the next packet.
			
			<enum 0     clpc_off> TPC error update disabled
			
			<enum 1     clpc_on> TPC error will be applied to DAC
			gain setting for the next packet
			
			<legal 0-1>
*/
#define PRE_TX_PHY_DESC_1_CLPC_EN_OFFSET                             0x00000004
#define PRE_TX_PHY_DESC_1_CLPC_EN_LSB                                11
#define PRE_TX_PHY_DESC_1_CLPC_EN_MASK                               0x00000800

/* Description		PRE_TX_PHY_DESC_1_MEASURE_POWER
			
			This field enables the TPC to use power measurement for
			current packet in CLPC updates.
			
			<enum 0 measure_dis> TPC will not latch power
			measurement result for current packet
			
			<enum 1 measure_en> TPC will latch power measurement
			result for current packet
*/
#define PRE_TX_PHY_DESC_1_MEASURE_POWER_OFFSET                       0x00000004
#define PRE_TX_PHY_DESC_1_MEASURE_POWER_LSB                          12
#define PRE_TX_PHY_DESC_1_MEASURE_POWER_MASK                         0x00001000

/* Description		PRE_TX_PHY_DESC_1_RESERVED_1
			
			Reserved<legal 0>
*/
#define PRE_TX_PHY_DESC_1_RESERVED_1_OFFSET                          0x00000004
#define PRE_TX_PHY_DESC_1_RESERVED_1_LSB                             13
#define PRE_TX_PHY_DESC_1_RESERVED_1_MASK                            0xffffe000


#endif // _PRE_TX_PHY_DESC_H_
