// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _MSDU_LINK_H_
#define _MSDU_LINK_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	next_msdu_index[15:0], encap_type[16], wds[17], reserved_0a[31:18]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_MSDU_LINK 1

struct msdu_link {
    volatile uint32_t next_msdu_index                 : 16, //[15:0]
                      encap_type                      :  1, //[16]
                      wds                             :  1, //[17]
                      reserved_0a                     : 14; //[31:18]
};

/*

next_msdu_index
			
			The  index of the next MSDU frame  that is part of this
			A-MSDU.
			
			Value: 0x0 represents the NULL pointer.  <legal all>

encap_type
			
			Indicates the encapsulation that HW will perform:
			
			0: RAW: no encapsulation
			
			1: Native WiFi
			
			2: Ethernet 2 (DIX)
			
			3: 802.3 (uses SNAP/LLC)
			
			Used by the OLE during encapsulation.
			
			
			

wds
			
			The bit is only evaluated when this MSDU is the first
			MSDU in an MPDU. For other MSDUs this bit setting is
			ignored.
			
			
			
			If set the current packet is 4-address frame.  Required
			because an aggregate can include some frames with 3 address
			format and other frames with 4 address format.  
			
			Used by the OLE during encapsulation.  
			
			<legal all>

reserved_0a
			
			<legal 0>
*/


/* Description		MSDU_LINK_0_NEXT_MSDU_INDEX
			
			The  index of the next MSDU frame  that is part of this
			A-MSDU.
			
			Value: 0x0 represents the NULL pointer.  <legal all>
*/
#define MSDU_LINK_0_NEXT_MSDU_INDEX_OFFSET                           0x00000000
#define MSDU_LINK_0_NEXT_MSDU_INDEX_LSB                              0
#define MSDU_LINK_0_NEXT_MSDU_INDEX_MASK                             0x0000ffff

/* Description		MSDU_LINK_0_ENCAP_TYPE
			
			Indicates the encapsulation that HW will perform:
			
			0: RAW: no encapsulation
			
			1: Native WiFi
			
			2: Ethernet 2 (DIX)
			
			3: 802.3 (uses SNAP/LLC)
			
			Used by the OLE during encapsulation.
			
			
			
*/
#define MSDU_LINK_0_ENCAP_TYPE_OFFSET                                0x00000000
#define MSDU_LINK_0_ENCAP_TYPE_LSB                                   16
#define MSDU_LINK_0_ENCAP_TYPE_MASK                                  0x00010000

/* Description		MSDU_LINK_0_WDS
			
			The bit is only evaluated when this MSDU is the first
			MSDU in an MPDU. For other MSDUs this bit setting is
			ignored.
			
			
			
			If set the current packet is 4-address frame.  Required
			because an aggregate can include some frames with 3 address
			format and other frames with 4 address format.  
			
			Used by the OLE during encapsulation.  
			
			<legal all>
*/
#define MSDU_LINK_0_WDS_OFFSET                                       0x00000000
#define MSDU_LINK_0_WDS_LSB                                          17
#define MSDU_LINK_0_WDS_MASK                                         0x00020000

/* Description		MSDU_LINK_0_RESERVED_0A
			
			<legal 0>
*/
#define MSDU_LINK_0_RESERVED_0A_OFFSET                               0x00000000
#define MSDU_LINK_0_RESERVED_0A_LSB                                  18
#define MSDU_LINK_0_RESERVED_0A_MASK                                 0xfffc0000


#endif // _MSDU_LINK_H_
