/*
 *  StatusInfo MIB group implementation - statusInfo.c
 *
 */

#include <config.h>
#include <stdio.h>

#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#if HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <sys/types.h>
#if HAVE_WINSOCK_H
#include <winsock.h>
#endif

# if HAVE_SYS_TIME_H
#  include <sys/time.h>
#endif

#include <ctype.h>
#if HAVE_UTSNAME_H
#include <utsname.h>
#else
#if HAVE_SYS_UTSNAME_H
#include <sys/utsname.h>
#endif
#endif
#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#if HAVE_DMALLOC_H
#include <dmalloc.h>
#endif

/* mibincl.h contains all the snmp specific headers to define the
   return types and various defines and structures. */
#include "mibincl.h"

/* header_generic() comes from here */
#include "util_funcs.h"

#include "agent_read_config.h"

#include "read_config.h"

/* include our .h file */
#include "statusInfo.h"

#include <linux/wireless.h>
//////////////////////Yichun Nov 17 2005////////////////////////////////////////////

#define FW_VERSION      fwVersion
#include "../../../../goahead-2.1.1/LINUX/apmib.h"
#include "../../../../goahead-2.1.1/LINUX/mibtbl.h"
#include "../../../../goahead-2.1.1/LINUX/utility.h"
/////////////////////////////////////////////////////////////

 /*********************
         *
         *  Kernel & interface information,
         *   and internal forward declarations
         *
         *********************/



	/*********************
	 *
	 *  Initialisation & common implementation functions
	 *
	 *********************/

/* define the structure we're going to ask the agent to register our
   information at */
struct variable2 statusInfo_variables[] = {
    {connectedToSSID, ASN_OCTET_STR, RONLY, var_statusInfo, 1, {1}},
    {usingChannel, ASN_INTEGER , RONLY,  var_statusInfo, 1, {2}},
    {accessPointMACAddress, ASN_OCTET_STR, RONLY, var_statusInfo, 1, {3}},
    {currentTransmissionRate, ASN_INTEGER, RONLY,  var_statusInfo , 1,  {4}},
    {currentSNR, ASN_INTEGER, RONLY, var_statusInfo, 1, {5}},
    {currentRSL, ASN_INTEGER, RONLY,  var_statusInfo, 1, {6}},
    {NoiseLevel, ASN_INTEGER, RONLY, var_statusInfo, 1,  {7}},
    {clientBridgeMACAddress, ASN_OCTET_STR, RONLY, var_statusInfo, 1, {8}},
    {currentIPAddress, ASN_IPADDRESS, RONLY, var_statusInfo, 1, {9}},
    {linkUpIndicator, ASN_INTEGER, RONLY, var_statusInfo, 1, {10}},
    {firmwareVersion, ASN_OCTET_STR, RONLY, var_statusInfo, 1, {11}}
//    {stationPhysAddress, ASN_OCTET_STR, RONLY, var_stationEntry, 3, {12,1,1}}
};

/* Define the OID pointer to the top of the mib tree that we're
   registering underneath */
oid statusInfo_variables_oid[] = { 1,3,6,1,4,1,14125,1 };


void init_statusInfo(void)
{
/* register ourselves with the agent to handle our mib tree */
  REGISTER_MIB("senaoMIB/statusInfo", statusInfo_variables, variable2, statusInfo_variables_oid);
}

        /*********************
         *
         *  System specific implementation functions
         *

         *********************/
/***********************************************************/
static void translate_control_code(char *buffer)
{
        char tmpBuf[200], *p1 = buffer, *p2 = tmpBuf;
                                                                                                                             
        while (*p1) {
                if (*p1 == '"') {
                        memcpy(p2, "&quot;", 6);
                        p2 += 6;
                }
                else
                        *p2++ = *p1;
                p1++;
        }
        *p2 = '\0';
                                                                                                                             
        strcpy(buffer, tmpBuf);
}
//////////////////////////////////////////////////////////////////////////////////////////////////

u_char  *
var_statusInfo(struct variable *vp,
           oid *name,
           size_t *length,
           int exact,
           size_t *var_len,
           WriteMethod **write_method)
{
  
    unsigned char buffer[500]; 
    int i,val,intval; 
    float NF,SNR,signal,noise;
    unsigned char *fwVersion="v1.41.03";  // referred by fmget.c
    int wlan_idx=0; // interface index
    char WLAN_IF[20];
    unsigned char  *pMibTbl;
    bss_info bss;

    if (header_generic(vp, name, length, exact, var_len, write_method) == MATCH_FAILED )
        return NULL;    

///////////////////YiChun Dec 13  2005/////////////////////////////////////////
    if ( !apmib_init()) {
                        printf("Initialize AP MIB failed!\n");
                        return 0;
                }   

//	printf("Initialize AP MIB success!\n");                                                                                            
///////////////////////////////////////////////////////////////////////////////
    switch (vp->magic)
    {
        case connectedToSSID:
            apmib_get( MIB_WLAN_MODE, (void *)&val);
            if (val == CLIENT_MODE)
            {
                   strcpy(WLAN_IF,"wlan0");
                   if( getWlBssInfo(WLAN_IF, &bss) < 0)
                        return 0;
                        if(bss.ssid){
                                sprintf(buffer, "%s", bss.ssid);
                        //        printf("bss.ssid 1 = %s\n",buffer);
                                *var_len = strlen(bss.ssid);
                        //        printf("bss.ssid 2  = %s\n",buffer);
              //                  return (u_char*)buffer;
                        }
            }
            else if(val == AP_MODE || val == AP_WDS_MODE)
            {
                    if( !apmib_get( MIB_WLAN_SSID,  (void *)buffer) ){
                        printf("get SSID failed\n");
                        return 0;
                    }
                    translate_control_code(buffer);
                    *var_len = strlen(buffer);
               //     printf("ap ssid = %s\n",buffer);
            //        return(u_char *)buffer;
            }
	    else{
		    buffer[0] = 0;
	    }
            return(u_char *)buffer;
                                                                                                                                         		 
        case usingChannel:
            strcpy(WLAN_IF,"wlan0");
            if ( getWlBssInfo(WLAN_IF, &bss) < 0)
                 return 0;
                 if (bss.channel){
 //                     sprintf(buffer, "%d", bss.channel);
                 //       printf("client channel = %d\n",bss.channel);
                        long_return = bss.channel;
                 }
                 else{
                        buffer[0] = '\0';
                        long_return = buffer;
                 }
                 return(u_char*)&long_return;

        case accessPointMACAddress:  
            apmib_get( MIB_WLAN_MODE, (void *)&val);
            if( val == CLIENT_MODE )
                return 0;
            else if(val == AP_MODE || val == AP_WDS_MODE) {
	    	    pMibTbl = &pHwSetting->wlan[wlan_idx].macAddr;
//                  for(i=0;i<6;i++){
//                  printf("%x.",pMibTbl[i]);
             //     sprintf(*(buffer+i),"%x",*(pMibTbl+i));
//                  buffer[i]=pMibTbl[i];
//	            printf("\n");
//                  printf("mac = %s \n",buffer); 
            	    *var_len = 6;
            	    if( pMibTbl!=NULL ){
//                      printf("macAddr 1 = %2x \n",buffer);
           	   	return (u_char*) pMibTbl;   
            	    }
	    }

        case currentTransmissionRate:
            apmib_get( MIB_WLAN_MODE, (void *)&val);
            if( val == CLIENT_MODE )
                return 0;
	    else if(val == AP_MODE || val == AP_WDS_MODE)
	    {
	          apmib_get( MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val);
	          if( val == 0){ 
	          
	              if ( !apmib_get( MIB_WLAN_FIX_RATE, (void *)&intval) )
                          return 0;
	//	sprintf(buffer, "%d", (int)val);
//                printf("rate = %d\n",val); 
	                 if(intval == 1)
			    long_return = 1;
			else if(intval == 2)
			    long_return = 2;
			 else if(intval == 4)
			    long_return = 5.5;
			 else if(intval == 8)
			    long_return = 11;
			 else if(intval == 16)
			    long_return = 6;
			 else if(intval == 32)
			    long_return = 9;
			 else if(intval == 64)
			    long_return = 12;
			 else if(intval == 128)
			    long_return = 18;
			 else if(intval == 256)
			    long_return = 24;
			 else if(intval == 512)
			    long_return = 36;
			 else if(intval == 1024)
			    long_return = 48;
			 else if(intval == 2048)
			    long_return = 54;
			 else
			    long_return = 0;
	    }  // fix rate
	    else if( val == 1 ){  //auto rate
				printf("auto rate!\n"); 
	    			long_return = 0;
	    }
      } //ap mode		    			
      return (u_char*)&long_return;
       
	case currentSNR:
            apmib_get( MIB_WLAN_MODE, (void *)&val);
            if( val == CLIENT_MODE )
            {
                strcpy(WLAN_IF,"wlan0");
                if ( getWlBssInfo(WLAN_IF, &bss) < 0){
                        printf("UpIndicator failed!\n");
                        return 0;
                }
                switch (bss.state) {
                    case STATE_DISABLED:
                    //    pMsg = "Disabled";
                          printf("Disabled\n");
                          long_return = 0;
                          break;
                    case STATE_IDLE:
                    //    pMsg = T("Idle");
                          printf("Idle\n");
                          long_return = 0;
                          break;
                    case STATE_STARTED:
                   //     pMsg = T("Started");
                          printf("Started\n");
                          long_return = 0;
                          break;
                    case STATE_CONNECTED:
                  //      pMsg = T("Connected");
                          printf("Connected\n");
                          if ( getWlBssInfo(WLAN_IF, &bss) < 0) {
                               printf("Get bssinfo failed!");
                               return 0;
                          }
                          signal = -90.0 + (0.6*bss.rssi); // signal units=(dBm)
                          if( -40.0 < signal  )
                                   noise = -80.0; // noise units=(dBm)
                          else if( -50.0 < signal )
                                   noise = -85.0;
                          else if( -60.0 < signal  )
                                   noise = -92.0;
                          else if( -90.0 < signal  )
                                   noise = -93.5;
			  else
				   noise = 0;

			  SNR = signal-noise;  //SNR units=(dB)
	//		  printf("SNR = %f\n",SNR);
			  long_return = SNR;   

/*			  if( getWlqualityInfo(WLAN_IF, &iw) < 0) {
				printf("get SNR failed\n");
				return 0;
			  }
			  printf("SNR = %d\n",iw.qual);
			  long_return = iw.qual;
*/
                          break;
                    case STATE_WAITFORKEY:
                 //       pMsg = T("Waiting for keys");
                          printf("Waiting for keys\n");
                          long_return = 0;
                          break;
                    case STATE_SCANNING:
                 //       pMsg = T("Scanning");
                          printf("Scanning\n");
                          long_return = 0;
                          break;
                    default:
                  //      pMsg =NULL;
                          printf("NULL\n");
//                        long_return = NULL;
                    }
                    return (u_char*)&long_return;
            }
            else if(val == AP_MODE || val == AP_WDS_MODE)
                    return 0;

        case currentRSL:
	    apmib_get( MIB_WLAN_MODE, (void *)&val);
            if( val == CLIENT_MODE )
            {
		strcpy(WLAN_IF,"wlan0");
                if ( getWlBssInfo(WLAN_IF, &bss) < 0){
                        printf("UpIndicator failed!\n");
                        return 0;
                }
                switch (bss.state) {
                    case STATE_DISABLED:
                    //    pMsg = "Disabled";
                          printf("Disabled\n");
                          long_return = 0;
                          break;
                    case STATE_IDLE:
                    //    pMsg = T("Idle");
                          printf("Idle\n");
                          long_return = 0;
                          break;
                    case STATE_STARTED:
                   //     pMsg = T("Started");
                          printf("Started\n");
                          long_return = 0;
                          break;
                    case STATE_CONNECTED:
                  //      pMsg = T("Connected");
                          printf("Connected\n");
			  if ( getWlBssInfo(WLAN_IF, &bss) < 0) {
               		       printf("Get bssinfo failed!");
                	       return 0;
        		  }
	//		  printf("rssi = %d\n",bss.rssi);
                          signal = -90.0 + (0.6*bss.rssi); // signal units=(dBm)
	//		  printf("signal=%f\n",signal);
			  long_return = signal;

/*			  if( getWlqualityInfo(WLAN_IF, &iw) < 0) {
				printf("get level failed\n");
				return 0;
			  }
			  printf("level = %d\n",iw.level);
			  long_return = iw.level; 
*/
                          break;
                    case STATE_WAITFORKEY:
                 //       pMsg = T("Waiting for keys");
                          printf("Waiting for keys\n");
                          long_return = 0;
                          break;
                    case STATE_SCANNING:
                 //       pMsg = T("Scanning");
                          printf("Scanning\n");
                          long_return = 0;
                          break;
                    default:
                  //      pMsg =NULL;
                          printf("NULL\n");
//                        long_return = NULL;
                    }
                    return (u_char*)&long_return;
            }
	    else if(val == AP_MODE || val == AP_WDS_MODE)
		    return 0;

	case NoiseLevel:
            apmib_get( MIB_WLAN_MODE, (void *)&val);
            if( val == CLIENT_MODE )
            {
		strcpy(WLAN_IF,"wlan0");
                if ( getWlBssInfo(WLAN_IF, &bss) < 0){
                        printf("UpIndicator failed!\n");
                        return 0;
                }
                switch (bss.state) {
                    case STATE_DISABLED:
                    //    pMsg = "Disabled";
                          printf("Disabled\n");
                          long_return = 0;
                          break;
                    case STATE_IDLE:
                    //    pMsg = T("Idle");
                          printf("Idle\n");
                          long_return = 0;
                          break;
                    case STATE_STARTED:
                   //     pMsg = T("Started");
                          printf("Started\n");
                          long_return = 0;
                          break;
                    case STATE_CONNECTED:
                  //      pMsg = T("Connected");
                          printf("Connected\n");
                          if ( getWlBssInfo(WLAN_IF, &bss) < 0) {
                               printf("Get bssinfo failed!");
                               return 0;
                          }
                          signal = -90.0 + (0.6*bss.rssi); // signal units=(dBm)

                          if( -40.0 < signal )
			           noise = -80; // noise units=(dBm)
                          else if( -50.0 < signal )
			           noise = -85; 
			  else if( -60.0 < signal )
				   noise = -92;
			  else if( -90.0 < signal )
				   noise = -93.5;
                          else 
                               noise = 0;
			
	//		  printf("noise = %2.5f\n", noise);
			  long_return = noise;                         	

/*			  if( getWlqualityInfo(WLAN_IF, &iw) < 0) {
				printf("get noise failed\n");
				return 0;
			  }
			  printf("noise = %d\n",iw.noise);
			  long_return = iw.noise; 
*/
                          break;
                    case STATE_WAITFORKEY:
                 //       pMsg = T("Waiting for keys");
                          printf("Waiting for keys\n");
                          long_return = 0;
                          break;
                    case STATE_SCANNING:
                 //       pMsg = T("Scanning");
                          printf("Scanning\n");
                          long_return = 0;
                          break;
                    default:
                  //      pMsg =NULL;
                          printf("NULL\n");
//                        long_return = NULL;
                    }
                    return (u_char*)&long_return;

	    }
            else if(val == AP_MODE || val == AP_WDS_MODE)
                    return 0;

	case clientBridgeMACAddress:
            apmib_get( MIB_WLAN_MODE, (void *)&val);
            if( val == CLIENT_MODE )
            {
                pMibTbl = &pHwSetting->wlan[wlan_idx].macAddr;
                *var_len = 6;
                if( pMibTbl!=NULL ){
//                  printf("macAddr 1 = %2x \n",buffer);
                    return (u_char*) pMibTbl;
                }
            }
            else if(val == AP_MODE || val == AP_WDS_MODE)
                  return 0;                                                                                                                             
        case currentIPAddress:
            if ( !apmib_get( MIB_IP_ADDR,  (void *)buffer) ){
                        printf("failed!!\n");
                        return 0;
            }
       //     printf("IP= %2x\n",buffer);
            return (u_char*)buffer;

	case linkUpIndicator:
            apmib_get( MIB_WLAN_MODE, (void *)&val);
            if( val == CLIENT_MODE )
            {
		strcpy(WLAN_IF,"wlan0");
                if ( getWlBssInfo(WLAN_IF, &bss) < 0){
			printf("UpIndicator failed!\n");
                        return 0;
		}
             	switch (bss.state) {
                    case STATE_DISABLED:
                    //    pMsg = "Disabled";
                          printf("Disabled\n");
		          long_return = 0;
                          break;
                    case STATE_IDLE:
                    //    pMsg = T("Idle");
                          printf("Idle\n");
		     	  long_return = 0;
                          break;
                    case STATE_STARTED:
                   //     pMsg = T("Started");
                          printf("Started\n");
			  long_return = 0;
                          break;
                    case STATE_CONNECTED:
                  //      pMsg = T("Connected");
		//	  system("./etc/traps");
                          printf("Connected\n");
			  long_return = 1;
                          break;
                    case STATE_WAITFORKEY:
                 //       pMsg = T("Waiting for keys");
                          printf("Waiting for keys\n");
			  long_return = 0;
                          break;
                    case STATE_SCANNING:
                 //       pMsg = T("Scanning");
                          printf("Scanning\n");
			  long_return = 0;
                          break;
                    default:
                  //      pMsg =NULL;
                          printf("NULL\n");
//			  long_return = NULL;
                    }
		    return (u_char*)&long_return;
	    }
	    else if(val == AP_MODE || val == AP_WDS_MODE)
		   return 0;

	case firmwareVersion:
	    *var_len = 8;    //version name length (*var_len default length is 4)
	    sprintf(buffer, "%s", FW_VERSION);
//	    printf("FW_VERSION  = %s\n", buffer);
            return (u_char *) buffer;

	default:
            DEBUGMSGTL(("snmpd", "unknown sub-id %d in var_statusInfo\n", vp->magic));

    } //switch(magic)
    return NULL;

} //var_statusInfo()


                                                                                
 


   

