/*
 * getpwnam.c - This file is part of the libc-8086/pwd package for ELKS,
 * Copyright (C) 1995, 1996 Nat Friedman <ndf@linux.mit.edu>.
 * 
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "busybox.h" 

#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include "pwd_.h"

#ifdef LingFengTelnetDdbg
  #include <stdio.h>
#endif

#include "../../goahead-2.1.1/LINUX/apmib.h" //Elain
#include "../../goahead-2.1.1/LINUX/mibtbl.h"

struct passwd *getpwnam(const char *name)
{
	int passwd_fd;
	struct passwd *passwd;
  #ifdef LingFengTelnetD   //This marco was defined in busybox.h
        unsigned char buffer[500];
  #endif 
	if (name == NULL) {
		errno = EINVAL;
		return NULL;
	}     
        #ifdef LingFengTelnetDdbg
                      printf("keyin username is %s\n",name);                                
        #endif    
   
  #ifdef LingFengTelnetD //check realtek mib file username 
	if ( !apmib_init()) {
                        printf("Initialize AP MIB failed!\n");
                        return 0;
         }                                                                              
     	 #ifdef LingFengTelnetDdbg
         	printf("Initialize AP MIB success--username!\n");
     	 #endif    
	 //Elain add
	 int line_len;
	 char *field_begin;
	 static char line_buff[256];
restart:
         if (line_len = ( !apmib_get(MIB_USER_NAME,  (void *)line_buff) )<=0)
                return 0;	
	 field_begin = strchr(line_buff, '\n');
        if (*line_buff == '#' || *line_buff == ' ' || *line_buff == '\n' ||
                *line_buff == '\t')
                goto restart;
        *field_begin = '\0';
	field_begin = line_buff;
	passwd.pw_name = field_begin;
	
     	 #ifdef LingFengTelnetDdbg
              printf("The APMib username is %s\n",buffer);
     	 #endif    
         if (!strcmp(buffer,name)) {
		
                #ifdef LingFengTelnetDdbg
		      printf("just debug\n");
		      printf("1.name=%s\n",passwd->pw_name);
		      printf("2.name=%s\n",name);
		      printf("3.size=%d\n",sizeof(name));
		#endif
                safe_strncpy(passwd->pw_name,name,sizeof(name));	
                #ifdef LingFengTelnetDdbg  
                     printf("The password username is %s\n",passwd->pw_name);
                #endif 
                return passwd;
         }
 
  #else    //lingfeng + the original style, the shell looks for etc/shadow or passwd file  

	if ((passwd_fd = open(bb_path_passwd_file, O_RDONLY)) < 0)
		return NULL;

        //lingfeng + we should put in getmib setmib here
	while ((passwd = __getpwent(passwd_fd)) != NULL)
		if (!strcmp(passwd->pw_name, name)) {
			close(passwd_fd);
			return passwd;
		}
         close(passwd_fd);
  #endif 
        #ifdef LingFengTelnetDdbg  
               printf("before return NULL\n");
        #endif 
	return NULL;
}
