//*****************************************************************************
//*
//*
//*     TinySmb.cpp
//*
//*
//*****************************************************************************
//
//  this is a small smb server for linux
//
#include    <time.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include    <memory.h>
#include    <malloc.h>
#include    <unistd.h>
#include    <signal.h>
#include    <sys/stat.h>
#include 		<mntent.h>
#include 		<sys/time.h>
#include 		<sys/resource.h> 
/*
#include 		<sys/types.h>
#include 		<fcntl.h>
*/
#include    "NmbServer.h"
#include    "SmbServer.h"

#ifndef			NMB_LOG
#define			NMB_LOG							1
#define			NMB_LOGGING(MES)		time(&timep);fprintf(nmblog, MES, ctime(&timep)); fflush(nmblog)
#define			NMB_LOGARG(MES)			fprintf(nmblog, "(%d)", MES); fflush(nmblog)
		FILE		*nmblog;
#endif

#define     MAX_SHARES          256

typedef struct
    {
    int     iAccess;                        // 0=read-only 1=view-only 2=rdwr
    int     iUserMode;                      // 0=allow     1=deny      2=all users
    char    cName   [64];                   // name of the share
    char    cComment[64];                   // is the descrition for the share
    char    cPath   [256];                  // is the used path (%u=user name)
    char    cUser   [2048];                 // a list of users
    }ShareData;

static int  uModi[3]={SMB_MODE_READONLY,SMB_MODE_VIEWSHARES,SMB_MODE_READWRITE};
ShareData  *aSharePtr[MAX_SHARES];
char       *pPasswdList      = 0;
int         iShareCount      = 0;
int         iShareRdOnly     = 0;
int         iShareVwOnly     = 0;
int         iPasswdCheck     = 1;
int         iQuiet           = 0;
int         iDaemon          = 0;
time_t      iPasswdTime      = 0;
char        cUserName  [ 64] = "";
char        cGroupName [ 64] = "";
char        cHostname  [ 64] = "";
char        cIpAddress [ 20] = "";
char        cSubNetMask[ 20] = "255.255.255.0";
char        cWorkgroup [ 20] = "WORKGROUP";
char        cPasswdFile[256] = "/etc/tinySMB/tinypasswd";
int         iKillDone        = 0;

//int					drop_cache_FD;	// file descriptor for dropping cache
time_t timep;

typedef void (*SignalHandler)(int);

//*****************************************************************************
//*
//*     checkMounted
//*
//*****************************************************************************
//  Check if the SD card have been mounted on the path
//  mntPath         : The dir path SD card mounted on
//  Returns 0 on success, -1 on error, 1 on miss.
static int checkMounted(char *mntPath)
{
  struct mntent *ent;
  FILE *aFile;

  aFile = setmntent("/proc/mounts", "r");
  if (aFile == NULL) {
    perror("setmntent");
    return -1;
  }
  while (NULL != (ent = getmntent(aFile))) {
  	if( !(strcmp(ent->mnt_dir, mntPath)) ) {
  		endmntent(aFile);
  		return 0;
  	}
    //printf("%s %s\n", ent->mnt_fsname, ent->mnt_dir);
  }
  endmntent(aFile);
  
  return 1;
}

//*****************************************************************************
//*
//*     BreakSignal
//*
//*****************************************************************************
//  New signal handler for KILL and CTRL+C
static void BreakSignal(int iSignal)
{

    if(iKillDone)return;

    iKillDone=1;

    if(!iQuiet) printf("\n...shutdown tinysmb...\n");

    SmbStopDaemon();
    NmbStopDaemon();
		
		time(&timep);
		fprintf(stderr, "%s\t exit via BreakSignal()\n", ctime(&timep));

    //exit(0);

}

//*****************************************************************************
//*
//*     SetSignalHandler
//*
//*****************************************************************************
//  Changes the signal handler of a signal
//  iSignal         : is the number of the new handler
//  pSignalHandler  : is the new handler function
//  Returns the old handler or SIG_ERR if an error occurs.
static SignalHandler SetSignalHandler(int iSignal,SignalHandler pSignalHandler)
{
struct sigaction    sNewSig;
struct sigaction    sOldSig;


    sigemptyset(&sNewSig.sa_mask);
    sNewSig.sa_handler = pSignalHandler;
    sNewSig.sa_flags   = SA_RESTART;


    if(sigaction(iSignal,&sNewSig,&sOldSig)<0)
        {
        return SIG_ERR;
        }


return sOldSig.sa_handler;
}

//*****************************************************************************
//*
//*     GetPassword
//*
//*****************************************************************************
//  callback to get the password vor a user
//  pUser       : is the user name
//  pPassword   : buffer for the password
//  iSize       : is the buffer size in bytes
//  returns the size of the saved password or 0 if the password
//  for this user should not be ckecked, or 10000 for an invalid user
int GetPassword(const char *pUser,char *pPassword,int iSize)
{
char    cUser[64];
int     iPos;
int     iLen;
int     iNum;

    if(iPasswdCheck==0)                         // all users have full access
        {
        	//fprintf(stderr, "iPasswdCheck==0\n");
        pPassword[0] =  0;

        if(!iQuiet)printf("\nPassword:    %s = '%s'%i\n",pUser,pPassword,0);
        return 0;
        }

    if(!pPasswdList)
        {
        	fprintf(stderr, "!pPasswdList\n");
        pPassword[0] = '#';                     // create a dummy password
        pPassword[1] =  0;

        if(!iQuiet)printf("\nPassword:    %s = '%s'%i\n",pUser,pPassword,10000);

        return 10000;
        }

       iNum =strlen(pUser);
    if(iNum>=sizeof(cUser))
        {
        iNum=sizeof(cUser)-1;
        }


    for(iPos=0;iPos<=iNum;iPos++)               // make lower case
        {
        if(pUser[iPos]>='A' && pUser[iPos]<='Z')
                cUser[iPos] = pUser[iPos]+32;
        else    cUser[iPos] = pUser[iPos];
        }
     

    for(iPos=0;pPasswdList[iPos];iPos+=iLen)    // find user
        {
        iPos += strspn (pPasswdList+iPos      ,"\t " );
        iLen  = strcspn(pPasswdList+iPos     ,"\n\r");
        iLen += strspn (pPasswdList+iPos+iLen,"\n\r");

        if(memcmp(pPasswdList+iPos,cUser,iNum))continue;
        if(pPasswdList[iPos+iNum]!=':')continue;

        iPos += iNum+1;

           iLen = strcspn(pPasswdList+iPos," \t\n\r");
        if(iLen>=iSize)iLen=iSize-1;
        if(iLen<=    0)iLen=0;

        memcpy(pPassword,pPasswdList+iPos,iLen);
        pPassword[iLen]=0;

        if(!iQuiet)printf("\nPassword:    %s = '%s'%i\n",pUser,pPassword,iLen);

        return iLen;
        }


    pPassword[0] = '#';                         // create a dummy password
    pPassword[1] =  0;


    if(!iQuiet)printf("\nPassword:    %s = '%s'10000\n",pUser,pPassword);


return 10000;
}

//*****************************************************************************
//*
//*     UserLogon
//*
//*****************************************************************************
//  callback for user logons
//  pTree   : pointer to the tree data, here you can insert seveal paths
//  pUser   : is the user name
//  returns TRUE if the userer is valid, or FALSE if a wrong user was logged on.
int _cdecl UserLogon(void *pTree,const char *pUser)
{
char   *pPtr;
char   *pPath;
char   *pNames[MAX_SHARES];
char    cUser[64];
int     iCheck;
int     iAdd;
int     iPos;
int     iLen;
int     iNum;
int     iOk;



    if(!iQuiet)printf("\nUserLogon:   %s \n",pUser);


       iNum =strlen(pUser);
    if(iNum>=sizeof(cUser))
        {
        iNum=sizeof(cUser)-1;
        }


    for(iPos=0;iPos<=iNum;iPos++)               // make lower case
        {
        if(pUser[iPos]>='A' && pUser[iPos]<='Z')
                cUser[iPos] = pUser[iPos]+32;
        else    cUser[iPos] = pUser[iPos];
        }


    iAdd = 0;


    for(iPos=0;iPos<iShareCount;iPos++)
        {
        if(aSharePtr[iPos]->iUserMode==0)       // allow list is used
            {
                pPtr = strstr(aSharePtr[iPos]->cUser,cUser);
            if(!pPtr)continue;
            if( pPtr>aSharePtr[iPos]->cUser)
                {
                if(pPtr[0]!=' ' )
                if(pPtr[0]!='\t')
                if(pPtr[0]!='\r')
                if(pPtr[0]!='\n')continue;
                }

            if(pPtr[iNum]!=' ' )
            if(pPtr[iNum]!='\t')
            if(pPtr[iNum]!='\r')
            if(pPtr[iNum]!='\n')
            if(pPtr[iNum]!= 0  )continue;
            }
        else if(aSharePtr[iPos]->iUserMode==1)  // deny list is used
            {
                pPtr = strstr(aSharePtr[iPos]->cUser,cUser);
            if( pPtr)
            if( pPtr==aSharePtr[iPos]->cUser ||
                pPtr[ 0  ]==' '  ||
                pPtr[ 0  ]=='\t' ||
                pPtr[ 0  ]=='\r' ||
                pPtr[ 0  ]=='\n')
            if( pPtr[iNum]==' '  ||
                pPtr[iNum]=='\t' ||
                pPtr[iNum]=='\r' ||
                pPtr[iNum]=='\n' ||
                pPtr[iNum]== 0  )continue;
            }


        iLen  = strlen(aSharePtr[iPos]->cPath);
        pPath = (char*)SmbMemAlloc(iLen+iNum+1);

        strcpy(pPath,aSharePtr[iPos]->cPath);
        pPtr=strstr(pPath,"%u");

        if(pPtr)
            {
            memmove(pPtr+iNum,pPtr+2,iLen-(pPtr-pPath)-1);
            memcpy (pPtr,cUser,iNum);
            }


        for(iCheck=0;iCheck<iAdd;iCheck++)
            {
            if(!strcasecmp(aSharePtr[iPos]->cName,pNames[iCheck]))break;
            }


        if(iCheck<iAdd)                 // exist a share with the same name
            {
            continue;
            }


        if(!iQuiet)printf("\nTreeEntry:   %i-%i:%s : %s\n",iPos,uModi[aSharePtr[iPos]->iAccess],aSharePtr[iPos]->cName,pPath);

        iOk=SmbInsertTreeEntry( pTree,pPath,
                                aSharePtr[iPos]->cName,
                                aSharePtr[iPos]->cComment,
                                uModi[aSharePtr[iPos]->iAccess],
                                pPath);


        if(iOk==SMB_ERR_NONE)
            {
            pNames[iAdd]=aSharePtr[iPos]->cName;
            iAdd++;
            }
        }


return (iAdd>0)? 1:0;
}

//*****************************************************************************
//*
//*     TreeCheck
//*
//*****************************************************************************
//  callback to check the access attributs of trees
//  return: -4 unknown error
//          -3 wrong server name
//          -2 wrong path
//          -1 wrong username/pasword
//           0 connect with common access
//           1 connect with readonly access
int _cdecl TreeCheck(const SmbTreeData *pData)
{


    if(!iQuiet)printf("\nTreeCheck:   %s : %s\n",pData->cUsername,pData->cService);


return 0;
}


//*****************************************************************************
//*
//*     InsertShare
//*
//*****************************************************************************
//  Inserts a share in the global table
//  pShare      : Pointer to share
//  Returns 1 if inserted
int InsertShare(ShareData *pShare,int iLine)
{
ShareData *pTemp;



    if(!pShare->cName[0])return 0;

    if(iShareCount>=MAX_SHARES)
        {
        printf("too much shares defined in line %i\n",iLine);
        return 0;
        }


    pTemp = new ShareData;
    memcpy(pTemp,pShare,sizeof(ShareData));
    pShare=pTemp;


    if(pShare->iAccess==2)                          // WriteRread-Access
        {
        memmove(aSharePtr+iShareRdOnly+1,aSharePtr+iShareRdOnly,sizeof(aSharePtr[0])*(iShareCount-iShareRdOnly));
        aSharePtr[iShareRdOnly] = pShare;
        iShareRdOnly++;
        iShareVwOnly++;
        iShareCount ++;
        }
    else if(pShare->iAccess==0)                     // ReadOnly-Access
        {
        memmove(aSharePtr+iShareVwOnly+1,aSharePtr+iShareVwOnly,sizeof(aSharePtr[0])*(iShareCount-iShareVwOnly));
        aSharePtr[iShareVwOnly] = pShare;
        iShareVwOnly++;
        iShareCount ++;
        }                                           // ViewOnly-Access
    else{
        aSharePtr[iShareCount]  = pShare;
        iShareCount ++;
        }



return 1;
}

//*****************************************************************************
//*
//*     ReadPasswordFile
//*
//*****************************************************************************
//  Loads the password file
//  pFilename   : is the name of the password file
//  returns 1 if all ok or 0 if an error occurs.
int ReadPasswordFile(const char *pFilename)
{
FILE        *pFile;
char        *pTemp;
char        *pOld;
struct stat sStat;
int         iLen;
int         iOk;


       iOk=stat(pFilename,&sStat);
    if(iOk<0)return 0;

    if(pPasswdList && iPasswdTime==sStat.st_mtime)
        {
        iPasswdTime = sStat.st_mtime;
        return 1;
        }

        pFile = fopen(pFilename,"r");
    if(!pFile)return 0;

        pTemp = new char[sStat.st_size+1];
    if(!pTemp)
        {
        fclose(pFile);
        return 0;
        }


    iLen = fread(pTemp,1,sStat.st_size,pFile);
    pTemp[iLen]=0;
    fclose(pFile);

    pOld        = pPasswdList;
    pPasswdList = pTemp;

    if(pOld)delete pOld;

return 1;
}

//*****************************************************************************
//*
//*     ReadConfigFile
//*
//*****************************************************************************
//  Parses the the config file
//  pFile   : is the handle to read fromm the file
//  returns 1 if all ok or 0 if an error occurs.
int ReadConfigFile(FILE *pFile)
{
int         iLen;
int         iMode;
int         iLine;
char        cName  [64];
char        cWord  [2048];
char        cBuffer[2048];
char       *pPtr;
ShareData   sShare;



    cBuffer[sizeof(cBuffer)-1]=0;
    iMode=0;
    iLine=0;

    while(fgets(cBuffer,sizeof(cBuffer)-1,pFile))
        {
        iLine++;

            pPtr  = cBuffer;
            pPtr += strspn(pPtr," \t\r\n");
        if(*pPtr== 0 )continue;
        if(*pPtr=='#')continue;
        if(*pPtr==';')continue;
        if(*pPtr=='/')continue;

        if(*pPtr=='[')                              // A new share was found
            {
            InsertShare(&sShare,iLine);

            memset(&sShare,0,sizeof(sShare));

                pPtr++;
                pPtr += strspn(pPtr," \t\r\n");
            if(*pPtr==0)
                {
                printf("no share name defined in line %i\n",iLine);
                continue;
                }

               iLen = strcspn(pPtr,"] \t\r\n*?");
            if(iLen<=0)continue;
            if(iLen>=sizeof(sShare.cName))
                {
                printf("warning share name is too long in line %i (only %i bytes allowed)\n",iLine,sizeof(sShare.cName)-1);
                iLen = sizeof(sShare.cName)-1;
                }

            memcpy(sShare.cName,pPtr,iLen);
            sShare.cName[iLen]=0;
            iMode=1;

            continue;
            }


           iLen = strcspn(pPtr,"= \t\r\n*?");       // Read first word of line
        if(iLen<=0)continue;
        if(iLen>=sizeof(cName))
            {
            printf("unknown parameter %*s in line %i\n",iLen,pPtr,iLine);
            continue;
            }

        memcpy(cName,pPtr,iLen);
        cName[iLen]=0;

            pPtr+=iLen;
            pPtr+=strspn(pPtr," \t\r\n");
        if(*pPtr!='=')
            {
            printf("wrong syntax in line %i\n",iLine);
            continue;
            }

        pPtr++;
        pPtr+=strspn(pPtr," \t\r\n");

        if(*pPtr=='"')                              // Read the first word after " ...= "
            {
               iLen = strcspn(pPtr+1,"\"\r\n");
            if(iLen>=sizeof(cWord))
                {
                iLen=sizeof(cWord)-1;
                }

            memcpy(cWord,pPtr+1,iLen);
            cWord[iLen]=0;
            }
        else{
               iLen = strcspn(pPtr," \t\r\n");
            if(iLen>=sizeof(cWord))
                {
                iLen=sizeof(cWord)-1;
                }

            memcpy(cWord,pPtr,iLen);
            cWord[iLen]=0;
            }

        //*********************************************************************

        if(iMode==0)                                // Global Parameters
            {
            if(!strcmp(cName,"ipaddress"))
                {
                strncpy(cIpAddress,cWord,sizeof(cIpAddress)-1);
                continue;
                }

            if(!strcmp(cName,"subnetmask"))
                {
                strncpy(cSubNetMask,cWord,sizeof(cSubNetMask)-1);
                continue;
                }

            if(!strcmp(cName,"hostname"))
                {
                strncpy(cHostname,cWord,sizeof(cHostname)-1);
                continue;
                }

            if(!strcmp(cName,"passwords"))
                {
                strncpy(cPasswdFile,cWord,sizeof(cPasswdFile)-1);
                continue;
                }

            if(!strcmp(cName,"passwd_ckeck"))
                {
                     if(!strcmp(cWord,"no"))iPasswdCheck=0;
                else if(!strcmp(cWord,"NO"))iPasswdCheck=0;
                else if(!strcmp(cWord,"nO"))iPasswdCheck=0;
                else if(!strcmp(cWord,"No"))iPasswdCheck=0;
                else                        iPasswdCheck=1;
                continue;
                }

            if(!strcmp(cName,"force_user"))
                {
                strncpy(cUserName,cWord,sizeof(cUserName)-1);
                continue;
                }

            if(!strcmp(cName,"force_group"))
                {
                strncpy(cGroupName,cWord,sizeof(cGroupName)-1);
                continue;
                }

            if(!strcmp(cName,"workgroup"))
                {
                strncpy(cWorkgroup,cWord,sizeof(cWorkgroup)-1);
                continue;
                }
            }
        else{                                       // Share parameters
            if(!strcmp(cName,"path"))
                {
                strncpy(sShare.cPath,cWord,sizeof(sShare.cPath)-1);
                continue;
                }

            if(!strcmp(cName,"comment"))
                {
                strncpy(sShare.cComment,cWord,sizeof(sShare.cComment)-1);
                continue;
                }

            if(!strcmp(cName,"allow"))
                {
                if(sShare.cUser[0] || sShare.iUserMode)
                    {
                    printf("warning a user list is allready defined (in line %i)\n",iLine);
                    continue;
                    }
                strncpy(sShare.cUser,cWord,sizeof(sShare.cUser)-1);
                sShare.iUserMode=0;
                continue;
                }

            if(!strcmp(cName,"deny"))
                {
                if(sShare.cUser[0] || sShare.iUserMode)
                    {
                    printf("warning a user list is allready defined (in line %i)\n",iLine);
                    continue;
                    }
                strncpy(sShare.cUser,cWord,sizeof(sShare.cUser)-1);
                sShare.iUserMode=1;
                continue;
                }

            if(!strcmp(cName,"all_users"))
                {
                if(sShare.cUser[0] || sShare.iUserMode)
                    {
                    printf("warning a user list is allready defined (in line %i)\n",iLine);
                    continue;
                    }

                if(strcmp(cWord,"no"))
                if(strcmp(cWord,"NO"))
                if(strcmp(cWord,"nO"))
                if(strcmp(cWord,"No"))sShare.iUserMode=2;

                continue;
                }

            if(!strcmp(cName,"access"))
                {
                     if(!strcmp(cWord,"rw"))sShare.iAccess=2;
                else if(!strcmp(cWord,"RW"))sShare.iAccess=2;
                else if(!strcmp(cWord,"rW"))sShare.iAccess=2;
                else if(!strcmp(cWord,"Rw"))sShare.iAccess=2;
                else if(!strcmp(cWord,"vo"))sShare.iAccess=1;
                else if(!strcmp(cWord,"VO"))sShare.iAccess=1;
                else if(!strcmp(cWord,"vO"))sShare.iAccess=1;
                else if(!strcmp(cWord,"Vo"))sShare.iAccess=1;
                else                        sShare.iAccess=0;

                continue;
                }

            }


        printf("unknown parameter %s in line %i\n",cName,iLine);
        }


    if(sShare.cName[0])
        {
        InsertShare(&sShare,iLine);
        }



return 1;
}


//*****************************************************************************
//*
//*     ForceUsers
//*
//*****************************************************************************
//  Changes the user and group id
//  pUser       : id the username  for the new group id
//  pGroup      : id the groupname for the new group id
void ForceUsers(const char *pUser,const char *pGroup)
{
FILE   *pFile;
char    cBuffer[256];
int     iLenU,iLenG;
int     iPos;
int     iNum;



    if(!pUser  || !*pUser )
    if(!pGroup || !*pGroup)
        {
        return;
        }

    if(!pUser )pUser ="";
    if(!pGroup)pGroup="";


    iLenU = strlen(pUser);
    iLenG = strlen(pGroup);


        pFile=fopen("/usr/sbin/passwd","r");
    if(!pFile)return;

    while(fgets(cBuffer,sizeof(cBuffer),pFile))
        {
        cBuffer[sizeof(cBuffer)-1]=0;

        if(iLenU>0 &&!memcmp(pUser,cBuffer,iLenU) && cBuffer[iLenU]==':')
            {
            iNum=1;

            for(iPos=iLenU+1;cBuffer[iPos];iPos++)
                {
                if(cBuffer[iPos]==':')
                    {
                       iNum--;
                    if(iNum<0)
                        {
                        iPos++;
                        break;
                        }
                    }
                }

            if(cBuffer[iPos]>='0' && cBuffer[iPos]<='9')
                {
                iNum = atoi(cBuffer+iPos);
                if(!iLenG)setgid(iNum);
                setuid(iNum);
                }
            }

        if(iLenG>0 &&!memcmp(pUser,cBuffer,iLenG) && cBuffer[iLenG]==':')
            {
            iNum=2;

            for(iPos=iLenG+1;cBuffer[iPos];iPos++)
                {
                if(cBuffer[iPos]==':')
                    {
                       iNum--;
                    if(iNum<0)
                        {
                        iPos++;
                        break;
                        }
                    }
                }

            if(cBuffer[iPos]>='0' && cBuffer[iPos]<='9')
                {
                iNum = atoi(cBuffer+iPos);
                setgid(iNum);
                }
            }
        }


    fclose(pFile);


}

//*****************************************************************************
//*
//*     main
//*
//*****************************************************************************
int main(int iArgc,char **pArgv)
{
SmbConfigData   sSmbConfig;
NmbConfigData   sNmbConfig;
FILE           *pFile;
char           *pParam;
char           *pConfigFile;
int             iNum,iErr;
//int             aPipe[2];
char            cRet;
    
    //printf("TinySMB start...\n");
    //fprintf(stderr, "TinySMB starting...\n");

    pConfigFile = "/etc/tinySMB/tinysmb.conf";


    for(iNum=1;iNum<iArgc;iNum++)               // scan command line
        {
        pParam = pArgv[iNum];

        if(!strcmp(pParam,"-help") || !strcmp(pParam,"?"))
            {
            printf("\n\n");
            printf("\ttinysmb   [-c configfile] [-q] [-d]\n\n");
            printf("               -c   set the used config file\n");
            printf("               -q   turn off the logging outputs\n");
            printf("               -d   start the process as a daemon\n");
            printf("\n\n");
            return -2;
            }

        if(!strcmp(pParam,"-c") && iNum+1<iArgc)
            {
            iNum++;
            pConfigFile = pArgv[iNum];
            continue;
            }

        if(!strcmp(pParam,"-q"))
            {
            iQuiet=1;
            continue;
            }

        if(!strcmp(pParam,"-d"))
            {
            iDaemon=1;
            continue;
            }
        }

//******************** read config file ***************************************



        pFile = fopen(pConfigFile,"r");
    if(!pFile)
        {
        printf("\n\nCan't open the config file: %s\n\n",pConfigFile);
        return -1;
        }

    if(!ReadConfigFile(pFile))
        {
        fclose(pFile);
        return -1;
        }

    fclose(pFile);
    ReadPasswordFile(cPasswdFile);


    if(iShareCount<=0)
        {
        printf("no shares defined\n");
        return -1;
        }

    if(!cIpAddress[0])
        {
        printf("no ipaddress was defined\n");
        return -1;
        }

    if(!cHostname[0])
        {
        if(gethostname(cHostname,sizeof(cHostname)))
            {
            printf("Can't hostname !\n");
            return -1;
            }
        }
/*
	  if( checkMounted("/usr/share/www/html/sdc") == 0 ){
	  	printf("Mount Dir Found....\n");
	  } else {
	  	printf("Mount Dir Not Found or Failed....\n");
	  	exit(1);
	  }
*/
	  /*
	  drop_cache_FD = open("/proc/sys/vm/drop_caches", O_RDWR);
	  if(!drop_cache_FD){
	  	printf("open /proc/sys/vm/drop_caches failed!\n");
	  	exit(-1);
	  }
	  */

#if			NMB_LOG
		nmblog = fopen("/etc/tinySMB/TMB_LOG", "w+");
		NMB_LOGGING("=========================================\n");
#endif
	  
//******************** start as daemon ****************************************

    if(iDaemon)
        {
        if( daemon(1, 1)<0 )perror("daemon");
				/*
        if(pipe(aPipe)==-1)return -1;

        if(fork())
            {
            read(aPipe[0],&cRet,1);             // wait on return value of child proccess
            return cRet;
            }
        */
        }


//******************** start server *******************************************

    SetSignalHandler(SIGUSR1,BreakSignal);
    SetSignalHandler(SIGINT ,BreakSignal);

    if(!iQuiet)
        {
        printf("\n");
        printf("workgroup  : '%s'\n",cWorkgroup );
        printf("hostname   : '%s'\n",cHostname  );
        printf("local ip   : '%s'\n",cIpAddress );
        printf("subnetmask : '%s'\n",cSubNetMask);
        }

    ForceUsers(cUserName,cGroupName);


    memset(&sSmbConfig,0,sizeof(sSmbConfig));
    memset(&sNmbConfig,0,sizeof(sNmbConfig));

    sSmbConfig.pGetPassword     = GetPassword;
    sSmbConfig.pUserLogon       = UserLogon;
    sSmbConfig.pTreeCheck       = TreeCheck;
    sSmbConfig.iMaxBufferSize   = 0xFFFF;
    sSmbConfig.iSecurityMode    = SMB_USER;
    sSmbConfig.iPriority        = 24;

    strncpy(sSmbConfig.cIpAddress ,cIpAddress ,sizeof(sSmbConfig.cIpAddress ));
    strncpy(sNmbConfig.cIpAddress ,cIpAddress ,sizeof(sNmbConfig.cIpAddress ));
    strncpy(sNmbConfig.cSubNetMask,cSubNetMask,sizeof(sNmbConfig.cSubNetMask));
    strncpy(sNmbConfig.cHostname  ,cHostname  ,sizeof(sNmbConfig.cHostname  ));
    strncpy(sNmbConfig.cWorkgroup ,cWorkgroup ,sizeof(sNmbConfig.cWorkgroup ));
            sNmbConfig.iPriority = 24;

       iErr=NmbDaemon(&sNmbConfig);             // start NMB service
    if(iErr!=NMB_ERR_NONE)
        {
        if(!iQuiet)printf("\nNMB-Error: %i\n",iErr);
        SmbStopDaemon();
        NmbStopDaemon();
        if(!iQuiet)printf("\n...exit...\n");
        //if(iDaemon)write(aPipe[1],"\xFF",1);
        time(&timep);
				fprintf(stderr, "%s\t NmbDaemon() Failed at main()\n", ctime(&timep));
        return -1;
        }

       iErr=SmbDaemon(&sSmbConfig);             // start SMB service
    if(iErr!=SMB_ERR_NONE)
        {
        if(!iQuiet)printf("\nSMB-Error: %i\n",iErr);
        SmbStopDaemon();
        NmbStopDaemon();
        if(!iQuiet)printf("\n...exit...\n");
        //if(iDaemon)write(aPipe[1],"\xFF",1);
        time(&timep);
				fprintf(stderr, "%s\t SmbDaemon() Failed at main()\n", ctime(&timep));        
        return -1;
        }

    //if(iDaemon)write(aPipe[1],"\x00",1);        // send return value to parent process
		
    while(1)
        {
        sleep(60);
        ReadPasswordFile(cPasswdFile);          // update config all 1 minutes
        //fprintf(stderr, "%s\t re-read pwd file...\n", ctime(&timep));
        }
		
		
    if(!iQuiet)printf("\nshutdown server\n");

    iKillDone = 1;

    SmbStopDaemon();
    NmbStopDaemon();
    if(!iQuiet)printf("\n...exit...\n");

		time(&timep);
		fprintf(stderr, "%s\t exit at end of main()\n", ctime(&timep));

return 0;
}

