//*****************************************************************************
//*
//*
//*      SmbServer.h
//*
//*
//*****************************************************************************
//
//  Copyright  2007    Anton Zechner
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//
#ifndef     __SMBSERVER_H__
#define     __SMBSERVER_H__


#ifdef  __cplusplus
extern "C" {
#endif 

#if     linux
#ifndef _cdecl
#define _cdecl
#endif
#endif


#define     MAX_PROCESS_COUNT       16          // maximum processes 
#define     MAX_BASE_ENTRIES        4           // base find handles per tree 
#define     MAX_FILE_ENTRIES        8           // file handles per tree 
#define     MAX_TREE_ENTRIES        8           // trees per session 
#define     MAX_USER_ENTRIES        8           // max logged in users 
#define     MAX_DEVICE_SIZE         8           // max size of a device name 
#define     MAX_SERVICE_SIZE        20          // max size of a service/share name 
#define     MAX_SERVERNAME_SIZE     16          // max size of a server name 
#define     MAX_BASENAME_SIZE       15          // max size of a base find name 
#define     MAX_USERNAME_SIZE       20          // max size of a user name 
#define     MAX_PASSWORD_SIZE       128         // max size of a password 
#define     MAX_PATHNAME_SIZE       256         // max size of a file name 
#define     MAX_WORKGROUP_SIZE      16          // max size of a user name 
#define     MAX_TREE_SHARES         8           // max shares in a tree 
#define     MAX_SMB_HEAP            0x30000     // size of the smb heap 

typedef struct 
    {
    char         cDevice  [MAX_DEVICE_SIZE];    // name of the device A:/LPT1:/IPC 
    char         cServer  [MAX_SERVERNAME_SIZE];// server name '//SERVER' 
    char         cService [MAX_SERVICE_SIZE];   // service/share name of a tree 
    char         cUsername[MAX_USERNAME_SIZE];  // useranme of a tree 
    char         cPassword[MAX_PASSWORD_SIZE];  // password for the user 
    int          iPasswordLen;                  // lenght of the password 
    int          bEncrypt;                      // password encryption 
    const unsigned char*pChallenge;             // challenge bytes  
    }SmbTreeData;


typedef int         (_cdecl *SmbTreeCheckProc)(const SmbTreeData*);
typedef int         (_cdecl *SmbUserLogonProc)(void*,const char*);
typedef int         (_cdecl *SmbGetPasswordProc)(const char*,char*,int);

typedef struct
    {
    char                cIpAddress[32];         // ip addres off the smb-server 
    int                 iSecurityMode;          // security mode (1=user 0=share) 
    int                 iMaxBufferSize;         // maximum size of the io buffer 
    int                 iPriority;              // priority of a smb-process task 
    SmbTreeCheckProc    pTreeCheck;             // callback function for tree access check 
    SmbUserLogonProc    pUserLogon;             // callback function for user login 
    SmbGetPasswordProc  pGetPassword;           // callback function to get a password for a user 
    }SmbConfigData;

void  SmbInfo(char *pBuffer,int iBufferSize);
int   SmbDaemon(SmbConfigData *pConfig);
int   SmbStopDaemon();
int   SmbInsertTreeEntry(void *pUserPointer,const char *pPath,
                                            const char *pService,
                                            const char *pComment,
                                            unsigned    uMode,
                                            void       *pMem);

// memory functions 

void       *SmbMemReAlloc(void *pMem,unsigned uSize);
void       *SmbMemAlloc  (           unsigned uSize);
void        SmbMemFree   (void *pMem               );


// share  mode defines 

#define     SMB_SHARE               0           // no login, all shares for all users 
#define     SMB_USER                1           // login is used, shares are individual for each user 

// server errors for SmbDaemon() and  SmbStopDaemon() 

#define     SMB_ERR_NONE            0           // no error 
#define     SMB_ERR_SOCKET          1           // socket error 
#define     SMB_ERR_ISRUNNING       2           // the server allready runns 
#define     SMB_ERR_ISNOTRUNNING    3           // the server ditn't run 
#define     SMB_ERR_INIT            4           // can't initialize server 
#define     SMB_ERR_MEMORY          5           // not entoth memory 
#define     SMB_ERR_WRONGSIZE       6           // the buffer size hase a wrong value 
#define     SMB_ERR_WRONGIP         7           // the ip address is wrong 

// server errors for SmbInsertTreeEntry() 

#define     SMB_ERR_TOOMUCHENTRIES  7           // do much entries (MAX_TREE_SHARES) 
#define     SMB_ERR_NOENTRY         8           // there is no user selected 
#define     SMB_ERR_WRONGMODE       9           // wrong modes for tree access 

// acess mode for SmbInsertTreeEntry() 

#define     SMB_MODE_VIEWSHARES     0           // list only the share names at an access 
#define     SMB_MODE_READONLY       1           // the share has only read access 
#define     SMB_MODE_READWRITE      2           // the share has read and write access 

#ifdef  __cplusplus
}
#endif 


#endif 
