//*****************************************************************************
//*
//*
//*     SmbIpc.cpp
//*
//*
//*****************************************************************************
//
//  Copyright  2003    Anton Zechner
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//
//


// REM AZ experemntial code 

#include "Smb.h"
#include "SmbIpc.h"
#include "SmbMisc.h"
#include "SmbCrypt.h"
#include "SmbServer.h"
#include "SmbInline.h"
#include "SmbInclude.h"

#if     SMB_PRINT_ERR
#define     ERROR_NT(status)                ErrorPacket(pOut,status,__LINE__,__FILE__)
#else 
#define     ERROR_NT(status)                ErrorPacket(pOut,status)
#endif 


#define     NT_STATUS_INVALID_PARAMETER     0xC000000D
#define     NT_STATUS_INVALID_HANDLE        0xC0000008

#define     TRANSACT_SETNAMEDPIPEHANDLESTATE    0x01
#define     TRANSACT_WAITNAMEDPIPEHANDLESTATE   0x53
#define     TRANSACT_DCERPCCMD                  0x26

typedef struct smb_np_struct
    {
    struct smb_np_struct   *next;
    struct smb_np_struct   *prev;
    SmbSession             *conn;
    int                     iPipeNum;
    int                     open;                               // open connection
    unsigned short          wUid;                               // points to the unauthenticated user that opened this pipe.
    unsigned short          device_state;
    unsigned short          priority;
    char                    name[256];

    /* When replying to an SMBtrans, this is the maximum amount of data that can be sent in the initial iRet. */

    int                     max_trans_reply;

    /*
     * NamedPipe state information.
     *
     * (e.g. typecast a np_struct, above).
     */

    void *np_state;

    /*
     * NamedPipe functions, to be called to perform
     * Named Pipe transactions on request from an
     * SMB client.
     */

    /* call to create a named pipe connection.
     * returns: state information representing the connection.
     *          is stored in np_state, above.
     */

    void *   (*namedpipe_create)(char *pipe_name,SmbSession *conn, unsigned short vuid);

    /* call to perform a write / read namedpipe transaction.
         * TransactNamedPipe is weird: it returns whether there
         * is more data outstanding to be read, and the
         * caller is expected to take note and follow up with
         * read requests.
         */
    int      (*namedpipe_transact)(void *np_state,
              char *data, int len,
              char *rdata, int rlen,
              int  *pipe_outstanding);

    /* call to perform a write namedpipe operation */

    int      (*namedpipe_write)(void * np_state,unsigned char *data, size_t n);

    /* call to perform a read namedpipe operation.
     *
     * NOTE: the only reason that the pipe_outstanding
     * argument is here is because samba does not use
     * the namedpipe_transact function yet: instead,
     * it performs the same as what namedpipe_transact
     * does - a write, followed by a read.
     *
     * when samba is modified to use namedpipe_transact,
     * the pipe_outstanding argument may be removed.
     */

    int      (*namedpipe_read)(void * np_state,char *data, size_t max_len,int  *pipe_outstanding);

    /* call to close a namedpipe.
     * function is expected to perform all cleanups
     * necessary, free all memory etc.
     *
     * returns True if cleanup was successful (not that
     * we particularly care).
     */

    int      (*namedpipe_close)(void * np_state);

    }smb_np_struct;

static smb_np_struct   *Pipes;
static smb_np_struct   *chain_p;

void SendTransReply(     SmbSession      *pSession,
                         unsigned char   *pOut,
                         char *pRParam   ,int iRParamLen,
                         char *pRData    ,int iRDataLen);

//*****************************************************************************
//*
//*     ErrorPacket
//*
//*****************************************************************************
//  Create an error packet. Normally called using the SMB_ERROR() macro.
#if     SMB_PRINT_ERR
int ErrorPacket(unsigned char *pOut,unsigned uErrorCode,int iLine,const char *pFile,const char *pError="")
#else 
int ErrorPacket(unsigned char *pOut,unsigned uErrorCode)
#endif 
{
int iOutsize;



    iOutsize = SmbSetMessage(pOut,0,0,FALSE);

    SIVAL(pOut,smb_rcls,uErrorCode);
    SSVAL(pOut,smb_flg2,SVAL(pOut,smb_flg2)|FLAGS2_32_BIT_ERROR_CODES);

    #if SMB_PRINT_ERR
    PRINT_SMB_ERR((" SMB Error nr=%i (%s) at %s(%i)\n",iErrorCode,pError,pFile,iLine)); 
    #endif 



return iOutsize;
}


//*****************************************************************************
//*
//*     PipeGet
//*
//*****************************************************************************
smb_np_struct *PipeGet(int iPipeNum)
{
smb_np_struct  *p;



    PRINT_SMB_MSG2(("search for pipe=%Xh\n", iPipeNum));

    for(p=Pipes;p;p=p->next)
        {
        if(p->iPipeNum == iPipeNum)
            {
            chain_p = p;
            return p;
            }
        }

return NULL;
}



//*****************************************************************************
//*
//*     NoReply
//*
//*****************************************************************************
static int NoReply(SmbSession *pSession,unsigned char *pOut,int iMaxLen)
{
unsigned char   aParam[4];



    SSVAL(aParam,0,ERRunsup);
    SSVAL(aParam,2,0       );

    PRINT_SMB_ERR(("Unsupported API fd command\n"));

    ReplyTrans(pSession,pOut,aParam,4,0);


return -1;
}


//*****************************************************************************
//*
//*     api_rpc_trans_reply
//*
//*****************************************************************************
static int api_rpc_trans_reply(SmbSession *pSession,unsigned char *outbuf,smb_np_struct *p)
{
int         is_data_outstanding;
char       *rdata;
int         data_len;


    rdata = (char *)SmbAlloc(p->max_trans_reply);

    if(rdata == NULL)
        {
        PRINT_SMB_ERR(("api_rpc_trans_reply: malloc fail.\n"));
        return FALSE;
        }

    data_len = p->namedpipe_read(p->np_state,rdata,p->max_trans_reply,&is_data_outstanding);

    if(data_len<0)
        {
        SmbFree(rdata);
        return FALSE;
        }

    SendTransReply(pSession,outbuf,NULL,0,rdata,data_len/*, is_data_outstanding*/);
    SmbFree(rdata);


return TRUE;
}

//*****************************************************************************
//*
//*     IpcReply
//*
//*****************************************************************************
int IpcReply(SmbSession *pSession,unsigned short wUid,unsigned char *pOut,
                unsigned short *pSetup,unsigned char *pData,char *pParam,
                int iSetupWordCount,int iTotalDataCount,int iTotalParamCount,
                int iMaxDataReturn ,int iMaxParamReturn)
{
smb_np_struct  *pPipe;
int             iPipe;
int             iCmd;
int             iRet;


    PRINT_SMB_MSG(("IpcReply"))


    if(iSetupWordCount!=2)                                      // First find out the name of this file.
        {
        PRINT_SMB_ERR(("Unexpected named pipe transaction.\n"));
        return ERROR_NT(NT_STATUS_INVALID_PARAMETER);
        }


    iPipe   = pSetup[1];
    iCmd    = pSetup[0];
    pPipe   = PipeGet(iPipe);
    iRet    = FALSE;

    if(!pPipe)
        {
        if(iCmd == TRANSACT_WAITNAMEDPIPEHANDLESTATE)
            {
            // Win9x does this call with a unicode pipe name, not a pipe.
            // Just return success for now...
            ReplyTrans(pSession,pOut,NULL,0,0);
            return -1;
            }

        PRINT_SMB_ERR(("IpcReply: INVALID PIPE HANDLE: %x\n", iPipe));
        return ERROR_NT(NT_STATUS_INVALID_HANDLE);
        }


    if(wUid != pPipe->wUid)
        {
        PRINT_SMB_ERR(("Got pipe request (pipe %Xh) using invalid VUID %d, expected %d\n",iPipe,wUid,pPipe->wUid));
        return ERROR_NT(NT_STATUS_INVALID_HANDLE);
        }

    PRINT_SMB_MSG2(("Got API command 0x%x on pipe \"%s\" (pipe %Xh)\n", iCmd, pPipe->name, iPipe));



    pPipe->max_trans_reply = iMaxDataReturn;                // Record maximum pData length that can be transmitted in an SMBtrans

    PRINT_SMB_MSG2(("IpcReply: pipe:%p max_trans_reply: %i\n", pPipe, pPipe->max_trans_reply));


    switch(iCmd)
        {
    case TRANSACT_DCERPCCMD:                                // dce/rpc command

           iRet = pPipe->namedpipe_write(pPipe,pData,iTotalDataCount);
        if(iRet)
            {
            iRet = api_rpc_trans_reply(pSession,pOut,pPipe);
            }

        break;

    case TRANSACT_WAITNAMEDPIPEHANDLESTATE:                 // Wait Named Pipe Handle state

        // iRet = api_WNPHS(pOut, pPipe, pParam, iTotalParamCount);
        // REM AZ
        break;

    case TRANSACT_SETNAMEDPIPEHANDLESTATE:                  // Set Named Pipe Handle state

        // iRet = api_SNPHS(pOut, pPipe, pParam, iTotalParamCount);
        // REM AZ
        break;

    default:

        return ERROR_NT(NT_STATUS_INVALID_PARAMETER);
        }

    if(!iRet)
        {
        return NoReply(pSession,pOut,iMaxDataReturn);
        }



return -1;
}
