//*****************************************************************************
//*
//*
//*     SmbCrypt.cpp
//*
//*
//*****************************************************************************
//
//  Copyright  2003    Anton Zechner
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//
//
#include "Smb.h"
#include "SmbCrypt.h"
#include "SmbInline.h"
#include "SmbInclude.h"
/*
#ifdef   USE_OPENSSL
#include <openssl/des.h>
#include <openssl/md4.h>
#include <openssl/md5.h>
#else
#include "SmbCrypt/openssl/ossl_des.h"
#include "SmbCrypt/openssl/ossl_md4.h"
#include "SmbCrypt/openssl/ossl_md5.h"
#endif
*/
#include <openssl/des.h>
#include <openssl/md4.h>
#include <openssl/md5.h>
#include <openssl/hmac.h>
#include <openssl/evp.h>
#include <time.h>
#include <ctype.h>

int  _cdecl  SmbGetPassword   (const char *pUser,char *pBuffer,int iSize){return 0;}
int (_cdecl *smb_get_password)(const char *pUser,char *pBuffer,int iSize)=SmbGetPassword;


#define SMB_S8  "KGS!@#$%"                      // 8 byte string for smb encryption

static const unsigned short usUnicodeMap[128]=  // OEM char map (range 128-255)
    {
    0x00C7,0x00FC,0x00E9,0x00E2,0x00E4,0x00E0,0x00E5,0x00E7,
    0x00EA,0x00EB,0x00E8,0x00EF,0x00EE,0x00EC,0x00C4,0x00C5,
    0x00C9,0x00E6,0x00C6,0x00F4,0x00F6,0x00F2,0x00FB,0x00F9,
    0x00FF,0x00D6,0x00DC,0x00A2,0x00A3,0x00A5,0x20A7,0x0192,
    0x00E1,0x00ED,0x00F3,0x00FA,0x00F1,0x00D1,0x00AA,0x00BA,
    0x00BF,0x2310,0x00AC,0x00BD,0x00BC,0x00A1,0x00AB,0x00BB,
    0x2591,0x2592,0x2593,0x2502,0x2524,0x2561,0x2562,0x2556,
    0x2555,0x2563,0x2551,0x2557,0x255D,0x255C,0x255B,0x2510,
    0x2514,0x2534,0x252C,0x251C,0x2500,0x253C,0x255E,0x255F,
    0x255A,0x2554,0x2569,0x2566,0x2560,0x2550,0x256C,0x2567,
    0x2568,0x2564,0x2565,0x2559,0x2558,0x2552,0x2553,0x256B,
    0x256A,0x2518,0x250C,0x2588,0x2584,0x258C,0x2590,0x2580,
    0x03B1,0x00DF,0x0393,0x03C0,0x03A3,0x03C3,0x00B5,0x03C4,
    0x03A6,0x0398,0x03A9,0x03B4,0x221E,0x03C6,0x03B5,0x2229,
    0x2261,0x00B1,0x2265,0x2264,0x2320,0x2321,0x00F7,0x2248,
    0x00B0,0x2219,0x00B7,0x221A,0x207F,0x00B2,0x25A0,0x00A0
    };

static const unsigned char cMap437[128]=
    {
    0x80,0x9A,0x90,0x41,0x8E,0x41,0x8F,0x80,0x45,0x45,0x45,0x49,0x49,0x49,0x8E,0x8F,
    0x90,0x92,0x92,0x4F,0x99,0x4F,0x55,0x55,0x59,0x99,0x9A,0x9B,0x9C,0x9D,0x50,0x9F,
    0x41,0x49,0x4F,0x55,0xA5,0xA5,0xA6,0xA7,0xA8,0xAA,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
    0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0x2B,0x2B,0xDD,0xDD,0x2B,0x2B,0x2B,0x2B,0x2B,
    0x2B,0x2D,0x2D,0x2B,0x2D,0x2B,0xDD,0xDD,0x2B,0x2B,0x2D,0x2D,0xDD,0x2D,0x2B,0x2D,
    0x2D,0x2D,0x2D,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0xDD,0x5F,0xDD,0xDD,0x5F,
    0x41,0xE1,0x47,0x50,0x53,0x53,0xE6,0x54,0x46,0x54,0x4F,0x44,0x38,0x46,0x45,0x4E,
    0x3D,0xF1,0x3D,0x3D,0x28,0x29,0xF6,0x7E,0xF8,0xFA,0xFA,0x56,0x4E,0xFD,0xDD,0xFF,
    };

//*****************************************************************************
//*
//*     verifyMem
//*
//*****************************************************************************
//  debug function. see what's inside memory. (shown in hex)
//  mem			   	: piece of memory you want to check
//	iLen				: length you want to check(in bytes)
void verifyMem(void *mem, int iLen)
{
	int i;
	unsigned char *m = (unsigned char *)mem;
	
  for (i=0; i<iLen; i++) {
    printf("%02x ", m[i]);
  }
  printf("\n");
}

//*****************************************************************************
//*
//*     unicodeMapping
//*
//*****************************************************************************
//  mapping input ANSI string into unicode unsigned short array.
//  ansiStr	   	: input ANSI string
//	iLen				: length of ansiStr
//  uniStr     	: output buffer where unicode stored, which should be at least twice large(in byte) as input(not NULL-terminated here)
//	return the pointer to output buffer
unsigned short *unicodeMapping(char *ansiStr, int iLen, unsigned short *uniStr)
{
  int i;
  for(i=0; i<iLen; i++)
      {
      if(ansiStr[i]<128)
              uniStr[i]=ansiStr[i];
      else    uniStr[i]=usUnicodeMap[ansiStr[i]-128];
      }
      
  return uniStr;	
}

//*****************************************************************************
//*
//*     Smbv1Hash
//*
//*****************************************************************************
//  hash the plaintext password into v1hash.
//  pPassword   : the password  witch shold be encrypted, always check password length
//	iLen				: length of pPassword
//  pOutput     : buffer where v1hash stored, which should be at least 16 bytes long(this function won't null terminated for you)
//	return the pointer to output buffer
unsigned char *Smbv1Hash(char *pPassword,int iLen,unsigned char *pOutput)
{
unsigned short  usUncode[MAX_PASSWORD_SIZE];

		unicodeMapping(pPassword, iLen, usUncode);

    MD4((unsigned char*)usUncode,iLen*2,pOutput); // produce NTLM hash in ucData21, with length of 16 and 5 * /0 padding
    
    return pOutput;
}

//*****************************************************************************
//*
//*     SmbPasswordCheck_NTLMv2
//*
//*****************************************************************************
//  Check an incomming passwort(NTLMv2).
//  pUser           : is the user name
//	pDomain					: is the domain name
//  pPasswordUnic   : is the unicode password, HMAC+blob(if it's really NTLMv2)
//  iLenUnic        : it the length of the unicode password in byte
//  pChallenge      : is the 24 byte encrypt key
//  returns TRUE if the password is correct
//
// 	steps for server to authorize NTLMv2:
// 	1. plaintext password -> NTLMv1 hash
// 	2. NTLMv1 hash -> NTLMv2 hash (userName+domain -> HMAC_MD5)
// 	3. retrieve data blob from client request, HMAC_MD5 it and get final HMAC
//	4. serverChanllege+blob -> HMAC_MD5 = HMAC
// 	5. compare HMAC with what client sent
int  SmbPasswordCheck_NTLMv2(  char *pUser				,char *pDomain,
                        			 void *pPasswordUnic,int iLenUnic,
                        			 void *pChallenge)
{
char            cPassword[MAX_PASSWORD_SIZE]; // plainText passwd from smbpasswd
unsigned char		v1hash[16];
unsigned char		v2hash[16];
unsigned int		i, iLen;
int							uLen=strlen(pUser);
int							dLen=strlen(pDomain);
// store upper case of user+domain
char						upperName[uLen];
char						upperDomain[dLen];
// store upper case unicode of user+domain, and concated data
unsigned short	uUser[uLen];
unsigned short	uDomain[dLen];
unsigned short	uCon[uLen+dLen];
// the HMAC from client/server, waiting for final authentication (fixed 16 bytes)
unsigned char		cHMAC[16];
unsigned char		sHMAC[16];
// data blob retrieve from pPasswordUnic, concate with 8 bytes chanllege, sblob=chanllege(8)+blob
unsigned char		sblob[iLenUnic-8];

    if(!*pUser)return TRUE;

       iLen=smb_get_password(pUser,cPassword,sizeof(cPassword));
    if(iLen<=0)return TRUE;
    if(iLen>MAX_PASSWORD_SIZE)return FALSE;

		// step1. turn plaintext password into v1hash(16)
		Smbv1Hash(cPassword, iLen, v1hash);
		
		// step2. calculate v2hash using v1hash and name+domain(upcase, and then unicode)
		for(i=0; i<uLen; i++) upperName[i]=toupper(pUser[i]);
		unicodeMapping(upperName, uLen, uUser);
		
		for(i=0; i<dLen; i++) upperDomain[i]=toupper(pDomain[i]);
		unicodeMapping(upperDomain, dLen, uDomain);	
	
		// concat NAME+DEST
		memcpy(uCon, uUser, 2*uLen);
		memcpy(uCon+uLen, uDomain, 2*dLen);
		
		// v2hash = HMAC_MD5(v1hash, data)
		//HMAC(EVP_md5(), v1hash, 16, udata, sizeof(udata), (unsigned char*)v2hash, &iLen);
		HMAC(EVP_md5(), v1hash, 16, (const unsigned char *)uCon, 2*(uLen+dLen), v2hash, &iLen);

		// step3. calculate the HMAC, using v2hash, and chanllege+blob(capture from request)
		// pPasswordUnic = HMAC+blob, retreieve them first
		memcpy(cHMAC, (unsigned char *)pPasswordUnic, 16);
		memcpy(sblob+8, (unsigned char *)pPasswordUnic+16, iLenUnic-16);

		// concat chanllege+blob
		memcpy(sblob, pChallenge, 8);
		
		// sHAC=HMAC_MD5(v2hash, 16, sblob, sizeof(sblob))
		HMAC(EVP_md5(), v2hash, 16, sblob, iLenUnic-8, sHMAC, &iLen);

#if   0			// for debug..ofc
		printf("pUser=\t%s\n", pUser);
		printf("pDomain=\t%s\n", pDomain);
		printf("uUser=\t"); verifyMem(uUser, sizeof(uUser));
		printf("uDomain=\t"); verifyMem(uDomain, sizeof(uDomain));
		printf("uCon=\t"); verifyMem(uCon, sizeof(uCon));
		printf("sblob=\t"); verifyMem(sblob, sizeof(sblob));
		printf("sHMAC=\t"); verifyMem(sHMAC, sizeof(sHMAC));
		printf("cHMAC=\t"); verifyMem(cHMAC, sizeof(cHMAC));
#endif
	
    // finally, compare sHMAC with cHMAC, if matched, then it's right password
    if(!memcmp(sHMAC,cHMAC,16)) return TRUE;

return FALSE;
}

//*****************************************************************************
//*
//*     SmbCovertSevenToEight
//*
//*****************************************************************************
static void SmbCovertSevenToEight(unsigned char *pInput, unsigned char *pOutput)
{
unsigned char   ucBuffer [8];
unsigned char   i;


    ucBuffer[0] = (unsigned char)(pInput[0]&(0xFF<<1));

    for (i = 1; i < 7; i ++)
        {
        ucBuffer[i] = (unsigned char) (
                  ((pInput[i-1] & (0xFF>>(8-i))) << (8-i)) |
                  ((pInput[i  ] & (0xFF<<(i+1))) >> (  i)));
        }

    ucBuffer[7] = (unsigned char)((pInput[6]&(0xFF>>1))<<1);

    memcpy(pOutput,ucBuffer,8);
}

//*****************************************************************************
//*
//*     SmbEncryptBlock
//*
//*****************************************************************************
//  pKey    : the key for the encryption
//  pInput  : 8 byte input  data buffer
//  pOutput : 8 byte output data buffer
static void SmbEncryptBlock(unsigned char *pKey,unsigned char *pInput,unsigned char *pOutput)
{
des_cblock          sKeyData;
des_key_schedule    sSchedule;


    SmbCovertSevenToEight(pKey,sKeyData);
    des_set_odd_parity   (&sKeyData);
    des_set_key_unchecked(&sKeyData,sSchedule);

    des_ecb_encrypt((des_cblock*)pInput,(des_cblock*)pOutput,sSchedule,DES_ENCRYPT);


}

//*****************************************************************************
//*
//*     SmbEncrypt24
//*
//*****************************************************************************
static void SmbEncrypt24(unsigned char *pData21,unsigned char *pKey,unsigned char *pOutput)
{
    SmbEncryptBlock(pData21   ,pKey,pOutput   );
    SmbEncryptBlock(pData21+ 7,pKey,pOutput+ 8);
    SmbEncryptBlock(pData21+14,pKey,pOutput+16);
}


//*****************************************************************************
//*
//*     SmpEncryptOld
//*
//*****************************************************************************
//  Encrypts a password to a 24 byte buffer whith the old mode
//  pPassword   : the password  witch shold be encrypted
//  pKey        : the key for the encryption
//  pOutput     : output buffer
void SmpEncryptOld(char * pPassword,void *pKey,void *pOutput)
{
unsigned char   ucData21[21];
unsigned char   ucData14[14];
unsigned char   ucChar;
int             i,iLen;



    memset(ucData21+16,0, 5);
    memset(ucData14   ,0,14);

       iLen=strlen(pPassword);
    if(iLen>14)iLen=14;

    memcpy(ucData14,pPassword,iLen);

    for(i=0;i<iLen;i++)
        {
        ucChar = ucData14[i];

        if(ucChar>='a' && ucChar<='z')
            {
            ucChar-='a'-'A';
            }
        else if(ucChar>=128)
            {
            ucChar=cMap437[ucChar-128];
            }

        ucData14[i]=ucChar;
        }

    SmbEncryptBlock(ucData14  ,(unsigned char*)SMB_S8, ucData21   );
    SmbEncryptBlock(ucData14+7,(unsigned char*)SMB_S8,&ucData21[8]);
    SmbEncrypt24   (ucData21  ,(unsigned char*)pKey,(unsigned char*)pOutput);

}


//*****************************************************************************
//*
//*     SmpEncryptNt
//*
//*****************************************************************************
//  Encrypts a password to a 24 byte buffer whith the new NT mode
//  pPassword   : the password  witch shold be encrypted
//  pKey        : the key for the encryption
//  pOutput     : output buffer
void SmpEncryptNt(char *pPassword,void *pKey,void *pOutput)
{
unsigned char   ucData21[21];
int             iLen;


    memset(ucData21+16,0,5); // padding 5 * /0 at tail of NTLM hash

       iLen=strlen(pPassword);
    if(iLen>MAX_PASSWORD_SIZE)iLen=MAX_PASSWORD_SIZE;

		Smbv1Hash(pPassword, iLen, ucData21);
    
    SmbEncrypt24(ucData21,(unsigned char*)pKey,(unsigned char*)pOutput);

}


//*****************************************************************************
//*
//*     SmbGenerateKey
//*
//*****************************************************************************
void SmbGenerateKey(void *pBuffer)
{
char    *pData=(char*)pBuffer;
int      iTime;

    
    iTime = SysTimeGet();

    pData[3]=(char)(iTime    );
    pData[0]=(char)(iTime>> 8);
    pData[7]=(char)(iTime>>16);
    pData[5]=(char)(iTime>>24);
    pData[1]=(char)SysTickCount();
    pData[4]=(char)SysTickCount()>>4;
    pData[2]=0x78;
    pData[6]=0x56;


    #ifdef STAIC_KEY

    pData[0]=0x2C;
    pData[1]=0x70;
    pData[2]=0x78;
    pData[3]=0x77;
    pData[4]=0x07;
    pData[5]=0x4B;
    pData[6]=0x56;
    pData[7]=0x31;

    #endif 

}


//*****************************************************************************
//*
//*     SmbPasswordCheck
//*
//*****************************************************************************
//  Check an incomming passwort.
//  pUser           : is the user name
//  pPasswordAnsi   : is the ansi password
//  iLenAnsi        : it the length of the ansi password in byte
//  pPasswordUnic   : is the unicode password
//  iLenUnic        : it the length of the unicode password in byte
//  pChallenge      : is the 24 byte encrypt key
//  iProtocoll      : is the uesd smb protcol (PROTOCOL_NT1,...)
//  iEncrypt        : is TRUE if the password are bEncrypted
//  returns TRUE if the password is correct
int  SmbPasswordCheck(  char *pUser,
                        void *pPasswordAnsi,int iLenAnsi,
                        void *pPasswordUnic,int iLenUnic,
                        void *pChallenge   ,int iProtocoll,int iEncrypt)
{
char            cPassword[MAX_PASSWORD_SIZE]; // plainText passwd from smbpasswd
char            cBuffer[24]; // store response(server) to compare with response(client)
int             iLen;

    if(!*pUser)return TRUE;

       iLen=smb_get_password(pUser,cPassword,sizeof(cPassword));
    if(iLen<=0)return TRUE;
    if(iLen>MAX_PASSWORD_SIZE)return FALSE;

    if(!iEncrypt)
        {
        if(pPasswordAnsi && iLenAnsi==iLen){
        	if(!memcmp(pPasswordAnsi,cPassword,iLen))
        		return TRUE;
				}
					
        if(pPasswordUnic && iLenUnic==iLen){
        	if(!memcmp(pPasswordUnic,cPassword,iLen))
        		return TRUE;
        }
        return FALSE;
        }

    if(iProtocoll>=PROTOCOL_NT1)
        {
        SmpEncryptNt(cPassword,pChallenge,cBuffer); // calculate the server's response, later compare with client

        if(pPasswordUnic && iLenUnic==24){
        	if(!memcmp(pPasswordUnic,cBuffer,24)){
        		return TRUE;
        	}
       	}

        if(pPasswordAnsi && iLenAnsi==24){
        	if(!memcmp(pPasswordAnsi,cBuffer,24)){
        		return TRUE;
        	}
        }
      	}

    if(pPasswordAnsi && iLenAnsi==24)
        {
        SmpEncryptOld(cPassword,pChallenge,cBuffer);
        if(!memcmp(pPasswordAnsi,cBuffer,24)){
        	return TRUE;
        }
      	}

return FALSE;
}
