//*****************************************************************************
//*
//*
//*      NmbServer.h
//*
//*
//*****************************************************************************
//
//  Copyright  2007    Anton Zechner
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//
#ifndef     __NMBSERVER_H__
#define     __NMBSERVER_H__

#include <endian.h>
#include    "System/SocketUtility.h"


// name server errors 

#define     NMB_ERR_NONE            0           // no error 
#define     NMB_ERR_SOCKET          1           // socket error 
#define     NMB_ERR_ISRUNNING       2           // nmb server is running 
#define     NMB_ERR_ISNOTRUNNING    3           // nmb server is running 
#define     NMB_ERR_INIT            4           // initialisation error 
#define     NMB_ERR_DGRAM           5           // datagram server failue 
#define     NMB_ERR_IPV6            6           // ip V6 sockets not allowed 
#define     NMB_ERR_WRONGIP         7           // the ip address is wrong 
#define     NMB_ERR_WRONGNET        8           // the subnet mask is wrong 



#ifdef  __cplusplus
extern "C" {
#endif 

typedef struct
    {
    char        cIpAddress [32];                // ip addres off the nmb-server 
    char        cSubNetMask[32];                // ip addres off the smb-server 
    char        cHostname  [16];                // name hostname of the workgroup 
    char        cWorkgroup [16];                // name of the workgroup 
    char        cDomain    [256];               // the domain name 
    int         iPriority;                      // taks priority 0-256 
    }NmbConfigData;


    int  NmbStopDaemon   ();
    int  NmbDaemon       (NmbConfigData *pConfig);
    int  NmbQueryName    (const char *pName,const char *pDomain,IpAddr *pIpAddr);
    int  NmbRefreshName  (const char *pName,const char *pDomain,int bGroup);
    int  NmbOverwriteName(const char *pName,const char *pDomain,int bGroup);
    int  NmbAddName      (const char *pName,const char *pDomain,int bGroup);
    void NmbAddNameNoWait(const char *pName,const char *pDomain,int bGroup);


#ifdef  __cplusplus
}
#endif 


#endif 

