/* $Id: upnpcommands.c,v 1.40 2012/06/23 22:36:35 nanard Exp $ */
/* Project : miniupnp
 * Author : Thomas Bernard
 * Copyright (c) 2005-2012 Thomas Bernard
 * This software is subject to the conditions detailed in the
 * LICENCE file provided in this distribution.
 * */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "upnpcommands.h"
#include "miniupnpc.h"
#include "portlistingparse.h"

//Barry adds 20130226
#include <syslog.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include "xml_db.h"

/* UPNP_GetStatusInfo() call the corresponding UPNP method
 * returns the current status and uptime */
LIBSPEC int
UPNP_GetStatusInfo(const char * controlURL,
				const char * servicetype,
				char * status,
				unsigned int * uptime,
				char * lastconnerror)
{
	struct NameValueParserData pdata;
	char * buffer;
	int bufsize;
	char * p;
	char * up;
	char * err;
	int ret = UPNPCOMMAND_UNKNOWN_ERROR;

	if(!status && !uptime)
		return UPNPCOMMAND_INVALID_ARGS;

	if(!(buffer = simpleUPnPcommand(-1, controlURL, servicetype,
	                                "GetStatusInfo", 0, &bufsize))) {
		return UPNPCOMMAND_HTTP_ERROR;
	}
	ParseNameValue(buffer, bufsize, &pdata);
	/*DisplayNameValueList(buffer, bufsize);*/
	free(buffer); buffer = NULL;
	up = GetValueFromNameValueList(&pdata, "NewUptime");
	p = GetValueFromNameValueList(&pdata, "NewConnectionStatus");
	err = GetValueFromNameValueList(&pdata, "NewLastConnectionError");
	if(p && up)
	  ret = UPNPCOMMAND_SUCCESS;

	if(status) {
		if(p){
			strncpy(status, p, 64 );
			status[63] = '\0';
		}else
			status[0]= '\0';
	}

	if(uptime) {
		if(up)
			sscanf(up,"%u",uptime);
		else
			uptime = 0;
	}

	if(lastconnerror) {
		if(err) {
			strncpy(lastconnerror, err, 64 );
			lastconnerror[63] = '\0';
		} else
			lastconnerror[0] = '\0';
	}

	p = GetValueFromNameValueList(&pdata, "errorCode");
	if(p) {
		ret = UPNPCOMMAND_UNKNOWN_ERROR;
		sscanf(p, "%d", &ret);
	}
	ClearNameValueList(&pdata);
	return ret;
}

/* UPNP_GetConnectionTypeInfo() call the corresponding UPNP method
 * returns the connection type */
LIBSPEC int
UPNP_GetConnectionTypeInfo(const char * controlURL,
                           const char * servicetype,
                           char * connectionType)
{
	struct NameValueParserData pdata;
	char * buffer;
	int bufsize;
	char * p;
	int ret = UPNPCOMMAND_UNKNOWN_ERROR;

	if(!connectionType)
		return UPNPCOMMAND_INVALID_ARGS;

	if(!(buffer = simpleUPnPcommand(-1, controlURL, servicetype,
	                                "GetConnectionTypeInfo", 0, &bufsize))) {
		return UPNPCOMMAND_HTTP_ERROR;
	}
	ParseNameValue(buffer, bufsize, &pdata);
	free(buffer); buffer = NULL;
	p = GetValueFromNameValueList(&pdata, "NewConnectionType");
	/*p = GetValueFromNameValueList(&pdata, "NewPossibleConnectionTypes");*/
	/* PossibleConnectionTypes will have several values.... */
	if(p) {
		strncpy(connectionType, p, 64 );
		connectionType[63] = '\0';
		ret = UPNPCOMMAND_SUCCESS;
	} else
		connectionType[0] = '\0';
	p = GetValueFromNameValueList(&pdata, "errorCode");
	if(p) {
		ret = UPNPCOMMAND_UNKNOWN_ERROR;
		sscanf(p, "%d", &ret);
	}
	ClearNameValueList(&pdata);
	return ret;
}

/* UPNP_GetLinkLayerMaxBitRate() call the corresponding UPNP method.
 * Returns 2 values: Downloadlink bandwidth and Uplink bandwidth.
 * One of the values can be null
 * Note : GetLinkLayerMaxBitRates belongs to WANPPPConnection:1 only
 * We can use the GetCommonLinkProperties from WANCommonInterfaceConfig:1 */
LIBSPEC int
UPNP_GetLinkLayerMaxBitRates(const char * controlURL,
                             const char * servicetype,
                             unsigned int * bitrateDown,
                             unsigned int * bitrateUp)
{
	struct NameValueParserData pdata;
	char * buffer;
	int bufsize;
	int ret = UPNPCOMMAND_UNKNOWN_ERROR;
	char * down;
	char * up;
	char * p;

	if(!bitrateDown && !bitrateUp)
		return UPNPCOMMAND_INVALID_ARGS;

	/* shouldn't we use GetCommonLinkProperties ? */
	if(!(buffer = simpleUPnPcommand(-1, controlURL, servicetype,
	                                "GetCommonLinkProperties", 0, &bufsize))) {
	                              /*"GetLinkLayerMaxBitRates", 0, &bufsize);*/
		return UPNPCOMMAND_HTTP_ERROR;
	}
	/*DisplayNameValueList(buffer, bufsize);*/
	ParseNameValue(buffer, bufsize, &pdata);
	free(buffer); buffer = NULL;
	/*down = GetValueFromNameValueList(&pdata, "NewDownstreamMaxBitRate");*/
	/*up = GetValueFromNameValueList(&pdata, "NewUpstreamMaxBitRate");*/
	down = GetValueFromNameValueList(&pdata, "NewLayer1DownstreamMaxBitRate");
	up = GetValueFromNameValueList(&pdata, "NewLayer1UpstreamMaxBitRate");
	/*GetValueFromNameValueList(&pdata, "NewWANAccessType");*/
	/*GetValueFromNameValueList(&pdata, "NewPhysicalLinkStatus");*/
	if(down && up)
		ret = UPNPCOMMAND_SUCCESS;

	if(bitrateDown) {
		if(down)
			sscanf(down,"%u",bitrateDown);
		else
			*bitrateDown = 0;
	}

	if(bitrateUp) {
		if(up)
			sscanf(up,"%u",bitrateUp);
		else
			*bitrateUp = 0;
	}
	p = GetValueFromNameValueList(&pdata, "errorCode");
	if(p) {
		ret = UPNPCOMMAND_UNKNOWN_ERROR;
		sscanf(p, "%d", &ret);
	}
	ClearNameValueList(&pdata);
	return ret;
}


/* UPNP_GetExternalIPAddress() call the corresponding UPNP method.
 * if the third arg is not null the value is copied to it.
 * at least 16 bytes must be available
 *
 * Return values :
 * 0 : SUCCESS
 * NON ZERO : ERROR Either an UPnP error code or an unknown error.
 *
 * 402 Invalid Args - See UPnP Device Architecture section on Control.
 * 501 Action Failed - See UPnP Device Architecture section on Control.
 */
LIBSPEC int
UPNP_GetExternalIPAddress(const char * controlURL,
                          const char * servicetype,
                          char * extIpAdd)
{
	struct NameValueParserData pdata;
	char * buffer;
	int bufsize;
	char * p;
	int ret = UPNPCOMMAND_UNKNOWN_ERROR;
   
	if(!extIpAdd || !controlURL || !servicetype)
		return UPNPCOMMAND_INVALID_ARGS;

	if(!(buffer = simpleUPnPcommand(-1, controlURL, servicetype,
	                                "GetExternalIPAddress", 0, &bufsize))) {
		return UPNPCOMMAND_HTTP_ERROR;
	}
	/*DisplayNameValueList(buffer, bufsize);*/
	ParseNameValue(buffer, bufsize, &pdata);
	free(buffer); buffer = NULL;
	/*printf("external ip = %s\n", GetValueFromNameValueList(&pdata, "NewExternalIPAddress") );*/
	p = GetValueFromNameValueList(&pdata, "NewExternalIPAddress");
	if(p) {
		strncpy(extIpAdd, p, 16 );
		extIpAdd[15] = '\0';
		ret = UPNPCOMMAND_SUCCESS;
	} else
		extIpAdd[0] = '\0';

	p = GetValueFromNameValueList(&pdata, "errorCode");
	if(p) {
		ret = UPNPCOMMAND_UNKNOWN_ERROR;
		sscanf(p, "%d", &ret);
	}

   //Barry_20130226
   SyncExPortDataXML(1, 2, "publicIp", -1, &extIpAdd[0]); //upnpc is failed;
   syslog(LOG_INFO, "UPNP_Get external IP Address is %s\n", extIpAdd);
   //

	ClearNameValueList(&pdata);
	return ret;
}

LIBSPEC int
UPNP_AddPortMapping( const char * controlURL,
                     const char * servicetype,
                     const char * extPort,
                     const char * inPort,
                     const char * inClient,
                     const char * desc,
                     const char * proto,
                     const char * remoteHost
                   )
{
	struct UPNParg * AddPortMappingArgs;
	char * buffer;
	int bufsize;
	struct NameValueParserData pdata;
	const char * resVal;
	int ret;

   //Barry_20130226
   char *pDesc = NULL ;
   MIPF_INFO tNetDBate ;	
   NETIF_INFO netif, *netif1;
   struct ifreq ifr;
   int sock_fd;
   struct ifreq ifr_eth;
   char S[25];
   char camType = -1 ;

   memset(&tNetDBate, 0, sizeof(tNetDBate));
   getCableState (&tNetDBate);
   getIpFindInfo (&tNetDBate);
   
   memset(&netif, 0, sizeof(netif));
   netif1 = &netif;
   sock_fd = socket(AF_INET, SOCK_DGRAM, 0);
   
   //Decide Network interface
   if (tNetDBate.CamType == 1) {//Wireless 
      if (tNetDBate.cabState == 0) {//Have Cable
         if (tNetDBate.netType == 0) //Lan
            strncpy(ifr.ifr_name, "eth0", IFNAMSIZ-1);
         else if (tNetDBate.netType == 1)
            strncpy(ifr.ifr_name, "ppp0", IFNAMSIZ-1);
         camType = 0 ;
      }else {
         strncpy(ifr.ifr_name, "ra0", IFNAMSIZ-1);
         camType = 1 ;
      }
   }else {
      if (tNetDBate.netType == 0) //Lan
         strncpy(ifr.ifr_name, "eth0", IFNAMSIZ-1);
      else if (tNetDBate.netType == 1)
         strncpy(ifr.ifr_name, "ppp0", IFNAMSIZ-1);
      camType = 0 ;
   }
   
   ifr.ifr_addr.sa_family = AF_INET;
   
   strncpy(ifr_eth.ifr_name, "eth0", IFNAMSIZ-1);
   ifr_eth.ifr_addr.sa_family = AF_INET;
   
   memset(&S, 0, sizeof(S));
   
   //Get MAC
   if (camType == 0) {
      if (ioctl(sock_fd, SIOCGIFHWADDR, &ifr_eth) == 0) {
         memcpy(netif1->mac_addr, ifr_eth.ifr_hwaddr.sa_data, 8);
         sprintf(S,"%02X:%02X:%02X:%02X:%02X:%02X-IP_Camera", netif.mac_addr[0],
                                                              netif.mac_addr[1],
                                                              netif.mac_addr[2],
                                                              netif.mac_addr[3],
                                                              netif.mac_addr[4],
                                                              netif.mac_addr[5] );
         pDesc=&S[0];
      }else
         fprintf(stderr, "Get ETH0 MAC error Add\n");
   }else if (camType == 1) {
      if (ioctl(sock_fd, SIOCGIFHWADDR, &ifr) == 0) {
         memcpy(netif1->mac_addr, ifr.ifr_hwaddr.sa_data, 8);
         sprintf(S,"%02X:%02X:%02X:%02X:%02X:%02X-IP_Camera",  netif.mac_addr[0], 
                                                               netif.mac_addr[1], 
                                                               netif.mac_addr[2],
                                                               netif.mac_addr[3],
                                                               netif.mac_addr[4], 
                                                               netif.mac_addr[5]);
         pDesc=&S[0];
      }else
         fprintf(stderr, "Get RA0 MAC error 1\n");
   }
   //
   
   //printf("FILE=%s, (%d),%s\n", __FILE__,__LINE__, pDesc);

   
	if(!inPort || !inClient || !proto || !extPort){
		return UPNPCOMMAND_INVALID_ARGS;
  }
	AddPortMappingArgs = calloc(9, sizeof(struct UPNParg));
	AddPortMappingArgs[0].elt = "NewRemoteHost";
	AddPortMappingArgs[0].val = remoteHost;
	AddPortMappingArgs[1].elt = "NewExternalPort";
	AddPortMappingArgs[1].val = extPort;
	AddPortMappingArgs[2].elt = "NewProtocol";
	AddPortMappingArgs[2].val = proto;
	AddPortMappingArgs[3].elt = "NewInternalPort";
	AddPortMappingArgs[3].val = inPort;
	AddPortMappingArgs[4].elt = "NewInternalClient";
	AddPortMappingArgs[4].val = inClient;
	AddPortMappingArgs[5].elt = "NewEnabled";
	AddPortMappingArgs[5].val = "1";
	AddPortMappingArgs[6].elt = "NewPortMappingDescription";
	
	//Barry
	AddPortMappingArgs[6].val = pDesc; 

	AddPortMappingArgs[7].elt = "NewLeaseDuration";
	//Barry
	AddPortMappingArgs[7].val = "0";
	
	if(!(buffer = simpleUPnPcommand(-1, controlURL, servicetype,
	                                "AddPortMapping", AddPortMappingArgs,
	                                &bufsize))) {
		free(AddPortMappingArgs);
		return UPNPCOMMAND_HTTP_ERROR;
	}

	ParseNameValue(buffer, bufsize, &pdata);
	free(buffer); buffer = NULL;
	resVal = GetValueFromNameValueList(&pdata, "errorCode");
	if(resVal) {
		ret = UPNPCOMMAND_UNKNOWN_ERROR;
		sscanf(resVal, "%d", &ret);
	} else {
		ret = UPNPCOMMAND_SUCCESS;
	}
	ClearNameValueList(&pdata);
	free(AddPortMappingArgs);
	return ret;
}

LIBSPEC int
UPNP_DeletePortMapping(const char * controlURL, const char * servicetype,
                       const char * extPort, const char * proto,
                       const char * remoteHost)
{
	/*struct NameValueParserData pdata;*/
	struct UPNParg * DeletePortMappingArgs;
	char * buffer;
	int bufsize;
	struct NameValueParserData pdata;
	const char * resVal;
	int ret;

	if(!extPort || !proto)
		return UPNPCOMMAND_INVALID_ARGS;

	DeletePortMappingArgs = calloc(4, sizeof(struct UPNParg));
	DeletePortMappingArgs[0].elt = "NewRemoteHost";
	DeletePortMappingArgs[0].val = remoteHost;
	DeletePortMappingArgs[1].elt = "NewExternalPort";
	DeletePortMappingArgs[1].val = extPort;
	DeletePortMappingArgs[2].elt = "NewProtocol";
	DeletePortMappingArgs[2].val = proto;
	if(!(buffer = simpleUPnPcommand(-1, controlURL, servicetype,
	                               "DeletePortMapping",
	                               DeletePortMappingArgs, &bufsize))) {
		free(DeletePortMappingArgs);
		return UPNPCOMMAND_HTTP_ERROR;
	}
	/*DisplayNameValueList(buffer, bufsize);*/
	ParseNameValue(buffer, bufsize, &pdata);
	free(buffer); buffer = NULL;
	resVal = GetValueFromNameValueList(&pdata, "errorCode");
	if(resVal) {
		ret = UPNPCOMMAND_UNKNOWN_ERROR;
		sscanf(resVal, "%d", &ret);
	} else {
		ret = UPNPCOMMAND_SUCCESS;
	}
		
	ClearNameValueList(&pdata);
	free(DeletePortMappingArgs);
	return ret;
}

LIBSPEC int
UPNP_GetGenericPortMappingEntry(const char * controlURL,
                                const char * servicetype,
							 const char * index,
							 char * extPort,
							 char * intClient,
							 char * intPort,
							 char * protocol,
							 char * desc,
							 char * enabled,
							 char * rHost,
							 char * duration)
{
	struct NameValueParserData pdata;
	struct UPNParg * GetPortMappingArgs;
	char * buffer;
	int bufsize;
	char * p;
	int r = UPNPCOMMAND_UNKNOWN_ERROR;
	if(!index)
		return UPNPCOMMAND_INVALID_ARGS;
	intClient[0] = '\0';
	intPort[0] = '\0';
	GetPortMappingArgs = calloc(2, sizeof(struct UPNParg));
	GetPortMappingArgs[0].elt = "NewPortMappingIndex";
	GetPortMappingArgs[0].val = index;
	
	if(!(buffer = simpleUPnPcommand(-1, controlURL, servicetype,
	                               "GetGenericPortMappingEntry",
	                               GetPortMappingArgs, &bufsize))) {
		free(GetPortMappingArgs);
		return UPNPCOMMAND_HTTP_ERROR;
	}
	ParseNameValue(buffer, bufsize, &pdata);
	free(buffer); buffer = NULL;

	p = GetValueFromNameValueList(&pdata, "NewRemoteHost");
	if(p && rHost)
	{
		strncpy(rHost, p, 64);
		rHost[63] = '\0';
	}
	p = GetValueFromNameValueList(&pdata, "NewExternalPort");
	if(p && extPort)
	{
		strncpy(extPort, p, 6);
		extPort[5] = '\0';
		r = UPNPCOMMAND_SUCCESS;
	}
	p = GetValueFromNameValueList(&pdata, "NewProtocol");
	if(p && protocol)
	{
		strncpy(protocol, p, 4);
		protocol[3] = '\0';
	}
	p = GetValueFromNameValueList(&pdata, "NewInternalClient");
	if(p && intClient)
	{
		strncpy(intClient, p, 16);
		intClient[15] = '\0';
		r = 0;
	}
	p = GetValueFromNameValueList(&pdata, "NewInternalPort");
	if(p && intPort)
	{
		strncpy(intPort, p, 6);
		intPort[5] = '\0';
	}
	p = GetValueFromNameValueList(&pdata, "NewEnabled");
	if(p && enabled)
	{
		strncpy(enabled, p, 4);
		enabled[3] = '\0';
	}
	p = GetValueFromNameValueList(&pdata, "NewPortMappingDescription");
	if(p && desc)
	{
		strncpy(desc, p, 80);
		desc[79] = '\0';
	}
	p = GetValueFromNameValueList(&pdata, "NewLeaseDuration");
	if(p && duration)
	{
		strncpy(duration, p, 16);
		duration[15] = '\0';
	}
	p = GetValueFromNameValueList(&pdata, "errorCode");
	if(p) {
		r = UPNPCOMMAND_UNKNOWN_ERROR;
		sscanf(p, "%d", &r);
	}
	ClearNameValueList(&pdata);
	free(GetPortMappingArgs);
	return r;
}

/* UPNP_GetSpecificPortMappingEntry retrieves an existing port mapping
 * the result is returned in the intClient and intPort strings
 * please provide 16 and 6 bytes of data */
LIBSPEC int
UPNP_GetSpecificPortMappingEntry(const char * controlURL,
                                 const char * servicetype,
                                 const char * extPort,
                                 const char * proto,
                                 char * intClient,
                                 char * intPort
                                )
                                 
{
	struct NameValueParserData pdata;
	struct UPNParg * GetPortMappingArgs;
	char * buffer;
	int bufsize;
	char * p;
	int ret = UPNPCOMMAND_UNKNOWN_ERROR;

	if(!intPort || !intClient || !extPort || !proto)
		return UPNPCOMMAND_INVALID_ARGS;

	GetPortMappingArgs = calloc(4, sizeof(struct UPNParg));
	GetPortMappingArgs[0].elt = "NewRemoteHost";
	GetPortMappingArgs[1].elt = "NewExternalPort";
	GetPortMappingArgs[1].val = extPort;
	GetPortMappingArgs[2].elt = "NewProtocol";
	GetPortMappingArgs[2].val = proto;

	if(!(buffer = simpleUPnPcommand(-1, controlURL, servicetype,
	                                "GetSpecificPortMappingEntry",
	                                GetPortMappingArgs, &bufsize))) {
		free(GetPortMappingArgs);
		return UPNPCOMMAND_HTTP_ERROR;
	}

	ParseNameValue(buffer, bufsize, &pdata);

	p = GetValueFromNameValueList(&pdata, "NewInternalClient");
	if(p) {
		strncpy(intClient, p, 16);
		intClient[15] = '\0';
		ret = UPNPCOMMAND_SUCCESS;
	} else
		intClient[0] = '\0';

	p = GetValueFromNameValueList(&pdata, "NewInternalPort");
	if(p) {
		strncpy(intPort, p, 6);
		intPort[5] = '\0';
	} else
		intPort[0] = '\0';

	p = GetValueFromNameValueList(&pdata, "errorCode");
	if(p) {
		ret = UPNPCOMMAND_UNKNOWN_ERROR;
		sscanf(p, "%d", &ret);
	}

	ClearNameValueList(&pdata);
	free(GetPortMappingArgs);
	return ret;
}
