#############################################################
#
# OpenCV (Open Source Computer Vision)
#
#############################################################
OPENCV_VERSION = 2.3.1a
OPENCV_SITE    = http://$(BR2_SOURCEFORGE_MIRROR).dl.sourceforge.net/project/opencvlibrary/opencv-unix/2.3.1
OPENCV_SOURCE  = OpenCV-$(OPENCV_VERSION).tar.bz2
OPENCV_INSTALL_STAGING = YES

OPENCV_CONF_OPT = \
	-DCMAKE_BUILD_TYPE=$(if $(BR2_ENABLE_DEBUG),Debug,Release) \
	-DBUILD_DOCS=$(if $(BR2_HAVE_DOCUMENTATION),ON,OFF) \
	-DBUILD_EXAMPLES=OFF \
	-DBUILD_PACKAGE=OFF \
	-DBUILD_TESTS=$(if $(BR2_PACKAGE_OPENCV_BUILD_TESTS),ON,OFF) \
	-DBUILD_SHARED_LIBS=$(if $(BR2_PREFER_STATIC_LIB),OFF,ON) \
	-DINSTALL_C_EXAMPLES=OFF \
	-DINSTALL_PYTHON_EXAMPLES=OFF \
	-DOPENCV_BUILD_3RDPARTY_LIBS=OFF \
	-DENABLE_PROFILING=OFF \
	-DCMAKE_SKIP_RPATH=OFF \
	-DUSE_FAST_MATH=ON \
	-DUSE_OMIT_FRAME_POINTER=ON \
	-DUSE_PRECOMPILED_HEADERS=OFF \
	-DWITH_1394=OFF \
	-DWITH_CUDA=OFF \
	-DWITH_EIGEN=OFF \
	-DWITH_IPP=OFF \
	-DWITH_JASPER=OFF \
	-DWITH_OPENEXR=OFF \
	-DWITH_OPENNI=OFF \
	-DWITH_PVAPI=OFF \
	-DWITH_TBB=OFF \
	-DWITH_UNICAP=OFF \
	-DWITH_XINE=OFF

ifeq ($(BR2_PACKAGE_OPENCV_WITH_PYTHON),y)
OPENCV_CONF_OPT += -DBUILD_NEW_PYTHON_SUPPORT=ON
OPENCV_DEPENDENCIES += python
else
OPENCV_CONF_OPT += -DBUILD_NEW_PYTHON_SUPPORT=OFF
endif

ifeq ($(BR2_PACKAGE_OPENCV_WITH_FFMPEG),y)
OPENCV_CONF_OPT += -DWITH_FFMPEG=ON
OPENCV_DEPENDENCIES += ffmpeg
else
OPENCV_CONF_OPT += -DWITH_FFMPEG=OFF
endif

ifeq ($(BR2_PACKAGE_OPENCV_WITH_GSTREAMER),y)
OPENCV_CONF_OPT += -DWITH_GSTREAMER=ON
OPENCV_DEPENDENCIES += gstreamer gst-plugins-base
else
OPENCV_CONF_OPT += -DWITH_GSTREAMER=OFF
endif

ifeq ($(BR2_PACKAGE_OPENCV_WITH_GTK),y)
OPENCV_CONF_OPT += -DWITH_GTK=ON
OPENCV_DEPENDENCIES += libgtk2
else
OPENCV_CONF_OPT += -DWITH_GTK=OFF
endif

ifeq ($(BR2_PACKAGE_OPENCV_WITH_JPEG),y)
OPENCV_CONF_OPT += -DWITH_JPEG=ON
OPENCV_DEPENDENCIES += jpeg
else
OPENCV_CONF_OPT += -DWITH_JPEG=OFF
endif

ifeq ($(BR2_PACKAGE_OPENCV_WITH_PNG),y)
OPENCV_CONF_OPT += -DWITH_PNG=ON
OPENCV_DEPENDENCIES += libpng
else
OPENCV_CONF_OPT += -DWITH_PNG=OFF
endif

ifeq ($(BR2_PACKAGE_OPENCV_WITH_QT),y)
OPENCV_CONF_OPT += -DWITH_QT=ON -DWITH_QT_OPENGL=OFF
OPENCV_DEPENDENCIES += qt
else
OPENCV_CONF_OPT += -DWITH_QT=OFF
endif

ifeq ($(BR2_PACKAGE_OPENCV_WITH_TIFF),y)
OPENCV_CONF_OPT += -DWITH_TIFF=ON
OPENCV_DEPENDENCIES += tiff
else
OPENCV_CONF_OPT += -DWITH_TIFF=OFF
endif

ifeq ($(BR2_PACKAGE_OPENCV_WITH_V4L),y)
OPENCV_CONF_OPT += -DWITH_V4L=ON
OPENCV_DEPENDENCIES += libv4l
else
OPENCV_CONF_OPT += -DWITH_V4L=OFF
endif

ifneq ($(BR2_HAVE_DOCUMENTATION),y)
define OPENCV_CLEAN_INSTALL_DOC
	$(RM) -fr $(TARGET_DIR)/usr/share/opencv/doc
endef

OPENCV_POST_INSTALL_TARGET_HOOKS += OPENCV_CLEAN_INSTALL_DOC
endif

ifneq ($(BR2_PACKAGE_CMAKE),y)
define OPENCV_CLEAN_INSTALL_CMAKE
	$(RM) -f $(TARGET_DIR)/usr/share/opencv/OpenCVConfig.cmake
endef
OPENCV_POST_INSTALL_TARGET_HOOKS += OPENCV_CLEAN_INSTALL_CMAKE
endif

ifneq ($(BR2_PACKAGE_OPENCV_INSTALL_DATA),y)
define OPENCV_CLEAN_INSTALL_DATA
	$(RM) -fr $(TARGET_DIR)/usr/share/opencv/haarcascades \
		$(TARGET_DIR)/usr/share/opencv/lbpcascades
endef
OPENCV_POST_INSTALL_TARGET_HOOKS += OPENCV_CLEAN_INSTALL_DATA
endif

$(eval $(call CMAKETARGETS))
