#ifndef __CONFIG_H
#define __CONFIG_H

/*
 * High Level Configuration Options
 * (easy to change)
 */
#define CONFIG_PLATFORM_GM8185_v2       1
#define CONFIG_SYS_CLOCK                204000000       /* AHB clock */
#define CONFIG_FA626                    1               /* This is an FA626 Core: sync_cache()	*/

#undef  CONFIG_USE_IRQ                                  /* we don't need IRQ/FIQ stuff	*/

#if 0
#define CONFIG_NAND                                     /* uncomment if Use NAND */
#endif

#define CONFIG_CMDLINE_TAG              1               /* enable passing of ATAGs	*/
#define CONFIG_SETUP_MEMORY_TAGS        1
#define CONFIG_INITRD_TAG               1

#define CONFIG_PMU_BASE                 0x98100000
#define CONFIG_INTC_BASE                0x98800000

#define CONFIG_SKIP_LOWLEVEL_INIT       1               /* U-Boot is loaded by a bootloader */

/*
 * Size of malloc() pool
 */
#define CFG_MALLOC_LEN                  (512*1024)
#define CFG_GBL_DATA_SIZE               128             /* size in bytes reserved for initial data */

/*
 * NS16550 Configuration
 */
#define CFG_NS16550
#define CFG_NS16550_SERIAL
#define CFG_NS16550_CLK                 16875000        /* UART_CLOCK=PLL3_CLK/32 */
#define CFG_NS16550_COM1                0x98200000
#define CFG_NS16550_REG_SIZE            4

/*
 * select serial console configuration
 */
#define CONFIG_BAUDRATE                 115200
#define CFG_BAUDRATE_TABLE              { 115200, 57600, 38400, 19200, 9600 }
#define CONFIG_CONS_INDEX               1
#undef  CONFIG_HWFLOW                                   /* don't include RTS/CTS flow control support	*/
#undef  CONFIG_MODEM_SUPPORT                            /* disable modem initialization stuff */

#define CONFIG_TIMESTAMP                                /* Print timestamp info for images */

/* 
 * Video console
 */
#define CFG_CONSOLE_IS_IN_ENV
#define CONFIG_SPLASH_SCREEN

/*
 * USB support
 */
#if 0
#define CONFIG_USB_UHCI                 1
#define CONFIG_USB_KEYBOARD             1
#define CONFIG_USB_STORAGE              1
#define CONFIG_DOS_PARTITION            1
#endif

/*
 * Autobooting
 */
#define CONFIG_ETHADDR                  00:42:70:00:30:22  /* used by common/env_common.c */
#define CONFIG_NETMASK                  255.0.0.0
#define CONFIG_IPADDR                   10.0.1.52
#define CONFIG_SERVERIP                 10.0.1.51
#define CONFIG_GATEWAYIP                10.0.1.51
#define CONFIG_OVERWRITE_ETHADDR_ONCE                      /* save MAC address */

/*
 * Only interrupt autoboot if <space> is pressed. Otherwise, garbage
 * data on the serial line may interrupt the boot sequence.
 */
#define CONFIG_BOOTDELAY                3
#define CONFIG_AUTOBOOT

#if 0
#define CONFIG_ZERO_BOOTDELAY_CHECK
#define CONFIG_AUTOBOOT_KEYED
#define CONFIG_AUTOBOOT_PROMPT          "Press SPACE to abort autoboot in %d seconds\n", bootdelay
#define CONFIG_AUTOBOOT_STOP_STR        " "
#define CONFIG_AUTOBOOT_DELAY_STR       "d"
#endif

#ifdef CONFIG_NAND
#define CONFIG_BOOTCOMMAND              "nand read 0x4000000 0x500000 0x1000000;" \
                                        "go 0x4000800"
#else
#define CONFIG_BOOTCOMMAND              "go 0x10240000"
#endif
#define CONFIG_BOOTARGS                 ""              /* We have not implement the boot args. yet */

#define CONFIG_NET_MULTI

/* 
 * this must be included AFTER the definition of CONFIG_COMMANDS (if any)
 */
#include <config_cmd_default.h>
#ifdef CONFIG_NAND
#define CONFIG_CMD_NAND
#define CONFIG_CMD_JFFS2
#undef  CONFIG_CMD_FLASH
#undef  CONFIG_CMD_IMLS
#else
#define CONFIG_CMD_IMLS                                 /* need NOR-flash */
#define CONFIG_CMD_FLASH
#endif
#define CONFIG_CMD_ENV
#undef CONFIG_CMD_FPGA

/*
 * Physical Memory Map
 */
#define CONFIG_NR_DRAM_BANKS            1
#define PHYS_SDRAM                      0x00000000
#define PHYS_SDRAM_SIZE                 0x08000000      /* 128 megs */

#define CFG_MEMTEST_START               PHYS_SDRAM + 0x400000
#define CFG_MEMTEST_END                 PHYS_SDRAM_SIZE - 262144

/* 
 * Ethernet
 */
#define CONFIG_FTGMAC100
#define CONFIG_FTGMAC100_BASE           0x70C00000
#define CONFIG_DRIVER_ETHER
#define CONFIG_NET_RETRY_COUNT          100
#if 0
#define RMII_MODE                       /* Using CONFIG_RMII is better because of u-boot naming style. (KJ suggest) */
#endif

//#define Marvell_PHY											1
//#define has_osc													1//has 25MHz clock for PHY
/*
 * FLASH organization
 */
#define CFG_FLASH_BASE                  0x10000000
//#define PHYS_FLASH_SIZE                 0x1000000        /* 16 MB */
#define PHYS_FLASH_SIZE                 0x2000000        /* 32 MB */

#define eight_bus_width                 /* Weird naming!! Using capital letter is better. (KJ suggest) */

#define CFG_MAX_FLASH_BANKS             1                /* max num of flash banks */
//#define CFG_MAX_FLASH_SECT              256              /* 16 MB max num of sects on this chip */
#define CFG_MAX_FLASH_SECT              512              /* 32 MB max num of sects on this chip */


#define CFG_FLASH_EMPTY_INFO                             /* print 'E' for empty sector on flinfo */
#define CFG_FLASH_CFI                   1	         /* Flash is CFI conformant */
#define CFG_FLASH_CFI_DRIVER            1                /* Use the common driver */
#define CFG_FLASH_USE_BUFFER_WRITE      1                /* use buffered writes (20x faster)     */
#define CFG_FLASH_INCREMENT             0x01000000
#define CFG_FLASH_BANKS_LIST            { CFG_FLASH_BASE, CFG_FLASH_BASE + CFG_FLASH_INCREMENT }
#define CFG_FLASH_ERASE_TOUT            120000           /* (in ms) */
#define CFG_FLASH_WRITE_TOUT            500              /* (in ms) */
#undef  CFG_FLASH_PROTECTION                             /* don't use hardware protection        */

/* 
 * NAND FLASH
 */
/* #define CONFIG_MTD_NAND_UNSAFE */

#define CFG_NAND0_BASE                  0x71D00000
#define CFG_NAND_BASE_LIST              { CFG_NAND0_BASE }
#define CFG_MAX_NAND_DEVICE             1       	/* Max number of NAND devices */

/* nand timeout values */
#define CFG_NAND_PROG_ERASE_TO          3000
#define CFG_NAND_OTHER_TO               100
#define CFG_NAND_SENDCMD_RETRY          3
#undef NAND_ALLOW_ERASE_ALL             /* Allow erasing bad blocks - don't use */

#undef CONFIG_MTD_DEBUG
#define CONFIG_MTD_DEBUG_VERBOSE        3

#define ADDR_COLUMN                     1
#define ADDR_PAGE                       2
#define ADDR_COLUMN_PAGE                3

#define NAND_ChipID_UNKNOWN             0x00
#define NAND_MAX_FLOORS                 1
#define NAND_MAX_CHIPS                  1

/*
 * Dynamic MTD partition support
 */
#if 0
#define CONFIG_JFFS2_CMDLINE
#endif

/*
 * Miscellaneous configurable options
 */
#define CFG_LONGHELP                                    /* undef to save memory */
#define CFG_PROMPT                      "=> "           /* Monitor Command Prompt */
#define CFG_CBSIZE                      256             /* Console I/O Buffer Size */
#define CFG_MAXARGS                     32              /* max number of command args */
#define CFG_PBSIZE                      (CFG_CBSIZE+sizeof(CFG_PROMPT)+16) /* Print Buffer Size */
#define CFG_LOAD_ADDR                   0x02000000      /* default load address */

#define CFG_DEVICE_NULLDEV              1               /* enble null device            */
#define CFG_DEVICE_DEREGISTER                           /* needs device_deregister */
#define LITTLEENDIAN                    1               /* used by usb_ohci.c  */

#define CONFIG_VERSION_VARIABLE         1               /* include version env variable */
#undef CONFIG_SILENT_CONSOLE                            /* enable silent startup        */

#ifndef __ASSEMBLY__
/*-----------------------------------------------------------------------
 * Board specific extension for bd_info
 *
 * This structure is embedded in the global bd_info (bd_t) structure
 * and can be used by the board specific code (eg board/...)
 */

struct bd_info_ext {
	/* helper variable for board environment handling
	 *
	 * env_crc_valid == 0	 =>   uninitialised
	 * env_crc_valid  > 0	 =>   environment crc in flash is valid
	 * env_crc_valid  < 0	 =>   environment crc in flash is invalid
	 */
	int env_crc_valid;
};
#endif	/* __ASSEMBLY__ */

#define CFG_HZ                          1000
#define CFG_HZ_CLOCK                    (CONFIG_SYS_CLOCK/2)            /* APB clock */
#define CFG_TIMERBASE                   (0x98400000)

#define CONFIG_STACKSIZE                (32*1024)                       /* regular stack */

#ifdef CONFIG_USE_IRQ
#error CONFIG_USE_IRQ not supported
#endif

/*
 * Environment settings
 */
#ifdef CONFIG_NAND
#define CFG_NO_FLASH
#define CONFIG_ENV_IS_IN_NAND           1
#define CONFIG_ENV_OFFSET               0x400000         /* add for 2008.10 */
#define CONFIG_ENV_OFFSET_REDUND        0x404000
#define CONFIG_ENV_SIZE                 0x4000
#else
#define CONFIG_ENV_IS_IN_FLASH          1
#define CONFIG_ENV_ADDR                 (CFG_FLASH_BASE + 0x000c0000)
#define CONFIG_ENV_SIZE                 0x20000
#define CONFIG_ENV_SECT_SIZE            0x20000
#define CONFIG_ENV_ADDR_REDUND          (CONFIG_ENV_ADDR + CONFIG_ENV_SECT_SIZE)
#endif

#endif	/* __CONFIG_H */
