#include <common.h>
#include <spi.h>
#include <asm/io.h>

#include "ftssp010_spi.h"

void ft_spi_cs_clk_init(void)
{
	UINT32 reg = 0;

	/* 0x78, SSP0CLK_PVALUE. Default value is 0x10011. 540/(2+1) = 180M.
	 * SSP has divisor as well. bclk = SSPCLK/(2(div+1))
	 */
	reg = readl(CONFIG_PMU_BASE + 0x78);
	reg &= ~0x3F;
	reg |= 0x2;
	writel(reg, CONFIG_PMU_BASE + 0x78);

	/* turn on SSP clock and GPIO clock */
	reg = readl(CONFIG_PMU_BASE + 0x3C);
	reg &= ~(0x1 << 5 | 0x1 << 9);
	writel(reg, CONFIG_PMU_BASE + 0x3C);

	/* PinMux with GPIO, set SSP0_RXD, SSP0_SCLK, SSP0_TXD*/
	reg = readl(CONFIG_PMU_BASE + 0x50);
	reg &= ~(0x3 << 30 | 0x3 << 28 | 0x3 << 26);
	reg |= (0x1 << 30 | 0x1 << 28 | 0x1 << 26);
	writel(reg, CONFIG_PMU_BASE + 0x50);

	/* set SSP0_FS0 as GPIO(pin 14) to be the SPI chip select*/
	reg = readl(CONFIG_PMU_BASE + 0x54);
	reg &= ~(0x3 << 4 | 0x7 << 0);
	reg |= (0x0 << 4); /* choose GPIO14 as FS0 */
	reg &= ~(0x3 << 6);/* choose GPIO15 as FS1 */
	writel(reg, CONFIG_PMU_BASE + 0x54);

	/* set FS2 ~ FS5 */
	reg = readl(CONFIG_PMU_BASE + 0x60);
	reg &= ~(0xFFF);//choose GPIO function for FS2 ~ FS5
	writel(reg, CONFIG_PMU_BASE + 0x60);
}

