/*
 * (C) Copyright 2003
 * Texas Instruments <www.ti.com>
 *
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 *
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Alex Zuepke <azu@sysgo.de>
 *
 * (C) Copyright 2002-2004
 * Gary Jennejohn, DENX Software Engineering, <gj@denx.de>
 *
 * (C) Copyright 2004
 * Philippe Robin, ARM Ltd. <philippe.robin@arm.com>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <arm946es.h>

uint TIMER_LOAD_VAL 
extern void reset_cpu(ulong addr);

#ifdef CONFIG_INTEGRATOR
	/* Timer functionality supplied by Integrator board (AP or CP) */
#else

static ulong timestamp;
static ulong lastdec;

#define CPE_CT_BASE                     0x98400000	 	/*   Counter/Timers 		*/
#define CPE_TIMER1_BASE                 CPE_CT_BASE
#define CPE_TIMER2_BASE                 (CPE_CT_BASE + 0x10)
#define CPE_TIMER3_BASE                 (CPE_CT_BASE + 0x20)

#define TIMER_CR                    0x30
// --------------------------------------------------------------------
//		functions copy from flib (timer.c)
// --------------------------------------------------------------------
typedef struct
{       
	UINT32 Tm1En:1;					// Timer1 enable bit
	UINT32 Tm1Clock:1;				// Timer1 clock source (0: PCLK, 1: EXT1CLK)
	UINT32 Tm1OfEn:1;				// Timer1 over flow interrupt enable bit
	UINT32 Tm2En:1;
	UINT32 Tm2Clock:1;
	UINT32 Tm2OfEn:1;
	UINT32 Tm3En:1;
	UINT32 Tm3Clock:1;
	UINT32 Tm3OfEn:1;       
	UINT32 Reserved;        
}fLib_TimerControl;


typedef struct 
{
	UINT32 TimerValue;
    UINT32 TimerLoad;
    UINT32 TimerMatch1;
    UINT32 TimerMatch2;
}fLib_TimerReg;


// --------------------------------------------------------------------
//		warning: Ϊɭԭn`N, q 1 }l
// --------------------------------------------------------------------
fLib_TimerReg *TimerBase[] ={0, (fLib_TimerReg *) CPE_TIMER1_BASE,
 							(fLib_TimerReg *) CPE_TIMER2_BASE,(fLib_TimerReg *)CPE_TIMER3_BASE};

// --------------------------------------------------------------------
//	warning:
//		timer = 1, 2, 3
// --------------------------------------------------------------------
UINT32 Read_Timer_Counter(UINT32 timer)
{
    volatile fLib_TimerReg *Timer = TimerBase[timer];    

    return Timer->TimerValue;
}


void Set_Timer_AutoReloadValue(UINT32 timer, UINT32 value)
{
    volatile fLib_TimerReg *Timer = TimerBase[timer];

    Timer->TimerLoad = value;
}


/* nothing really to do with interrupts, just starts up a counter. */
int interrupt_init (void)
{
	/* init the timestamp and lastdec value */
	//reset_timer_masked();
	volatile fLib_TimerControl *TimerControl=(fLib_TimerControl *)(CPE_CT_BASE + TIMER_CR);

	TimerControl->Tm1En = 1;		// enable timer 1
	TimerControl->Tm1Clock = 0;
	TimerControl->Tm1OfEn = 0;		// over flow interrupt disable

	TimerControl->Tm2En = 0;		// disable timer 2
	TimerControl->Tm3En = 0;		// disable timer 3
TIMER_LOAD_VAL=102000000;//u32PMU_ReadPCLK()/1000;
	Set_Timer_AutoReloadValue(1, TIMER_LOAD_VAL);
	/* ++ John Ho, 2007/04/16, fix tftp occasional timeout while timer wrap around */
	lastdec = TIMER_LOAD_VAL;
	timestamp = 0;
	/* ++ John Ho, 2007/04/16, fix tftp occasional timeout while timer wrap around */	

	return (0);
}

/*
 * timer without interrupts
 */

void reset_timer (void)
{
	reset_timer_masked ();
}

ulong get_timer (ulong base)
{
	return get_timer_masked () - base;
}

void set_timer (ulong t)
{
	timestamp = t;
}

/* delay x useconds AND perserve advance timstamp value */
void udelay(unsigned long usec)
{
	udelay_masked(usec);
}

void reset_timer_masked (void)
{
	/* reset time */
	lastdec = READ_TIMER;  /* capure current decrementer value time */
	timestamp = 0;         /* start "advancing" time stamp from 0 */
}

ulong get_timer_raw (void)
{
	ulong now = READ_TIMER;		/* current tick value */

	if (lastdec >= now) {		/* normal mode (non roll) */
		/* normal mode */
		timestamp += lastdec - now; /* move stamp fordward with absoulte diff ticks */
	} else {			/* we have overflow of the count down timer */
		/* nts = ts + ld + (TLV - now)
		 * ts=old stamp, ld=time that passed before passing through -1
		 * (TLV-now) amount of time after passing though -1
		 * nts = new "advancing time stamp"...it could also roll and cause problems.
		 */
		timestamp += lastdec + TIMER_LOAD_VAL - now;
	}
	lastdec = now;

	return timestamp;
}

ulong get_timer_masked (void)
{
	return get_timer_raw() / TIMER_LOAD_VAL;
}

/* waits specified delay value and resets timestamp */
void udelay_masked (unsigned long usec)
{
	ulong tmo;

	if(usec >= 1000){               /* if "big" number, spread normalization to seconds */
		tmo = usec / 1000;      /* start to normalize for usec to ticks per sec */
		tmo *= CFG_HZ_CLOCK;    /* find number of "ticks" to wait to achieve target */
		tmo /= 1000;            /* finish normalize. */
	}else{                          /* else small number, don't kill it prior to HZ multiply */
		tmo = usec * CFG_HZ_CLOCK;
		tmo /= (1000*1000);
	}

	reset_timer_masked ();	/* set "advancing" timestamp to 0, set lastdec vaule */

	while (get_timer_raw () < tmo) /* wait for time stamp to overtake tick number.*/
		/*NOP*/;
}

/*
 * This function is derived from PowerPC code (read timebase as long long).
 * On ARM it just returns the timer value.
 */
unsigned long long get_ticks(void)
{
	return get_timer(0);
}

/*
 * This function is derived from PowerPC code (timebase clock frequency).
 * On ARM it returns the number of timer ticks per second.
 */
ulong get_tbclk (void)
{
	ulong tbclk;

	tbclk = CFG_HZ;
	return tbclk;
}

#endif /* CONFIG_INTEGRATOR */
