
#include <common.h>
#include <watchdog.h>
#include <command.h>
#include "gemtek_init.h"

#define CPE_CT_BASE                     0x99100000	 	
#define CONFIG_PMU_BASE                 0x99000000
#define CPE_PMU_BASE                  0x99000000
#define TIMER_COUNT                 0x0
#define TIMER_LOAD                  0x4
#define TIMER_MATCH1                0x8
#define TIMER_MATCH2                0xC
#define TIMER_CR                    0x30
#define TIMER_INTRSTATE             0x34
#define TIMER_INTRMASK              0x38
#define SYS_CLK		12000000
#define SCCR              0x6C
#define AHBMCLKOFF	0x38
#define APBMCLKOFF	0x3C
#define CSCR	0x28
void outw(unsigned int  *port,unsigned int  data)
{
 	*port=data;
}
unsigned int inw(unsigned int *port)
{
	return *port;
}

uint u32PMU_ReadPLL1CLK_test(void)
{
    uint mul, div;

    mul = (inw(CONFIG_PMU_BASE+0x30) >>  4) & 0xff;
    div = (inw(CONFIG_PMU_BASE+0x30) >> 12) & 0xff;

    return (SYS_CLK * mul / div);
}

uint u32PMU_ReadHCLK_test(void)
{
    uint pll1_out;
    uint cpu3x;

    cpu3x = (inw(CONFIG_PMU_BASE+0x30) >> 26) & 0x3;
    pll1_out = u32PMU_ReadPLL1CLK_test();

    if(cpu3x == 0)
    	{    		
    		return pll1_out / 1;
    	}
    else if(cpu3x == 1)
    	{    		
    		return pll1_out / 2;
    	}
    else if(cpu3x == 2)
    	{    		
    		return pll1_out / 3;
    	}
    else {
		if (GET_PLAT_ID() == GPLAT_8181_ID)
    		return pll1_out / 6;
		else
			return pll1_out / 4;
	}
}
uint u32PMU_ReadPCLK_test(void)
{
    return (u32PMU_ReadHCLK_test() >> 1);
}

void fLib_Timer_Counter(unsigned int timer, unsigned int value)
{
    outw(CPE_CT_BASE + TIMER_COUNT, value); 
}
void fLib_Timer_AutoReloadValue(unsigned int timer, unsigned int value)
{
    outw(CPE_CT_BASE + TIMER_LOAD, value);   
}

void register_init(void)
{
	unsigned int val;
	
	//val = inw(CPE_PMU_BASE + CSCR);	
	//val=0x841000;	
	//outw(CPE_PMU_BASE + CSCR, val); 	

	val = inw(CPE_PMU_BASE + AHBMCLKOFF);
	val=0x76C517;
	outw(CPE_PMU_BASE + SCCR, val); 

	val = inw(CPE_PMU_BASE + APBMCLKOFF);	
	//val &= ~0x4000;
	val=0xfbffadde;	
	outw(CPE_PMU_BASE + APBMCLKOFF, val); 	

	//val = inw(CPE_PMU_BASE + SCCR);	
	//val=0x76C517;
	//outw(CPE_PMU_BASE + SCCR, val); 

}

void timer_init(void)
{
	unsigned int val;
	
	val = inw(CPE_CT_BASE + TIMER_CR);
	val |= 0x1;
	outw(CPE_CT_BASE + TIMER_CR, val); 


	/* Set the timer tick */
  val = u32PMU_ReadPCLK_test();
  fLib_Timer_Counter(1,val);
	val = u32PMU_ReadPCLK();  
	fLib_Timer_AutoReloadValue(1,val); 

}
